/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

@SideOnly(value=Side.CLIENT)
public class SoundManager {
    private static final Marker field_148623_a = MarkerManager.getMarker((String)"SOUNDS");
    private static final Logger field_148621_b = LogManager.getLogger();
    private final SoundHandler field_148622_c;
    private final GameSettings field_148619_d;
    private SoundSystemStarterThread field_148620_e;
    private boolean field_148617_f;
    private int field_148618_g = 0;
    private final Map field_148629_h = HashBiMap.create();
    private final Map field_148630_i = ((BiMap)this.field_148629_h).inverse();
    private Map field_148627_j = Maps.newHashMap();
    private final Multimap field_148628_k = HashMultimap.create();
    private final List field_148625_l = Lists.newArrayList();
    private final Map field_148626_m = Maps.newHashMap();
    private final Map field_148624_n = Maps.newHashMap();
    private static final String __OBFID = "CL_00001141";

    public SoundManager(SoundHandler p_i45119_1_, GameSettings p_i45119_2_) {
        this.field_148622_c = p_i45119_1_;
        this.field_148619_d = p_i45119_2_;
        try {
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            MinecraftForge.EVENT_BUS.post((Event)new SoundSetupEvent(this, this.field_148622_c));
        }
        catch (SoundSystemException soundsystemexception) {
            field_148621_b.error(field_148623_a, "Error linking with the LibraryJavaSound plug-in", (Throwable)soundsystemexception);
        }
    }

    public void func_148596_a() {
        this.func_148613_b();
        this.func_148608_i();
        MinecraftForge.EVENT_BUS.post((Event)new SoundLoadEvent(this, this.field_148622_c));
    }

    private synchronized void func_148608_i() {
        if (!this.field_148617_f) {
            try {
                new Thread(new Runnable(){
                    private static final String __OBFID = "CL_00001142";

                    @Override
                    public void run() {
                        SoundManager soundManager = SoundManager.this;
                        soundManager.getClass();
                        SoundManager.this.field_148620_e = soundManager.new SoundSystemStarterThread(null);
                        SoundManager.this.field_148617_f = true;
                        SoundManager.this.field_148620_e.setMasterVolume(SoundManager.this.field_148619_d.func_151438_a(SoundCategory.MASTER));
                        field_148621_b.info(field_148623_a, "Sound engine started");
                    }
                }, "Sound Library Loader").start();
            }
            catch (RuntimeException runtimeexception) {
                field_148621_b.error(field_148623_a, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeexception);
                this.field_148619_d.func_151439_a(SoundCategory.MASTER, 0.0f);
                this.field_148619_d.func_74303_b();
            }
        }
    }

    private float func_148595_a(SoundCategory p_148595_1_) {
        return p_148595_1_ != null && p_148595_1_ != SoundCategory.MASTER ? this.field_148619_d.func_151438_a(p_148595_1_) : 1.0f;
    }

    public void func_148601_a(SoundCategory p_148601_1_, float p_148601_2_) {
        if (this.field_148617_f) {
            if (p_148601_1_ == SoundCategory.MASTER) {
                this.field_148620_e.setMasterVolume(p_148601_2_);
            } else {
                for (String s : this.field_148628_k.get((Object)p_148601_1_)) {
                    ISound isound = (ISound)this.field_148629_h.get(s);
                    float f1 = this.func_148594_a(isound, (SoundPoolEntry)this.field_148627_j.get(isound), p_148601_1_);
                    if (f1 <= 0.0f) {
                        this.func_148602_b(isound);
                        continue;
                    }
                    this.field_148620_e.setVolume(s, f1);
                }
            }
        }
    }

    public void func_148613_b() {
        if (this.field_148617_f) {
            this.func_148614_c();
            this.field_148620_e.cleanup();
            this.field_148617_f = false;
        }
    }

    public void func_148614_c() {
        if (this.field_148617_f) {
            for (String s : this.field_148629_h.keySet()) {
                this.field_148620_e.stop(s);
            }
            this.field_148629_h.clear();
            this.field_148626_m.clear();
            this.field_148625_l.clear();
            this.field_148628_k.clear();
            this.field_148627_j.clear();
            this.field_148624_n.clear();
        }
    }

    public void func_148605_d() {
        ISound isound;
        String s;
        ++this.field_148618_g;
        for (ITickableSound itickablesound : this.field_148625_l) {
            itickablesound.func_73660_a();
            if (itickablesound.func_147667_k()) {
                this.func_148602_b((ISound)itickablesound);
                continue;
            }
            s = (String)this.field_148630_i.get(itickablesound);
            this.field_148620_e.setVolume(s, this.func_148594_a((ISound)itickablesound, (SoundPoolEntry)this.field_148627_j.get(itickablesound), this.field_148622_c.func_147680_a(itickablesound.func_147650_b()).func_148728_d()));
            this.field_148620_e.setPitch(s, this.func_148606_a((ISound)itickablesound, (SoundPoolEntry)this.field_148627_j.get(itickablesound)));
            this.field_148620_e.setPosition(s, itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
        }
        Iterator<Object> iterator = this.field_148629_h.entrySet().iterator();
        while (iterator.hasNext()) {
            int i;
            Map.Entry entry = (Map.Entry)iterator.next();
            s = (String)entry.getKey();
            isound = (ISound)entry.getValue();
            if (this.field_148620_e.playing(s) || (i = ((Integer)this.field_148624_n.get(s)).intValue()) > this.field_148618_g) continue;
            int j = isound.func_147652_d();
            if (isound.func_147657_c() && j > 0) {
                this.field_148626_m.put(isound, this.field_148618_g + j);
            }
            iterator.remove();
            field_148621_b.debug(field_148623_a, "Removed channel {} because it's not playing anymore", new Object[]{s});
            this.field_148620_e.removeSource(s);
            this.field_148624_n.remove(s);
            this.field_148627_j.remove(isound);
            try {
                this.field_148628_k.remove((Object)this.field_148622_c.func_147680_a(isound.func_147650_b()).func_148728_d(), (Object)s);
            }
            catch (RuntimeException runtimeexception) {
                // empty catch block
            }
            if (!(isound instanceof ITickableSound)) continue;
            this.field_148625_l.remove(isound);
        }
        Iterator iterator1 = this.field_148626_m.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry entry1 = iterator1.next();
            if (this.field_148618_g < (Integer)entry1.getValue()) continue;
            isound = (ISound)entry1.getKey();
            if (isound instanceof ITickableSound) {
                ((ITickableSound)isound).func_73660_a();
            }
            this.func_148611_c(isound);
            iterator1.remove();
        }
    }

    public boolean func_148597_a(ISound p_148597_1_) {
        if (!this.field_148617_f) {
            return false;
        }
        String s = (String)this.field_148630_i.get(p_148597_1_);
        return s == null ? false : this.field_148620_e.playing(s) || this.field_148624_n.containsKey(s) && (Integer)this.field_148624_n.get(s) <= this.field_148618_g;
    }

    public void func_148602_b(ISound p_148602_1_) {
        String s;
        if (this.field_148617_f && (s = (String)this.field_148630_i.get(p_148602_1_)) != null) {
            this.field_148620_e.stop(s);
        }
    }

    public void func_148611_c(ISound p_148611_1_) {
        if (this.field_148617_f) {
            if (this.field_148620_e.getMasterVolume() <= 0.0f) {
                field_148621_b.debug(field_148623_a, "Skipped playing soundEvent: {}, master volume was zero", new Object[]{p_148611_1_.func_147650_b()});
            } else {
                if ((p_148611_1_ = ForgeHooksClient.playSound(this, this.field_148622_c, p_148611_1_)) == null) {
                    return;
                }
                SoundEventAccessorComposite soundeventaccessorcomposite = this.field_148622_c.func_147680_a(p_148611_1_.func_147650_b());
                if (soundeventaccessorcomposite == null) {
                    field_148621_b.warn(field_148623_a, "Unable to play unknown soundEvent: {}", new Object[]{p_148611_1_.func_147650_b()});
                } else {
                    SoundPoolEntry soundpoolentry = soundeventaccessorcomposite.func_148720_g();
                    if (soundpoolentry == SoundHandler.field_147700_a) {
                        field_148621_b.warn(field_148623_a, "Unable to play empty soundEvent: {}", new Object[]{soundeventaccessorcomposite.func_148729_c()});
                    } else {
                        float f = p_148611_1_.func_147653_e();
                        float f1 = 16.0f;
                        if (f > 1.0f) {
                            f1 *= f;
                        }
                        SoundCategory soundcategory = soundeventaccessorcomposite.func_148728_d();
                        float f2 = this.func_148594_a(p_148611_1_, soundpoolentry, soundcategory);
                        double d0 = this.func_148606_a(p_148611_1_, soundpoolentry);
                        ResourceLocation resourcelocation = soundpoolentry.func_148652_a();
                        if (f2 == 0.0f) {
                            field_148621_b.debug(field_148623_a, "Skipped playing sound {}, volume was zero.", new Object[]{resourcelocation});
                        } else {
                            boolean flag = p_148611_1_.func_147657_c() && p_148611_1_.func_147652_d() == 0;
                            String s = UUID.randomUUID().toString();
                            if (soundpoolentry.func_148648_d()) {
                                this.field_148620_e.newStreamingSource(false, s, SoundManager.func_148612_a(resourcelocation), resourcelocation.toString(), flag, p_148611_1_.func_147649_g(), p_148611_1_.func_147654_h(), p_148611_1_.func_147651_i(), p_148611_1_.func_147656_j().func_148586_a(), f1);
                                MinecraftForge.EVENT_BUS.post((Event)new PlayStreamingSourceEvent(this, this.field_148622_c, p_148611_1_, s));
                            } else {
                                this.field_148620_e.newSource(false, s, SoundManager.func_148612_a(resourcelocation), resourcelocation.toString(), flag, p_148611_1_.func_147649_g(), p_148611_1_.func_147654_h(), p_148611_1_.func_147651_i(), p_148611_1_.func_147656_j().func_148586_a(), f1);
                                MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(this, this.field_148622_c, p_148611_1_, s));
                            }
                            field_148621_b.debug(field_148623_a, "Playing sound {} for event {} as channel {}", new Object[]{soundpoolentry.func_148652_a(), soundeventaccessorcomposite.func_148729_c(), s});
                            this.field_148620_e.setPitch(s, (float)d0);
                            this.field_148620_e.setVolume(s, f2);
                            this.field_148620_e.play(s);
                            this.field_148624_n.put(s, this.field_148618_g + 20);
                            this.field_148629_h.put(s, p_148611_1_);
                            this.field_148627_j.put(p_148611_1_, soundpoolentry);
                            if (soundcategory != SoundCategory.MASTER) {
                                this.field_148628_k.put((Object)soundcategory, (Object)s);
                            }
                            if (p_148611_1_ instanceof ITickableSound) {
                                this.field_148625_l.add((ITickableSound)p_148611_1_);
                            }
                        }
                    }
                }
            }
        }
    }

    private float func_148606_a(ISound p_148606_1_, SoundPoolEntry p_148606_2_) {
        return (float)MathHelper.func_151237_a((double)((double)p_148606_1_.func_147655_f() * p_148606_2_.func_148650_b()), (double)0.5, (double)2.0);
    }

    private float func_148594_a(ISound p_148594_1_, SoundPoolEntry p_148594_2_, SoundCategory p_148594_3_) {
        return (float)MathHelper.func_151237_a((double)((double)p_148594_1_.func_147653_e() * p_148594_2_.func_148649_c() * (double)this.func_148595_a(p_148594_3_)), (double)0.0, (double)1.0);
    }

    public void func_148610_e() {
        for (String s : this.field_148629_h.keySet()) {
            field_148621_b.debug(field_148623_a, "Pausing channel {}", new Object[]{s});
            this.field_148620_e.pause(s);
        }
    }

    public void func_148604_f() {
        for (String s : this.field_148629_h.keySet()) {
            field_148621_b.debug(field_148623_a, "Resuming channel {}", new Object[]{s});
            this.field_148620_e.play(s);
        }
    }

    public void func_148599_a(ISound p_148599_1_, int p_148599_2_) {
        this.field_148626_m.put(p_148599_1_, this.field_148618_g + p_148599_2_);
    }

    public void connect() {
    }

    private static URL func_148612_a(final ResourceLocation p_148612_0_) {
        String s = String.format("%s:%s:%s", "mcsounddomain", p_148612_0_.func_110624_b(), p_148612_0_.func_110623_a());
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){
            private static final String __OBFID = "CL_00001143";

            @Override
            protected URLConnection openConnection(URL par1URL) {
                return new URLConnection(par1URL){
                    private static final String __OBFID = "CL_00001144";

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Minecraft.func_71410_x().func_110442_L().func_110536_a(p_148612_0_).func_110527_b();
                    }
                };
            }
        };
        try {
            return new URL((URL)null, s, urlstreamhandler);
        }
        catch (MalformedURLException malformedurlexception) {
            throw new Error("TODO: Sanely handle url exception! :D");
        }
    }

    public void func_148615_a(EntityPlayer p_148615_1_, float p_148615_2_) {
        if (this.field_148617_f && p_148615_1_ != null) {
            float f1 = p_148615_1_.field_70127_C + (p_148615_1_.field_70125_A - p_148615_1_.field_70127_C) * p_148615_2_;
            float f2 = p_148615_1_.field_70126_B + (p_148615_1_.field_70177_z - p_148615_1_.field_70126_B) * p_148615_2_;
            double d0 = p_148615_1_.field_70169_q + (p_148615_1_.field_70165_t - p_148615_1_.field_70169_q) * (double)p_148615_2_;
            double d1 = p_148615_1_.field_70167_r + (p_148615_1_.field_70163_u - p_148615_1_.field_70167_r) * (double)p_148615_2_;
            double d2 = p_148615_1_.field_70166_s + (p_148615_1_.field_70161_v - p_148615_1_.field_70166_s) * (double)p_148615_2_;
            float f3 = MathHelper.func_76134_b((float)((f2 + 90.0f) * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)((f2 + 90.0f) * ((float)Math.PI / 180)));
            float f5 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = MathHelper.func_76134_b((float)((-f1 + 90.0f) * ((float)Math.PI / 180)));
            float f8 = MathHelper.func_76126_a((float)((-f1 + 90.0f) * ((float)Math.PI / 180)));
            float f9 = f3 * f5;
            float f10 = f4 * f5;
            float f11 = f3 * f7;
            float f12 = f4 * f7;
            this.field_148620_e.setListenerPosition((float)d0, (float)d1, (float)d2);
            this.field_148620_e.setListenerOrientation(f9, f6, f10, f11, f8, f12);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class SoundSystemStarterThread
    extends SoundSystem {
        private static final String __OBFID = "CL_00001145";

        private SoundSystemStarterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean playing(String p_playing_1_) {
            Object object = SoundSystemConfig.THREAD_SYNC;
            Object object2 = SoundSystemConfig.THREAD_SYNC;
            synchronized (object2) {
                if (this.soundLibrary == null) {
                    return false;
                }
                Source source = (Source)this.soundLibrary.getSources().get(p_playing_1_);
                boolean bl = source == null ? false : source.playing() || source.paused();
                return bl;
            }
        }

        SoundSystemStarterThread(Object p_i45118_2_) {
            this();
        }
    }
}

