/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.RenderBlockFluid;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public class ForgeHooksClient {
    static int renderPass = -1;
    static int stencilBits = 0;
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;

    static TextureManager engine() {
        return FMLClientHandler.instance().getClient().field_71446_o;
    }

    public static String getArmorTexture(Entity entity, ItemStack armor, String _default, int slot, String type) {
        String result = armor.func_77973_b().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static boolean renderEntityItem(EntityItem entity, ItemStack item, float bobing, float rotation, Random random, TextureManager engine, RenderBlocks renderBlocks, int count) {
        Block block;
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer == null) {
            return false;
        }
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.ENTITY_ROTATION)) {
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.ENTITY_BOBBING)) {
            GL11.glTranslatef((float)0.0f, (float)(-bobing), (float)0.0f);
        }
        boolean is3D = customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        engine.func_110577_a(item.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        Block block2 = block = item.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)item.func_77973_b()) : null;
        if (is3D || block != null && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
            boolean blend;
            int renderType = block != null ? block.func_149645_b() : 1;
            float scale = renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2 ? 0.5f : 0.25f;
            boolean bl = blend = block != null && block.func_149701_w() > 0;
            if (RenderItem.field_82407_g) {
                GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (blend) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            for (int j = 0; j < count; ++j) {
                GL11.glPushMatrix();
                if (j > 0) {
                    GL11.glTranslatef((float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / scale), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / scale), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / scale));
                }
                customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, new Object[]{renderBlocks, entity});
                GL11.glPopMatrix();
            }
            if (blend) {
                GL11.glDisable((int)3042);
            }
        } else {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, new Object[]{renderBlocks, entity});
        }
        return true;
    }

    public static boolean renderInventoryItem(RenderBlocks renderBlocks, TextureManager engine, ItemStack item, boolean inColor, float zLevel, float x, float y) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        if (customRenderer == null) {
            return false;
        }
        engine.func_110577_a(item.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, item, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2.0f), (float)(y + 3.0f), (float)(-3.0f + zLevel));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (inColor) {
                int color = item.func_77973_b().func_82790_a(item, 0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderBlocks.field_147844_c = inColor;
            customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, item, new Object[]{renderBlocks});
            renderBlocks.field_147844_c = true;
            GL11.glPopMatrix();
        } else {
            GL11.glDisable((int)2896);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)(-3.0f + zLevel));
            if (inColor) {
                int color = item.func_77973_b().func_82790_a(item, 0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            }
            customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, item, new Object[]{renderBlocks});
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
        }
        return true;
    }

    public static void renderEffectOverlay(TextureManager manager, RenderItem render) {
    }

    public static void renderEquippedItem(IItemRenderer.ItemRenderType type, IItemRenderer customRenderer, RenderBlocks renderBlocks, EntityLivingBase entity, ItemStack item) {
        if (customRenderer.shouldUseRenderHelper(type, item, IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            customRenderer.renderItem(type, item, new Object[]{renderBlocks, entity});
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            customRenderer.renderItem(type, item, new Object[]{renderBlocks, entity});
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    public static void orientBedCamera(Minecraft mc, EntityLivingBase entity) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        Block block = mc.field_71441_e.func_147439_a(x, y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (block != null && block.isBed((IBlockAccess)mc.field_71441_e, x, y, z, entity)) {
            GL11.glRotatef((float)(block.getBedDirection((IBlockAccess)mc.field_71441_e, x, y, z) * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    public static boolean onDrawBlockHighlight(RenderGlobal context, EntityPlayer player, MovingObjectPosition target, int subID, ItemStack currentItem, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post((Event)new DrawBlockHighlightEvent(context, player, target, subID, currentItem, partialTicks));
    }

    public static void dispatchRenderLast(RenderGlobal context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(RenderGlobal context, float partialTicks, int renderPass) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderHandEvent(context, partialTicks, renderPass));
    }

    public static void onTextureStitchedPre(TextureMap map) {
        MinecraftForge.EVENT_BUS.post((Event)new TextureStitchEvent.Pre(map));
    }

    public static void onTextureStitchedPost(TextureMap map) {
        MinecraftForge.EVENT_BUS.post((Event)new TextureStitchEvent.Post(map));
        FluidRegistry.WATER.setIcons(BlockLiquid.func_149803_e((String)"water_still"), BlockLiquid.func_149803_e((String)"water_flow"));
        FluidRegistry.LAVA.setIcons(BlockLiquid.func_149803_e((String)"lava_still"), BlockLiquid.func_149803_e((String)"lava_flow"));
    }

    public static void onTextureLoadPre(String texture) {
        if (Tessellator.renderingWorldRenderer) {
            FMLLog.warning((String)"Warning: Texture %s not preloaded, will cause render glitches!", (Object[])new Object[]{texture});
            if (Tessellator.class.getPackage() != null && Tessellator.class.getPackage().getName().startsWith("net.minecraft.")) {
                Minecraft mc = FMLClientHandler.instance().getClient();
                if (mc.field_71456_v != null) {
                    mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentTranslation("forge.texture.preload.warning", new Object[]{texture}));
                }
            }
        }
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int slotID, ModelBiped _default) {
        ModelBiped modelbiped = itemStack.func_77973_b().getArmorModel(entityLiving, itemStack, slotID);
        return modelbiped == null ? _default : modelbiped;
    }

    public static void createDisplay() throws LWJGLException {
        ImageIO.setUseCache(false);
        PixelFormat format = new PixelFormat().withDepthBits(24);
        try {
            Display.create((PixelFormat)format.withStencilBits(8));
            stencilBits = 8;
        }
        catch (LWJGLException e) {
            Display.create((PixelFormat)format);
            stencilBits = 0;
        }
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    public static boolean postMouseEvent() {
        return MinecraftForge.EVENT_BUS.post((Event)new MouseEvent());
    }

    public static float getOffsetFOV(EntityPlayerSP entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post((Event)fovUpdateEvent);
        return fovUpdateEvent.newfov;
    }

    public static int getSkyBlendColour(World world, int playerX, int playerY, int playerZ) {
        if (playerX == skyX && playerZ == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                int colour = biome.func_76731_a(biome.func_150564_a(playerX + x, playerY, playerZ + z));
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        skyX = playerX;
        skyZ = playerZ;
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static void renderMainMenu(GuiMainMenu gui, FontRenderer font, int width, int height) {
        String line;
        ForgeVersion.Status status = ForgeVersion.getStatus();
        if (status == ForgeVersion.Status.BETA || status == ForgeVersion.Status.BETA_OUTDATED) {
            line = EnumChatFormatting.RED + "WARNING:" + EnumChatFormatting.RESET + " Forge Beta,";
            gui.func_73731_b(font, line, (width - font.func_78256_a(line)) / 2, 4 + 0 * (font.field_78288_b + 1), -1);
            line = "Major issues may arise, verify before reporting.";
            gui.func_73731_b(font, line, (width - font.func_78256_a(line)) / 2, 4 + 1 * (font.field_78288_b + 1), -1);
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = "New Forge version avalible: " + ForgeVersion.getTarget();
                break;
            }
        }
        if (line != null) {
            gui.func_73731_b(font, line, width - font.func_78256_a(line) - 2, height - 2 * (font.field_78288_b + 1), -1);
        }
    }

    public static ISound playSound(SoundManager manager, SoundHandler handler, ISound sound) {
        SoundEventAccessorComposite accessor = handler.func_147680_a(sound.func_147650_b());
        PlaySoundEvent event = new PlaySoundEvent(manager, handler, sound, accessor != null ? accessor.func_148728_d() : null);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.result;
    }

    static {
        FluidRegistry.renderIdFluid = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)RenderBlockFluid.instance);
    }
}

