/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderExtra {
    public static final RenderExtra INSTANCE = new RenderExtra();
    public byte uvRotateEast;
    public byte uvRotateWest;
    public byte uvRotateSouth;
    public byte uvRotateNorth;
    public byte uvRotateTop;
    public byte uvRotateBottom;
    public boolean uvFlipEast;
    public boolean uvFlipWest;
    public boolean uvFlipSouth;
    public boolean uvFlipNorth;
    public boolean uvFlipTop;
    public boolean uvFlipBottom;
    private boolean[] faceSkip = new boolean[6];
    private boolean overrideColor = false;
    private int overridingColor = 0xFFFFFF;
    private IIcon[] iconIndex = new IIcon[6];
    private byte[] subIcon = new byte[6];

    public void reset() {
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        this.uvFlipEast = false;
        this.uvFlipWest = false;
        this.uvFlipSouth = false;
        this.uvFlipNorth = false;
        this.uvFlipTop = false;
        this.uvFlipBottom = false;
        this.clearFaceSkip();
        this.clearColorOverride();
        this.clearIconOverrides();
        this.clearSubIcons();
    }

    public void setFaceSkip(boolean ... face) {
        for (int side = 0; side < Math.min(6, face.length); side = (int)((byte)(side + 1))) {
            this.faceSkip[side] = face[side];
        }
    }

    public void clearFaceSkip() {
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            this.faceSkip[side] = false;
        }
    }

    public void setColorOverride(int color) {
        this.overrideColor = true;
        this.overridingColor = color;
    }

    public void clearColorOverride() {
        this.overrideColor = false;
        this.overridingColor = 0xFFFFFF;
    }

    public void setIconOverride(IIcon icon, int face) {
        if (face >= 0 && face <= 6) {
            this.iconIndex[face] = icon;
        }
    }

    public void setIconOverrides(IIcon ... icon) {
        for (int face = 0; face < Math.min(6, icon.length); face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = icon[face];
        }
    }

    public void setAllIconOverrides(IIcon icon) {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = icon;
        }
    }

    public void clearIconOverride(int face) {
        if (face >= 0 && face <= 6) {
            this.iconIndex[face] = null;
        }
    }

    public void clearIconOverrides() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.iconIndex[face] = null;
        }
    }

    public void setSubIcons(int ... icon) {
        for (int face = 0; face < Math.min(6, icon.length); face = (int)((byte)(face + 1))) {
            this.subIcon[face] = (byte)MathHelper.func_76125_a((int)icon[face], (int)0, (int)4);
        }
    }

    public void clearSubIcons() {
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            this.subIcon[face] = 0;
        }
    }

    public boolean renderStandardBlock(RenderBlocks renderblocks, Block block, int x, int y, int z) {
        int color = this.overrideColor ? this.overridingColor : block.func_149720_d(renderblocks.field_147845_a, x, y, z);
        float valR = (float)(color >> 16 & 0xFF) / 255.0f;
        float valG = (float)(color >> 8 & 0xFF) / 255.0f;
        float valB = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float newR = (valR * 30.0f + valG * 59.0f + valB * 11.0f) / 100.0f;
            float newG = (valR * 30.0f + valG * 70.0f) / 100.0f;
            float newB = (valR * 30.0f + valB * 70.0f) / 100.0f;
            valR = newR;
            valG = newG;
            valB = newB;
        }
        if (Minecraft.func_71379_u() && block.func_149750_m() == 0) {
            boolean fullBlock = !renderblocks.field_147849_o;
            return this.withAmbientOcclusion(renderblocks, block, x, y, z, valR, valG, valB, fullBlock);
        }
        return this.withColorMultiplier(renderblocks, block, x, y, z, valR, valG, valB);
    }

    private boolean withAmbientOcclusion(RenderBlocks renderblocks, Block block, int x, int y, int z, float valR, float valG, float valB, boolean fullBlock) {
        int l1;
        int i2;
        int j1;
        int k1;
        float f10;
        float f11;
        float f8;
        float f9;
        float aoLightValue;
        int tempBrightness;
        boolean flag4;
        boolean flag5;
        boolean flag2;
        boolean flag3;
        renderblocks.field_147863_w = true;
        float colorTL = 0.0f;
        float colorBL = 0.0f;
        float colorBR = 0.0f;
        float colorTR = 0.0f;
        boolean flag1 = true;
        int masterBrightness = block.func_149677_c(renderblocks.field_147845_a, x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(983055);
        if (renderblocks.func_147745_b(block).func_94215_i().equals("grass_top") || renderblocks.func_147744_b()) {
            flag1 = false;
        }
        if (!this.faceSkip[0] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y - 1, z, 0))) {
            if (renderblocks.field_147855_j <= 0.0) {
                --y;
            }
            renderblocks.field_147831_S = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z);
            renderblocks.field_147825_U = block.func_149677_c(renderblocks.field_147845_a, x, y, z - 1);
            renderblocks.field_147828_V = block.func_149677_c(renderblocks.field_147845_a, x, y, z + 1);
            renderblocks.field_147835_X = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z);
            renderblocks.field_147886_y = renderblocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderblocks.field_147814_A = renderblocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderblocks.field_147815_B = renderblocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            renderblocks.field_147810_D = renderblocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            flag3 = renderblocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149751_l();
            flag2 = renderblocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149751_l();
            flag5 = renderblocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149751_l();
            flag4 = renderblocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149751_l();
            if (!flag4 && !flag2) {
                renderblocks.field_147888_x = renderblocks.field_147886_y;
                renderblocks.field_147832_R = renderblocks.field_147831_S;
            } else {
                renderblocks.field_147888_x = renderblocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I();
                renderblocks.field_147832_R = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z - 1);
            }
            if (!flag5 && !flag2) {
                renderblocks.field_147884_z = renderblocks.field_147886_y;
                renderblocks.field_147826_T = renderblocks.field_147831_S;
            } else {
                renderblocks.field_147884_z = renderblocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I();
                renderblocks.field_147826_T = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z + 1);
            }
            if (!flag4 && !flag3) {
                renderblocks.field_147816_C = renderblocks.field_147810_D;
                renderblocks.field_147827_W = renderblocks.field_147835_X;
            } else {
                renderblocks.field_147816_C = renderblocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I();
                renderblocks.field_147827_W = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z - 1);
            }
            if (!flag5 && !flag3) {
                renderblocks.field_147811_E = renderblocks.field_147810_D;
                renderblocks.field_147834_Y = renderblocks.field_147835_X;
            } else {
                renderblocks.field_147811_E = renderblocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I();
                renderblocks.field_147834_Y = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z + 1);
            }
            if (renderblocks.field_147855_j <= 0.0) {
                ++y;
            }
            tempBrightness = masterBrightness;
            if (renderblocks.field_147855_j <= 0.0 || !renderblocks.field_147845_a.func_147439_a(x, y - 1, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z);
            }
            aoLightValue = renderblocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            colorTL = (renderblocks.field_147884_z + renderblocks.field_147886_y + renderblocks.field_147815_B + aoLightValue) / 4.0f;
            colorTR = (renderblocks.field_147815_B + aoLightValue + renderblocks.field_147811_E + renderblocks.field_147810_D) / 4.0f;
            colorBR = (aoLightValue + renderblocks.field_147814_A + renderblocks.field_147810_D + renderblocks.field_147816_C) / 4.0f;
            colorBL = (renderblocks.field_147886_y + renderblocks.field_147888_x + aoLightValue + renderblocks.field_147814_A) / 4.0f;
            renderblocks.field_147864_al = renderblocks.func_147778_a(renderblocks.field_147826_T, renderblocks.field_147831_S, renderblocks.field_147828_V, tempBrightness);
            renderblocks.field_147870_ao = renderblocks.func_147778_a(renderblocks.field_147828_V, renderblocks.field_147834_Y, renderblocks.field_147835_X, tempBrightness);
            renderblocks.field_147876_an = renderblocks.func_147778_a(renderblocks.field_147825_U, renderblocks.field_147835_X, renderblocks.field_147827_W, tempBrightness);
            renderblocks.field_147874_am = renderblocks.func_147778_a(renderblocks.field_147831_S, renderblocks.field_147832_R, renderblocks.field_147825_U, tempBrightness);
            if (flag1) {
                renderblocks.field_147850_ar = renderblocks.field_147848_as = valR * 0.5f;
                renderblocks.field_147852_aq = renderblocks.field_147848_as;
                renderblocks.field_147872_ap = renderblocks.field_147848_as;
                renderblocks.field_147858_av = renderblocks.field_147856_aw = valG * 0.5f;
                renderblocks.field_147860_au = renderblocks.field_147856_aw;
                renderblocks.field_147846_at = renderblocks.field_147856_aw;
                renderblocks.field_147839_az = renderblocks.field_147833_aA = valB * 0.5f;
                renderblocks.field_147841_ay = renderblocks.field_147833_aA;
                renderblocks.field_147854_ax = renderblocks.field_147833_aA;
            } else {
                renderblocks.field_147848_as = 0.5f;
                renderblocks.field_147850_ar = 0.5f;
                renderblocks.field_147852_aq = 0.5f;
                renderblocks.field_147872_ap = 0.5f;
                renderblocks.field_147856_aw = 0.5f;
                renderblocks.field_147858_av = 0.5f;
                renderblocks.field_147860_au = 0.5f;
                renderblocks.field_147846_at = 0.5f;
                renderblocks.field_147833_aA = 0.5f;
                renderblocks.field_147839_az = 0.5f;
                renderblocks.field_147841_ay = 0.5f;
                renderblocks.field_147854_ax = 0.5f;
            }
            renderblocks.field_147872_ap *= colorTL;
            renderblocks.field_147846_at *= colorTL;
            renderblocks.field_147854_ax *= colorTL;
            renderblocks.field_147852_aq *= colorBL;
            renderblocks.field_147860_au *= colorBL;
            renderblocks.field_147841_ay *= colorBL;
            renderblocks.field_147850_ar *= colorBR;
            renderblocks.field_147858_av *= colorBR;
            renderblocks.field_147839_az *= colorBR;
            renderblocks.field_147848_as *= colorTR;
            renderblocks.field_147856_aw *= colorTR;
            renderblocks.field_147833_aA *= colorTR;
            this.renderFace(renderblocks, block, x, y, z, 0);
        }
        if (!this.faceSkip[1] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y + 1, z, 1))) {
            if (renderblocks.field_147857_k >= 1.0) {
                ++y;
            }
            renderblocks.field_147880_aa = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z);
            renderblocks.field_147885_ae = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z);
            renderblocks.field_147878_ac = block.func_149677_c(renderblocks.field_147845_a, x, y, z - 1);
            renderblocks.field_147887_af = block.func_149677_c(renderblocks.field_147845_a, x, y, z + 1);
            renderblocks.field_147813_G = renderblocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderblocks.field_147824_K = renderblocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            renderblocks.field_147822_I = renderblocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderblocks.field_147817_L = renderblocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            flag3 = renderblocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149751_l();
            flag2 = renderblocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149751_l();
            flag5 = renderblocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149751_l();
            flag4 = renderblocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149751_l();
            if (!flag4 && !flag2) {
                renderblocks.field_147812_F = renderblocks.field_147813_G;
                renderblocks.field_147836_Z = renderblocks.field_147880_aa;
            } else {
                renderblocks.field_147812_F = renderblocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I();
                renderblocks.field_147836_Z = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                renderblocks.field_147823_J = renderblocks.field_147824_K;
                renderblocks.field_147879_ad = renderblocks.field_147885_ae;
            } else {
                renderblocks.field_147823_J = renderblocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I();
                renderblocks.field_147879_ad = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z - 1);
            }
            if (!flag5 && !flag2) {
                renderblocks.field_147821_H = renderblocks.field_147813_G;
                renderblocks.field_147881_ab = renderblocks.field_147880_aa;
            } else {
                renderblocks.field_147821_H = renderblocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I();
                renderblocks.field_147881_ab = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z + 1);
            }
            if (!flag5 && !flag3) {
                renderblocks.field_147818_M = renderblocks.field_147824_K;
                renderblocks.field_147882_ag = renderblocks.field_147885_ae;
            } else {
                renderblocks.field_147818_M = renderblocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I();
                renderblocks.field_147882_ag = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z + 1);
            }
            if (renderblocks.field_147857_k >= 1.0) {
                --y;
            }
            tempBrightness = masterBrightness;
            if (renderblocks.field_147857_k >= 1.0 || !renderblocks.field_147845_a.func_147439_a(x, y + 1, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z);
            }
            aoLightValue = renderblocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            colorTR = (renderblocks.field_147821_H + renderblocks.field_147813_G + renderblocks.field_147817_L + aoLightValue) / 4.0f;
            colorTL = (renderblocks.field_147817_L + aoLightValue + renderblocks.field_147818_M + renderblocks.field_147824_K) / 4.0f;
            colorBL = (aoLightValue + renderblocks.field_147822_I + renderblocks.field_147824_K + renderblocks.field_147823_J) / 4.0f;
            colorBR = (renderblocks.field_147813_G + renderblocks.field_147812_F + aoLightValue + renderblocks.field_147822_I) / 4.0f;
            renderblocks.field_147870_ao = renderblocks.func_147778_a(renderblocks.field_147881_ab, renderblocks.field_147880_aa, renderblocks.field_147887_af, tempBrightness);
            renderblocks.field_147864_al = renderblocks.func_147778_a(renderblocks.field_147887_af, renderblocks.field_147882_ag, renderblocks.field_147885_ae, tempBrightness);
            renderblocks.field_147874_am = renderblocks.func_147778_a(renderblocks.field_147878_ac, renderblocks.field_147885_ae, renderblocks.field_147879_ad, tempBrightness);
            renderblocks.field_147876_an = renderblocks.func_147778_a(renderblocks.field_147880_aa, renderblocks.field_147836_Z, renderblocks.field_147878_ac, tempBrightness);
            renderblocks.field_147850_ar = renderblocks.field_147848_as = valR;
            renderblocks.field_147852_aq = renderblocks.field_147848_as;
            renderblocks.field_147872_ap = renderblocks.field_147848_as;
            renderblocks.field_147858_av = renderblocks.field_147856_aw = valG;
            renderblocks.field_147860_au = renderblocks.field_147856_aw;
            renderblocks.field_147846_at = renderblocks.field_147856_aw;
            renderblocks.field_147839_az = renderblocks.field_147833_aA = valB;
            renderblocks.field_147841_ay = renderblocks.field_147833_aA;
            renderblocks.field_147854_ax = renderblocks.field_147833_aA;
            renderblocks.field_147872_ap *= colorTL;
            renderblocks.field_147846_at *= colorTL;
            renderblocks.field_147854_ax *= colorTL;
            renderblocks.field_147852_aq *= colorBL;
            renderblocks.field_147860_au *= colorBL;
            renderblocks.field_147841_ay *= colorBL;
            renderblocks.field_147850_ar *= colorBR;
            renderblocks.field_147858_av *= colorBR;
            renderblocks.field_147839_az *= colorBR;
            renderblocks.field_147848_as *= colorTR;
            renderblocks.field_147856_aw *= colorTR;
            renderblocks.field_147833_aA *= colorTR;
            this.renderFace(renderblocks, block, x, y, z, 1);
        }
        if (!this.faceSkip[2] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y, z - 1, 2))) {
            if (renderblocks.field_147851_l <= 0.0) {
                --z;
            }
            renderblocks.field_147819_N = renderblocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderblocks.field_147814_A = renderblocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderblocks.field_147822_I = renderblocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderblocks.field_147820_O = renderblocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            renderblocks.field_147883_ah = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z);
            renderblocks.field_147825_U = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z);
            renderblocks.field_147878_ac = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z);
            renderblocks.field_147866_ai = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z);
            flag3 = renderblocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149751_l();
            flag2 = renderblocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149751_l();
            flag5 = renderblocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149751_l();
            flag4 = renderblocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149751_l();
            if (!flag2 && !flag4) {
                renderblocks.field_147888_x = renderblocks.field_147819_N;
                renderblocks.field_147832_R = renderblocks.field_147883_ah;
            } else {
                renderblocks.field_147888_x = renderblocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I();
                renderblocks.field_147832_R = block.func_149677_c(renderblocks.field_147845_a, x - 1, y - 1, z);
            }
            if (!flag2 && !flag5) {
                renderblocks.field_147812_F = renderblocks.field_147819_N;
                renderblocks.field_147836_Z = renderblocks.field_147883_ah;
            } else {
                renderblocks.field_147812_F = renderblocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I();
                renderblocks.field_147836_Z = block.func_149677_c(renderblocks.field_147845_a, x - 1, y + 1, z);
            }
            if (!flag3 && !flag4) {
                renderblocks.field_147816_C = renderblocks.field_147820_O;
                renderblocks.field_147827_W = renderblocks.field_147866_ai;
            } else {
                renderblocks.field_147816_C = renderblocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I();
                renderblocks.field_147827_W = block.func_149677_c(renderblocks.field_147845_a, x + 1, y - 1, z);
            }
            if (!flag3 && !flag5) {
                renderblocks.field_147823_J = renderblocks.field_147820_O;
                renderblocks.field_147879_ad = renderblocks.field_147866_ai;
            } else {
                renderblocks.field_147823_J = renderblocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I();
                renderblocks.field_147879_ad = block.func_149677_c(renderblocks.field_147845_a, x + 1, y + 1, z);
            }
            if (renderblocks.field_147851_l <= 0.0) {
                ++z;
            }
            tempBrightness = masterBrightness;
            if (renderblocks.field_147851_l <= 0.0 || !renderblocks.field_147845_a.func_147439_a(x, y, z - 1).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderblocks.field_147845_a, x, y, z - 1);
            }
            aoLightValue = renderblocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            if (fullBlock) {
                colorTL = (renderblocks.field_147819_N + renderblocks.field_147812_F + aoLightValue + renderblocks.field_147822_I) / 4.0f;
                colorBL = (aoLightValue + renderblocks.field_147822_I + renderblocks.field_147820_O + renderblocks.field_147823_J) / 4.0f;
                colorBR = (renderblocks.field_147814_A + aoLightValue + renderblocks.field_147816_C + renderblocks.field_147820_O) / 4.0f;
                colorTR = (renderblocks.field_147888_x + renderblocks.field_147819_N + renderblocks.field_147814_A + aoLightValue) / 4.0f;
                renderblocks.field_147864_al = renderblocks.func_147778_a(renderblocks.field_147883_ah, renderblocks.field_147836_Z, renderblocks.field_147878_ac, tempBrightness);
                renderblocks.field_147874_am = renderblocks.func_147778_a(renderblocks.field_147878_ac, renderblocks.field_147866_ai, renderblocks.field_147879_ad, tempBrightness);
                renderblocks.field_147876_an = renderblocks.func_147778_a(renderblocks.field_147825_U, renderblocks.field_147827_W, renderblocks.field_147866_ai, tempBrightness);
                renderblocks.field_147870_ao = renderblocks.func_147778_a(renderblocks.field_147832_R, renderblocks.field_147883_ah, renderblocks.field_147825_U, tempBrightness);
            } else {
                f9 = (renderblocks.field_147819_N + renderblocks.field_147812_F + aoLightValue + renderblocks.field_147822_I) / 4.0f;
                f8 = (aoLightValue + renderblocks.field_147822_I + renderblocks.field_147820_O + renderblocks.field_147823_J) / 4.0f;
                f11 = (renderblocks.field_147814_A + aoLightValue + renderblocks.field_147816_C + renderblocks.field_147820_O) / 4.0f;
                f10 = (renderblocks.field_147888_x + renderblocks.field_147819_N + renderblocks.field_147814_A + aoLightValue) / 4.0f;
                colorTL = (float)((double)f9 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147859_h) + (double)f8 * renderblocks.field_147857_k * renderblocks.field_147859_h + (double)f11 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147859_h + (double)f10 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147859_h));
                colorBL = (float)((double)f9 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147861_i) + (double)f8 * renderblocks.field_147857_k * renderblocks.field_147861_i + (double)f11 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147861_i + (double)f10 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147861_i));
                colorBR = (float)((double)f9 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147861_i) + (double)f8 * renderblocks.field_147855_j * renderblocks.field_147861_i + (double)f11 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147861_i + (double)f10 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147861_i));
                colorTR = (float)((double)f9 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147859_h) + (double)f8 * renderblocks.field_147855_j * renderblocks.field_147859_h + (double)f11 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147859_h + (double)f10 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147859_h));
                k1 = renderblocks.func_147778_a(renderblocks.field_147883_ah, renderblocks.field_147836_Z, renderblocks.field_147878_ac, tempBrightness);
                j1 = renderblocks.func_147778_a(renderblocks.field_147878_ac, renderblocks.field_147866_ai, renderblocks.field_147879_ad, tempBrightness);
                i2 = renderblocks.func_147778_a(renderblocks.field_147825_U, renderblocks.field_147827_W, renderblocks.field_147866_ai, tempBrightness);
                l1 = renderblocks.func_147778_a(renderblocks.field_147832_R, renderblocks.field_147883_ah, renderblocks.field_147825_U, tempBrightness);
                renderblocks.field_147864_al = renderblocks.func_147727_a(k1, j1, i2, l1, renderblocks.field_147857_k * (1.0 - renderblocks.field_147859_h), renderblocks.field_147857_k * renderblocks.field_147859_h, (1.0 - renderblocks.field_147857_k) * renderblocks.field_147859_h, (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147859_h));
                renderblocks.field_147874_am = renderblocks.func_147727_a(k1, j1, i2, l1, renderblocks.field_147857_k * (1.0 - renderblocks.field_147861_i), renderblocks.field_147857_k * renderblocks.field_147861_i, (1.0 - renderblocks.field_147857_k) * renderblocks.field_147861_i, (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147861_i));
                renderblocks.field_147876_an = renderblocks.func_147727_a(k1, j1, i2, l1, renderblocks.field_147855_j * (1.0 - renderblocks.field_147861_i), renderblocks.field_147855_j * renderblocks.field_147861_i, (1.0 - renderblocks.field_147855_j) * renderblocks.field_147861_i, (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147861_i));
                renderblocks.field_147870_ao = renderblocks.func_147727_a(k1, j1, i2, l1, renderblocks.field_147855_j * (1.0 - renderblocks.field_147859_h), renderblocks.field_147855_j * renderblocks.field_147859_h, (1.0 - renderblocks.field_147855_j) * renderblocks.field_147859_h, (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147859_h));
            }
            if (flag1) {
                renderblocks.field_147850_ar = renderblocks.field_147848_as = valR * 0.8f;
                renderblocks.field_147852_aq = renderblocks.field_147848_as;
                renderblocks.field_147872_ap = renderblocks.field_147848_as;
                renderblocks.field_147858_av = renderblocks.field_147856_aw = valG * 0.8f;
                renderblocks.field_147860_au = renderblocks.field_147856_aw;
                renderblocks.field_147846_at = renderblocks.field_147856_aw;
                renderblocks.field_147839_az = renderblocks.field_147833_aA = valB * 0.8f;
                renderblocks.field_147841_ay = renderblocks.field_147833_aA;
                renderblocks.field_147854_ax = renderblocks.field_147833_aA;
            } else {
                renderblocks.field_147848_as = 0.8f;
                renderblocks.field_147850_ar = 0.8f;
                renderblocks.field_147852_aq = 0.8f;
                renderblocks.field_147872_ap = 0.8f;
                renderblocks.field_147856_aw = 0.8f;
                renderblocks.field_147858_av = 0.8f;
                renderblocks.field_147860_au = 0.8f;
                renderblocks.field_147846_at = 0.8f;
                renderblocks.field_147833_aA = 0.8f;
                renderblocks.field_147839_az = 0.8f;
                renderblocks.field_147841_ay = 0.8f;
                renderblocks.field_147854_ax = 0.8f;
            }
            renderblocks.field_147872_ap *= colorTL;
            renderblocks.field_147846_at *= colorTL;
            renderblocks.field_147854_ax *= colorTL;
            renderblocks.field_147852_aq *= colorBL;
            renderblocks.field_147860_au *= colorBL;
            renderblocks.field_147841_ay *= colorBL;
            renderblocks.field_147850_ar *= colorBR;
            renderblocks.field_147858_av *= colorBR;
            renderblocks.field_147839_az *= colorBR;
            renderblocks.field_147848_as *= colorTR;
            renderblocks.field_147856_aw *= colorTR;
            renderblocks.field_147833_aA *= colorTR;
            this.renderFace(renderblocks, block, x, y, z, 2);
        }
        if (!this.faceSkip[3] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y, z + 1, 3))) {
            if (renderblocks.field_147853_m >= 1.0) {
                ++z;
            }
            renderblocks.field_147830_P = renderblocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            renderblocks.field_147829_Q = renderblocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            renderblocks.field_147815_B = renderblocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderblocks.field_147817_L = renderblocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderblocks.field_147868_aj = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z);
            renderblocks.field_147862_ak = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z);
            renderblocks.field_147828_V = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z);
            renderblocks.field_147887_af = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z);
            flag3 = renderblocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149751_l();
            flag2 = renderblocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149751_l();
            flag5 = renderblocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149751_l();
            flag4 = renderblocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149751_l();
            if (!flag2 && !flag4) {
                renderblocks.field_147884_z = renderblocks.field_147830_P;
                renderblocks.field_147826_T = renderblocks.field_147868_aj;
            } else {
                renderblocks.field_147884_z = renderblocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I();
                renderblocks.field_147826_T = block.func_149677_c(renderblocks.field_147845_a, x - 1, y - 1, z);
            }
            if (!flag2 && !flag5) {
                renderblocks.field_147821_H = renderblocks.field_147830_P;
                renderblocks.field_147881_ab = renderblocks.field_147868_aj;
            } else {
                renderblocks.field_147821_H = renderblocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I();
                renderblocks.field_147881_ab = block.func_149677_c(renderblocks.field_147845_a, x - 1, y + 1, z);
            }
            if (!flag3 && !flag4) {
                renderblocks.field_147811_E = renderblocks.field_147829_Q;
                renderblocks.field_147834_Y = renderblocks.field_147862_ak;
            } else {
                renderblocks.field_147811_E = renderblocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I();
                renderblocks.field_147834_Y = block.func_149677_c(renderblocks.field_147845_a, x + 1, y - 1, z);
            }
            if (!flag3 && !flag5) {
                renderblocks.field_147818_M = renderblocks.field_147829_Q;
                renderblocks.field_147882_ag = renderblocks.field_147862_ak;
            } else {
                renderblocks.field_147818_M = renderblocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I();
                renderblocks.field_147882_ag = block.func_149677_c(renderblocks.field_147845_a, x + 1, y + 1, z);
            }
            if (renderblocks.field_147853_m >= 1.0) {
                --z;
            }
            tempBrightness = masterBrightness;
            if (renderblocks.field_147853_m >= 1.0 || !renderblocks.field_147845_a.func_147439_a(x, y, z + 1).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderblocks.field_147845_a, x, y, z + 1);
            }
            aoLightValue = renderblocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            if (fullBlock) {
                colorTL = (renderblocks.field_147830_P + renderblocks.field_147821_H + aoLightValue + renderblocks.field_147817_L) / 4.0f;
                colorTR = (aoLightValue + renderblocks.field_147817_L + renderblocks.field_147829_Q + renderblocks.field_147818_M) / 4.0f;
                colorBR = (renderblocks.field_147815_B + aoLightValue + renderblocks.field_147811_E + renderblocks.field_147829_Q) / 4.0f;
                colorBL = (renderblocks.field_147884_z + renderblocks.field_147830_P + renderblocks.field_147815_B + aoLightValue) / 4.0f;
                renderblocks.field_147864_al = renderblocks.func_147778_a(renderblocks.field_147868_aj, renderblocks.field_147881_ab, renderblocks.field_147887_af, tempBrightness);
                renderblocks.field_147870_ao = renderblocks.func_147778_a(renderblocks.field_147887_af, renderblocks.field_147862_ak, renderblocks.field_147882_ag, tempBrightness);
                renderblocks.field_147876_an = renderblocks.func_147778_a(renderblocks.field_147828_V, renderblocks.field_147834_Y, renderblocks.field_147862_ak, tempBrightness);
                renderblocks.field_147874_am = renderblocks.func_147778_a(renderblocks.field_147826_T, renderblocks.field_147868_aj, renderblocks.field_147828_V, tempBrightness);
            } else {
                f9 = (renderblocks.field_147830_P + renderblocks.field_147821_H + aoLightValue + renderblocks.field_147817_L) / 4.0f;
                f8 = (aoLightValue + renderblocks.field_147817_L + renderblocks.field_147829_Q + renderblocks.field_147818_M) / 4.0f;
                f11 = (renderblocks.field_147815_B + aoLightValue + renderblocks.field_147811_E + renderblocks.field_147829_Q) / 4.0f;
                f10 = (renderblocks.field_147884_z + renderblocks.field_147830_P + renderblocks.field_147815_B + aoLightValue) / 4.0f;
                colorTL = (float)((double)f9 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147859_h) + (double)f8 * renderblocks.field_147857_k * renderblocks.field_147859_h + (double)f11 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147859_h + (double)f10 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147859_h));
                colorBL = (float)((double)f9 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147859_h) + (double)f8 * renderblocks.field_147855_j * renderblocks.field_147859_h + (double)f11 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147859_h + (double)f10 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147859_h));
                colorBR = (float)((double)f9 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147861_i) + (double)f8 * renderblocks.field_147855_j * renderblocks.field_147861_i + (double)f11 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147861_i + (double)f10 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147861_i));
                colorTR = (float)((double)f9 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147861_i) + (double)f8 * renderblocks.field_147857_k * renderblocks.field_147861_i + (double)f11 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147861_i + (double)f10 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147861_i));
                k1 = renderblocks.func_147778_a(renderblocks.field_147868_aj, renderblocks.field_147881_ab, renderblocks.field_147887_af, tempBrightness);
                j1 = renderblocks.func_147778_a(renderblocks.field_147887_af, renderblocks.field_147862_ak, renderblocks.field_147882_ag, tempBrightness);
                i2 = renderblocks.func_147778_a(renderblocks.field_147828_V, renderblocks.field_147834_Y, renderblocks.field_147862_ak, tempBrightness);
                l1 = renderblocks.func_147778_a(renderblocks.field_147826_T, renderblocks.field_147868_aj, renderblocks.field_147828_V, tempBrightness);
                renderblocks.field_147864_al = renderblocks.func_147727_a(k1, l1, i2, j1, renderblocks.field_147857_k * (1.0 - renderblocks.field_147859_h), (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147859_h), (1.0 - renderblocks.field_147857_k) * renderblocks.field_147859_h, renderblocks.field_147857_k * renderblocks.field_147859_h);
                renderblocks.field_147874_am = renderblocks.func_147727_a(k1, l1, i2, j1, renderblocks.field_147855_j * (1.0 - renderblocks.field_147859_h), (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147859_h), (1.0 - renderblocks.field_147855_j) * renderblocks.field_147859_h, renderblocks.field_147855_j * renderblocks.field_147859_h);
                renderblocks.field_147876_an = renderblocks.func_147727_a(k1, l1, i2, j1, renderblocks.field_147855_j * (1.0 - renderblocks.field_147861_i), (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147861_i), (1.0 - renderblocks.field_147855_j) * renderblocks.field_147861_i, renderblocks.field_147855_j * renderblocks.field_147861_i);
                renderblocks.field_147870_ao = renderblocks.func_147727_a(k1, l1, i2, j1, renderblocks.field_147857_k * (1.0 - renderblocks.field_147861_i), (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147861_i), (1.0 - renderblocks.field_147857_k) * renderblocks.field_147861_i, renderblocks.field_147857_k * renderblocks.field_147861_i);
            }
            if (flag1) {
                renderblocks.field_147850_ar = renderblocks.field_147848_as = valR * 0.8f;
                renderblocks.field_147852_aq = renderblocks.field_147848_as;
                renderblocks.field_147872_ap = renderblocks.field_147848_as;
                renderblocks.field_147858_av = renderblocks.field_147856_aw = valG * 0.8f;
                renderblocks.field_147860_au = renderblocks.field_147856_aw;
                renderblocks.field_147846_at = renderblocks.field_147856_aw;
                renderblocks.field_147839_az = renderblocks.field_147833_aA = valB * 0.8f;
                renderblocks.field_147841_ay = renderblocks.field_147833_aA;
                renderblocks.field_147854_ax = renderblocks.field_147833_aA;
            } else {
                renderblocks.field_147848_as = 0.8f;
                renderblocks.field_147850_ar = 0.8f;
                renderblocks.field_147852_aq = 0.8f;
                renderblocks.field_147872_ap = 0.8f;
                renderblocks.field_147856_aw = 0.8f;
                renderblocks.field_147858_av = 0.8f;
                renderblocks.field_147860_au = 0.8f;
                renderblocks.field_147846_at = 0.8f;
                renderblocks.field_147833_aA = 0.8f;
                renderblocks.field_147839_az = 0.8f;
                renderblocks.field_147841_ay = 0.8f;
                renderblocks.field_147854_ax = 0.8f;
            }
            renderblocks.field_147872_ap *= colorTL;
            renderblocks.field_147846_at *= colorTL;
            renderblocks.field_147854_ax *= colorTL;
            renderblocks.field_147852_aq *= colorBL;
            renderblocks.field_147860_au *= colorBL;
            renderblocks.field_147841_ay *= colorBL;
            renderblocks.field_147850_ar *= colorBR;
            renderblocks.field_147858_av *= colorBR;
            renderblocks.field_147839_az *= colorBR;
            renderblocks.field_147848_as *= colorTR;
            renderblocks.field_147856_aw *= colorTR;
            renderblocks.field_147833_aA *= colorTR;
            this.renderFace(renderblocks, block, x, y, z, 3);
        }
        if (!this.faceSkip[4] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x - 1, y, z, 4))) {
            if (renderblocks.field_147859_h <= 0.0) {
                --x;
            }
            renderblocks.field_147886_y = renderblocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderblocks.field_147819_N = renderblocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderblocks.field_147830_P = renderblocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            renderblocks.field_147813_G = renderblocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderblocks.field_147831_S = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z);
            renderblocks.field_147883_ah = block.func_149677_c(renderblocks.field_147845_a, x, y, z - 1);
            renderblocks.field_147868_aj = block.func_149677_c(renderblocks.field_147845_a, x, y, z + 1);
            renderblocks.field_147880_aa = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z);
            flag3 = renderblocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149751_l();
            flag2 = renderblocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149751_l();
            flag5 = renderblocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149751_l();
            flag4 = renderblocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149751_l();
            if (!flag5 && !flag2) {
                renderblocks.field_147888_x = renderblocks.field_147819_N;
                renderblocks.field_147832_R = renderblocks.field_147883_ah;
            } else {
                renderblocks.field_147888_x = renderblocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I();
                renderblocks.field_147832_R = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z - 1);
            }
            if (!flag4 && !flag2) {
                renderblocks.field_147884_z = renderblocks.field_147830_P;
                renderblocks.field_147826_T = renderblocks.field_147868_aj;
            } else {
                renderblocks.field_147884_z = renderblocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I();
                renderblocks.field_147826_T = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z + 1);
            }
            if (!flag5 && !flag3) {
                renderblocks.field_147812_F = renderblocks.field_147819_N;
                renderblocks.field_147836_Z = renderblocks.field_147883_ah;
            } else {
                renderblocks.field_147812_F = renderblocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I();
                renderblocks.field_147836_Z = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z - 1);
            }
            if (!flag4 && !flag3) {
                renderblocks.field_147821_H = renderblocks.field_147830_P;
                renderblocks.field_147881_ab = renderblocks.field_147868_aj;
            } else {
                renderblocks.field_147821_H = renderblocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I();
                renderblocks.field_147881_ab = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z + 1);
            }
            if (renderblocks.field_147859_h <= 0.0) {
                ++x;
            }
            tempBrightness = masterBrightness;
            if (renderblocks.field_147859_h <= 0.0 || !renderblocks.field_147845_a.func_147439_a(x - 1, y, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z);
            }
            aoLightValue = renderblocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            if (fullBlock) {
                colorTR = (renderblocks.field_147886_y + renderblocks.field_147884_z + aoLightValue + renderblocks.field_147830_P) / 4.0f;
                colorTL = (aoLightValue + renderblocks.field_147830_P + renderblocks.field_147813_G + renderblocks.field_147821_H) / 4.0f;
                colorBL = (renderblocks.field_147819_N + aoLightValue + renderblocks.field_147812_F + renderblocks.field_147813_G) / 4.0f;
                colorBR = (renderblocks.field_147888_x + renderblocks.field_147886_y + renderblocks.field_147819_N + aoLightValue) / 4.0f;
                renderblocks.field_147870_ao = renderblocks.func_147778_a(renderblocks.field_147831_S, renderblocks.field_147826_T, renderblocks.field_147868_aj, tempBrightness);
                renderblocks.field_147864_al = renderblocks.func_147778_a(renderblocks.field_147868_aj, renderblocks.field_147880_aa, renderblocks.field_147881_ab, tempBrightness);
                renderblocks.field_147874_am = renderblocks.func_147778_a(renderblocks.field_147883_ah, renderblocks.field_147836_Z, renderblocks.field_147880_aa, tempBrightness);
                renderblocks.field_147876_an = renderblocks.func_147778_a(renderblocks.field_147832_R, renderblocks.field_147831_S, renderblocks.field_147883_ah, tempBrightness);
            } else {
                f9 = (renderblocks.field_147886_y + renderblocks.field_147884_z + aoLightValue + renderblocks.field_147830_P) / 4.0f;
                f8 = (aoLightValue + renderblocks.field_147830_P + renderblocks.field_147813_G + renderblocks.field_147821_H) / 4.0f;
                f11 = (renderblocks.field_147819_N + aoLightValue + renderblocks.field_147812_F + renderblocks.field_147813_G) / 4.0f;
                f10 = (renderblocks.field_147888_x + renderblocks.field_147886_y + renderblocks.field_147819_N + aoLightValue) / 4.0f;
                colorTL = (float)((double)f8 * renderblocks.field_147857_k * renderblocks.field_147853_m + (double)f11 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147853_m) + (double)f10 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147853_m) + (double)f9 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147853_m);
                colorBL = (float)((double)f8 * renderblocks.field_147857_k * renderblocks.field_147851_l + (double)f11 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147851_l) + (double)f10 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147851_l) + (double)f9 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147851_l);
                colorBR = (float)((double)f8 * renderblocks.field_147855_j * renderblocks.field_147851_l + (double)f11 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147851_l) + (double)f10 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147851_l) + (double)f9 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147851_l);
                colorTR = (float)((double)f8 * renderblocks.field_147855_j * renderblocks.field_147853_m + (double)f11 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147853_m) + (double)f10 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147853_m) + (double)f9 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147853_m);
                k1 = renderblocks.func_147778_a(renderblocks.field_147831_S, renderblocks.field_147826_T, renderblocks.field_147868_aj, tempBrightness);
                j1 = renderblocks.func_147778_a(renderblocks.field_147868_aj, renderblocks.field_147880_aa, renderblocks.field_147881_ab, tempBrightness);
                i2 = renderblocks.func_147778_a(renderblocks.field_147883_ah, renderblocks.field_147836_Z, renderblocks.field_147880_aa, tempBrightness);
                l1 = renderblocks.func_147778_a(renderblocks.field_147832_R, renderblocks.field_147831_S, renderblocks.field_147883_ah, tempBrightness);
                renderblocks.field_147864_al = renderblocks.func_147727_a(j1, i2, l1, k1, renderblocks.field_147857_k * renderblocks.field_147853_m, renderblocks.field_147857_k * (1.0 - renderblocks.field_147853_m), (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147853_m), (1.0 - renderblocks.field_147857_k) * renderblocks.field_147853_m);
                renderblocks.field_147874_am = renderblocks.func_147727_a(j1, i2, l1, k1, renderblocks.field_147857_k * renderblocks.field_147851_l, renderblocks.field_147857_k * (1.0 - renderblocks.field_147851_l), (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147851_l), (1.0 - renderblocks.field_147857_k) * renderblocks.field_147851_l);
                renderblocks.field_147876_an = renderblocks.func_147727_a(j1, i2, l1, k1, renderblocks.field_147855_j * renderblocks.field_147851_l, renderblocks.field_147855_j * (1.0 - renderblocks.field_147851_l), (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147851_l), (1.0 - renderblocks.field_147855_j) * renderblocks.field_147851_l);
                renderblocks.field_147870_ao = renderblocks.func_147727_a(j1, i2, l1, k1, renderblocks.field_147855_j * renderblocks.field_147853_m, renderblocks.field_147855_j * (1.0 - renderblocks.field_147853_m), (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147853_m), (1.0 - renderblocks.field_147855_j) * renderblocks.field_147853_m);
            }
            if (flag1) {
                renderblocks.field_147850_ar = renderblocks.field_147848_as = valR * 0.6f;
                renderblocks.field_147852_aq = renderblocks.field_147848_as;
                renderblocks.field_147872_ap = renderblocks.field_147848_as;
                renderblocks.field_147858_av = renderblocks.field_147856_aw = valG * 0.6f;
                renderblocks.field_147860_au = renderblocks.field_147856_aw;
                renderblocks.field_147846_at = renderblocks.field_147856_aw;
                renderblocks.field_147839_az = renderblocks.field_147833_aA = valB * 0.6f;
                renderblocks.field_147841_ay = renderblocks.field_147833_aA;
                renderblocks.field_147854_ax = renderblocks.field_147833_aA;
            } else {
                renderblocks.field_147848_as = 0.6f;
                renderblocks.field_147850_ar = 0.6f;
                renderblocks.field_147852_aq = 0.6f;
                renderblocks.field_147872_ap = 0.6f;
                renderblocks.field_147856_aw = 0.6f;
                renderblocks.field_147858_av = 0.6f;
                renderblocks.field_147860_au = 0.6f;
                renderblocks.field_147846_at = 0.6f;
                renderblocks.field_147833_aA = 0.6f;
                renderblocks.field_147839_az = 0.6f;
                renderblocks.field_147841_ay = 0.6f;
                renderblocks.field_147854_ax = 0.6f;
            }
            renderblocks.field_147872_ap *= colorTL;
            renderblocks.field_147846_at *= colorTL;
            renderblocks.field_147854_ax *= colorTL;
            renderblocks.field_147852_aq *= colorBL;
            renderblocks.field_147860_au *= colorBL;
            renderblocks.field_147841_ay *= colorBL;
            renderblocks.field_147850_ar *= colorBR;
            renderblocks.field_147858_av *= colorBR;
            renderblocks.field_147839_az *= colorBR;
            renderblocks.field_147848_as *= colorTR;
            renderblocks.field_147856_aw *= colorTR;
            renderblocks.field_147833_aA *= colorTR;
            this.renderFace(renderblocks, block, x, y, z, 4);
        }
        if (!this.faceSkip[5] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x + 1, y, z, 5))) {
            if (renderblocks.field_147861_i >= 1.0) {
                ++x;
            }
            renderblocks.field_147810_D = renderblocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            renderblocks.field_147820_O = renderblocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            renderblocks.field_147829_Q = renderblocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            renderblocks.field_147824_K = renderblocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            renderblocks.field_147835_X = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z);
            renderblocks.field_147866_ai = block.func_149677_c(renderblocks.field_147845_a, x, y, z - 1);
            renderblocks.field_147862_ak = block.func_149677_c(renderblocks.field_147845_a, x, y, z + 1);
            renderblocks.field_147885_ae = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z);
            flag3 = renderblocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149751_l();
            flag2 = renderblocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149751_l();
            flag5 = renderblocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149751_l();
            flag4 = renderblocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149751_l();
            if (!flag2 && !flag4) {
                renderblocks.field_147816_C = renderblocks.field_147820_O;
                renderblocks.field_147827_W = renderblocks.field_147866_ai;
            } else {
                renderblocks.field_147816_C = renderblocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I();
                renderblocks.field_147827_W = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z - 1);
            }
            if (!flag2 && !flag5) {
                renderblocks.field_147811_E = renderblocks.field_147829_Q;
                renderblocks.field_147834_Y = renderblocks.field_147862_ak;
            } else {
                renderblocks.field_147811_E = renderblocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I();
                renderblocks.field_147834_Y = block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z + 1);
            }
            if (!flag3 && !flag4) {
                renderblocks.field_147823_J = renderblocks.field_147820_O;
                renderblocks.field_147879_ad = renderblocks.field_147866_ai;
            } else {
                renderblocks.field_147823_J = renderblocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I();
                renderblocks.field_147879_ad = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z - 1);
            }
            if (!flag3 && !flag5) {
                renderblocks.field_147818_M = renderblocks.field_147829_Q;
                renderblocks.field_147882_ag = renderblocks.field_147862_ak;
            } else {
                renderblocks.field_147818_M = renderblocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I();
                renderblocks.field_147882_ag = block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z + 1);
            }
            if (renderblocks.field_147861_i >= 1.0) {
                --x;
            }
            tempBrightness = masterBrightness;
            if (renderblocks.field_147861_i >= 1.0 || !renderblocks.field_147845_a.func_147439_a(x + 1, y, z).func_149662_c()) {
                tempBrightness = block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z);
            }
            aoLightValue = renderblocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            if (fullBlock) {
                colorTL = (renderblocks.field_147810_D + renderblocks.field_147811_E + aoLightValue + renderblocks.field_147829_Q) / 4.0f;
                colorBL = (renderblocks.field_147816_C + renderblocks.field_147810_D + renderblocks.field_147820_O + aoLightValue) / 4.0f;
                colorBR = (renderblocks.field_147820_O + aoLightValue + renderblocks.field_147823_J + renderblocks.field_147824_K) / 4.0f;
                colorTR = (aoLightValue + renderblocks.field_147829_Q + renderblocks.field_147824_K + renderblocks.field_147818_M) / 4.0f;
                renderblocks.field_147864_al = renderblocks.func_147778_a(renderblocks.field_147835_X, renderblocks.field_147834_Y, renderblocks.field_147862_ak, tempBrightness);
                renderblocks.field_147870_ao = renderblocks.func_147778_a(renderblocks.field_147862_ak, renderblocks.field_147885_ae, renderblocks.field_147882_ag, tempBrightness);
                renderblocks.field_147876_an = renderblocks.func_147778_a(renderblocks.field_147866_ai, renderblocks.field_147879_ad, renderblocks.field_147885_ae, tempBrightness);
                renderblocks.field_147874_am = renderblocks.func_147778_a(renderblocks.field_147827_W, renderblocks.field_147835_X, renderblocks.field_147866_ai, tempBrightness);
            } else {
                f9 = (renderblocks.field_147810_D + renderblocks.field_147811_E + aoLightValue + renderblocks.field_147829_Q) / 4.0f;
                f8 = (renderblocks.field_147816_C + renderblocks.field_147810_D + renderblocks.field_147820_O + aoLightValue) / 4.0f;
                f11 = (renderblocks.field_147820_O + aoLightValue + renderblocks.field_147823_J + renderblocks.field_147824_K) / 4.0f;
                f10 = (aoLightValue + renderblocks.field_147829_Q + renderblocks.field_147824_K + renderblocks.field_147818_M) / 4.0f;
                colorTL = (float)((double)f9 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147853_m + (double)f8 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147853_m) + (double)f11 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147853_m) + (double)f10 * renderblocks.field_147855_j * renderblocks.field_147853_m);
                colorBL = (float)((double)f9 * (1.0 - renderblocks.field_147855_j) * renderblocks.field_147851_l + (double)f8 * (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147851_l) + (double)f11 * renderblocks.field_147855_j * (1.0 - renderblocks.field_147851_l) + (double)f10 * renderblocks.field_147855_j * renderblocks.field_147851_l);
                colorBR = (float)((double)f9 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147851_l + (double)f8 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147851_l) + (double)f11 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147851_l) + (double)f10 * renderblocks.field_147857_k * renderblocks.field_147851_l);
                colorTR = (float)((double)f9 * (1.0 - renderblocks.field_147857_k) * renderblocks.field_147853_m + (double)f8 * (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147853_m) + (double)f11 * renderblocks.field_147857_k * (1.0 - renderblocks.field_147853_m) + (double)f10 * renderblocks.field_147857_k * renderblocks.field_147853_m);
                k1 = renderblocks.func_147778_a(renderblocks.field_147835_X, renderblocks.field_147834_Y, renderblocks.field_147862_ak, tempBrightness);
                j1 = renderblocks.func_147778_a(renderblocks.field_147862_ak, renderblocks.field_147885_ae, renderblocks.field_147882_ag, tempBrightness);
                i2 = renderblocks.func_147778_a(renderblocks.field_147866_ai, renderblocks.field_147879_ad, renderblocks.field_147885_ae, tempBrightness);
                l1 = renderblocks.func_147778_a(renderblocks.field_147827_W, renderblocks.field_147835_X, renderblocks.field_147866_ai, tempBrightness);
                renderblocks.field_147864_al = renderblocks.func_147727_a(k1, l1, i2, j1, (1.0 - renderblocks.field_147855_j) * renderblocks.field_147853_m, (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147853_m), renderblocks.field_147855_j * (1.0 - renderblocks.field_147853_m), renderblocks.field_147855_j * renderblocks.field_147853_m);
                renderblocks.field_147874_am = renderblocks.func_147727_a(k1, l1, i2, j1, (1.0 - renderblocks.field_147855_j) * renderblocks.field_147851_l, (1.0 - renderblocks.field_147855_j) * (1.0 - renderblocks.field_147851_l), renderblocks.field_147855_j * (1.0 - renderblocks.field_147851_l), renderblocks.field_147855_j * renderblocks.field_147851_l);
                renderblocks.field_147876_an = renderblocks.func_147727_a(k1, l1, i2, j1, (1.0 - renderblocks.field_147857_k) * renderblocks.field_147851_l, (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147851_l), renderblocks.field_147857_k * (1.0 - renderblocks.field_147851_l), renderblocks.field_147857_k * renderblocks.field_147851_l);
                renderblocks.field_147870_ao = renderblocks.func_147727_a(k1, l1, i2, j1, (1.0 - renderblocks.field_147857_k) * renderblocks.field_147853_m, (1.0 - renderblocks.field_147857_k) * (1.0 - renderblocks.field_147853_m), renderblocks.field_147857_k * (1.0 - renderblocks.field_147853_m), renderblocks.field_147857_k * renderblocks.field_147853_m);
            }
            if (flag1) {
                renderblocks.field_147850_ar = renderblocks.field_147848_as = valR * 0.6f;
                renderblocks.field_147852_aq = renderblocks.field_147848_as;
                renderblocks.field_147872_ap = renderblocks.field_147848_as;
                renderblocks.field_147858_av = renderblocks.field_147856_aw = valG * 0.6f;
                renderblocks.field_147860_au = renderblocks.field_147856_aw;
                renderblocks.field_147846_at = renderblocks.field_147856_aw;
                renderblocks.field_147839_az = renderblocks.field_147833_aA = valB * 0.6f;
                renderblocks.field_147841_ay = renderblocks.field_147833_aA;
                renderblocks.field_147854_ax = renderblocks.field_147833_aA;
            } else {
                renderblocks.field_147848_as = 0.6f;
                renderblocks.field_147850_ar = 0.6f;
                renderblocks.field_147852_aq = 0.6f;
                renderblocks.field_147872_ap = 0.6f;
                renderblocks.field_147856_aw = 0.6f;
                renderblocks.field_147858_av = 0.6f;
                renderblocks.field_147860_au = 0.6f;
                renderblocks.field_147846_at = 0.6f;
                renderblocks.field_147833_aA = 0.6f;
                renderblocks.field_147839_az = 0.6f;
                renderblocks.field_147841_ay = 0.6f;
                renderblocks.field_147854_ax = 0.6f;
            }
            renderblocks.field_147872_ap *= colorTL;
            renderblocks.field_147846_at *= colorTL;
            renderblocks.field_147854_ax *= colorTL;
            renderblocks.field_147852_aq *= colorBL;
            renderblocks.field_147860_au *= colorBL;
            renderblocks.field_147841_ay *= colorBL;
            renderblocks.field_147850_ar *= colorBR;
            renderblocks.field_147858_av *= colorBR;
            renderblocks.field_147839_az *= colorBR;
            renderblocks.field_147848_as *= colorTR;
            renderblocks.field_147856_aw *= colorTR;
            renderblocks.field_147833_aA *= colorTR;
            this.renderFace(renderblocks, block, x, y, z, 5);
        }
        renderblocks.field_147863_w = false;
        return true;
    }

    private boolean withColorMultiplier(RenderBlocks renderblocks, Block block, int x, int y, int z, float valR, float valG, float valB) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int brightness = block.func_149677_c(renderblocks.field_147845_a, x, y, z);
        if (!this.faceSkip[0] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y - 1, z, 0))) {
            tessellator.func_78380_c(renderblocks.field_147855_j > 0.0 ? brightness : block.func_149677_c(renderblocks.field_147845_a, x, y - 1, z));
            tessellator.func_78386_a(valR * 0.5f, valG * 0.5f, valB * 0.5f);
            this.renderFace(renderblocks, block, x, y, z, 0);
        }
        if (!this.faceSkip[1] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y + 1, z, 1))) {
            tessellator.func_78380_c(renderblocks.field_147857_k > 0.0 ? brightness : block.func_149677_c(renderblocks.field_147845_a, x, y + 1, z));
            tessellator.func_78386_a(valR, valG, valB);
            this.renderFace(renderblocks, block, x, y, z, 1);
        }
        if (!this.faceSkip[2] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y, z - 1, 2))) {
            tessellator.func_78380_c(renderblocks.field_147851_l > 0.0 ? brightness : block.func_149677_c(renderblocks.field_147845_a, x, y, z - 1));
            tessellator.func_78386_a(valR * 0.8f, valG * 0.8f, valB * 0.8f);
            this.renderFace(renderblocks, block, x, y, z, 2);
        }
        if (!this.faceSkip[3] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x, y, z + 1, 3))) {
            tessellator.func_78380_c(renderblocks.field_147853_m < 1.0 ? brightness : block.func_149677_c(renderblocks.field_147845_a, x, y, z + 1));
            tessellator.func_78386_a(valR * 0.8f, valG * 0.8f, valB * 0.8f);
            this.renderFace(renderblocks, block, x, y, z, 3);
        }
        if (!this.faceSkip[4] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x - 1, y, z, 4))) {
            tessellator.func_78380_c(renderblocks.field_147859_h > 0.0 ? brightness : block.func_149677_c(renderblocks.field_147845_a, x - 1, y, z));
            tessellator.func_78386_a(valR * 0.6f, valG * 0.6f, valB * 0.6f);
            this.renderFace(renderblocks, block, x, y, z, 4);
        }
        if (!this.faceSkip[5] && (renderblocks.field_147837_f || block.func_149646_a(renderblocks.field_147845_a, x + 1, y, z, 5))) {
            tessellator.func_78380_c(renderblocks.field_147861_i < 1.0 ? brightness : block.func_149677_c(renderblocks.field_147845_a, x + 1, y, z));
            tessellator.func_78386_a(valR * 0.6f, valG * 0.6f, valB * 0.6f);
            this.renderFace(renderblocks, block, x, y, z, 5);
        }
        return true;
    }

    private void renderFace(RenderBlocks renderblocks, Block block, int x, int y, int z, int side) {
        IIcon icon = this.iconIndex[side] != null ? renderblocks.func_147758_b(this.iconIndex[side]) : renderblocks.func_147793_a(block, renderblocks.field_147845_a, x, y, z, side);
        byte subIcon = this.subIcon[side];
        double[] pX = new double[]{renderblocks.field_147859_h, renderblocks.field_147861_i};
        double[] pY = new double[]{renderblocks.field_147855_j, renderblocks.field_147857_k};
        double[] pZ = new double[]{renderblocks.field_147851_l, renderblocks.field_147853_m};
        double[] rX = new double[]{(double)x + pX[0], (double)x + pX[1]};
        double[] rY = new double[]{(double)y + pY[0], (double)y + pY[1]};
        double[] rZ = new double[]{(double)z + pZ[0], (double)z + pZ[1]};
        double difX = (pX[1] - pX[0]) / 2.0;
        double difY = (pY[1] - pY[0]) / 2.0;
        double difZ = (pZ[1] - pZ[0]) / 2.0;
        if (side == 0 || side == 1) {
            if (subIcon > 0 && subIcon < 5) {
                if (subIcon % 2 == 0) {
                    pX[0] = pX[0] + difX;
                } else {
                    pX[1] = pX[1] - difX;
                }
                if (subIcon > 2) {
                    pZ[0] = pZ[0] + difZ;
                } else {
                    pZ[1] = pZ[1] - difZ;
                }
            }
            if (side == 0) {
                this.renderBottom(renderblocks, icon, pX, pZ, rX, rY[0], rZ);
            } else {
                this.renderTop(renderblocks, icon, pX, pZ, rX, rY[1], rZ);
            }
        } else if (side == 2 || side == 3) {
            if (subIcon > 0 && subIcon < 5) {
                if (subIcon % 2 == 0) {
                    pX[0] = pX[0] + difX;
                    pZ[0] = pZ[0] + difZ;
                } else {
                    pX[1] = pX[1] - difX;
                    pZ[1] = pZ[1] - difZ;
                }
                if (subIcon > 2) {
                    pY[0] = pY[0] + difY;
                } else {
                    pY[1] = pY[1] - difY;
                }
            }
            if (side == 2) {
                this.renderNorth(renderblocks, icon, pX, pY, rX, rY, rZ[0]);
            } else {
                this.renderSouth(renderblocks, icon, pX, pY, rX, rY, rZ[1]);
            }
        } else if (side == 4 || side == 5) {
            if (subIcon > 0 && subIcon < 5) {
                if (subIcon % 2 == 0) {
                    pY[0] = pY[0] + difY;
                } else {
                    pY[1] = pY[1] - difY;
                }
                if (subIcon > 2) {
                    pZ[0] = pZ[0] + difZ;
                } else {
                    pZ[1] = pZ[1] - difZ;
                }
            }
            if (side == 4) {
                this.renderWest(renderblocks, icon, pY, pZ, rX[0], rY, rZ);
            } else {
                this.renderEast(renderblocks, icon, pY, pZ, rX[1], rY, rZ);
            }
        }
    }

    private void renderBottom(RenderBlocks renderblocks, IIcon icon, double[] pX, double[] pZ, double[] rX, double rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateBottom) {
            default: {
                pt[0] = icon.func_94214_a(pX[0] * 16.0);
                pt[1] = icon.func_94214_a(pX[1] * 16.0);
                pt[2] = icon.func_94207_b(pZ[0] * 16.0);
                pt[3] = icon.func_94207_b(pZ[1] * 16.0);
                cords[0] = this.buildCords(rX[0], rY, rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(rX[0], rY, rZ[0], pt[0], pt[2]);
                cords[2] = this.buildCords(rX[1], rY, rZ[0], pt[1], pt[2]);
                cords[3] = this.buildCords(rX[1], rY, rZ[1], pt[1], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - pZ[1] * 16.0);
                pt[1] = icon.func_94207_b(pX[0] * 16.0);
                pt[2] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[3] = icon.func_94207_b(pX[1] * 16.0);
                cords[0] = this.buildCords(rX[0], rY, rZ[1], pt[0], pt[1]);
                cords[1] = this.buildCords(rX[0], rY, rZ[0], pt[2], pt[1]);
                cords[2] = this.buildCords(rX[1], rY, rZ[0], pt[2], pt[3]);
                cords[3] = this.buildCords(rX[1], rY, rZ[1], pt[0], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(pZ[0] * 16.0);
                pt[1] = icon.func_94207_b(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94214_a(pZ[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pX[0] * 16.0);
                cords[0] = this.buildCords(rX[0], rY, rZ[1], pt[2], pt[3]);
                cords[1] = this.buildCords(rX[0], rY, rZ[0], pt[0], pt[3]);
                cords[2] = this.buildCords(rX[1], rY, rZ[0], pt[0], pt[1]);
                cords[3] = this.buildCords(rX[1], rY, rZ[1], pt[2], pt[1]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pZ[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pZ[1] * 16.0);
                cords[0] = this.buildCords(rX[0], rY, rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(rX[0], rY, rZ[0], pt[0], pt[2]);
                cords[2] = this.buildCords(rX[1], rY, rZ[0], pt[1], pt[2]);
                cords[3] = this.buildCords(rX[1], rY, rZ[1], pt[1], pt[3]);
            }
        }
        this.render(renderblocks, cords, this.uvFlipBottom);
    }

    private void renderTop(RenderBlocks renderblocks, IIcon icon, double[] pX, double[] pZ, double[] rX, double rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateTop) {
            default: {
                pt[0] = icon.func_94214_a(pX[0] * 16.0);
                pt[1] = icon.func_94214_a(pX[1] * 16.0);
                pt[2] = icon.func_94207_b(pZ[0] * 16.0);
                pt[3] = icon.func_94207_b(pZ[1] * 16.0);
                cords[0] = this.buildCords(rX[1], rY, rZ[1], pt[1], pt[3]);
                cords[1] = this.buildCords(rX[1], rY, rZ[0], pt[1], pt[2]);
                cords[2] = this.buildCords(rX[0], rY, rZ[0], pt[0], pt[2]);
                cords[3] = this.buildCords(rX[0], rY, rZ[1], pt[0], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(pZ[0] * 16.0);
                pt[1] = icon.func_94207_b(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94214_a(pZ[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pX[0] * 16.0);
                cords[0] = this.buildCords(rX[1], rY, rZ[1], pt[2], pt[1]);
                cords[1] = this.buildCords(rX[1], rY, rZ[0], pt[0], pt[1]);
                cords[2] = this.buildCords(rX[0], rY, rZ[0], pt[0], pt[3]);
                cords[3] = this.buildCords(rX[0], rY, rZ[1], pt[2], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - pZ[1] * 16.0);
                pt[1] = icon.func_94207_b(pX[0] * 16.0);
                pt[2] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[3] = icon.func_94207_b(pX[1] * 16.0);
                cords[0] = this.buildCords(rX[1], rY, rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(rX[1], rY, rZ[0], pt[2], pt[3]);
                cords[2] = this.buildCords(rX[0], rY, rZ[0], pt[2], pt[1]);
                cords[3] = this.buildCords(rX[0], rY, rZ[1], pt[0], pt[1]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pZ[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pZ[1] * 16.0);
                cords[0] = this.buildCords(rX[1], rY, rZ[1], pt[1], pt[3]);
                cords[1] = this.buildCords(rX[1], rY, rZ[0], pt[1], pt[2]);
                cords[2] = this.buildCords(rX[0], rY, rZ[0], pt[0], pt[2]);
                cords[3] = this.buildCords(rX[0], rY, rZ[1], pt[0], pt[3]);
            }
        }
        this.render(renderblocks, cords, this.uvFlipTop);
    }

    private void renderNorth(RenderBlocks renderblocks, IIcon icon, double[] pX, double[] pY, double[] rX, double[] rY, double rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateNorth) {
            default: {
                pt[0] = icon.func_94214_a(pX[0] * 16.0);
                pt[1] = icon.func_94214_a(pX[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[1], pt[2]);
                cords[1] = this.buildCords(rX[1], rY[1], rZ, pt[0], pt[2]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[0], pt[3]);
                cords[3] = this.buildCords(rX[0], rY[0], rZ, pt[1], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - pY[1] * 16.0);
                pt[1] = icon.func_94214_a(pX[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(pX[0] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[2], pt[3]);
                cords[1] = this.buildCords(rX[1], rY[1], rZ, pt[2], pt[1]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[0], pt[1]);
                cords[3] = this.buildCords(rX[0], rY[0], rZ, pt[0], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(pY[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[2] = icon.func_94207_b(pY[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pX[1] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[0], pt[1]);
                cords[1] = this.buildCords(rX[1], rY[1], rZ, pt[0], pt[3]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[2], pt[3]);
                cords[3] = this.buildCords(rX[0], rY[0], rZ, pt[2], pt[1]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94207_b(pY[1] * 16.0);
                pt[3] = icon.func_94207_b(pY[0] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[1], pt[2]);
                cords[1] = this.buildCords(rX[1], rY[1], rZ, pt[0], pt[2]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[0], pt[3]);
                cords[3] = this.buildCords(rX[0], rY[0], rZ, pt[1], pt[3]);
            }
        }
        this.render(renderblocks, cords, this.uvFlipNorth);
    }

    private void renderSouth(RenderBlocks renderblocks, IIcon icon, double[] pX, double[] pY, double[] rX, double[] rY, double rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateSouth) {
            default: {
                pt[0] = icon.func_94214_a(16.0 - pX[1] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[0], pt[2]);
                cords[1] = this.buildCords(rX[0], rY[0], rZ, pt[0], pt[3]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[1], pt[3]);
                cords[3] = this.buildCords(rX[1], rY[1], rZ, pt[1], pt[2]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - pY[1] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pX[1] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[0], pt[1]);
                cords[1] = this.buildCords(rX[0], rY[0], rZ, pt[2], pt[1]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[2], pt[3]);
                cords[3] = this.buildCords(rX[1], rY[1], rZ, pt[0], pt[3]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - pY[1] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pX[0] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[2], pt[1]);
                cords[1] = this.buildCords(rX[0], rY[0], rZ, pt[0], pt[1]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[0], pt[3]);
                cords[3] = this.buildCords(rX[1], rY[1], rZ, pt[2], pt[3]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - pX[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pX[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pY[1] * 16.0);
                cords[0] = this.buildCords(rX[0], rY[1], rZ, pt[0], pt[2]);
                cords[1] = this.buildCords(rX[0], rY[0], rZ, pt[0], pt[3]);
                cords[2] = this.buildCords(rX[1], rY[0], rZ, pt[1], pt[3]);
                cords[3] = this.buildCords(rX[1], rY[1], rZ, pt[1], pt[2]);
            }
        }
        this.render(renderblocks, cords, this.uvFlipSouth);
    }

    private void renderWest(RenderBlocks renderblocks, IIcon icon, double[] pY, double[] pZ, double rX, double[] rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateWest) {
            default: {
                pt[0] = icon.func_94214_a(pZ[0] * 16.0);
                pt[1] = icon.func_94214_a(pZ[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                cords[0] = this.buildCords(rX, rY[1], rZ[1], pt[1], pt[2]);
                cords[1] = this.buildCords(rX, rY[1], rZ[0], pt[0], pt[2]);
                cords[2] = this.buildCords(rX, rY[0], rZ[0], pt[0], pt[3]);
                cords[3] = this.buildCords(rX, rY[0], rZ[1], pt[1], pt[3]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(pY[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pZ[1] * 16.0);
                pt[2] = icon.func_94207_b(pY[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pZ[0] * 16.0);
                cords[0] = this.buildCords(rX, rY[1], rZ[1], pt[0], pt[1]);
                cords[1] = this.buildCords(rX, rY[1], rZ[0], pt[0], pt[3]);
                cords[2] = this.buildCords(rX, rY[0], rZ[0], pt[2], pt[3]);
                cords[3] = this.buildCords(rX, rY[0], rZ[1], pt[2], pt[1]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - pY[1] * 16.0);
                pt[1] = icon.func_94214_a(pZ[0] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(pZ[1] * 16.0);
                cords[0] = this.buildCords(rX, rY[1], rZ[1], pt[2], pt[3]);
                cords[1] = this.buildCords(rX, rY[1], rZ[0], pt[2], pt[1]);
                cords[2] = this.buildCords(rX, rY[0], rZ[0], pt[0], pt[1]);
                cords[3] = this.buildCords(rX, rY[0], rZ[1], pt[0], pt[3]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pZ[1] * 16.0);
                pt[2] = icon.func_94207_b(pY[1] * 16.0);
                pt[3] = icon.func_94207_b(pY[0] * 16.0);
                cords[0] = this.buildCords(rX, rY[1], rZ[1], pt[1], pt[2]);
                cords[1] = this.buildCords(rX, rY[1], rZ[0], pt[0], pt[2]);
                cords[2] = this.buildCords(rX, rY[0], rZ[0], pt[0], pt[3]);
                cords[3] = this.buildCords(rX, rY[0], rZ[1], pt[1], pt[3]);
            }
        }
        this.render(renderblocks, cords, this.uvFlipWest);
    }

    private void renderEast(RenderBlocks renderblocks, IIcon icon, double[] pY, double[] pZ, double rX, double[] rY, double[] rZ) {
        double[][] cords = new double[4][5];
        double[] pt = new double[4];
        switch (this.uvRotateEast) {
            default: {
                pt[0] = icon.func_94214_a(16.0 - pZ[1] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[1] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                cords[0] = this.buildCords(rX, rY[0], rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(rX, rY[0], rZ[0], pt[1], pt[3]);
                cords[2] = this.buildCords(rX, rY[1], rZ[0], pt[1], pt[2]);
                cords[3] = this.buildCords(rX, rY[1], rZ[1], pt[0], pt[2]);
                break;
            }
            case 1: {
                pt[0] = icon.func_94214_a(16.0 - pY[1] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pZ[1] * 16.0);
                cords[0] = this.buildCords(rX, rY[0], rZ[1], pt[0], pt[1]);
                cords[1] = this.buildCords(rX, rY[0], rZ[0], pt[0], pt[3]);
                cords[2] = this.buildCords(rX, rY[1], rZ[0], pt[2], pt[3]);
                cords[3] = this.buildCords(rX, rY[1], rZ[1], pt[2], pt[1]);
                break;
            }
            case 2: {
                pt[0] = icon.func_94214_a(16.0 - pY[1] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pZ[1] * 16.0);
                cords[0] = this.buildCords(rX, rY[0], rZ[1], pt[2], pt[3]);
                cords[1] = this.buildCords(rX, rY[0], rZ[0], pt[2], pt[1]);
                cords[2] = this.buildCords(rX, rY[1], rZ[0], pt[0], pt[1]);
                cords[3] = this.buildCords(rX, rY[1], rZ[1], pt[0], pt[3]);
                break;
            }
            case 3: {
                pt[0] = icon.func_94214_a(16.0 - pZ[0] * 16.0);
                pt[1] = icon.func_94214_a(16.0 - pZ[1] * 16.0);
                pt[2] = icon.func_94207_b(16.0 - pY[0] * 16.0);
                pt[3] = icon.func_94207_b(16.0 - pY[1] * 16.0);
                cords[0] = this.buildCords(rX, rY[0], rZ[1], pt[0], pt[3]);
                cords[1] = this.buildCords(rX, rY[0], rZ[0], pt[1], pt[3]);
                cords[2] = this.buildCords(rX, rY[1], rZ[0], pt[1], pt[2]);
                cords[3] = this.buildCords(rX, rY[1], rZ[1], pt[0], pt[2]);
            }
        }
        this.render(renderblocks, cords, this.uvFlipEast);
    }

    private double[] buildCords(double x, double y, double z, double u, double v) {
        double[] cords = new double[]{x, y, z, u, v};
        return cords;
    }

    private void render(RenderBlocks renderblocks, double[][] cords, boolean flipTexture) {
        if (flipTexture) {
            double tempcord = cords[0][3];
            cords[0][3] = cords[2][3];
            cords[2][3] = tempcord;
            tempcord = cords[1][3];
            cords[1][3] = cords[3][3];
            cords[3][3] = tempcord;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderblocks.field_147863_w) {
            tessellator.func_78386_a(renderblocks.field_147872_ap, renderblocks.field_147846_at, renderblocks.field_147854_ax);
            tessellator.func_78380_c(renderblocks.field_147864_al);
            tessellator.func_78374_a(cords[0][0], cords[0][1], cords[0][2], cords[0][3], cords[0][4]);
            tessellator.func_78386_a(renderblocks.field_147852_aq, renderblocks.field_147860_au, renderblocks.field_147841_ay);
            tessellator.func_78380_c(renderblocks.field_147874_am);
            tessellator.func_78374_a(cords[1][0], cords[1][1], cords[1][2], cords[1][3], cords[1][4]);
            tessellator.func_78386_a(renderblocks.field_147850_ar, renderblocks.field_147858_av, renderblocks.field_147839_az);
            tessellator.func_78380_c(renderblocks.field_147876_an);
            tessellator.func_78374_a(cords[2][0], cords[2][1], cords[2][2], cords[2][3], cords[2][4]);
            tessellator.func_78386_a(renderblocks.field_147848_as, renderblocks.field_147856_aw, renderblocks.field_147833_aA);
            tessellator.func_78380_c(renderblocks.field_147870_ao);
            tessellator.func_78374_a(cords[3][0], cords[3][1], cords[3][2], cords[3][3], cords[3][4]);
        } else {
            tessellator.func_78374_a(cords[0][0], cords[0][1], cords[0][2], cords[0][3], cords[0][4]);
            tessellator.func_78374_a(cords[1][0], cords[1][1], cords[1][2], cords[1][3], cords[1][4]);
            tessellator.func_78374_a(cords[2][0], cords[2][1], cords[2][2], cords[2][3], cords[2][4]);
            tessellator.func_78374_a(cords[3][0], cords[3][1], cords[3][2], cords[3][3], cords[3][4]);
        }
    }

    public static void drawFaces(Block block, int metadata, RenderBlocks renderBlocks) {
        RenderExtra.drawFaces(block, metadata, renderBlocks, 0);
    }

    public static void drawFaces(Block block, int metadata, RenderBlocks renderBlocks, int bottom) {
        IIcon[] icons = new IIcon[6];
        icons[0] = block.func_149691_a(bottom, metadata);
        for (int face = 1; face < 6; face = (int)((byte)(face + 1))) {
            icons[face] = block.func_149691_a(face, metadata);
        }
        RenderExtra.drawFaces(block, icons, renderBlocks);
    }

    public static void drawFaces(Block block, IIcon icon, RenderBlocks renderBlocks) {
        IIcon[] icons = new IIcon[6];
        for (int face = 0; face < 6; face = (int)((byte)(face + 1))) {
            icons[face] = icon;
        }
        RenderExtra.drawFaces(block, icons, renderBlocks);
    }

    public static void drawFaces(Block block, IIcon[] icons, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderBlocks.func_147768_a(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[0]));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderBlocks.func_147806_b(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[1]));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderBlocks.field_147842_e = true;
        renderBlocks.func_147764_f(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[2]));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderBlocks.field_147842_e = false;
        renderBlocks.func_147798_e(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[3]));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderBlocks.field_147842_e = true;
        renderBlocks.func_147761_c(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[4]));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderBlocks.field_147842_e = false;
        renderBlocks.func_147734_d(block, 0.0, 0.0, 0.0, renderBlocks.func_147758_b(icons[5]));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

