/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertank;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.Function;
import shetiphian.core.Localization;
import shetiphian.endertank.TankFunctions;
import shetiphian.endertank.TileEntityEnderTank;
import shetiphian.endertank.Values;

public class BlockEnderTank
extends BlockContainer {
    private String lastCode;
    private String lastOwner;
    private IIcon[] iconIndex = new IIcon[5];
    public static Class<? extends TileEntityEnderTank> tankTile;

    public BlockEnderTank() {
        super(Material.field_151592_s);
        this.func_149663_c("shetiphian.endertanks.tank");
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.func_149711_c(0.5f);
        this.func_149647_a(Values.tabEnderTanks);
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return tankTile.newInstance();
        }
        catch (Exception exception) {
            return new TileEntityEnderTank();
        }
    }

    public int func_149645_b() {
        return Values.renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess iBlockAccess, int x, int y, int z) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconIndex[0] = iconRegister.func_94245_a("endertanks:tank_normal_tb");
        this.iconIndex[1] = iconRegister.func_94245_a("endertanks:tank_normal_s");
        this.iconIndex[2] = iconRegister.func_94245_a("endertanks:tank_private_tb");
        this.iconIndex[3] = iconRegister.func_94245_a("endertanks:tank_private_s");
        this.iconIndex[4] = iconRegister.func_94245_a("endertanks:tank_bands");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side > 9) {
            return this.iconIndex[side -= 10];
        }
        return this.iconIndex[4];
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int quantityDropped(int metadata, int fortune, Random random) {
        return 1;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tankTile != null) {
            this.lastCode = tankTile.code;
            this.lastOwner = tankTile.owner;
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (world.field_72995_K || this.lastCode == null) {
            return arrayList;
        }
        arrayList.add(new ItemStack((Block)this, 1, Integer.parseInt(this.lastCode, 16)));
        if (!this.lastOwner.equals("all")) {
            arrayList.add(new ItemStack(Values.itemPersonal));
        }
        return arrayList;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile == null) {
            return null;
        }
        while (tankTile.code.length() < 3) {
            tankTile.code = "0" + tankTile.code;
        }
        return new ItemStack((Block)this, 1, Integer.parseInt(tankTile.code, 16));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.func_72864_z(x, y, z)) {
            TileEntity thisTile = world.func_147438_o(x, y, z);
            if (thisTile != null && thisTile instanceof TileEntityEnderTank) {
                TileEntityEnderTank tankTile = (TileEntityEnderTank)thisTile;
                FluidTank thisTank = TankFunctions.getTank(tankTile.owner, tankTile.code);
                FluidStack thisLiquid = thisTank.getFluid();
                TileEntity otherTile = world.func_147438_o(x, y + 1, z);
                int moveAmount = 250;
                if (otherTile != null && otherTile instanceof IFluidHandler) {
                    FluidStack getLiquid;
                    if (thisLiquid != null && thisTank.getCapacity() - thisLiquid.amount < moveAmount) {
                        moveAmount = thisTank.getCapacity() - thisLiquid.amount;
                    }
                    if ((getLiquid = ((IFluidHandler)otherTile).drain(ForgeDirection.DOWN, moveAmount, false)) != null && (thisLiquid == null || getLiquid.isFluidEqual(thisLiquid) || thisLiquid.amount < 1)) {
                        getLiquid = ((IFluidHandler)otherTile).drain(ForgeDirection.DOWN, moveAmount, true);
                        if (thisLiquid == null || thisLiquid.amount == 0) {
                            thisLiquid = getLiquid;
                        } else {
                            thisLiquid.amount += getLiquid.amount;
                        }
                        TankFunctions.updateTank(tankTile.owner, tankTile.code, thisLiquid);
                    }
                }
                moveAmount = 250;
                thisTank = TankFunctions.getTank(tankTile.owner, tankTile.code);
                thisLiquid = thisTank.getFluid();
                otherTile = world.func_147438_o(x, y - 1, z);
                if (thisLiquid != null && thisTile != null && otherTile != null && otherTile instanceof IFluidHandler) {
                    FluidStack placeLiquid;
                    int usedAmount;
                    if (thisLiquid.amount < 250) {
                        moveAmount = thisLiquid.amount;
                    }
                    if ((usedAmount = ((IFluidHandler)otherTile).fill(ForgeDirection.UP, placeLiquid = new FluidStack(thisLiquid.fluidID, moveAmount, thisLiquid.tag), false)) > 0) {
                        ((IFluidHandler)otherTile).fill(ForgeDirection.UP, placeLiquid, true);
                        thisLiquid.amount -= usedAmount;
                        TankFunctions.updateTank(tankTile.owner, tankTile.code, thisLiquid);
                    }
                }
            }
            world.func_147464_a(x, y, z, (Block)this, 20);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.125, (double)y, (double)z + 0.125, (double)x + 0.875, (double)y + 1.0, (double)z + 0.875);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile == null) {
            return null;
        }
        float ringMin = 0.09375f;
        float ringMax = 0.90625f;
        float ringOffset = 0.03125f;
        float ringShift = 0.09375f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        MovingObjectPosition fullblock = super.func_149731_a(world, x, y, z, vec3d, vec3d1);
        if (fullblock == null) {
            return fullblock;
        }
        MovingObjectPosition areaHit = null;
        double hitDist = 100.0;
        if (fullblock.field_72310_e > 1) {
            for (int codeBand = 0; codeBand < 4; codeBand = (int)((byte)(codeBand + 1))) {
                switch (codeBand) {
                    case 0: {
                        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(ringMin, 0.5f + ringShift - ringOffset, ringMin, ringMax, 0.5f + ringShift + ringOffset, ringMax);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(ringMin, 0.5f - ringOffset, ringMin, ringMax, 0.5f + ringOffset, ringMax);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(ringMin, 0.5f - ringShift - ringOffset, ringMin, ringMax, 0.5f - ringShift + ringOffset, ringMax);
                    }
                }
                MovingObjectPosition ringHit = super.func_149731_a(world, x, y, z, vec3d, vec3d1);
                if (ringHit == null) continue;
                ringHit.subHit = codeBand;
                double ringDist = ringHit.field_72307_f.func_72436_e(vec3d);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = ringHit;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                switch (areaHit.subHit) {
                    case 1: {
                        this.func_149676_a(ringMin, 0.5f + ringShift - ringOffset, ringMin, ringMax, 0.5f + ringShift + ringOffset, ringMax);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(ringMin, 0.5f - ringOffset, ringMin, ringMax, 0.5f + ringOffset, ringMax);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(ringMin, 0.5f - ringShift - ringOffset, ringMin, ringMax, 0.5f - ringShift + ringOffset, ringMax);
                    }
                }
                return areaHit;
            }
        }
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        return fullblock;
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile.owner.equals("all") || tankTile.owner.equals(entityPlayer.getDisplayName())) {
            return super.func_149737_a(entityPlayer, world, x, y, z);
        }
        return -1.0f;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float posX, float posY, float posZ) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile == null) {
            return false;
        }
        ItemStack currentItem = entityPlayer.field_71071_by.func_70448_g();
        if (currentItem != null) {
            ItemStack filledItem;
            FluidStack containerLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentItem);
            if (containerLiquid != null) {
                int usedAmmount = tankTile.fill(ForgeDirection.UP, containerLiquid, !world.field_72995_K);
                if (usedAmmount != 0 && !entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, this.consumeItem(currentItem));
                }
                return true;
            }
            FluidStack tankLiquid = tankTile.getTankInfo().fluid;
            if (tankLiquid != null && (filledItem = FluidContainerRegistry.fillFluidContainer((FluidStack)tankLiquid, (ItemStack)currentItem)) != null && !entityPlayer.field_71075_bZ.field_75098_d) {
                if (currentItem.field_77994_a > 1) {
                    if (!entityPlayer.field_71071_by.func_70441_a(filledItem)) {
                        return false;
                    }
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, this.consumeItem(currentItem));
                } else {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, this.consumeItem(currentItem));
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, filledItem);
                }
                tankTile.drain(ForgeDirection.DOWN, 1000, !world.field_72995_K);
                return true;
            }
        }
        if (world.field_72995_K) {
            return true;
        }
        if (currentItem != null) {
            MovingObjectPosition areaHit;
            if (tankTile.owner.equals("all") && currentItem.func_77973_b() == Values.itemPersonal) {
                tankTile.owner = entityPlayer.getDisplayName();
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    --currentItem.field_77994_a;
                }
                Function.syncTile(tankTile);
                return true;
            }
            if (currentItem.func_77973_b() == Items.field_151079_bi || currentItem.func_77973_b() == Items.field_151061_bv) {
                byte increase = (byte)(currentItem.func_77973_b() == Items.field_151079_bi ? 8 : 16);
                String tankKey = tankTile.owner + ":" + tankTile.code;
                int current = 32;
                if (Values.tankCapacity.containsKey(tankKey)) {
                    current = Values.tankCapacity.get(tankKey).shortValue();
                }
                if (current + increase <= 256) {
                    Values.tankCapacity.put(tankKey, (short)(current + increase));
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    String tankInfo = Localization.get("info.tank.capacity.msg");
                    tankInfo = tankInfo + " " + TankFunctions.getCapacity(tankTile.owner, tankTile.code);
                    Localization.addChat(entityPlayer, tankInfo);
                    return true;
                }
            }
            if ((areaHit = this.retraceBlock(world, (EntityPlayerMP)entityPlayer, x, y, z)) == null) {
                return false;
            }
            if ((tankTile.owner.equals("all") || tankTile.owner.equals(entityPlayer.getDisplayName())) && areaHit.subHit >= 1 && areaHit.subHit <= 3) {
                String[] dyes = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
                for (int scan = 0; scan < 16; scan = (int)((byte)(scan + 1))) {
                    ArrayList results = OreDictionary.getOres((String)dyes[scan]);
                    for (ItemStack check : results) {
                        if (!OreDictionary.itemMatches((ItemStack)currentItem, (ItemStack)check, (boolean)true)) continue;
                        int ring = areaHit.subHit - 1;
                        char color = Integer.toHexString(scan).charAt(0);
                        char[] code = tankTile.code.toCharArray();
                        if (code[ring] == color) continue;
                        code[ring] = color;
                        tankTile.code = "" + code[0] + code[1] + code[2];
                        if (!entityPlayer.field_71075_bZ.field_75098_d) {
                            --currentItem.field_77994_a;
                        }
                        Function.syncTile(tankTile);
                        return true;
                    }
                }
            }
        }
        FluidStack currentLiquid = TankFunctions.getTank(tankTile.owner, tankTile.code).getFluid();
        BlockEnderTank.sendTankInfo(entityPlayer, currentLiquid, tankTile.owner, tankTile.code, false);
        return true;
    }

    private ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    private MovingObjectPosition retraceBlock(World world, EntityPlayerMP thePlayer, int x, int y, int z) {
        Vec3 headVec = Vec3.func_72443_a((double)thePlayer.field_70165_t, (double)(thePlayer.field_70163_u + (double)thePlayer.func_70047_e() - (double)thePlayer.field_70129_M), (double)thePlayer.field_70161_v);
        Vec3 lookVec = thePlayer.func_70676_i(1.0f);
        double reach = thePlayer.field_71134_c.getBlockReachDistance();
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_147439_a(x, y, z).func_149731_a(world, x, y, z, headVec, endVec);
    }

    public static void sendTankInfo(EntityPlayer entityPlayer, FluidStack fluidStack, String owner, String code, boolean bucket) {
        String tankInfo = "";
        tankInfo = tankInfo + (bucket ? Localization.get("info.bucket.header.msg") : Localization.get("info.tank.header.msg"));
        tankInfo = tankInfo + "\u00a7r<br>";
        if (fluidStack == null || fluidStack.amount < 1) {
            tankInfo = tankInfo + Localization.get("info.tank.empty.msg");
        } else {
            tankInfo = tankInfo + (float)fluidStack.amount / 1000.0f + "K / ";
            tankInfo = tankInfo + TankFunctions.getCapacity(owner, code) / 1000 + "K ";
            tankInfo = tankInfo + Localization.get("info.tank.amount.msg") + " ";
            tankInfo = tankInfo + fluidStack.getFluid().getLocalizedName();
        }
        tankInfo = tankInfo + " [-";
        tankInfo = tankInfo + (owner.equals("all") ? Localization.get("info.tank.public.msg") : owner);
        tankInfo = tankInfo + "-]";
        Localization.addChat(entityPlayer, tankInfo);
    }
}

