/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertank;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import shetiphian.endertank.EnderTanks;
import shetiphian.endertank.Values;

public class TankFunctions {
    public static FluidTank getTank(String owner, String code) {
        String tankKey = owner + ":" + code;
        FluidTank tank = new FluidTank(TankFunctions.getCapacity(owner, code));
        tank.setFluid(Values.tankStorage.get(tankKey));
        return tank;
    }

    public static int getCapacity(String owner, String code) {
        String tankKey = owner + ":" + code;
        if (Values.tankCapacity.containsKey(tankKey)) {
            return 1000 * Values.tankCapacity.get(tankKey);
        }
        return 32000;
    }

    public static void updateTank(String owner, String code, FluidStack tankValue) {
        String tankKey = owner + ":" + code;
        if (tankValue != null && tankValue.amount < 1) {
            tankValue = null;
        }
        Values.tankStorage.put(tankKey, tankValue);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        NBTTagCompound nbtEntry;
        if (event.world == null || event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        File saveFile = this.getSaveFile(event.world);
        NBTTagCompound nbtData = new NBTTagCompound();
        for (Map.Entry<String, FluidStack> entry : Values.tankStorage.entrySet()) {
            nbtEntry = new NBTTagCompound();
            FluidStack liquid = entry.getValue();
            if (liquid != null && liquid.amount > 0) {
                liquid.writeToNBT(nbtEntry);
            }
            nbtData.func_74782_a(entry.getKey(), (NBTBase)nbtEntry);
        }
        for (Map.Entry<String, Object> entry : Values.tankCapacity.entrySet()) {
            if ((Short)entry.getValue() <= 32) continue;
            nbtEntry = nbtData.func_74764_b(entry.getKey()) ? nbtData.func_74775_l(entry.getKey()) : new NBTTagCompound();
            nbtEntry.func_74777_a("Capacity", ((Short)entry.getValue()).shortValue());
            nbtData.func_74782_a(entry.getKey(), (NBTBase)nbtEntry);
        }
        try {
            FileOutputStream fileoutputstream = new FileOutputStream(saveFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbtData, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (event.world == null || event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        Values.tankStorage.clear();
        NBTTagCompound nbtData = this.getNBTtag(this.getSaveFile(event.world));
        for (String key : nbtData.func_150296_c()) {
            NBTTagCompound nbtEntry = nbtData.func_74775_l(key);
            FluidStack tankFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtEntry);
            if (tankFluid == null) {
                tankFluid = this.loadOldFormat(nbtEntry);
            }
            if (tankFluid != null) {
                Values.tankStorage.put(key, tankFluid);
            }
            if (!nbtEntry.func_74764_b("Capacity")) continue;
            Values.tankCapacity.put(key, (short)Math.min(nbtEntry.func_74765_d("Capacity"), 256));
        }
    }

    private FluidStack loadOldFormat(NBTTagCompound nbtEntry) {
        if (nbtEntry.func_74764_b("Name")) {
            int fluidID = FluidRegistry.getFluidID((String)nbtEntry.func_74779_i("Name"));
            int amount = nbtEntry.func_74762_e("Amount");
            if (fluidID > 0 && amount > 0) {
                NBTTagCompound nbt = null;
                if (nbtEntry.func_74764_b("NBT")) {
                    nbt = nbtEntry.func_74775_l("NBT");
                }
                return new FluidStack(fluidID, amount, nbt);
            }
        }
        return null;
    }

    private File getSaveFile(World world) {
        String saveDir = EnderTanks.proxy.getSaveDir(world, Values.mincraftDir);
        File file = null;
        try {
            file = new File(saveDir);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            file = new File(saveDir, "EnderTank.dat");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return file;
    }

    private NBTTagCompound getNBTtag(File file) {
        NBTTagCompound nbtData = new NBTTagCompound();
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            nbtData = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nbtData;
    }
}

