/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertank;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import shetiphian.core.TileEntityBase;
import shetiphian.endertank.TankFunctions;

public class TileEntityEnderTank
extends TileEntityBase
implements IFluidHandler {
    public String code = "000";
    public String owner = "all";

    public int fill(ForgeDirection side, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(side, resource.getFluid())) {
            return 0;
        }
        FluidTank activeTank = TankFunctions.getTank(this.owner, this.code);
        int amountUsed = activeTank.fill(resource, doFill);
        resource.amount -= amountUsed;
        if (doFill && amountUsed > 0) {
            TankFunctions.updateTank(this.owner, this.code, activeTank.getFluid());
        }
        return amountUsed;
    }

    public FluidStack drain(ForgeDirection side, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(side, resource.getFluid())) {
            return null;
        }
        FluidTank activeTank = TankFunctions.getTank(this.owner, this.code);
        return activeTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection side, int amount, boolean doDrain) {
        if (!this.canDrain(side, null)) {
            return null;
        }
        FluidTank activeTank = TankFunctions.getTank(this.owner, this.code);
        return activeTank.drain(amount, doDrain);
    }

    public boolean canFill(ForgeDirection side, Fluid fluid) {
        FluidStack currentLiquid;
        if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
            return false;
        }
        FluidTank activeTank = TankFunctions.getTank(this.owner, this.code);
        if (activeTank.getFluidAmount() >= activeTank.getCapacity()) {
            return false;
        }
        if (fluid != null && (currentLiquid = activeTank.getFluid()) != null) {
            if (currentLiquid.amount < 1) {
                activeTank.setFluid(null);
            } else if (currentLiquid.getFluid() != fluid) {
                return false;
            }
        }
        return true;
    }

    public boolean canDrain(ForgeDirection side, Fluid fluid) {
        if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
            return false;
        }
        FluidTank activeTank = TankFunctions.getTank(this.owner, this.code);
        if (activeTank.getFluidAmount() < 1) {
            return false;
        }
        return fluid == null || activeTank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
            return null;
        }
        return new FluidTankInfo[]{this.getTankInfo()};
    }

    public FluidTankInfo getTankInfo() {
        return TankFunctions.getTank(this.owner, this.code).getInfo();
    }

    @Override
    public NBTTagCompound buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("code", this.code);
        nbtTag.func_74778_a("owner", this.owner);
        return nbtTag;
    }

    @Override
    public void processNBT(NBTTagCompound nbtTag) {
        this.code = nbtTag.func_74779_i("code");
        this.owner = nbtTag.func_74779_i("owner");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        this.buildNBT(nbtTag);
        FluidTankInfo tankinfo = this.getTankInfo();
        if (tankinfo.fluid != null) {
            nbtTag.func_74778_a("liquid", tankinfo.fluid.getFluid().getLocalizedName());
            nbtTag.func_74768_a("amount", tankinfo.fluid.amount);
            nbtTag.func_74768_a("capacity", TankFunctions.getCapacity(this.owner, this.code));
        } else {
            nbtTag.func_74778_a("liquid", "NONE");
        }
    }
}

