/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertank.modsupport.bc;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import shetiphian.endertank.TileEntityEnderTank;

public class TankTrigger
implements ITileTrigger {
    private String id;
    public State state;
    private IIcon icon;

    public TankTrigger(String id, State state) {
        this.id = id;
        this.state = state;
        ActionManager.registerTrigger((ITrigger)this);
    }

    public String getUniqueTag() {
        return "endertanks:" + this.id;
    }

    public boolean hasParameter() {
        return false;
    }

    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Tank Empty";
            }
            case Contains: {
                return "Liquid in Tank";
            }
            case Space: {
                return "Space for Liquid";
            }
            case Under: {
                return "Under Half Full";
            }
            case Over: {
                return "Over Half Full";
            }
        }
        return "Tank Full";
    }

    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileEntityEnderTank) {
            FluidTankInfo tankInfo = ((TileEntityEnderTank)tile).getTankInfo();
            if (tankInfo == null) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    return tankInfo.fluid == null || tankInfo.fluid.amount == 0;
                }
                case Full: {
                    return tankInfo.fluid != null && tankInfo.fluid.amount == tankInfo.capacity;
                }
                case Contains: {
                    return tankInfo.fluid != null && tankInfo.fluid.amount > 0;
                }
                case Space: {
                    return tankInfo.fluid != null && tankInfo.fluid.amount < tankInfo.capacity;
                }
                case Under: {
                    return tankInfo.fluid != null && tankInfo.fluid.amount < tankInfo.capacity / 2;
                }
                case Over: {
                    return tankInfo.fluid != null && tankInfo.fluid.amount > tankInfo.capacity / 2;
                }
            }
        }
        return false;
    }

    public boolean requiresParameter() {
        return false;
    }

    public ITriggerParameter createParameter() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("endertanks:gate_" + this.id);
    }

    public static enum State {
        Empty,
        Full,
        Contains,
        Space,
        Under,
        Over;

    }
}

