/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertank.modsupport.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import shetiphian.core.Localization;
import shetiphian.endertank.BlockEnderTank;
import shetiphian.endertank.TileEntityEnderTank;
import shetiphian.endertank.Values;

public class WailaDataProvider
implements IWailaDataProvider {
    public static WailaDataProvider INSTANCE = new WailaDataProvider();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig("endertanks.showtankdata") && accessor.getBlock() == Values.blockEnderTank) {
            try {
                NBTTagCompound tag = accessor.getNBTData();
                String liquid = tag.func_74779_i("liquid");
                int amount = tag.func_74762_e("amount");
                if (liquid.equals("NONE") || amount < 1) {
                    currenttip.add(Localization.get("info.tank.empty.msg"));
                } else {
                    int capacity = tag.func_74762_e("capacity");
                    currenttip.add(amount / 1000 + "K/" + capacity / 1000 + "K " + Localization.get("info.tank.amount.msg") + " " + liquid);
                }
                String owner = ((TileEntityEnderTank)accessor.getTileEntity()).owner;
                currenttip.add(owner.equals("all") ? Localization.get("info.tank.public.msg") : owner);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        if (Values.blockEnderTank != null) {
            registrar.addConfigRemote("EnderTanks", "endertanks.showtankdata", "Show Tank Data");
            registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, BlockEnderTank.class);
        }
    }
}

