/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class TransformerBase
implements IClassTransformer {
    protected final String classPath;
    protected final String unobfClass;

    public TransformerBase(String classPath) {
        this.classPath = classPath;
        this.unobfClass = classPath.substring(classPath.lastIndexOf(46) + 1);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals(this.classPath)) {
            System.out.println("M&B - Patching Class " + this.unobfClass + " (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            this.setupMappings();
            boolean success = this.processFields(cn.fields) && this.processMethods(cn.methods);
            this.addInterface(cn.interfaces);
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class " + this.unobfClass + (success ? " done" : " FAILED!"));
            if (!success && BattlegearTranslator.debug) {
                TransformerBase.writeClassFile(cw, this.unobfClass + " (" + name + ")");
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    void addInterface(List<String> interfaces) {
    }

    abstract boolean processMethods(List<MethodNode> var1);

    abstract boolean processFields(List<FieldNode> var1);

    abstract void setupMappings();

    public static void writeClassFile(ClassWriter cw, String name) {
        try {
            File outDir = BattlegearLoadingPlugin.debugOutputLocation;
            outDir.mkdirs();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File(outDir, name + ".class")));
            dout.write(cw.toByteArray());
            dout.flush();
            dout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MethodNode replaceInventoryArrayAccess(MethodNode method, String className, String fieldName, int maxStack, int maxLocal) {
        return TransformerBase.replaceInventoryArrayAccess(method, className, fieldName, 4, maxStack, maxLocal);
    }

    public static MethodNode replaceInventoryArrayAccess(MethodNode method, String className, String fieldName, int todelete, int maxStack, int maxLocal) {
        InsnList newList = new InsnList();
        ListIterator it = method.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode nextNode = (AbstractInsnNode)it.next();
            if (nextNode instanceof FieldInsnNode && nextNode.getNext() instanceof FieldInsnNode && ((FieldInsnNode)nextNode).owner.equals(className) && ((FieldInsnNode)nextNode).name.equals(fieldName) && ((FieldInsnNode)nextNode.getNext()).owner.equals(BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer")) && ((FieldInsnNode)nextNode.getNext()).name.equals(BattlegearTranslator.getMapedFieldName("InventoryPlayer", "field_70462_a", "mainInventory"))) {
                for (int i = 0; i < todelete; ++i) {
                    nextNode = (AbstractInsnNode)it.next();
                }
                nextNode = (AbstractInsnNode)it.next();
                while (it.hasNext() && nextNode.getOpcode() != 83) {
                    newList.add(nextNode);
                    nextNode = (AbstractInsnNode)it.next();
                }
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "setPlayerCurrentItem", "(L" + BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer") + ";L" + BattlegearTranslator.getMapedClassName("item.ItemStack") + ";)V"));
                continue;
            }
            newList.add(nextNode);
        }
        method.instructions = newList;
        method.maxStack = maxStack;
        method.maxLocals = maxLocal;
        return method;
    }

    public void sendPatchLog(String method) {
        System.out.println("\tPatching method " + method + " in " + this.unobfClass);
    }

    public static MethodNode generateSetter(String className, String methodName, String fieldName, String fieldType) {
        MethodNode mn = new MethodNode(262144, 1, methodName, "(" + fieldType + ")V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int opCode = 0;
        opCode = fieldType.equals("I") ? 21 : (fieldType.equals("L") ? 22 : (fieldType.equals("F") ? 23 : (fieldType.equals("D") ? 24 : 25)));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(opCode, 1));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, className, fieldName, fieldType));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 2;
        mn.maxLocals = 2;
        return mn;
    }

    public static MethodNode generateGetter(String className, String methodName, String fieldName, String fieldType) {
        MethodNode mn = new MethodNode(262144, 1, methodName, "()" + fieldType, null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, className, fieldName, fieldType));
        int opCode = 0;
        opCode = fieldType.equals("I") ? 172 : (fieldType.equals("L") ? 173 : (fieldType.equals("F") ? 174 : (fieldType.equals("D") ? 175 : 176)));
        mn.instructions.add((AbstractInsnNode)new InsnNode(opCode));
        mn.maxStack = 1;
        mn.maxLocals = 1;
        return mn;
    }
}

