/*
 * Decompiled with CFR 0.152.
 */
package net.seventeencups.stillhungry.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.seventeencups.stillhungry.StillHungry;
import net.seventeencups.stillhungry.block.ModBlocks;
import net.seventeencups.stillhungry.tileentity.TileStove;

public class BlockStove
extends BlockContainer {
    public TileStove tileEntity;
    public boolean isActive = false;
    private static boolean keepInventory = false;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveBackIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveFrontIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveLeftIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveRightIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveBottomIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveTopOnIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stoveTopOffIcon;

    public BlockStove(boolean active) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("stoveBlock");
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.isActive = active;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.stoveBackIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "Back");
        this.stoveFrontIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "Front");
        this.stoveLeftIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "Left");
        this.stoveRightIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "Right");
        this.stoveBottomIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "Bottom");
        this.stoveTopOnIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "TopOn");
        this.stoveTopOffIcon = par1IconRegister.func_94245_a("stillhungry:" + this.func_149739_a() + "TopOff");
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        this.setDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K && !keepInventory) {
            Block l = par1World.func_147439_a(par2, par3, par4 - 1);
            Block i1 = par1World.func_147439_a(par2, par3, par4 + 1);
            Block j1 = par1World.func_147439_a(par2 - 1, par3, par4);
            Block k1 = par1World.func_147439_a(par2 + 1, par3, par4);
            int b0 = 3;
            if (l.func_149662_c() && !i1.func_149662_c()) {
                b0 = 3;
            }
            if (i1.func_149662_c() && !l.func_149662_c()) {
                b0 = 2;
            }
            if (j1.func_149662_c() && !k1.func_149662_c()) {
                b0 = 5;
            }
            if (k1.func_149662_c() && !j1.func_149662_c()) {
                b0 = 4;
            }
            par1World.func_72921_c(par2, par3, par4, b0, 2);
        }
    }

    public IIcon func_149691_a(int side, int metadata) {
        switch (metadata) {
            case 2: {
                switch (side) {
                    case 0: {
                        return this.stoveBottomIcon;
                    }
                    case 1: {
                        if (this.isActive) {
                            return this.stoveTopOnIcon;
                        }
                        return this.stoveTopOffIcon;
                    }
                    case 2: {
                        return this.stoveFrontIcon;
                    }
                    case 3: {
                        return this.stoveBackIcon;
                    }
                    case 4: {
                        return this.stoveRightIcon;
                    }
                    case 5: {
                        return this.stoveLeftIcon;
                    }
                }
            }
            case 3: {
                switch (side) {
                    case 0: {
                        return this.stoveBottomIcon;
                    }
                    case 1: {
                        if (this.isActive) {
                            return this.stoveTopOnIcon;
                        }
                        return this.stoveTopOffIcon;
                    }
                    case 2: {
                        return this.stoveBackIcon;
                    }
                    case 3: {
                        return this.stoveFrontIcon;
                    }
                    case 4: {
                        return this.stoveLeftIcon;
                    }
                    case 5: {
                        return this.stoveRightIcon;
                    }
                }
            }
            case 4: {
                switch (side) {
                    case 0: {
                        return this.stoveBottomIcon;
                    }
                    case 1: {
                        if (this.isActive) {
                            return this.stoveTopOnIcon;
                        }
                        return this.stoveTopOffIcon;
                    }
                    case 2: {
                        return this.stoveLeftIcon;
                    }
                    case 3: {
                        return this.stoveRightIcon;
                    }
                    case 4: {
                        return this.stoveFrontIcon;
                    }
                    case 5: {
                        return this.stoveBackIcon;
                    }
                }
            }
            case 5: {
                switch (side) {
                    case 0: {
                        return this.stoveBottomIcon;
                    }
                    case 1: {
                        if (this.isActive) {
                            return this.stoveTopOnIcon;
                        }
                        return this.stoveTopOffIcon;
                    }
                    case 2: {
                        return this.stoveRightIcon;
                    }
                    case 3: {
                        return this.stoveLeftIcon;
                    }
                    case 4: {
                        return this.stoveBackIcon;
                    }
                    case 5: {
                        return this.stoveFrontIcon;
                    }
                }
            }
        }
        switch (side) {
            case 0: {
                return this.stoveBottomIcon;
            }
            case 1: {
                return this.stoveTopOffIcon;
            }
            case 2: {
                return this.stoveLeftIcon;
            }
            case 3: {
                return this.stoveRightIcon;
            }
            case 4: {
                return this.stoveFrontIcon;
            }
            case 5: {
                return this.stoveBackIcon;
            }
        }
        return this.stoveBackIcon;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.func_72921_c(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.func_72921_c(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.func_72921_c(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.func_72921_c(par2, par3, par4, 4, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)StillHungry.instance, 0, world, x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (!keepInventory) {
            this.dropItems(world, x, y, z);
            super.func_149749_a(world, x, y, z, par5, par6);
        }
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)te;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileStove();
    }

    public static void updateBlockState(boolean par0, World par1World, int par2, int par3, int par4) {
        int var5 = par1World.func_72805_g(par2, par3, par4);
        TileEntity var6 = par1World.func_147438_o(par2, par3, par4);
        keepInventory = true;
        if (par0) {
            par1World.func_147465_d(par2, par3, par4, ModBlocks.stoveBlockBurning, var5, 2);
        } else {
            par1World.func_147465_d(par2, par3, par4, ModBlocks.stoveBlock, var5, 2);
        }
        keepInventory = false;
        if (var6 != null) {
            var6.func_145829_t();
            par1World.func_147455_a(par2, par3, par4, var6);
        }
    }

    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.isActive) {
            float x1 = (float)par2 + 0.23f;
            float y = (float)par3 + 1.0f;
            float z1 = (float)par4 + 0.25f;
            float x2 = (float)par2 + 0.73f;
            float z2 = (float)par4 + 0.25f;
            float x3 = (float)par2 + 0.73f;
            float z3 = (float)par4 + 0.75f;
            float x4 = (float)par2 + 0.23f;
            float z4 = (float)par4 + 0.75f;
            par1World.func_72869_a("smoke", (double)x1, (double)y, (double)z1, 0.0, 0.0, 0.0);
            par1World.func_72869_a("smoke", (double)x2, (double)y, (double)z2, 0.0, 0.0, 0.0);
            par1World.func_72869_a("smoke", (double)x3, (double)y, (double)z3, 0.0, 0.0, 0.0);
            par1World.func_72869_a("smoke", (double)x4, (double)y, (double)z4, 0.0, 0.0, 0.0);
        }
    }
}

