/*
 * Decompiled with CFR 0.152.
 */
package net.seventeencups.stillhungry.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.seventeencups.stillhungry.block.BlockStove;
import net.seventeencups.stillhungry.item.ItemFryingPan;
import net.seventeencups.stillhungry.item.ModItems;
import net.seventeencups.stillhungry.recipe.RecipesStove;

public class TileStove
extends TileEntity
implements ISidedInventory {
    private ItemStack[] inv = new ItemStack[6];
    public int stoveBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int stoveCookTime = 0;

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inv[par1] != null) {
            if (this.inv[par1].field_77994_a <= par2) {
                ItemStack var3 = this.inv[par1];
                this.inv[par1] = null;
                return var3;
            }
            ItemStack var3 = this.inv[par1].func_77979_a(par2);
            if (this.inv[par1].field_77994_a == 0) {
                this.inv[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inv[par1] != null) {
            ItemStack var2 = this.inv[par1];
            this.inv[par1] = null;
            return var2;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.inv = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.stoveBurnTime = tagCompound.func_74765_d("BurnTime");
        this.stoveCookTime = tagCompound.func_74765_d("CookTime");
        this.currentItemBurnTime = TileStove.getItemBurnTime(this.inv[3]);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.stoveBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.stoveCookTime);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(var4);
            itemList.func_74742_a((NBTBase)var4);
        }
        tagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public String func_145825_b() {
        return "container.stove";
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.stoveCookTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.stoveBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.stoveBurnTime > 0;
    }

    public void func_145845_h() {
        boolean var1 = this.stoveBurnTime > 0;
        boolean var2 = false;
        if (this.stoveBurnTime > 0) {
            --this.stoveBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.stoveBurnTime == 0 && this.canCook()) {
                this.currentItemBurnTime = this.stoveBurnTime = TileStove.getItemBurnTime(this.inv[3]);
                if (this.stoveBurnTime > 0) {
                    var2 = true;
                    if (this.inv[3] != null) {
                        --this.inv[3].field_77994_a;
                        if (this.inv[3].field_77994_a == 0) {
                            this.inv[3] = this.inv[3].func_77973_b().getContainerItem(this.inv[3]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canCook()) {
                ++this.stoveCookTime;
                if (this.stoveCookTime == 200) {
                    this.stoveCookTime = 0;
                    this.cookItem();
                    var2 = true;
                }
            } else {
                this.stoveCookTime = 0;
            }
            if (var1 != this.stoveBurnTime > 0) {
                var2 = true;
                BlockStove.updateBlockState(this.stoveBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (var2) {
            this.func_70296_d();
        }
    }

    private boolean canCook() {
        if (this.inv[0] == null || this.inv[1] == null || this.inv[2] == null) {
            return false;
        }
        List<Item> slots = Arrays.asList(this.inv[0].func_77973_b(), this.inv[1].func_77973_b(), this.inv[2].func_77973_b());
        ItemStack var1 = RecipesStove.cooking().getCookingResult(slots);
        if (var1 == null) {
            return false;
        }
        if (this.inv[5] != null) {
            if ((this.inv[0].func_77969_a(new ItemStack(ModItems.oil)) || this.inv[1].func_77969_a(new ItemStack(ModItems.oil))) && !this.inv[5].func_77969_a(new ItemStack(Items.field_151069_bo))) {
                return false;
            }
            if ((this.inv[0].func_77969_a(new ItemStack(Items.field_151117_aB)) || this.inv[1].func_77969_a(new ItemStack(Items.field_151117_aB))) && !this.inv[5].func_77969_a(new ItemStack(Items.field_151133_ar))) {
                return false;
            }
        }
        if (this.inv[4] == null) {
            return true;
        }
        if (!this.inv[4].func_77969_a(var1)) {
            return false;
        }
        int result = this.inv[4].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void cookItem() {
        if (this.canCook()) {
            List<Item> slots = Arrays.asList(this.inv[0].func_77973_b(), this.inv[1].func_77973_b(), this.inv[2].func_77973_b());
            ItemStack var1 = RecipesStove.cooking().getCookingResult(slots);
            boolean consume = RecipesStove.cooking().getConsumeResult(slots);
            if (this.inv[4] == null) {
                this.inv[4] = var1.func_77946_l();
            } else if (this.inv[4].func_77969_a(var1)) {
                this.inv[4].field_77994_a += var1.field_77994_a;
            }
            if (this.inv[0].func_77969_a(new ItemStack(ModItems.oil)) || this.inv[1].func_77969_a(new ItemStack(ModItems.oil))) {
                if (this.inv[5] == null) {
                    this.inv[5] = new ItemStack(Items.field_151069_bo, 1);
                } else {
                    ++this.inv[5].field_77994_a;
                }
            }
            if (this.inv[0].func_77969_a(new ItemStack(Items.field_151117_aB)) || this.inv[1].func_77969_a(new ItemStack(Items.field_151117_aB))) {
                if (this.inv[5] == null) {
                    this.inv[5] = new ItemStack(Items.field_151133_ar, 1);
                } else {
                    ++this.inv[5].field_77994_a;
                }
            }
            --this.inv[0].field_77994_a;
            --this.inv[1].field_77994_a;
            if (this.inv[0].field_77994_a <= 0) {
                this.inv[0] = null;
            }
            if (this.inv[1].field_77994_a <= 0) {
                this.inv[1] = null;
            }
            if (consume) {
                --this.inv[2].field_77994_a;
                if (this.inv[2].field_77994_a <= 0) {
                    this.inv[2] = null;
                }
            } else if (this.inv[2].func_77973_b() instanceof ItemFryingPan) {
                ItemFryingPan fp = (ItemFryingPan)this.inv[2].func_77973_b();
                this.inv[2] = fp.damageTool(this.inv[2], 1);
            }
        }
    }

    public static int getItemBurnTime(ItemStack p_145952_0_) {
        if (p_145952_0_ == null) {
            return 0;
        }
        Item item = p_145952_0_.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)p_145952_0_);
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileStove.getItemBurnTime(par0ItemStack) > 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 3 && TileStove.isItemFuel(itemstack);
    }
}

