/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.FactoryType;
import factorization.crafting.TileEntityMixer;
import factorization.crafting.TileEntityStamper;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntitySlagFurnace;
import factorization.servo.TileEntityParaSieve;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityFactorization;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerFactorization
extends Container {
    public TileEntityFactorization factory;
    FactoryType type;
    int slot_start;
    int slot_end;
    int player_slot_start;
    int player_slot_end;
    public EntityPlayer entityplayer;
    public int invdx = 0;
    public int invdy = 0;

    public ContainerFactorization(EntityPlayer entityplayer, TileEntityFactorization factory) {
        this.factory = factory;
        this.entityplayer = entityplayer;
        this.type = factory.getFactoryType();
    }

    public void addSlotsForGui(TileEntityFactorization ent, InventoryPlayer inventoryplayer) {
        FactoryType type = ent.getFactoryType();
        EntityPlayer player = inventoryplayer.field_70458_d;
        switch (type) {
            case STAMPER: 
            case PACKAGER: {
                TileEntityStamper stamper = (TileEntityStamper)ent;
                this.func_75146_a(new Slot((IInventory)stamper, 0, 44, 43));
                this.func_75146_a(new FactorySlot(stamper, 1, 116, 43, null, null));
                break;
            }
            case SLAGFURNACE: {
                TileEntitySlagFurnace furnace = (TileEntitySlagFurnace)ent;
                this.func_75146_a(new Slot((IInventory)furnace, 0, 56, 17));
                this.func_75146_a(new Slot((IInventory)furnace, 1, 56, 53));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)furnace, 2, 114, 22));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)furnace, 3, 114, 48));
                break;
            }
            case MIXER: {
                TileEntityMixer mixer = (TileEntityMixer)ent;
                this.func_75146_a(new Slot((IInventory)mixer, 0, 38, 25));
                this.func_75146_a(new Slot((IInventory)mixer, 1, 56, 25));
                this.func_75146_a(new Slot((IInventory)mixer, 2, 38, 43));
                this.func_75146_a(new Slot((IInventory)mixer, 3, 56, 43));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)mixer, 4, 112, 25));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)mixer, 5, 130, 25));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)mixer, 6, 112, 43));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)mixer, 7, 130, 43));
                break;
            }
            case CRYSTALLIZER: {
                TileEntityCrystallizer crys = (TileEntityCrystallizer)ent;
                this.func_75146_a(new Slot((IInventory)crys, 0, 80, 13));
                this.func_75146_a(new Slot((IInventory)crys, 1, 108, 29));
                this.func_75146_a(new Slot((IInventory)crys, 2, 108, 55));
                this.func_75146_a(new Slot((IInventory)crys, 3, 80, 69));
                this.func_75146_a(new Slot((IInventory)crys, 4, 52, 55));
                this.func_75146_a(new Slot((IInventory)crys, 5, 52, 29));
                this.func_75146_a((Slot)new SlotFurnace(player, (IInventory)crys, 6, 80, 40));
                break;
            }
            case PARASIEVE: {
                TileEntityParaSieve proto = (TileEntityParaSieve)ent;
                for (int i = 0; i < proto.filters.length / 2; ++i) {
                    this.func_75146_a(new Slot((IInventory)proto, i * 2, 53 + i * 18, 17));
                    this.func_75146_a(new Slot((IInventory)proto, i * 2 + 1, 53 + i * 18, 35));
                }
                this.invdy -= 18;
                break;
            }
        }
        this.addPlayerSlots(inventoryplayer);
    }

    void addPlayerSlots(InventoryPlayer inventoryplayer) {
        this.player_slot_start = this.field_75151_b.size();
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, this.invdx + 8 + k * 18, this.invdy + 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, this.invdy + 142));
        }
        this.player_slot_end = this.field_75151_b.size();
        this.slot_start = 0;
        this.slot_end = this.player_slot_start;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.factory == null) {
            return true;
        }
        return this.factory.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        Slot slot = (Slot)this.field_75151_b.get(i);
        ItemStack itemstack = slot.func_75211_c();
        if (itemstack == null) {
            return null;
        }
        switch (this.type) {
            case SLAGFURNACE: {
                if (i < 4) break;
                if (TileEntityFurnace.func_145952_a((ItemStack)itemstack) > 0) {
                    return FzUtil.transferSlotToSlots(player, slot, Arrays.asList((Slot)this.field_75151_b.get(1)));
                }
                return FzUtil.transferSlotToSlots(player, slot, Arrays.asList((Slot)this.field_75151_b.get(0)));
            }
            case STAMPER: 
            case PACKAGER: {
                if (i < 2) break;
                return FzUtil.transferSlotToSlots(player, slot, Arrays.asList((Slot)this.field_75151_b.get(0)));
            }
            case MIXER: {
                if (i < 8) break;
                ArrayList<Slot> av = new ArrayList<Slot>(4);
                for (int j = 0; j < 4; ++j) {
                    av.add((Slot)this.field_75151_b.get(j));
                }
                return FzUtil.transferSlotToSlots(player, slot, av);
            }
            case CRYSTALLIZER: {
                if (i < 8) break;
                ArrayList<Slot> av = new ArrayList<Slot>(6);
                for (int j = 0; j < 6; ++j) {
                    av.add((Slot)this.field_75151_b.get(j));
                }
                return FzUtil.transferSlotToSlots(player, slot, av);
            }
        }
        ItemStack itemstack1 = slot.func_75211_c();
        itemstack = itemstack1.func_77946_l();
        if (i < this.slot_end ? !this.func_75135_a(itemstack1, this.player_slot_start, this.player_slot_end, true) : !this.func_75135_a(itemstack1, this.slot_start, this.slot_end, false)) {
            return null;
        }
        if (itemstack1.field_77994_a == 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        if (itemstack1.field_77994_a == itemstack.field_77994_a) {
            return null;
        }
        slot.func_82870_a(player, itemstack1);
        return itemstack;
    }

    class StackLimitedSlot
    extends Slot {
        int max_size;

        public StackLimitedSlot(int max_size, IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
            this.max_size = max_size;
        }

        public int func_75219_a() {
            return this.max_size;
        }
    }

    class FactorySlot
    extends Slot {
        Item[] allowed;
        Item[] forbidden;

        public FactorySlot(IInventory iinventory, int slotNumber, int posX, int posY, Item[] a, Item[] f) {
            super(iinventory, slotNumber, posX, posY);
            this.allowed = a;
            this.forbidden = f;
        }

        public boolean func_75214_a(ItemStack itemstack) {
            if (!super.func_75214_a(itemstack)) {
                return false;
            }
            if (this.allowed != null) {
                for (Item a : this.allowed) {
                    if (itemstack.func_77973_b() != a) continue;
                    return true;
                }
                return false;
            }
            if (this.forbidden != null) {
                for (Item f : this.forbidden) {
                    if (itemstack.func_77973_b() != f) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

