/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.notify.ISaneCoord;
import factorization.notify.NotifyImplementation;
import factorization.notify.SimpleCoord;
import factorization.shared.FzUtil;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class NotifyNetwork {
    static final String channelName = "fzNotify";
    static FMLEventChannel channel;
    static final byte COORD = 0;
    static final byte VEC3 = 1;
    static final byte ENTITY = 2;
    static final byte TILEENTITY = 3;
    static final byte ONSCREEN = 4;
    public static final ItemStack EMPTY_ITEMSTACK;

    public NotifyNetwork() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        channel.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void recievePacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBufInputStream input = new ByteBufInputStream(event.packet.payload());
        try {
            this.handleNotify((DataInput)input, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    void handleNotify(DataInput input, EntityPlayer me) throws IOException {
        Object target = null;
        switch (input.readByte()) {
            case 0: {
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                target = new SimpleCoord(me.field_70170_p, x, y, z);
                break;
            }
            case 2: {
                int id = input.readInt();
                if (id == me.func_145782_y()) {
                    target = me;
                    break;
                }
                target = me.field_70170_p.func_73045_a(id);
                break;
            }
            case 3: {
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                target = me.field_70170_p.func_147438_o(x, y, z);
                if (target != null) break;
                target = new SimpleCoord(me.field_70170_p, x, y, z);
                break;
            }
            case 1: {
                target = Vec3.func_72443_a((double)input.readDouble(), (double)input.readDouble(), (double)input.readDouble());
                break;
            }
            case 4: {
                String message = input.readUTF();
                String[] formatArgs = NotifyNetwork.readStrings(input);
                NotifyImplementation.proxy.onscreen(message, formatArgs);
                return;
            }
            default: {
                return;
            }
        }
        if (target == null) {
            return;
        }
        ItemStack item = FzUtil.readStack(input);
        if (item != null && EMPTY_ITEMSTACK.func_77969_a(item)) {
            item = null;
        }
        String msg = input.readUTF();
        String[] args = NotifyNetwork.readStrings(input);
        NotifyImplementation.recieve(me, target, item, msg, args);
    }

    static void broadcast(FMLProxyPacket packet, EntityPlayer player, NetworkRegistry.TargetPoint area) {
        if (player == null) {
            channel.sendToAll(packet);
        } else if (player instanceof EntityPlayerMP) {
            channel.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    private static void writeStrings(DataOutputStream output, String[] args) throws IOException {
        output.writeByte((byte)args.length);
        for (String s : args) {
            output.writeUTF(s);
        }
    }

    private static String[] readStrings(DataInput input) throws IOException {
        String[] ret = new String[input.readByte()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = input.readUTF();
        }
        return ret;
    }

    static FMLProxyPacket notifyPacket(Object where, ItemStack item, String format, String ... args) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            if (where instanceof Vec3) {
                output.writeByte(1);
                Vec3 v = (Vec3)where;
                output.writeDouble(v.field_72450_a);
                output.writeDouble(v.field_72448_b);
                output.writeDouble(v.field_72449_c);
            } else if (where instanceof ISaneCoord) {
                output.writeByte(0);
                ISaneCoord c = (ISaneCoord)where;
                output.writeInt(c.x());
                output.writeInt(c.y());
                output.writeInt(c.z());
            } else if (where instanceof Entity) {
                output.writeByte(2);
                Entity ent = (Entity)where;
                output.writeInt(ent.func_145782_y());
            } else if (where instanceof TileEntity) {
                output.writeByte(3);
                TileEntity te = (TileEntity)where;
                output.writeInt(te.field_145851_c);
                output.writeInt(te.field_145848_d);
                output.writeInt(te.field_145849_e);
            } else {
                return null;
            }
            if (item == null) {
                item = EMPTY_ITEMSTACK;
            }
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
            output.writeUTF(format);
            NotifyNetwork.writeStrings(output, args);
            output.flush();
            return NotifyNetwork.generate(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static FMLProxyPacket onscreenPacket(String message, String[] formatArgs) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeByte(4);
            output.writeUTF(message);
            NotifyNetwork.writeStrings(output, formatArgs);
            output.flush();
            return NotifyNetwork.generate(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FMLProxyPacket generate(ByteArrayOutputStream baos) {
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])baos.toByteArray()), channelName);
    }

    static {
        EMPTY_ITEMSTACK = new ItemStack(Blocks.field_150350_a);
    }
}

