/*
 * Decompiled with CFR 0.152.
 */
package factorization.oreprocessing;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IActOnCraft;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemOreProcessing
extends ItemFactorization
implements IActOnCraft {
    public static ArrayList<String> OD_ores = new ArrayList();
    public static ArrayList<String> OD_ingots = new ArrayList();
    String stateName;

    public ItemOreProcessing(String stateName) {
        super("ore/" + stateName, Core.TabType.MATERIALS);
        this.func_77627_a(true);
        this.stateName = stateName;
    }

    public int func_82790_a(ItemStack is, int renderPass) {
        return OreType.fromIS((ItemStack)is).color;
    }

    public String func_77667_c(ItemStack is) {
        return "item.factorization:ore/" + this.stateName + "/" + (Object)((Object)OreType.fromIS(is));
    }

    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (OreType oreType : OreType.values()) {
            if (!oreType.enabled) continue;
            boolean show = true;
            if ((this == Core.registry.ore_crystal || this == Core.registry.ore_reduced) && oreType == OreType.GALENA) {
                show = false;
            }
            if ((this == Core.registry.ore_dirty_gravel || this == Core.registry.ore_clean_gravel) && oreType == OreType.SILVER) {
                show = false;
            }
            if (!show) continue;
            list.add(new ItemStack((Item)this, 1, oreType.ID));
        }
    }

    public ItemStack makeStack(OreType ot) {
        return new ItemStack((Item)this, 1, ot.ID);
    }

    @Override
    public void onCraft(ItemStack is, IInventory craftMatrix, int craftSlot, ItemStack result, EntityPlayer player) {
        if (result == null || player == null) {
            return;
        }
        if (player.field_70170_p == null ? FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT : player.field_70170_p.field_72995_K) {
            return;
        }
        if (result.func_77973_b() != Core.registry.ore_clean_gravel) {
            return;
        }
        if (is.func_77973_b() != Core.registry.ore_dirty_gravel) {
            return;
        }
        boolean any = false;
        if (Math.random() > 0.25) {
            return;
        }
        any = true;
        ItemStack toAdd = new ItemStack((Item)Core.registry.sludge);
        if (!player.field_71071_by.func_70441_a(toAdd)) {
            player.func_71019_a(new ItemStack((Item)Core.registry.sludge, 1), false);
        }
    }

    public static enum OreType {
        IRON(0, 0xD8D8D8, "Iron", "oreIron", "ingotIron"),
        GOLD(1, 15657768, "Gold", "oreGold", "ingotGold"),
        LEAD(2, 3091516, "Lead", "oreLead", "ingotLead"),
        TIN(3, 0xD7F7FF, "Tin", "oreTin", "ingotTin"),
        COPPER(4, 14060601, "Copper", "oreCopper", "ingotCopper"),
        SILVER(5, 8099513, "Silver", null, "ingotSilver"),
        GALENA(6, 6847385, "Galena", "oreSilver", null),
        COBALT(8, 2324189, "Cobalt", "oreCobalt", "ingotCobalt"),
        ARDITE(9, 16026112, "Ardite", "oreArdite", "ingotArdite"),
        DARKIRON(10, 5243092, "Dark Iron", "oreFzDarkIron", "ingotFzDarkIron"),
        INVALID(0, 0xFFFFFF, "Invalid", null, null);

        public int ID;
        int color;
        String en_name;
        String OD_ore;
        String OD_ingot;
        public boolean enabled = false;
        ItemStack processingResult = null;
        ItemStack surounding_medium = new ItemStack(Blocks.field_150348_b);
        static OreType[] vals;

        private OreType(int ID, int color, String en_name, String OD_ore, String OD_ingot) {
            this.ID = ID;
            this.color = color;
            this.en_name = en_name;
            this.OD_ore = OD_ore;
            this.OD_ingot = OD_ingot;
            if (OD_ore != null) {
                OD_ores.add(OD_ore);
            }
            if (OD_ingot != null) {
                OD_ingots.add(OD_ingot);
            }
        }

        public void enable() {
            if (!this.enabled) {
                ItemStack dirty = Core.registry.ore_dirty_gravel.makeStack(this);
                ItemStack clean = Core.registry.ore_clean_gravel.makeStack(this);
                ItemStack reduced = Core.registry.ore_reduced.makeStack(this);
                ItemStack crystal = Core.registry.ore_crystal.makeStack(this);
                OreDictionary.registerOre((String)("dirtyGravel" + this.en_name), (ItemStack)dirty);
                OreDictionary.registerOre((String)("cleanGravel" + this.en_name), (ItemStack)clean);
                OreDictionary.registerOre((String)("reduced" + this.en_name), (ItemStack)reduced);
                OreDictionary.registerOre((String)("crystalline" + this.en_name), (ItemStack)crystal);
            }
            this.enabled = true;
        }

        public static OreType fromOreClass(String oreClass) {
            for (OreType ot : OreType.values()) {
                if (ot.OD_ingot != null && ot.OD_ingot.equals(oreClass)) {
                    return ot;
                }
                if (ot.OD_ore == null || !ot.OD_ore.equals(oreClass)) continue;
                return ot;
            }
            return null;
        }

        public static OreType fromID(int id) {
            if (vals == null) {
                int max = 0;
                for (OreType ot : OreType.values()) {
                    max = Math.max(max, ot.ID);
                }
                vals = new OreType[max + 1];
                Arrays.fill((Object[])vals, (Object)INVALID);
                for (OreType ot : OreType.values()) {
                    if (ot == INVALID) continue;
                    OreType.vals[ot.ID] = ot;
                }
            }
            if (id < 0 || id >= vals.length) {
                return INVALID;
            }
            return vals[id];
        }

        public static OreType fromIS(ItemStack is) {
            if (is == null) {
                return INVALID;
            }
            return OreType.fromID(is.func_77960_j());
        }

        static {
            OreType.COBALT.surounding_medium = new ItemStack(Blocks.field_150424_aL);
            OreType.ARDITE.surounding_medium = new ItemStack(Blocks.field_150424_aL);
            vals = null;
        }
    }
}

