/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.shared.Core;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class FzUtil {
    public static final int WILDCARD_DAMAGE = Short.MAX_VALUE;
    static Random rand = new Random();
    private static final UUID FZ_UUID = UUID.fromString("f979c78a-f80d-46b1-9c49-0121ea8850e6");
    private static HashMap<String, WeakHashMap<World, FzFakePlayer>> usedPlayerCache = new HashMap();
    private static ThreadLocal<ArrayList<ForgeDirection>> direction_cache = new ThreadLocal();
    private static ThreadLocal<Random> random_cache = new ThreadLocal();
    @SideOnly(value=Side.CLIENT)
    private static RenderBlocks rb;
    private static final ItemStack[] slots3x3;
    public static boolean craft_succeeded;
    public static ArrayList<ItemStack> emptyArrayList;
    static ArrayList<IRecipe> recipeCache;
    private static int cache_fear;
    private static IRecipe stupid_hacky_vanilla_item_repair_recipe;

    public static ItemStack makeWildcard(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static ItemStack makeWildcard(Block item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static boolean identical(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return FzUtil.couldMerge(a, b);
    }

    public static boolean couldMerge(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && FzUtil.sameItemTags(a, b);
    }

    public static boolean sameItemTags(ItemStack a, ItemStack b) {
        if (a.field_77990_d == null || b.field_77990_d == null) {
            return a.field_77990_d == b.field_77990_d;
        }
        return a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean similar(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j();
    }

    public static boolean wildcardSimilar(ItemStack template, ItemStack stranger) {
        if (template == null || stranger == null) {
            return template == stranger;
        }
        if (template.func_77960_j() == Short.MAX_VALUE) {
            return template.func_77973_b() == stranger.func_77973_b();
        }
        return FzUtil.similar(template, stranger);
    }

    public static boolean oreDictionarySimilar(Object template, ItemStack stranger) {
        if (template instanceof String) {
            ArrayList ores = OreDictionary.getOres((String)((String)template));
            for (int i = 0; i < ores.size(); ++i) {
                if (!FzUtil.wildcardSimilar((ItemStack)ores.get(i), stranger)) continue;
                return true;
            }
            return false;
        }
        if (template instanceof List) {
            for (Object o : (List)template) {
                if (!FzUtil.oreDictionarySimilar(o, stranger)) continue;
                return true;
            }
            return false;
        }
        return FzUtil.wildcardSimilar((ItemStack)template, stranger);
    }

    public static int stackSize(ItemStack is) {
        return is == null ? 0 : is.field_77994_a;
    }

    public static ItemStack normalDecr(ItemStack is) {
        --is.field_77994_a;
        return is.field_77994_a <= 0 ? null : is;
    }

    public static NBTTagCompound getTag(ItemStack is) {
        NBTTagCompound ret = is.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            is.func_77982_d(ret);
        }
        return ret;
    }

    public static long getItemHash(ItemStack is) {
        if (is == null) {
            return Long.MIN_VALUE;
        }
        long ih = FzUtil.getId(is);
        long md = is.func_77960_j();
        long tg = 0L;
        if (is.func_77942_o()) {
            tg = is.func_77978_p().hashCode();
        }
        return (ih << 48) + (md << 32) + tg + (long)(is.field_77994_a * 100);
    }

    public static String getCustomItemName(ItemStack is) {
        if (is != null && is.func_82837_s()) {
            return is.func_82833_r();
        }
        return null;
    }

    public static boolean itemCanFire(World w, ItemStack is, int tickDelay) {
        NBTTagCompound tag = FzUtil.getTag(is);
        long t = tag.func_74763_f("lf");
        if (t > w.func_82737_E()) {
            tag.func_74772_a("lf", w.func_82737_E());
            return true;
        }
        if (t + (long)tickDelay > w.func_82737_E()) {
            return false;
        }
        tag.func_74772_a("lf", w.func_82737_E());
        return true;
    }

    public static ItemStack normalize(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        return is;
    }

    public static int getStackSize(ItemStack is) {
        if (is == null) {
            return 0;
        }
        return is.field_77994_a;
    }

    public static int getFreeSpace(ItemStack is, int stackLimit) {
        int max = Math.min(is.func_77976_d(), stackLimit);
        return Math.max(0, max - is.field_77994_a);
    }

    @Deprecated
    public static ItemStack transferStackToArea(IInventory srcInv, int slotIndex, IInventory destInv, Iterable<Integer> targetSlots) {
        ItemStack target;
        ItemStack is = srcInv.func_70301_a(slotIndex);
        if (is == null || is.field_77994_a == 0) {
            return null;
        }
        for (int i : targetSlots) {
            target = destInv.func_70301_a(i);
            if (target == null) continue;
            if (FzUtil.couldMerge(is, target)) {
                int free_space = target.func_77976_d() - target.field_77994_a;
                int incr = Math.min(free_space, is.field_77994_a);
                if (incr <= 0) continue;
                is.field_77994_a -= incr;
                target.field_77994_a += incr;
            }
            if (is.field_77994_a > 0) continue;
            srcInv.func_70299_a(slotIndex, null);
            return null;
        }
        for (int i : targetSlots) {
            target = destInv.func_70301_a(i);
            if (target != null) continue;
            destInv.func_70299_a(i, is.func_77946_l());
            is.field_77994_a = 0;
            srcInv.func_70299_a(slotIndex, null);
            return null;
        }
        if (is.field_77994_a <= 0) {
            srcInv.func_70299_a(slotIndex, null);
            return null;
        }
        srcInv.func_70299_a(slotIndex, is);
        return is;
    }

    public static ItemStack transferSlotToSlots(EntityPlayer player, Slot clickSlot, Iterable<Slot> destinations) {
        ItemStack got = FzUtil.tryTransferSlotToSlots(player, clickSlot, destinations);
        if (got != null) {
            clickSlot.func_75215_d(got);
        }
        return null;
    }

    public static ItemStack tryTransferSlotToSlots(EntityPlayer player, Slot clickSlot, Iterable<Slot> destinations) {
        ItemStack clickStack = FzUtil.normalize(clickSlot.func_75211_c());
        if (clickStack == null) {
            return null;
        }
        clickSlot.func_82870_a(player, clickStack);
        for (Slot slot : destinations) {
            int freeSpace;
            ItemStack is = FzUtil.normalize(slot.func_75211_c());
            if (is == null || !FzUtil.couldMerge(is, clickStack) || (freeSpace = Math.min(is.func_77976_d() - is.field_77994_a, slot.func_75219_a() - is.field_77994_a)) <= 0 || !slot.func_75214_a(clickStack)) continue;
            int delta = Math.min(freeSpace, clickStack.field_77994_a);
            is.field_77994_a += delta;
            slot.func_75215_d(is);
            clickStack.field_77994_a -= delta;
            if (clickStack.field_77994_a > 0) continue;
            clickSlot.func_75215_d(null);
            return null;
        }
        for (Slot slot : destinations) {
            if (slot.func_75216_d() || !slot.func_75214_a(clickStack)) continue;
            int freeSpace = Math.min(slot.func_75219_a(), clickStack.func_77976_d());
            int delta = Math.min(freeSpace, clickStack.field_77994_a);
            ItemStack toPut = clickStack.func_77946_l();
            toPut.field_77994_a = delta;
            slot.func_75215_d(toPut);
            clickStack.field_77994_a -= delta;
            if ((clickStack = FzUtil.normalize(clickStack)) != null) continue;
            clickSlot.func_75215_d(null);
            return null;
        }
        return FzUtil.normalize(clickStack);
    }

    public static FzInv openInventory(IInventory orig_inv, ForgeDirection side) {
        return FzUtil.openInventory(orig_inv, side.ordinal(), true);
    }

    public static FzInv openInventory(IInventory orig_inv, ForgeDirection side, boolean openBothChests) {
        return FzUtil.openInventory(orig_inv, side.ordinal(), openBothChests);
    }

    public static FzInv openInventory(IInventory orig_inv, int side) {
        return FzUtil.openInventory(orig_inv, side, true);
    }

    public static FzInv openInventory(IInventory orig_inv, final int side, boolean openBothChests) {
        if (orig_inv == null) {
            return null;
        }
        if (orig_inv instanceof TileEntityChest && (orig_inv = FzUtil.openDoubleChest((TileEntityChest)orig_inv, openBothChests)) == null) {
            return null;
        }
        if (orig_inv instanceof ISidedInventory) {
            final ISidedInventory inv = (ISidedInventory)orig_inv;
            int[] _ = inv.func_94128_d(side);
            if (_ == null) {
                _ = new int[]{};
            }
            final int[] slotMap = _;
            return new FzInv((IInventory)inv){

                @Override
                int slotIndex(int i) {
                    return slotMap[i];
                }

                @Override
                public int size() {
                    return slotMap.length;
                }

                @Override
                public boolean canExtract(int slot, ItemStack is) {
                    if (is == null) {
                        return false;
                    }
                    return inv.func_102008_b(slotMap[slot], is, side);
                }

                @Override
                public boolean canInsert(int i, ItemStack is) {
                    if (this.forceInsert) {
                        return true;
                    }
                    return super.canInsert(i, is) && inv.func_102007_a(this.slotIndex(i), is, side);
                }
            };
        }
        return new PlainInvWrapper(orig_inv);
    }

    public static FzInv openInventory(Entity ent, boolean access_players) {
        if (ent instanceof EntityPlayer && !access_players) {
            return null;
        }
        if (ent instanceof IInventory) {
            return FzUtil.openInventory((IInventory)ent, ForgeDirection.UP);
        }
        if (ent instanceof EntityPlayer) {
            InventoryPlayer ip = ((EntityPlayer)ent).field_71071_by;
            return FzUtil.openInventory((IInventory)ip, ForgeDirection.UP).slice(0, ip.field_70462_a.length);
        }
        return null;
    }

    public static boolean canAccessSlot(IInventory inv, int slot) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory isi = (ISidedInventory)inv;
            for (int i = 0; i < 6; ++i) {
                int[] slots = isi.func_94128_d(i);
                for (int j = 0; j < slots.length; ++j) {
                    if (slots[j] != slot) continue;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public static IInventory openDoubleChest(TileEntityChest chest, boolean openBothSides) {
        TileEntityChest origChest = chest;
        World world = chest.func_145831_w();
        int i = chest.field_145851_c;
        int j = chest.field_145848_d;
        int k = chest.field_145849_e;
        Block cb = chest.func_145838_q();
        if (cb == null) {
            return null;
        }
        BlockChest chestBlock = Blocks.field_150486_ae;
        if (world.func_147439_a(i - 1, j, k) == chestBlock) {
            return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)((TileEntityChest)world.func_147438_o(i - 1, j, k)), (IInventory)origChest);
        }
        if (world.func_147439_a(i, j, k - 1) == chestBlock) {
            return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)((TileEntityChest)world.func_147438_o(i, j, k - 1)), (IInventory)origChest);
        }
        if (world.func_147439_a(i + 1, j, k) == chestBlock) {
            if (openBothSides) {
                return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)origChest, (IInventory)((TileEntityChest)world.func_147438_o(i + 1, j, k)));
            }
            return null;
        }
        if (world.func_147439_a(i, j, k + 1) == chestBlock) {
            if (openBothSides) {
                return new InventoryLargeChest(origChest.func_145825_b(), (IInventory)origChest, (IInventory)((TileEntityChest)world.func_147438_o(i, j, k + 1)));
            }
            return null;
        }
        return chest;
    }

    public static IInventory openDoubleChest(IInventory inv, boolean openBothSides) {
        if (inv instanceof TileEntityChest) {
            return FzUtil.openDoubleChest((TileEntityChest)inv, openBothSides);
        }
        return inv;
    }

    public static IRecipe createShapedRecipe(ItemStack result, Object ... args) {
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (args[var4] instanceof String[]) {
            String[] var7 = (String[])args[var4++];
            for (int var8 = 0; var8 < var7.length; ++var8) {
                String var9 = var7[var8];
                ++var6;
                var5 = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (args[var4] instanceof String) {
                String var11 = (String)args[var4++];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        }
        HashMap<Character, ItemStack> var12 = new HashMap<Character, ItemStack>();
        while (var4 < args.length) {
            Character var13 = (Character)args[var4];
            ItemStack var14 = null;
            if (args[var4 + 1] instanceof Item) {
                var14 = new ItemStack((Item)args[var4 + 1]);
            } else if (args[var4 + 1] instanceof Block) {
                var14 = new ItemStack((Block)args[var4 + 1], 1, -1);
            } else if (args[var4 + 1] instanceof ItemStack) {
                var14 = (ItemStack)args[var4 + 1];
            }
            var12.put(var13, var14);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (int var16 = 0; var16 < var5 * var6; ++var16) {
            char var10 = var3.charAt(var16);
            var15[var16] = var12.containsKey(Character.valueOf(var10)) ? ((ItemStack)var12.get(Character.valueOf(var10))).func_77946_l() : null;
        }
        return new ShapedRecipes(var5, var6, var15, result);
    }

    public static IRecipe createShapelessRecipe(ItemStack result, Object ... args) {
        ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
        for (Object var7 : args) {
            if (var7 instanceof ItemStack) {
                var3.add(((ItemStack)var7).func_77946_l());
                continue;
            }
            if (var7 instanceof Item) {
                var3.add(new ItemStack((Item)var7));
                continue;
            }
            if (!(var7 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipy!");
            }
            var3.add(new ItemStack((Block)var7));
        }
        return new ShapelessRecipes(result, var3);
    }

    public static EntityItem spawnItemStack(Coord c, ItemStack item) {
        if (item == null) {
            return null;
        }
        EntityItem entityitem = new EntityItem(c.w, (double)c.x + 0.5, (double)c.y + 0.5, (double)c.z + 0.5, item);
        entityitem.field_70181_x = 0.2 + rand.nextGaussian() * 0.02;
        entityitem.field_70159_w = rand.nextGaussian() * 0.02;
        entityitem.field_70179_y = rand.nextGaussian() * 0.02;
        c.w.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static EntityItem spawnItemStack(Entity c, ItemStack item) {
        if (item == null) {
            return null;
        }
        EntityItem entityitem = new EntityItem(c.field_70170_p, c.field_70165_t + (double)(c.field_70130_N / 2.0f), c.field_70163_u + (double)(c.field_70131_O / 2.0f), c.field_70161_v + (double)(c.field_70130_N / 2.0f), item);
        entityitem.field_70181_x = 0.2 + rand.nextGaussian() * 0.02;
        entityitem.field_70159_w = rand.nextGaussian() * 0.02;
        entityitem.field_70179_y = rand.nextGaussian() * 0.02;
        c.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static int determineOrientation(EntityPlayer player) {
        if (player.field_70125_A > 75.0f) {
            return 0;
        }
        if (player.field_70125_A <= -75.0f) {
            return 1;
        }
        return FzUtil.determineFlatOrientation(player);
    }

    public static int determineFlatOrientation(EntityPlayer player) {
        int var7 = MathHelper.func_76128_c((double)((double)((180.0f + player.field_70177_z) * 4.0f / 360.0f) + 0.5)) & 3;
        return var7 == 0 ? 2 : (var7 == 1 ? 5 : (var7 == 2 ? 3 : (var7 == 3 ? 4 : 0)));
    }

    public static DeltaCoord getFlatDiagonalFacing(EntityPlayer player) {
        double angle = Math.toRadians(90.0f + player.field_70177_z);
        int dx = Math.cos(angle) > 0.0 ? 1 : -1;
        int dz = Math.sin(angle) > 0.0 ? 1 : -1;
        return new DeltaCoord(dx, 0, dz);
    }

    public static byte getOpposite(int dir) {
        return (byte)ForgeDirection.getOrientation((int)dir).getOpposite().ordinal();
    }

    public static <E extends Enum> E shiftEnum(E current, E[] values, int delta) {
        int next = current.ordinal() + delta;
        if (next < 0) {
            return values[values.length - 1];
        }
        if (next >= values.length) {
            return values[0];
        }
        return values[next];
    }

    public static void writeTank(NBTTagCompound tag, FluidTank tank, String name2) {
        FluidStack ls = tank.getFluid();
        if (ls == null) {
            return;
        }
        NBTTagCompound liquid_tag = new NBTTagCompound();
        ls.writeToNBT(liquid_tag);
        tag.func_74782_a(name2, (NBTBase)liquid_tag);
    }

    public static void readTank(NBTTagCompound tag, FluidTank tank, String name2) {
        NBTTagCompound liquid_tag = tag.func_74775_l(name2);
        FluidStack ls = FluidStack.loadFluidStackFromNBT((NBTTagCompound)liquid_tag);
        tank.setFluid(ls);
    }

    public static void spill(Coord where, FluidStack what) {
        if (what == null || what.amount < 0) {
            return;
        }
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(what, where.w, where.x, where.y, where.z));
    }

    public static Vec3 getMin(AxisAlignedBB aabb) {
        return Vec3.func_72443_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c);
    }

    public static void setMin(AxisAlignedBB aabb, Vec3 v) {
        aabb.field_72340_a = v.field_72450_a;
        aabb.field_72338_b = v.field_72448_b;
        aabb.field_72339_c = v.field_72449_c;
    }

    public static Vec3 getMax(AxisAlignedBB aabb) {
        return Vec3.func_72443_a((double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
    }

    public static void setMax(AxisAlignedBB aabb, Vec3 v) {
        aabb.field_72336_d = v.field_72450_a;
        aabb.field_72337_e = v.field_72448_b;
        aabb.field_72334_f = v.field_72449_c;
    }

    public static Vec3 averageVec(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)((a.field_72450_a + b.field_72450_a) / 2.0), (double)((a.field_72448_b + b.field_72448_b) / 2.0), (double)((a.field_72449_c + b.field_72449_c) / 2.0));
    }

    public static boolean intersect(double la, double ha, double lb, double hb) {
        return !(ha < lb) && !(hb < la);
    }

    public static InventoryCrafting makeCraftingGrid() {
        return new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return false;
            }

            public void func_75130_a(IInventory iinventory) {
            }
        }, 3, 3);
    }

    private static GameProfile makeProfile(String name2) {
        if (StringUtils.func_151246_b((String)name2)) {
            return new GameProfile(FZ_UUID, "[FZ]");
        }
        return new GameProfile(FZ_UUID, "[FZ:" + name2 + "]");
    }

    public static EntityPlayer makePlayer(Coord where, String use) {
        FzFakePlayer found;
        WeakHashMap<Object, FzFakePlayer> fakePlayerCache = usedPlayerCache.get(use);
        if (fakePlayerCache == null) {
            fakePlayerCache = new WeakHashMap();
            usedPlayerCache.put(use, fakePlayerCache);
        }
        if ((found = fakePlayerCache.get(where.w)) == null) {
            if (!(where.w instanceof WorldServer)) {
                throw new IllegalArgumentException("Can't construct fake players on the client");
            }
            found = new FzFakePlayer((WorldServer)where.w, "[FZ." + use + "]", where);
            fakePlayerCache.put(where.w, found);
        }
        found.where = where;
        where.setAsEntityLocation((Entity)found);
        Arrays.fill(found.field_71071_by.field_70460_b, null);
        Arrays.fill(found.field_71071_by.field_70462_a, null);
        found.field_70128_L = false;
        return found;
    }

    public static void addInventoryToArray(IInventory inv, ArrayList<ItemStack> ret) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = FzUtil.normalize(inv.func_70301_a(i));
            if (is == null) continue;
            ret.add(is);
        }
    }

    public static ArrayList<ForgeDirection> getRandomDirections(Random rand) {
        ArrayList<Object> ret = direction_cache.get();
        if (ret == null) {
            ret = new ArrayList(6);
            for (int i = 0; i < 6; ++i) {
                ret.add(ForgeDirection.getOrientation((int)i));
            }
            direction_cache.set(ret);
        }
        Collections.shuffle(ret, rand);
        return ret;
    }

    public static Random dirtyRandomCache() {
        Random ret = random_cache.get();
        if (ret == null) {
            ret = new Random();
            random_cache.set(ret);
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static RenderBlocks getRB() {
        if (rb == null) {
            rb = new RenderBlocks();
        }
        FzUtil.rb.field_147845_a = Minecraft.func_71410_x().field_71441_e;
        return rb;
    }

    static InventoryCrafting getCrafter(ItemStack ... slots) {
        InventoryCrafting craft = FzUtil.makeCraftingGrid();
        for (int i = 0; i < 9; ++i) {
            craft.func_70299_a(i, slots[i]);
        }
        return craft;
    }

    static boolean wantSize(int size, TileEntity where, ItemStack ... slots) {
        if (slots.length != size) {
            System.out.println("Tried to craft with items.length != " + size);
            if (where != null) {
                System.out.println("At " + new Coord(where));
            }
            Thread.dumpStack();
            return true;
        }
        return false;
    }

    public static List<ItemStack> craft1x1(TileEntity where, boolean fake, ItemStack what) {
        for (int i = 0; i < slots3x3.length; ++i) {
            FzUtil.slots3x3[i] = null;
        }
        FzUtil.slots3x3[4] = what;
        return FzUtil.craft3x3(where, fake, false, slots3x3);
    }

    public static List<ItemStack> craft2x2(TileEntity where, boolean fake, ItemStack ... slots) {
        if (FzUtil.wantSize(4, where, slots)) {
            return Arrays.asList(slots);
        }
        for (int i = 0; i < slots3x3.length; ++i) {
            FzUtil.slots3x3[i] = null;
        }
        FzUtil.slots3x3[0] = slots[0];
        FzUtil.slots3x3[1] = slots[1];
        FzUtil.slots3x3[3] = slots[2];
        FzUtil.slots3x3[4] = slots[3];
        return FzUtil.craft3x3(where, fake, false, slots3x3);
    }

    public static List<ItemStack> craft3x3(TileEntity where, boolean fake, boolean leaveSlots, ItemStack ... slots) {
        craft_succeeded = false;
        if (FzUtil.wantSize(9, where, slots)) {
            return leaveSlots ? emptyArrayList : Arrays.asList(slots);
        }
        InventoryCrafting craft = FzUtil.getCrafter(slots);
        IRecipe recipe = FzUtil.findMatchingRecipe(craft, where == null ? null : where.func_145831_w());
        ItemStack result = null;
        if (recipe != null) {
            result = recipe.func_77572_b(craft);
        }
        if (result == null) {
            return leaveSlots ? emptyArrayList : Arrays.asList(slots);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (fake) {
            ret.add(result);
            craft_succeeded = true;
            return ret;
        }
        Coord pos = null;
        if (where != null) {
            pos = new Coord(where);
        }
        EntityPlayer fakePlayer = FzUtil.makePlayer(pos, "Crafting");
        if (pos != null) {
            pos.setAsEntityLocation((Entity)fakePlayer);
        }
        InventoryCraftResult craftResult = new InventoryCraftResult();
        craftResult.func_70299_a(0, result);
        SlotCrafting slot = new SlotCrafting(fakePlayer, (IInventory)craft, (IInventory)craftResult, 0, 0, 0);
        slot.func_82870_a(fakePlayer, result);
        ret.add(result);
        if (!leaveSlots) {
            FzUtil.addInventoryToArray((IInventory)craft, ret);
        }
        FzUtil.addInventoryToArray((IInventory)fakePlayer.field_71071_by, ret);
        craft_succeeded = true;
        return ret;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting inv, World world) {
        if (Core.serverStarted) {
            List craftingManagerRecipes = CraftingManager.func_77594_a().func_77592_b();
            if (--cache_fear > 0) {
                return FzUtil.lookupRecipeUncached(inv, world);
            }
            if (craftingManagerRecipes.size() != recipeCache.size()) {
                if (cache_fear < 0) {
                    cache_fear = 10;
                    return FzUtil.lookupRecipeUncached(inv, world);
                }
                recipeCache.clear();
                recipeCache.ensureCapacity(craftingManagerRecipes.size());
                recipeCache.addAll(craftingManagerRecipes);
                recipeCache.add(stupid_hacky_vanilla_item_repair_recipe);
            }
            for (int i = 0; i < recipeCache.size(); ++i) {
                IRecipe recipe = recipeCache.get(i);
                if (!recipe.func_77569_a(inv, world)) continue;
                if (i > 50) {
                    int j = i / 3;
                    IRecipe swapeh = recipeCache.get(j);
                    recipeCache.set(j, recipe);
                    recipeCache.set(i, swapeh);
                }
                return recipe;
            }
        } else {
            return FzUtil.lookupRecipeUncached(inv, world);
        }
        return null;
    }

    public static IRecipe lookupRecipeUncached(InventoryCrafting inv, World world) {
        List craftingManagerRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < craftingManagerRecipes.size(); ++i) {
            IRecipe recipe = (IRecipe)craftingManagerRecipes.get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe;
        }
        return null;
    }

    public static NBTTagCompound readTag(DataInput input, NBTSizeTracker tracker) throws IOException {
        return CompressedStreamTools.func_152456_a((DataInput)input, (NBTSizeTracker)tracker);
    }

    public static ItemStack readStack(DataInput input, NBTSizeTracker tracker) throws IOException {
        ItemStack is = ItemStack.func_77949_a((NBTTagCompound)FzUtil.readTag(input, tracker));
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        return is;
    }

    @Deprecated
    public static NBTTagCompound readTag(DataInput input) throws IOException {
        return FzUtil.readTag(input, NBTSizeTracker.field_152451_a);
    }

    @Deprecated
    public static ItemStack readStack(DataInput input) throws IOException {
        return FzUtil.readStack(input, NBTSizeTracker.field_152451_a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void rotateForDirection(ForgeDirection dir) {
        switch (dir) {
            case WEST: {
                break;
            }
            case EAST: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
        }
    }

    public static NBTTagCompound item2tag(ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        is.func_77955_b(tag);
        tag.func_82580_o("id");
        tag.func_74778_a("name", FzUtil.getName(is));
        return tag;
    }

    public static ItemStack tag2item(NBTTagCompound tag, ItemStack defaultValue) {
        if (tag == null || tag.func_82582_d()) {
            return defaultValue.func_77946_l();
        }
        if (tag.func_74764_b("id")) {
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (is == null) {
                return defaultValue.func_77946_l();
            }
            return is;
        }
        String itemName = tag.func_74779_i("name");
        if (StringUtils.func_151246_b((String)itemName)) {
            return defaultValue.func_77946_l();
        }
        byte stackSize = tag.func_74771_c("Count");
        short itemDamage = tag.func_74765_d("Damage");
        Item it = FzUtil.getItemFromName(itemName);
        if (it == null) {
            return defaultValue.func_77946_l();
        }
        ItemStack ret = new ItemStack(it, (int)stackSize, (int)itemDamage);
        if (tag.func_150297_b("tag", 10)) {
            ret.func_77982_d(tag.func_74775_l("tag"));
        }
        return ret;
    }

    public static void collapseItemList(List<ItemStack> total) {
        int i = 0;
        while (i < total.size()) {
            ItemStack is = FzUtil.normalize(total.get(i));
            if (is == null) {
                total.remove(i);
                continue;
            }
            int s = i + 1;
            while (s < total.size()) {
                ItemStack other = FzUtil.normalize(total.get(s));
                if (other == null) {
                    total.remove(s);
                    continue;
                }
                if (FzUtil.couldMerge(is, other)) {
                    int free = is.func_77976_d() - is.field_77994_a;
                    if (free <= 0) break;
                    int delta = Math.min(free, other.field_77994_a);
                    is.field_77994_a += delta;
                    other.field_77994_a -= delta;
                    if (other.field_77994_a <= 0) {
                        total.remove(s);
                        continue;
                    }
                }
                ++s;
            }
            ++i;
        }
    }

    public static boolean significantChange(float a, float b) {
        float thresh;
        if (a == b) {
            return false;
        }
        if (a == 0.0f || b == 0.0f) {
            a = Math.abs(a);
            b = Math.abs(b);
        }
        return (double)(thresh = Math.abs(a - b) / Math.max(a, b)) > 0.05;
    }

    public static float interp(float oldValue, float newValue, float partial) {
        return oldValue * (1.0f - partial) + newValue * partial;
    }

    public static int getAxis(ForgeDirection fd) {
        if (fd.offsetX != 0) {
            return 1;
        }
        if (fd.offsetY != 0) {
            return 2;
        }
        if (fd.offsetZ != 0) {
            return 3;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean checkGLError(String op) {
        int errSym = GL11.glGetError();
        if (errSym != 0) {
            Core.logSevere("GL Error @ " + op, new Object[0]);
            Core.logSevere(errSym + ": " + GLU.gluErrorString((int)errSym), new Object[0]);
            return true;
        }
        return false;
    }

    public static int getWorldDimension(World world) {
        return world.field_73011_w.field_76574_g;
    }

    public static FluidStack drainSpecificBlockFluid(World worldObj, int x, int y, int z, boolean doDrain, Fluid targetFluid) {
        Block b = worldObj.func_147439_a(x, y, z);
        if (!(b instanceof IFluidBlock)) {
            Fluid vanilla;
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
                vanilla = FluidRegistry.WATER;
            } else if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
                vanilla = FluidRegistry.LAVA;
            } else {
                return null;
            }
            if (worldObj.func_72805_g(x, y, z) != 0) {
                return null;
            }
            if (doDrain) {
                worldObj.func_147468_f(x, y, z);
            }
            return new FluidStack(vanilla, 1000);
        }
        IFluidBlock block = (IFluidBlock)b;
        if (!block.canDrain(worldObj, x, y, z)) {
            return null;
        }
        FluidStack fs = block.drain(worldObj, x, y, z, false);
        if (fs == null) {
            return null;
        }
        if (fs.getFluid() != targetFluid) {
            return null;
        }
        if (doDrain) {
            fs = block.drain(worldObj, x, y, z, true);
        }
        if (fs == null || fs.amount <= 0) {
            return null;
        }
        return fs;
    }

    public static TileEntity cloneTileEntity(TileEntity orig) {
        NBTTagCompound tag = new NBTTagCompound();
        orig.func_145841_b(tag);
        return TileEntity.func_145827_c((NBTTagCompound)tag);
    }

    @SideOnly(value=Side.CLIENT)
    public static void copyStringToClipboard(String text) {
        StringSelection stringselection = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
    }

    public static <E> ArrayList<E> copyWithoutNull(Collection<E> orig) {
        ArrayList<E> ret = new ArrayList<E>();
        if (orig == null) {
            return ret;
        }
        for (E e : orig) {
            if (e == null) continue;
            ret.add(e);
        }
        return ret;
    }

    public static Block getBlock(ItemStack is) {
        if (is == null) {
            return null;
        }
        return Block.func_149634_a((Item)is.func_77973_b());
    }

    public static Block getBlock(Item it) {
        return Block.func_149634_a((Item)it);
    }

    public static Block getBlock(int id) {
        return Block.func_149729_e((int)id);
    }

    public static Item getItem(int id) {
        return Item.func_150899_d((int)id);
    }

    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static int getId(Block block) {
        return Block.func_149682_b((Block)block);
    }

    public static int getId(Item it) {
        return Item.func_150891_b((Item)it);
    }

    public static int getId(ItemStack is) {
        if (is == null) {
            return 0;
        }
        return Item.func_150891_b((Item)is.func_77973_b());
    }

    public static String getName(Item it) {
        return Item.field_150901_e.func_148750_c((Object)it);
    }

    public static String getName(ItemStack is) {
        return FzUtil.getName(is == null ? null : is.func_77973_b());
    }

    public static String getName(Block b) {
        return Block.field_149771_c.func_148750_c((Object)b);
    }

    public static Block getBlockFromName(String blockName) {
        return (Block)Block.field_149771_c.func_82594_a(blockName);
    }

    public static Item getItemFromName(String itemName) {
        return (Item)Item.field_150901_e.func_82594_a(itemName);
    }

    public static ItemStack nameItemStack(ItemStack is, String name2) {
        is = is.func_77946_l();
        is.func_151001_c(name2);
        return is;
    }

    public static void closeNoisily(String msg, InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            Core.logSevere(msg, new Object[0]);
            e.printStackTrace();
        }
    }

    public static boolean stringsEqual(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static EntityPlayer fakeplayerToNull(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            if (player instanceof FakePlayer) {
                return null;
            }
            return player;
        }
        return null;
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        if ((player = FzUtil.fakeplayerToNull(player)) == null) {
            return false;
        }
        return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH());
    }

    public static boolean isPlayerOpped(ICommandSender player) {
        if (player instanceof EntityPlayer) {
            return FzUtil.isPlayerOpped(player);
        }
        return player instanceof MinecraftServer || player instanceof RConConsoleSource;
    }

    public static StatisticsFile getStatsFile(EntityPlayer player) {
        ServerConfigurationManager cm = MinecraftServer.func_71276_C().func_71203_ab();
        return cm.func_152602_a(player);
    }

    static {
        slots3x3 = new ItemStack[9];
        craft_succeeded = false;
        emptyArrayList = new ArrayList(0);
        recipeCache = new ArrayList();
        cache_fear = 10;
        stupid_hacky_vanilla_item_repair_recipe = new IRecipe(){
            ItemStack firstItem;
            ItemStack secondItem;
            ItemStack result;

            void update(IInventory par1InventoryCrafting) {
                this.result = null;
                this.secondItem = null;
                this.firstItem = null;
                int i = 0;
                for (int j = 0; j < par1InventoryCrafting.func_70302_i_(); ++j) {
                    ItemStack itemstack2 = par1InventoryCrafting.func_70301_a(j);
                    if (itemstack2 == null) continue;
                    if (i == 0) {
                        this.firstItem = itemstack2;
                    }
                    if (i == 1) {
                        this.secondItem = itemstack2;
                    }
                    ++i;
                }
                if (i == 2 && this.firstItem.func_77973_b() == this.secondItem.func_77973_b() && this.firstItem.field_77994_a == 1 && this.secondItem.field_77994_a == 1 && this.firstItem.func_77973_b().isRepairable()) {
                    Item item = this.firstItem.func_77973_b();
                    int j1 = item.func_77612_l() - this.firstItem.func_77952_i();
                    int k = item.func_77612_l() - this.secondItem.func_77952_i();
                    int l = j1 + k + item.func_77612_l() * 5 / 100;
                    int i1 = item.func_77612_l() - l;
                    if (i1 < 0) {
                        i1 = 0;
                    }
                    this.result = new ItemStack(this.firstItem.func_77973_b(), 1, i1);
                }
            }

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                this.update((IInventory)inventorycrafting);
                return this.result != null;
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                this.update((IInventory)inventorycrafting);
                return this.result;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return null;
            }
        };
    }

    private static class FzFakePlayer
    extends FakePlayer {
        Coord where;

        private FzFakePlayer(WorldServer world, String name2, Coord where) {
            super(world, FzUtil.makeProfile(name2));
            this.where = where;
        }

        public ChunkCoordinates func_82114_b() {
            return new ChunkCoordinates(this.where.x, this.where.y, this.where.z);
        }

        public boolean func_85032_ar() {
            return true;
        }
    }

    public static class Container2IInventory
    implements IInventory {
        Container cont;

        public Container2IInventory(Container cont) {
            this.cont = cont;
        }

        public int func_70302_i_() {
            return this.cont.func_75138_a().size();
        }

        public ItemStack func_70301_a(int i) {
            return this.cont.func_75139_a(i).func_75211_c();
        }

        public ItemStack func_70298_a(int i, int j) {
            return this.cont.func_75139_a(i).func_75209_a(j);
        }

        public ItemStack func_70304_b(int i) {
            return null;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.cont.func_75141_a(i, itemstack);
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return this.cont.func_75139_a(i).func_75214_a(itemstack);
        }

        public String func_145825_b() {
            return "Container2IInventory wrapper";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }
    }

    public static class PlainInvWrapper
    extends FzInv {
        final int length;

        public PlainInvWrapper(IInventory inv) {
            super(inv);
            this.length = inv.func_70302_i_();
        }

        @Override
        int slotIndex(int i) {
            return i;
        }

        @Override
        public int size() {
            return this.length;
        }
    }

    public static class SubsetInv
    extends FzInv {
        final FzInv ui;
        int start;
        int end;

        public SubsetInv(FzInv ui, int start, int end) {
            super(ui.under);
            this.ui = ui;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        int slotIndex(int i) {
            return this.ui.slotIndex(this.start + i);
        }
    }

    public static abstract class FzInv {
        boolean forceInsert = false;
        boolean callInvChanged = true;
        public final IInventory under;

        public abstract int size();

        abstract int slotIndex(int var1);

        public FzInv(IInventory inv) {
            this.under = inv;
        }

        public void setInsertForce(boolean b) {
            this.forceInsert = b;
        }

        public void setCallOnInventoryChanged(boolean b) {
            this.callInvChanged = b;
        }

        public void onInvChanged() {
            if (this.callInvChanged) {
                this.under.func_70296_d();
            }
        }

        public ItemStack get(int i) {
            return this.under.func_70301_a(this.slotIndex(i));
        }

        public void set(int i, ItemStack is) {
            this.under.func_70299_a(this.slotIndex(i), is);
        }

        public int getFreeSpace(int i) {
            ItemStack dest = this.get(i);
            if (dest == null) {
                return this.under.func_70297_j_();
            }
            int ret = Math.min(this.under.func_70297_j_(), dest.func_77976_d()) - dest.field_77994_a;
            return Math.max(0, ret);
        }

        public int getFreeSpaceFor(ItemStack target, int maxNeeded) {
            int space = 0;
            int spaceInEmpty = Math.min(target.func_77976_d(), this.under.func_70297_j_());
            for (int i = 0; i < this.size(); ++i) {
                if (!this.canInsert(i, target)) continue;
                ItemStack is = this.get(i);
                if (is == null) {
                    space += spaceInEmpty;
                } else {
                    if (!FzUtil.couldMerge(target, is)) continue;
                    space += spaceInEmpty - is.field_77994_a;
                }
                if (space < maxNeeded) continue;
                return space;
            }
            return space;
        }

        public boolean canPush(ItemStack is) {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack here = this.get(i);
                if (this.get(i) == null) {
                    return true;
                }
                if (!FzUtil.couldMerge(here, is)) continue;
                return true;
            }
            return false;
        }

        public ItemStack pushInto(int i, ItemStack is) {
            int slotIndex = this.slotIndex(i);
            if (!this.canInsert(i, is)) {
                return is;
            }
            ItemStack dest = this.under.func_70301_a(slotIndex);
            if (dest == null) {
                ItemStack toPut = is;
                int stack_limit = this.under.func_70297_j_();
                if (toPut.field_77994_a > stack_limit) {
                    toPut = is.func_77979_a(stack_limit);
                } else {
                    is = null;
                }
                this.under.func_70299_a(slotIndex, toPut);
                this.onInvChanged();
                return is;
            }
            if (!FzUtil.couldMerge(dest, is)) {
                return is;
            }
            int dest_free = this.getFreeSpace(i);
            if (dest_free < 1) {
                return is;
            }
            int delta = Math.min(dest_free, is.field_77994_a);
            dest.field_77994_a += delta;
            is.field_77994_a -= delta;
            this.under.func_70299_a(slotIndex, dest);
            this.onInvChanged();
            return FzUtil.normalize(is);
        }

        public boolean canExtract(int slot, ItemStack is) {
            return true;
        }

        public boolean canInsert(int i, ItemStack is) {
            if (this.forceInsert) {
                return true;
            }
            return this.under.func_94041_b(this.slotIndex(i), is) && FzUtil.couldMerge(this.get(i), is);
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null) continue;
                return false;
            }
            return true;
        }

        public boolean transfer(FzInv dest_inv, int max_transfer, ItemStack exclude) {
            for (int i = 0; i < this.size(); ++i) {
                int orig_size;
                ItemStack is = FzUtil.normalize(this.get(i));
                if (is == null || is == exclude || !this.canExtract(i, is)) continue;
                if (is.field_77994_a <= max_transfer) {
                    int orig_size2 = is.field_77994_a;
                    if (orig_size2 == FzUtil.getStackSize(is = dest_inv.push(is))) continue;
                    this.set(i, is);
                    this.onInvChanged();
                    return true;
                }
                ItemStack to_push = is.func_77946_l();
                to_push.field_77994_a = orig_size = Math.min(to_push.field_77994_a, max_transfer);
                int taken = orig_size - FzUtil.getStackSize(to_push = dest_inv.push(to_push));
                if (taken <= 0) continue;
                is.field_77994_a -= taken;
                is = FzUtil.normalize(is);
                this.set(i, is);
                this.onInvChanged();
                return true;
            }
            return false;
        }

        public int transfer(int i, FzInv dest_inv, int dest_i, int max_transfer) {
            ItemStack src = FzUtil.normalize(this.get(i));
            if (src == null) {
                return 0;
            }
            if (!this.canExtract(i, src)) {
                return 0;
            }
            ItemStack dest = dest_inv.get(dest_i);
            if (dest == null) {
                dest = src.func_77946_l();
                dest.field_77994_a = 0;
            } else if (!FzUtil.couldMerge(src, dest)) {
                return 0;
            }
            if (!dest_inv.canInsert(dest_i, src)) {
                return 0;
            }
            int dest_free = dest_inv.getFreeSpace(dest_i);
            if (dest_free < 1) {
                return 0;
            }
            int delta = Math.min(dest_free, src.field_77994_a);
            delta = Math.min(max_transfer, delta);
            dest.field_77994_a += delta;
            src.field_77994_a -= delta;
            src = FzUtil.normalize(src);
            dest_inv.set(dest_i, dest);
            this.set(i, src);
            if (this.callInvChanged) {
                dest_inv.under.func_70296_d();
                this.under.func_70296_d();
            }
            return delta;
        }

        public ItemStack push(ItemStack is) {
            ItemStack dest;
            int i;
            is = FzUtil.normalize(is);
            for (i = 0; i < this.size(); ++i) {
                if (is == null) {
                    return null;
                }
                dest = this.get(i);
                if (dest == null) continue;
                is = FzUtil.normalize(this.pushInto(i, is));
            }
            for (i = 0; i < this.size(); ++i) {
                if (is == null) {
                    return null;
                }
                dest = this.get(i);
                if (dest != null) continue;
                is = FzUtil.normalize(this.pushInto(i, is));
            }
            return is;
        }

        public ItemStack peek() {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack is = FzUtil.normalize(this.get(i));
                if (is == null) continue;
                return is;
            }
            return null;
        }

        public ItemStack pull() {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack ret = this.pull(i, 64);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public ItemStack pullFromSlot(int slot) {
            return this.pull(slot, 64);
        }

        public ItemStack pullWithLimit(int limit) {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack ret = this.pull(i, limit);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public ItemStack pull(int slot, int limit) {
            int i = this.slotIndex(slot);
            ItemStack is = this.under.func_70301_a(i);
            if (FzUtil.normalize(is) == null) {
                return null;
            }
            if (!this.canExtract(slot, is)) {
                return null;
            }
            return this.under.func_70298_a(i, limit);
        }

        public ItemStack pull(ItemStack toMatch, int limit, boolean strict) {
            ItemStack ret = null;
            for (int i = 0; i < this.size(); ++i) {
                ItemStack pulled;
                ItemStack is = this.get(i);
                if ((!strict ? !FzUtil.wildcardSimilar(toMatch, is) : !FzUtil.couldMerge(toMatch, is)) || (pulled = FzUtil.normalize(this.pull(i, limit))) == null) continue;
                limit -= pulled.field_77994_a;
                if (ret == null) {
                    ret = pulled;
                } else {
                    ret.field_77994_a += pulled.field_77994_a;
                }
                if (limit <= 0) break;
            }
            return ret;
        }

        private int slice_index(int i) {
            int size = this.size();
            while (i < 0 && size > 0) {
                i += size;
            }
            return i;
        }

        public FzInv slice(int start, int end) {
            start = this.slice_index(start);
            end = this.slice_index(end);
            start = Math.max(start, 0);
            if ((end = Math.min(end, this.size())) < start) {
                end = start;
            }
            if (start > end) {
                start = end;
            }
            return new SubsetInv(this, start, end);
        }
    }
}

