/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets.fanturpeller;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ObjectModel;
import factorization.sockets.ISocketHolder;
import factorization.sockets.fanturpeller.BufferedFanturpeller;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;

public class PumpLiquids
extends BufferedFanturpeller {
    static final int max_pool = 884736;
    transient PumpAction sourceAction;
    transient PumpAction destinationAction;
    transient ForgeDirection sourceDirection;
    transient ForgeDirection destinationDirection;
    boolean dirty = true;
    @SideOnly(value=Side.CLIENT)
    private static ObjectModel corkscrew;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_PUMP;
    }

    @Override
    public void neighborChanged() {
        this.dirty = true;
    }

    @Override
    protected void fanturpellerUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        boolean onServo;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = onServo = socket != this;
        if (this.isSucking) {
            this.sourceDirection = this.facing;
            this.destinationDirection = this.facing.getOpposite();
        } else {
            this.sourceDirection = this.facing.getOpposite();
            this.destinationDirection = this.facing;
        }
        if (this.dirty) {
            this.dirty = false;
            coord.adjust(this.facing.getOpposite());
            if (this.sourceAction instanceof TankPumper ^ this.hasTank(coord)) {
                this.sourceAction = null;
            }
            if (this.sourceAction instanceof Drainer ^ this.isLiquid(coord)) {
                this.sourceAction = null;
            }
            coord.adjust(this.facing);
            coord.adjust(this.facing);
            if (this.destinationAction instanceof TankPumper ^ this.hasTank(coord)) {
                this.destinationAction = null;
            }
            if (this.destinationAction instanceof Flooder ^ this.isLiquid(coord)) {
                this.destinationAction = null;
            }
            coord.adjust(this.facing.getOpposite());
        }
        if (!this.shouldDoWork()) {
            this.updateDestination(coord, onServo);
            if (this.sourceAction == null) {
                this.updateSource(coord, onServo);
            }
        } else {
            this.updateSource(coord, onServo);
            this.updateDestination(coord, onServo);
        }
    }

    void updateSource(Coord coord, boolean onServo) {
        if (this.sourceAction == null) {
            coord.adjust(this.facing.getOpposite());
            if (this.hasTank(coord)) {
                this.sourceAction = new TankPumper();
            } else if (!onServo && this.isLiquid(coord)) {
                Coord c = new Coord(this).add(this.sourceDirection);
                this.sourceAction = new Drainer(c, c.getFluid());
            }
            coord.adjust(this.facing);
        } else {
            this.sourceAction.suckIn();
        }
    }

    void updateDestination(Coord coord, boolean onServo) {
        if (this.destinationAction == null) {
            coord.adjust(this.facing);
            if (this.hasTank(coord)) {
                this.destinationAction = new TankPumper();
            } else if (!onServo && (this.isLiquid(coord) || coord.isReplacable()) && this.buffer.getFluidAmount() > 0) {
                Coord c = new Coord(this).add(this.destinationDirection);
                this.destinationAction = new Flooder(c, this.buffer.getFluid().getFluid());
            }
            coord.adjust(this.facing.getOpposite());
        } else {
            this.destinationAction.pumpOut();
        }
    }

    @Override
    protected boolean isSafeToDiscard() {
        return this.buffer.getFluidAmount() == 0;
    }

    String easyName(Object obj) {
        if (obj == null) {
            return "None";
        }
        return obj.getClass().getSimpleName();
    }

    @Override
    public String getInfo() {
        FluidStack fs = this.buffer.getFluid();
        String fluid = fs == null ? "" : "\n" + fs.amount + "mB of " + fs.getFluid().getName();
        float targetSpeed = this.getTargetSpeed();
        String speed = "";
        if (Math.abs(targetSpeed) > 1.0f) {
            speed = "\nSpeed: " + (int)(100.0f * this.fan\u03c9 / targetSpeed) + "%";
        }
        return this.easyName(this.sourceAction) + " -> " + this.easyName(this.destinationAction) + fluid + speed;
    }

    @Override
    protected boolean shouldFeedJuice() {
        return this.sourceAction != null || this.destinationAction != null;
    }

    @Override
    int getRequiredCharge() {
        return (int)this.getTargetSpeed();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void representYoSelf() {
        super.representYoSelf();
        corkscrew = new ObjectModel(Core.getResource("models/corkscrew.obj"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
        float d = 0.5f;
        GL11.glTranslatef((float)d, (float)d, (float)d);
        Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())).glRotate();
        float turn = this.scaleRotation(FzUtil.interp(this.prevFanRotation, this.fanRotation, partial));
        GL11.glRotatef((float)turn, (float)0.0f, (float)1.0f, (float)0.0f);
        float sd = motor == null ? -0.125f : 0.1875f;
        GL11.glTranslatef((float)0.0f, (float)(sd += -0.4375f), (float)0.0f);
        float s = 0.75f;
        if (motor != null) {
            s = 0.625f;
            GL11.glTranslatef((float)0.0f, (float)-0.1875f, (float)0.0f);
        }
        GL11.glScalef((float)s, (float)1.0f, (float)s);
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(Core.blockAtlas);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)32826);
        corkscrew.render(BlockIcons.socket$corkscrew);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
    }

    @Override
    public ItemStack getCreatingItem() {
        return new ItemStack((Item)Core.registry.corkscrew);
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        IDataSerializable ret = super.serialize(prefix, data);
        this.target_speed = (byte)2;
        this.isSucking = false;
        return ret;
    }

    private class TankPumper
    implements PumpAction {
        private TankPumper() {
        }

        @Override
        public void suckIn() {
            if (PumpLiquids.this.buffer.getFluidAmount() >= 1000) {
                return;
            }
            Coord at = new Coord(PumpLiquids.this);
            at.adjust(PumpLiquids.this.sourceDirection);
            IFluidHandler te = at.getTE(IFluidHandler.class);
            if (te == null) {
                return;
            }
            FluidStack rep = null;
            if (PumpLiquids.this.buffer.getFluidAmount() > 0) {
                rep = PumpLiquids.this.buffer.getFluid().copy();
                rep.amount = Math.min(50, 1000 - PumpLiquids.this.buffer.getFluidAmount());
                PumpLiquids.this.buffer.fill(te.drain(PumpLiquids.this.destinationDirection, rep, true), true);
            } else {
                FluidTankInfo[] tanks = te.getTankInfo(PumpLiquids.this.destinationDirection);
                if (tanks == null || tanks.length == 0) {
                    return;
                }
                for (FluidTankInfo tank : tanks) {
                    FluidStack fs;
                    if (tank.fluid == null || (fs = te.drain(PumpLiquids.this.destinationDirection, 1000, true)) == null) continue;
                    PumpLiquids.this.buffer.setFluid(fs);
                    break;
                }
            }
        }

        @Override
        public void pumpOut() {
            if (PumpLiquids.this.buffer.getFluidAmount() <= 0) {
                return;
            }
            Coord at = new Coord(PumpLiquids.this);
            at.adjust(PumpLiquids.this.destinationDirection);
            IFluidHandler te = at.getTE(IFluidHandler.class);
            if (te == null) {
                return;
            }
            FluidStack offering = PumpLiquids.this.buffer.getFluid().copy();
            offering.amount = Math.min(10, offering.amount);
            int usage = te.fill(PumpLiquids.this.sourceDirection, offering, true);
            PumpLiquids.this.buffer.drain(usage, true);
        }

        @Override
        public FluidStack drainBlock(PumpCoord probe, boolean doDrain) {
            return null;
        }
    }

    private class Flooder
    extends Drainer {
        private Coord at;

        Flooder(Coord start, Fluid targetFluid) {
            super(start, targetFluid);
            this.at = new Coord(PumpLiquids.this.field_145850_b, 0, 0, 0);
        }

        @Override
        Comparator<PumpCoord> getComparator() {
            return new Comparator<PumpCoord>(){

                @Override
                public int compare(PumpCoord a, PumpCoord b) {
                    if (a.y == b.y) {
                        if (a.pathDistance == b.pathDistance) {
                            return 0;
                        }
                        if (a.pathDistance > b.pathDistance) {
                            return 1;
                        }
                        return -1;
                    }
                    if (a.y > b.y) {
                        return 1;
                    }
                    return -1;
                }
            };
        }

        @Override
        void reset() {
            super.reset();
            this.queue.add(this.frontier.peek());
        }

        @Override
        protected void found(boolean replaceable, boolean is_liquid, PumpCoord at) {
            if (replaceable && !is_liquid) {
                this.queue.add(at);
            } else if (is_liquid) {
                this.frontier.add(at);
            }
        }

        @Override
        public void suckIn() {
        }

        @Override
        public void pumpOut() {
            if (PumpLiquids.this.isSucking) {
                return;
            }
            if (!this.foundContainers.isEmpty()) {
                FoundFluidHandler foundIfh = (FoundFluidHandler)this.foundContainers.poll();
                FluidStack work = PumpLiquids.this.buffer.getFluid().copy();
                if (work.amount > 10) {
                    work.amount = 10;
                }
                int amount = foundIfh.te.fill(foundIfh.dir, work, true);
                PumpLiquids.this.buffer.drain(amount, true);
                if (PumpLiquids.this.buffer.getFluidAmount() <= 0) {
                    this.reset();
                } else {
                    if (amount > 0) {
                        this.foundContainers.add(foundIfh);
                    }
                    this.delay = 0;
                }
                return;
            }
            if (PumpLiquids.this.buffer.getFluidAmount() < 1000) {
                return;
            }
            FluidStack fs = PumpLiquids.this.buffer.getFluid();
            if (fs == null) {
                return;
            }
            Fluid fluid = fs.getFluid();
            if (!fluid.canBePlacedInWorld()) {
                PumpLiquids.this.destinationAction = new TankPumper();
                return;
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.delay = 20;
            if (this.updateFrontier()) {
                return;
            }
            for (int i = 0; i < 16; ++i) {
                PumpCoord pc = (PumpCoord)this.queue.poll();
                if (pc == null || !pc.verifyConnection(this, PumpLiquids.this.field_145850_b)) {
                    this.reset();
                    return;
                }
                if (!this.placeFluid(pc, fluid)) continue;
                this.frontier.add(pc);
                break;
            }
        }

        boolean placeFluid(PumpCoord pc, Fluid fluid) {
            this.at.w = PumpLiquids.this.field_145850_b;
            this.at.x = pc.x;
            this.at.y = pc.y;
            this.at.z = pc.z;
            if (!this.at.isReplacable()) {
                return false;
            }
            Block block = fluid.getBlock();
            if (block == null) {
                return false;
            }
            if (this.drainBlock(pc, false) != null) {
                return false;
            }
            if (block == Blocks.field_150355_j) {
                block = Blocks.field_150358_i;
            } else if (block == Blocks.field_150353_l) {
                block = Blocks.field_150356_k;
            }
            if (block == Blocks.field_150358_i) {
                ((ItemBucket)Items.field_151131_as).func_77875_a(this.at.w, this.at.x, this.at.y, this.at.z);
            } else {
                this.at.setIdMd(block, block instanceof BlockFluidFinite ? 15 : 0, true);
            }
            PumpLiquids.this.buffer.setFluid(null);
            this.at.notifyBlockChange();
            return true;
        }

        @Override
        int getMaxHeight() {
            return PumpLiquids.this.field_145848_d + 1 + 3 * PumpLiquids.this.target_speed;
        }
    }

    private class Drainer
    implements PumpAction {
        final ArrayDeque<PumpCoord> frontier = new ArrayDeque();
        final HashSet<PumpCoord> visited = new HashSet();
        final PriorityQueue<PumpCoord> queue = new PriorityQueue<PumpCoord>(128, this.getComparator());
        final ArrayDeque<FoundFluidHandler> foundContainers = new ArrayDeque();
        final Coord start;
        final Fluid targetFluid;
        int delay;

        Comparator<PumpCoord> getComparator() {
            return new Comparator<PumpCoord>(){

                @Override
                public int compare(PumpCoord a, PumpCoord b) {
                    if (a.y == b.y) {
                        return b.pathDistance - a.pathDistance;
                    }
                    return b.y - a.y;
                }
            };
        }

        Drainer(Coord start, Fluid targetFluid) {
            this.start = start;
            this.targetFluid = targetFluid;
            this.reset();
        }

        void reset() {
            this.visited.clear();
            this.queue.clear();
            this.frontier.clear();
            PumpCoord seed = new PumpCoord(this.start, null, 0);
            this.frontier.add(seed);
            this.visited.add(seed);
            this.queue.add(seed);
            this.delay = 60;
            this.foundContainers.clear();
        }

        @Override
        public FluidStack drainBlock(PumpCoord probe, boolean doDrain) {
            return FzUtil.drainSpecificBlockFluid(PumpLiquids.this.field_145850_b, probe.x, probe.y, probe.z, doDrain, this.targetFluid);
        }

        FluidStack probeAbove(PumpCoord probe) {
            return FzUtil.drainSpecificBlockFluid(PumpLiquids.this.field_145850_b, probe.x, probe.y + 1, probe.z, false, this.targetFluid);
        }

        boolean updateFrontier() {
            if (this.visited.size() > 884736) {
                return false;
            }
            if (this.frontier.isEmpty()) {
                return false;
            }
            Coord probe = new Coord(PumpLiquids.this.field_145850_b, 0, 0, 0);
            int maxHeight = this.getMaxHeight();
            int maxDistance = this.getMaxDistance();
            for (int amount = Math.max(this.frontier.size(), 1024); amount > 0; --amount) {
                boolean orig_is_liquid;
                PumpCoord pc = this.frontier.poll();
                if (pc == null) {
                    return true;
                }
                if (pc.y >= maxHeight || pc.pathDistance >= maxDistance) continue;
                boolean bl = orig_is_liquid = this.drainBlock(pc, false) != null;
                if (!orig_is_liquid) continue;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (!PumpLiquids.this.isSucking && pc.y + dir.offsetY >= maxHeight) continue;
                    PumpCoord at = new PumpCoord(pc, dir);
                    probe.set(PumpLiquids.this.field_145850_b, at.x, at.y, at.z);
                    if (this.visited.contains(at) || !probe.blockExists()) continue;
                    boolean is_liquid = this.drainBlock(at, false) != null;
                    boolean replaceable = probe.isReplacable();
                    if (!is_liquid && !replaceable) {
                        IFluidHandler ifh = probe.getTE(IFluidHandler.class);
                        if (ifh == null || ifh == PumpLiquids.this) continue;
                        this.foundContainers.add(new FoundFluidHandler(ifh, dir));
                        continue;
                    }
                    if (!is_liquid && replaceable && PumpLiquids.this.isLiquid(probe)) continue;
                    this.visited.add(at);
                    this.found(replaceable, is_liquid, at);
                }
            }
            return true;
        }

        protected void found(boolean replaceable, boolean is_liquid, PumpCoord at) {
            if (is_liquid) {
                this.queue.add(at);
                this.frontier.add(at);
            }
        }

        @Override
        public void suckIn() {
            if (PumpLiquids.this.isSucking) {
                return;
            }
            if (PumpLiquids.this.buffer.getFluidAmount() > 0) {
                return;
            }
            if (this.updateFrontier()) {
                return;
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.delay = 20;
            PumpCoord pc = this.queue.poll();
            if (pc == null) {
                FoundFluidHandler foundIfh = this.foundContainers.poll();
                if (foundIfh == null) {
                    this.reset();
                    return;
                }
                FluidStack resource = new FluidStack(this.targetFluid, PumpLiquids.this.buffer.getCapacity() - PumpLiquids.this.buffer.getFluidAmount());
                FluidStack gotten = foundIfh.te.drain(foundIfh.dir, resource, true);
                PumpLiquids.this.buffer.fill(gotten, true);
                return;
            }
            if (!pc.verifyConnection(this, PumpLiquids.this.field_145850_b)) {
                this.reset();
                return;
            }
            if (this.probeAbove(pc) != null) {
                this.reset();
            } else {
                PumpLiquids.this.buffer.setFluid(this.drainBlock(pc, true));
            }
        }

        @Override
        public void pumpOut() {
        }

        int getMaxHeight() {
            return PumpLiquids.this.field_145850_b.func_72800_K();
        }

        int getMaxDistance() {
            return 64 * PumpLiquids.this.target_speed;
        }
    }

    static final class FoundFluidHandler {
        final IFluidHandler te;
        final ForgeDirection dir;

        public FoundFluidHandler(IFluidHandler te, ForgeDirection dir) {
            this.te = te;
            this.dir = dir;
        }
    }

    static final class PumpCoord {
        final int x;
        final int y;
        final int z;
        final short pathDistance;
        final PumpCoord parent;

        PumpCoord(Coord at, PumpCoord parent, int pathDistance) {
            this.x = at.x;
            this.y = at.y;
            this.z = at.z;
            this.pathDistance = (short)pathDistance;
            this.parent = parent;
        }

        PumpCoord(PumpCoord parent, ForgeDirection d) {
            this.x = parent.x + d.offsetX;
            this.y = parent.y + d.offsetY;
            this.z = parent.z + d.offsetZ;
            this.pathDistance = (short)(parent.pathDistance + 1);
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            PumpCoord o = (PumpCoord)obj;
            return o.x == this.x && o.y == this.y && o.z == this.z;
        }

        public int hashCode() {
            return (this.x * 11 % 71 << 7) + this.z * 7 % 479 + this.y;
        }

        boolean verifyConnection(PumpAction pump, World w) {
            PumpCoord here = this.parent;
            while (here != null) {
                if (pump.drainBlock(here, false) == null) {
                    return false;
                }
                here = here.parent;
            }
            return true;
        }
    }

    private static interface PumpAction {
        public void suckIn();

        public FluidStack drainBlock(PumpCoord var1, boolean var2);

        public void pumpOut();
    }
}

