/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.ConductorSet;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Charge
implements IDataSerializable {
    ConductorSet conductorSet = null;
    IChargeConductor conductor = null;
    boolean isConductorSetLeader = false;
    boolean justCreated = true;

    public Charge(IChargeConductor conductor) {
        this.conductor = conductor;
    }

    public int getValue() {
        if (this.conductorSet == null || this.conductorSet.memberCount == 0) {
            return 0;
        }
        int chargeShare = this.conductorSet.totalCharge / this.conductorSet.memberCount;
        if (this.isConductorSetLeader) {
            chargeShare += this.conductorSet.totalCharge % this.conductorSet.memberCount;
        }
        return chargeShare;
    }

    public void setValue(int newCharge) {
        this.createOrJoinConductorSet();
        this.conductorSet.totalCharge += newCharge - this.getValue();
    }

    public int addValue(int chargeToAdd) {
        this.createOrJoinConductorSet();
        return this.conductorSet.totalCharge += chargeToAdd;
    }

    public int deplete() {
        int ret = this.getValue();
        this.setValue(0);
        return ret;
    }

    public int deplete(int toTake) {
        int c = this.getValue();
        toTake = Math.min(toTake, c);
        this.setValue(c - toTake);
        return toTake;
    }

    public int tryTake(int toTake) {
        int c = this.getValue();
        if (c < toTake) {
            return 0;
        }
        this.setValue(c - toTake);
        return toTake;
    }

    public void writeToNBT(NBTTagCompound tag, String name2) {
        tag.func_74768_a(name2, this.getValue());
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, "charge");
    }

    public void readFromNBT(NBTTagCompound tag, String name2) {
        int val = tag.func_74762_e(name2);
        this.setValue(val < 0 ? 0 : val);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.readFromNBT(tag, "charge");
    }

    void createOrJoinConductorSet() {
        if (this.conductorSet != null) {
            return;
        }
        Coord here = this.conductor.getCoord();
        if (here.w == null) {
            ConductorSet assignedConductorSet = new ConductorSet(this.conductor);
            return;
        }
        ArrayList<Coord> neighbors = here.getNeighborsAdjacent();
        for (Coord n : neighbors) {
            IChargeConductor neighbor = n.getTE(IChargeConductor.class);
            if (neighbor == null) continue;
            Charge neighbor_charge = neighbor.getCharge();
            if (neighbor_charge.conductorSet == null || !neighbor_charge.conductorSet.addConductor(this.conductor)) continue;
            for (Coord coord_otherNeighbor : neighbors) {
                IChargeConductor otherNeighbor = coord_otherNeighbor.getTE(IChargeConductor.class);
                if (otherNeighbor == null) continue;
                this.conductorSet.addNeighbor(otherNeighbor.getCharge().conductorSet);
            }
            return;
        }
        ConductorSet assignedConductorSet = new ConductorSet(this.conductor);
    }

    public void update() {
        TileEntity te = (TileEntity)this.conductor;
        World w = te.func_145831_w();
        if (w.field_72995_K) {
            return;
        }
        this.createOrJoinConductorSet();
        if (this.isConductorSetLeader) {
            this.conductorSet.update();
        }
        int seed = (te.field_145851_c << 4 + te.field_145849_e << 8) + te.field_145848_d;
        if (this.justCreated || (w.func_82737_E() + (long)seed) % 600L == 0L) {
            this.justCreated = false;
            if (this.conductorSet.leader == null) {
                this.conductorSet.leader = this.conductor;
            }
            Coord here = this.conductor.getCoord();
            for (IChargeConductor neighbor : here.getAdjacentTEs(IChargeConductor.class)) {
                this.justCreated |= this.conductorSet.addNeighbor(neighbor.getCharge().conductorSet);
            }
        }
    }

    public void remove() {
        if (this.conductorSet == null) {
            return;
        }
        int memberCount = this.conductorSet.memberCount;
        if (memberCount <= 1) {
            return;
        }
        for (IChargeConductor hereConductor : this.conductorSet.getMembers(this.conductor)) {
            int val;
            if (hereConductor == this.conductor) continue;
            Charge hereCharge = hereConductor.getCharge();
            new ConductorSet((IChargeConductor)hereConductor).totalCharge = val = hereCharge.getValue();
            --this.conductorSet.memberCount;
            this.conductorSet.totalCharge -= val;
        }
        this.conductorSet = null;
    }

    public static ChargeDensityReading getChargeDensity(IChargeConductor start) {
        ConductorSet cs = start.getCharge().conductorSet;
        if (cs == null) {
            return new ChargeDensityReading();
        }
        ChargeDensityReading ret = new ChargeDensityReading();
        ret.totalCharge = cs.totalCharge;
        ret.conductorCount = cs.memberCount;
        return ret;
    }

    public void invalidate() {
        if (this.conductorSet == null) {
            return;
        }
        this.remove();
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        int new_val = data.as(Share.PRIVATE, prefix + "charge").put(this.getValue());
        if (data.isReader()) {
            this.setValue(new_val);
        }
        return this;
    }

    public static class ChargeDensityReading {
        public int totalCharge;
        public int conductorCount;
    }
}

