/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

class ConductorSet
implements Comparable {
    int totalCharge = 0;
    int memberCount = 0;
    static final int maxMemberCount = 24;
    IChargeConductor leader = null;
    TreeSet<ConductorSet> neighbors = null;
    Iterator<ConductorSet> neighborIterator = null;
    private static ArrayList<IChargeConductor> frontier = new ArrayList(100);
    private static HashSet<IChargeConductor> visited = new HashSet(125);

    ConductorSet(IChargeConductor leader) {
        this.leader = leader;
        this.memberCount = 1;
        Charge lc = leader.getCharge();
        lc.conductorSet = this;
        lc.isConductorSetLeader = true;
        lc.justCreated = true;
    }

    boolean addConductor(IChargeConductor other) {
        other.getCharge().conductorSet = this;
        ++this.memberCount;
        return true;
    }

    void update() {
        int hisNewCharge;
        if (this.neighbors == null || this.neighbors.size() == 0) {
            this.neighbors = null;
            return;
        }
        if (this.neighborIterator == null || !this.neighborIterator.hasNext()) {
            this.neighborIterator = this.neighbors.iterator();
        }
        ConductorSet luckyNeighbor = this.neighborIterator.next();
        if (luckyNeighbor.memberCount <= 0) {
            this.neighborIterator.remove();
            return;
        }
        if (luckyNeighbor.memberCount + this.memberCount < 24 && luckyNeighbor.memberCount <= this.memberCount) {
            Iterable<IChargeConductor> noms = luckyNeighbor.getMembers(luckyNeighbor.leader);
            this.totalCharge += luckyNeighbor.totalCharge;
            for (IChargeConductor nom : noms) {
                this.addConductor(nom);
            }
            luckyNeighbor.totalCharge = 0;
            luckyNeighbor.memberCount = 0;
            luckyNeighbor.leader = null;
            this.neighborIterator.remove();
            return;
        }
        int ourCharge = this.totalCharge + luckyNeighbor.totalCharge;
        int ourMemberCount = this.memberCount + luckyNeighbor.memberCount;
        luckyNeighbor.totalCharge = hisNewCharge = ourCharge * luckyNeighbor.memberCount / ourMemberCount;
        this.totalCharge = ourCharge - hisNewCharge;
    }

    boolean addNeighbor(ConductorSet neighbor) {
        if (neighbor == this || neighbor == null) {
            return false;
        }
        if (this.neighbors == null) {
            this.neighbors = new TreeSet();
        }
        if (this.neighbors.add(neighbor)) {
            this.neighborIterator = null;
            neighbor.addNeighbor(this);
            return true;
        }
        return false;
    }

    Iterable<IChargeConductor> getMembers(IChargeConductor seed) {
        if (seed == null) {
            return new ArrayList<IChargeConductor>(0);
        }
        frontier.clear();
        visited.clear();
        frontier.add(seed);
        visited.add(seed);
        ArrayList<IChargeConductor> ret = new ArrayList<IChargeConductor>(this.memberCount);
        while (frontier.size() > 0) {
            IChargeConductor here = frontier.remove(0);
            Coord hereCoord = here.getCoord();
            Charge hereCharge = here.getCharge();
            if (hereCharge.conductorSet != this) continue;
            ret.add(here);
            for (IChargeConductor neighbor : hereCoord.getAdjacentTEs(IChargeConductor.class)) {
                if (!visited.add(neighbor)) continue;
                frontier.add(neighbor);
            }
        }
        return ret;
    }

    public int compareTo(Object arg0) {
        return this.hashCode() - arg0.hashCode();
    }
}

