/*
 * Decompiled with CFR 0.152.
 */
package factorization.ceramics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.ceramics.TileEntityGreenware;
import factorization.common.BlockIcons;
import factorization.notify.Notice;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ItemFactorization;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemGlazeBucket
extends ItemFactorization {
    public static final int MAX_CHARGES = 64;
    private ArrayList<ItemStack> subItems = new ArrayList();
    private boolean done;
    int md_for_nei = 0;

    public ItemGlazeBucket() {
        super("ceramics/glaze_bucket", Core.TabType.ART);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
        Core.tab(this, Core.TabType.ART);
    }

    public IIcon getIcon(ItemStack is, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (renderPass == 0) {
            return this.func_77617_a(0);
        }
        Block block = this.getBlockId(is);
        if (block == null) {
            return BlockIcons.uv_test;
        }
        return block.func_149691_a((int)this.getBlockSide(is), (int)this.getBlockMd(is));
    }

    public String func_77667_c(ItemStack is) {
        String base = super.func_77667_c(is);
        NBTTagCompound tag = FzUtil.getTag(is);
        if (tag.func_74764_b("gid")) {
            String key = tag.func_74779_i("gid");
            return base + "." + key;
        }
        return base;
    }

    public String func_77653_i(ItemStack is) {
        ItemStack hint;
        String base = super.func_77653_i(is);
        if (this.isMimic(is) && (hint = this.getSource(is)) != null && hint.func_77973_b() != null) {
            return Core.translate(this.func_77658_a() + ".mimicry_prefix") + " " + hint.func_82833_r();
        }
        return base;
    }

    public float getFullness(ItemStack is) {
        int c = this.getCharges(is);
        if (c >= 32) {
            return 1.0f;
        }
        if (c <= 0) {
            return 0.0f;
        }
        return (float)c / 64.0f;
    }

    public int getCharges(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        return tag.func_74762_e("remaining");
    }

    public boolean useCharge(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        int remaining = tag.func_74762_e("remaining");
        if (remaining <= 0) {
            return false;
        }
        tag.func_74768_a("remaining", --remaining);
        return remaining > 0;
    }

    private Block getBlockId(ItemStack is) {
        return FzUtil.getBlock(FzUtil.getTag(is).func_74765_d("bid"));
    }

    private byte getBlockMd(ItemStack is) {
        return FzUtil.getTag(is).func_74771_c("bmd");
    }

    private byte getBlockSide(ItemStack is) {
        return FzUtil.getTag(is).func_74771_c("bsd");
    }

    private boolean isMimic(ItemStack is) {
        return FzUtil.getTag(is).func_74767_n("mimic");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemId, CreativeTabs tab, List list) {
        list.addAll(this.subItems);
    }

    public void doneMakingStandardGlazes() {
        this.done = true;
    }

    public void notDoneMakingStandardGlazes() {
        this.done = false;
    }

    public void addGlaze(ItemStack is) {
        if (this.subItems.isEmpty()) {
            this.subItems.add(Core.registry.empty_glaze_bucket.func_77946_l());
        }
        if (!this.done) {
            this.subItems.add(is);
        }
    }

    void setGid(ItemStack is, String unique_id) {
        FzUtil.getTag(is).func_74778_a("gid", unique_id);
    }

    public ItemStack makeCraftingGlaze(String unique_id) {
        ItemStack is = new ItemStack((Item)this);
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74757_a("fake", true);
        this.setGid(is, unique_id);
        is.func_77964_b(this.md_for_nei++);
        return is;
    }

    private ItemStack makeGlazeWith(Block id, int md, int side) {
        ItemStack is = new ItemStack((Item)this);
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74777_a("bid", (short)FzUtil.getId(id));
        tag.func_74774_a("bmd", (byte)md);
        tag.func_74774_a("bsd", (byte)side);
        tag.func_74768_a("remaining", 64);
        this.addGlaze(is);
        return is;
    }

    public ItemStack makeMimicingGlaze(Block id, int md, int side) {
        ItemStack is = this.makeGlazeWith(id, md, side);
        this.setMimicry(is);
        return is;
    }

    public void setMimicry(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74757_a("mimic", true);
    }

    public boolean isUsable(ItemStack is) {
        if (FzUtil.getTag(is).func_74767_n("fake")) {
            return false;
        }
        return this.getBlockId(is) != null;
    }

    ItemStack getSource(ItemStack is) {
        Block b = this.getBlockId(is);
        if (b == null) {
            return null;
        }
        return new ItemStack(b, 1, (int)this.getBlockMd(is));
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer player) {
        if (w.field_72995_K) {
            return is;
        }
        MovingObjectPosition mop = this.func_77621_a(w, player, true);
        if (!this.isUsable(is)) {
            return is;
        }
        if (mop == null) {
            return is;
        }
        if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mop.subHit == -1) {
            return is;
        }
        TileEntityGreenware clay = new Coord(w, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).getTE(TileEntityGreenware.class);
        if (clay == null) {
            return is;
        }
        TileEntityGreenware.ClayState state = clay.getState();
        if (player.field_71075_bZ.field_75098_d) {
            if (state != TileEntityGreenware.ClayState.HIGHFIRED) {
                clay.totalHeat = TileEntityGreenware.highfireHeat + 1;
            }
        } else {
            switch (state) {
                case WET: 
                case DRY: {
                    new Notice(clay, "Use a {ITEM_NAME} to bisque", new String[0]).withItem(Core.registry.heater_item).send(player);
                    return is;
                }
                case HIGHFIRED: {
                    new Notice(clay, "Already high-fired", new String[0]).send(player);
                    return is;
                }
            }
        }
        TileEntityGreenware.ClayLump part = clay.parts.get(mop.subHit);
        Block id = this.getBlockId(is);
        byte md = this.getBlockMd(is);
        byte sd = this.getBlockSide(is);
        if (part.icon_id == id && part.icon_md == md && part.icon_side == sd) {
            return is;
        }
        if (this.getCharges(is) > 0) {
            part.icon_id = id;
            part.icon_md = md;
            part.icon_side = sd;
            clay.changeLump(mop.subHit, part);
            clay.glazesApplied = true;
            if (!player.field_71075_bZ.field_75098_d) {
                this.useCharge(is);
                if (this.getCharges(is) <= 0) {
                    return Core.registry.empty_glaze_bucket.func_77946_l();
                }
            }
        }
        return is;
    }
}

