/*
 * Decompiled with CFR 0.152.
 */
package factorization.ceramics;

import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.ceramics.ItemSculptingTool;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.ResourceType;
import factorization.notify.Notice;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.shared.TileEntityExtension;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityGreenware
extends TileEntityCommon {
    public static int MAX_PARTS = 32;
    ForgeDirection front = ForgeDirection.UNKNOWN;
    byte rotation = 0;
    Quaternion rotation_quat = Quaternion.getRotationQuaternionRadians(0.0, ForgeDirection.UP);
    public ArrayList<ClayLump> parts = new ArrayList();
    public int lastTouched = 0;
    public int totalHeat = 0;
    boolean glazesApplied = false;
    private boolean partsValidated = false;
    public static int dryTime = 2400;
    public static int bisqueHeat = 1000;
    public static int highfireHeat = bisqueHeat * 10;
    public boolean shouldRenderTesr = false;
    private ClayState lastState = null;
    Item woolItem = Item.func_150898_a((Block)Blocks.field_150325_L);
    private static final Vec3 zeroVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CERAMIC;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Ceramic;
    }

    public ClayState getState() {
        if (this.totalHeat > highfireHeat) {
            return ClayState.HIGHFIRED;
        }
        if (this.totalHeat > bisqueHeat) {
            if (this.glazesApplied) {
                return ClayState.UNFIRED_GLAZED;
            }
            return ClayState.BISQUED;
        }
        if (this.lastTouched > dryTime) {
            return ClayState.DRY;
        }
        return ClayState.WET;
    }

    public IIcon getIcon(ClayLump lump, int side) {
        switch (this.getState()) {
            case WET: {
                return Blocks.field_150435_aG.func_149733_h(side);
            }
            case DRY: {
                return BlockIcons.ceramics$dry;
            }
            case BISQUED: 
            case UNFIRED_GLAZED: {
                return BlockIcons.error;
            }
            case HIGHFIRED: {
                Item it = FzUtil.getItem(lump.icon_id);
                if (it == null) {
                    return BlockIcons.error;
                }
                return it.func_77617_a((int)lump.icon_md);
            }
        }
        return BlockIcons.error;
    }

    public void touch() {
        if (this.getState() == ClayState.WET) {
            this.lastTouched = 0;
        }
    }

    public boolean renderEfficient() {
        return this.getState() != ClayState.WET;
    }

    public boolean canEdit() {
        return this.getState() == ClayState.WET;
    }

    void initialize() {
        this.parts = new ArrayList();
        this.parts.add(new ClayLump().asDefault());
        this.touch();
    }

    void writeParts(NBTTagCompound tag) {
        NBTTagList l = new NBTTagList();
        for (ClayLump lump : this.parts) {
            NBTTagCompound rc_tag = new NBTTagCompound();
            lump.write(rc_tag);
            l.func_74742_a((NBTBase)rc_tag);
        }
        tag.func_74782_a("parts", (NBTBase)l);
        tag.func_74768_a("touch", this.lastTouched);
        tag.func_74768_a("heat", this.totalHeat);
        tag.func_74757_a("glazed", this.glazesApplied);
        tag.func_74774_a("front", (byte)this.front.ordinal());
        tag.func_74774_a("rot", this.rotation);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeParts(tag);
        if (this.parts.size() == 0) {
            this.getCoord().setAir();
        }
    }

    public void loadParts(NBTTagCompound tag) {
        if (tag == null) {
            this.initialize();
            return;
        }
        NBTTagList partList = tag.func_150295_c("parts", 10);
        if (partList == null) {
            this.initialize();
            return;
        }
        int tagCount = partList.func_74745_c();
        this.parts = new ArrayList(tagCount);
        for (int i = 0; i < tagCount; ++i) {
            NBTTagCompound rc_tag = partList.func_150305_b(i);
            this.parts.add(new ClayLump().read(rc_tag));
        }
        this.lastTouched = tag.func_74762_e("touch");
        this.totalHeat = tag.func_74762_e("heat");
        this.glazesApplied = tag.func_74767_n("glazed");
        if (tag.func_74764_b("front")) {
            this.front = ForgeDirection.getOrientation((int)tag.func_74771_c("front"));
            this.setRotation(tag.func_74771_c("rot"));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.loadParts(tag);
    }

    public void setRotation(byte newRotation) {
        this.rotation = newRotation;
        this.rotation_quat = Quaternion.getRotationQuaternionRadians(Math.PI * (double)newRotation / 2.0, ForgeDirection.UP);
    }

    @Override
    public FMLProxyPacket getDescriptionPacket() {
        ArrayList<Object> args = new ArrayList<Object>(2 + this.parts.size() * 9);
        args.add((Object)NetworkFactorization.MessageType.SculptDescription);
        args.add(this.getState().ordinal());
        args.add((byte)this.front.ordinal());
        args.add(this.rotation);
        for (ClayLump lump : this.parts) {
            lump.write(args);
        }
        return this.getDescriptionPacketWith(args.toArray());
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        NBTTagCompound tag = is.func_77978_p();
        this.loadParts(tag);
        ForgeDirection placement = ForgeDirection.getOrientation((int)FzUtil.determineFlatOrientation(player));
        if (tag == null || !tag.func_74764_b("front")) {
            this.front = placement;
            this.setRotation((byte)0);
        } else if (placement.offsetY == 0 && placement != ForgeDirection.UNKNOWN) {
            this.front = ForgeDirection.getOrientation((int)tag.func_74771_c("front"));
            if (this.front == ForgeDirection.UNKNOWN || this.front.offsetY != 0) {
                this.setRotation((byte)0);
                this.front = placement;
            } else {
                ForgeDirection f = placement;
                int r = 0;
                for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                    if (f == this.front) {
                        r = i;
                        break;
                    }
                    f = f.getRotation(ForgeDirection.UP);
                }
                this.setRotation((byte)r);
            }
        }
    }

    public ItemStack getItem() {
        ItemStack ret = Core.registry.greenware_item.func_77946_l();
        NBTTagCompound tag = new NBTTagCompound();
        this.writeParts(tag);
        tag.func_74774_a("front", (byte)this.front.ordinal());
        ret.func_77982_d(tag);
        if (this.customName != null) {
            ret.func_151001_c(this.customName);
        }
        return ret;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.partsValidated) {
            this.partsValidated = true;
            Iterator<ClayLump> it = this.parts.iterator();
            while (it.hasNext()) {
                ClayLump lump = it.next();
                if (this.isValidLump(lump)) continue;
                if (this.parts.size() == 1) {
                    lump.asDefault();
                    continue;
                }
                it.remove();
                FzUtil.spawnItemStack(this.getCoord(), new ItemStack(Items.field_151119_aD));
            }
        }
        if (this.getState() == ClayState.WET) {
            if (!this.field_145850_b.func_72896_J()) {
                ++this.lastTouched;
            }
            if (this.totalHeat > 0) {
                --this.totalHeat;
                ++this.lastTouched;
            }
        }
        if (this.getState() != this.lastState) {
            this.lastState = this.getState();
            this.broadcastMessage(null, NetworkFactorization.MessageType.SculptState, this.lastState.ordinal());
        }
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        ItemStack held;
        ClayState state = this.getState();
        if (state == ClayState.WET) {
            this.touch();
        }
        if ((held = player.func_71045_bC()) == null) {
            return false;
        }
        Item heldId = held.func_77973_b();
        boolean creative = player.field_71075_bZ.field_75098_d;
        if (heldId == Items.field_151131_as && state == ClayState.DRY) {
            this.lastTouched = 0;
            if (creative) {
                return true;
            }
            int ci = player.field_71071_by.field_70461_c;
            player.field_71071_by.field_70462_a[ci] = new ItemStack(Items.field_151133_ar);
            return true;
        }
        if (heldId == this.woolItem) {
            this.lastTouched = dryTime + 1;
            return true;
        }
        if (held.func_77973_b() != Items.field_151119_aD || held.field_77994_a == 0) {
            return false;
        }
        if (state != ClayState.WET) {
            new Notice(this, "Not wet", new String[0]).send(player);
            return false;
        }
        if (!creative) {
            --held.field_77994_a;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.parts.size() >= MAX_PARTS) {
            new Notice(this, "Too complex", new String[0]).send(player);
            ++held.field_77994_a;
            return false;
        }
        ClayLump toAdd = this.addLump();
        MovingObjectPosition hit = ItemSculptingTool.doRayTrace(player);
        if (hit == null || hit.subHit == -1) {
            return true;
        }
        ClayLump against = this.parts.get(hit.subHit);
        ClayLump extrusion = this.extrudeLump(against, hit.field_72310_e);
        if (this.isValidLump(extrusion)) {
            this.changeLump(this.parts.size() - 1, extrusion);
        }
        return true;
    }

    ClayLump addLump() {
        ClayLump ret = new ClayLump().asDefault();
        this.parts.add(ret);
        if (!this.field_145850_b.field_72995_K) {
            this.broadcastMessage(null, NetworkFactorization.MessageType.SculptNew, new Object[0]);
            this.touch();
        }
        return ret;
    }

    void removeLump(int id) {
        if (id < 0 || id >= this.parts.size()) {
            return;
        }
        this.parts.remove(id);
        if (!this.field_145850_b.field_72995_K) {
            this.broadcastMessage(null, NetworkFactorization.MessageType.SculptRemove, id);
            this.touch();
        }
    }

    ClayLump extrudeLump(ClayLump against, int side) {
        ClayLump lump = against.copy();
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        BlockRenderHelper b = Core.registry.serverTraceHelper;
        against.toBlockBounds(b);
        int wX = lump.maxX - lump.minX;
        int wY = lump.maxY - lump.minY;
        int wZ = lump.maxZ - lump.minZ;
        lump.maxX = (byte)(lump.maxX + wX * dir.offsetX);
        lump.maxY = (byte)(lump.maxY + wY * dir.offsetY);
        lump.maxZ = (byte)(lump.maxZ + wZ * dir.offsetZ);
        lump.minX = (byte)(lump.minX + wX * dir.offsetX);
        lump.minY = (byte)(lump.minY + wY * dir.offsetY);
        lump.minZ = (byte)(lump.minZ + wZ * dir.offsetZ);
        return lump;
    }

    public boolean isValidLump(ClayLump lump) {
        if (!Core.cheat) {
            int wX = lump.maxX - lump.minX;
            int wY = lump.maxY - lump.minY;
            int wZ = lump.maxZ - lump.minZ;
            int area = wX * wY * wZ;
            int max_area = 4096;
            if (!FzConfig.stretchy_clay) {
                max_area /= 4;
            }
            if (area <= 0 || area > max_area) {
                return false;
            }
        }
        int B = 48;
        if (lump.minX < 0) {
            return false;
        }
        if (lump.minY < 0) {
            return false;
        }
        if (lump.minZ < 0) {
            return false;
        }
        if (lump.maxX > 48) {
            return false;
        }
        if (lump.maxY > 48) {
            return false;
        }
        if (lump.maxZ > 48) {
            return false;
        }
        BlockRenderHelper block = Core.registry.serverTraceHelper;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    TileEntityExtension tex;
                    AxisAlignedBB ab = AxisAlignedBB.func_72330_a((double)(this.field_145851_c + dx), (double)(this.field_145848_d + dy), (double)(this.field_145849_e + dz), (double)(this.field_145851_c + dx + 1), (double)(this.field_145848_d + dy + 1), (double)(this.field_145849_e + dz + 1));
                    Coord c = this.getCoord();
                    c.x += dx;
                    c.y += dy;
                    c.z += dz;
                    lump.toRotatedBlockBounds(this, block);
                    AxisAlignedBB in = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (!ab.func_72326_a(in)) continue;
                    if (c.isAir() || c.isReplacable()) {
                        c.setId((Block)Core.registry.factory_block);
                        TileEntityExtension tex2 = new TileEntityExtension(this);
                        c.setTE(tex2);
                        tex2.getBlockClass().enforce(c);
                        continue;
                    }
                    TileEntity te = c.getTE();
                    if (te == this || te instanceof TileEntityExtension && (tex = (TileEntityExtension)te).getParent() == this) continue;
                    new Notice(c, "!", new String[0]).sendToAll();
                }
            }
        }
        return true;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Coord c = this.getCoord().add(x, y, z);
                    TileEntityExtension tex = c.getTE(TileEntityExtension.class);
                    if (tex == null || tex.getParent() != this) continue;
                    c.setAir();
                }
            }
        }
    }

    private void updateLump(int id, ClayLump lump) {
        if (id < 0 || id >= this.parts.size()) {
            return;
        }
        ClayLump old = this.parts.get(id);
        if (old.equals(lump)) {
            return;
        }
        this.parts.set(id, lump);
        this.touch();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
    }

    private void shareLump(int id, ClayLump selection) {
        ArrayList<Object> toSend = new ArrayList<Object>();
        toSend.add(id);
        selection.write(toSend);
        this.broadcastMessage(null, NetworkFactorization.MessageType.SculptMove, toSend.toArray());
    }

    void changeLump(int id, ClayLump newValue) {
        this.updateLump(id, newValue);
        this.shareLump(id, newValue);
    }

    private float getFloat(DataInput input) throws IOException {
        int r = (int)(input.readFloat() * 2.0f);
        return (float)r / 2.0f;
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case SculptDescription: {
                this.readStateChange(input);
                this.front = ForgeDirection.getOrientation((int)input.readByte());
                this.setRotation(input.readByte());
                this.parts.clear();
                ArrayList args = new ArrayList();
                try {
                    while (true) {
                        this.parts.add(new ClayLump().read(input));
                    }
                }
                catch (IOException e) {
                    this.shouldRenderTesr = this.getState() == ClayState.WET;
                    break;
                }
            }
            case SculptMove: {
                this.updateLump(input.readInt(), new ClayLump().read(input));
                break;
            }
            case SculptNew: {
                this.addLump();
                break;
            }
            case SculptRemove: {
                this.removeLump(input.readInt());
                break;
            }
            case SculptState: {
                this.readStateChange(input);
                break;
            }
            default: {
                return false;
            }
        }
        if (this.renderEfficient()) {
            this.getCoord().redraw();
        }
        return true;
    }

    private void readStateChange(DataInput input) throws IOException {
        switch (ClayState.values()[input.readInt()]) {
            case WET: {
                this.lastTouched = 0;
                break;
            }
            case DRY: {
                this.lastTouched = dryTime + 10;
                break;
            }
            case BISQUED: {
                this.totalHeat = bisqueHeat + 1;
                break;
            }
            case UNFIRED_GLAZED: {
                this.totalHeat = bisqueHeat + 2;
                this.glazesApplied = true;
                break;
            }
            case HIGHFIRED: {
                this.totalHeat = highfireHeat + 1;
            }
        }
        this.getCoord().redraw();
    }

    @Override
    protected boolean removedByPlayer(EntityPlayer player) {
        boolean shouldDestroy;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        MovingObjectPosition hit = ItemSculptingTool.doRayTrace(player);
        if (hit == null || hit.subHit == -1 || this.parts.size() < 1) {
            return super.removedByPlayer(player);
        }
        Coord here = this.getCoord();
        ClayState state = this.getState();
        boolean bl = shouldDestroy = player.func_70093_af() || this.parts.size() == 1;
        if (player.field_71075_bZ.field_75098_d) {
            if (shouldDestroy) {
                return super.removedByPlayer(player);
            }
            this.removeLump(hit.subHit);
            return true;
        }
        if (shouldDestroy |= state != ClayState.WET) {
            FzUtil.spawnItemStack(here, this.getItem());
            here.setAir();
        } else {
            this.removeLump(hit.subHit);
            FzUtil.spawnItemStack(here, new ItemStack(Items.field_151119_aD));
        }
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        BlockRenderHelper block = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        double dx = startVec.field_72450_a - endVec.field_72450_a;
        double dy = startVec.field_72448_b - endVec.field_72448_b;
        double dz = startVec.field_72449_c - endVec.field_72449_c;
        double scale = 5.2;
        startVec.field_72450_a += dx * scale;
        startVec.field_72448_b += dy * scale;
        startVec.field_72449_c += dz * scale;
        MovingObjectPosition shortest = null;
        for (int i = 0; i < this.parts.size(); ++i) {
            ClayLump lump = this.parts.get(i);
            lump.toRotatedBlockBounds(this, block);
            MovingObjectPosition mop = block.func_149731_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
            if (mop == null) continue;
            mop.subHit = i;
            if (shortest == null) {
                shortest = mop;
                continue;
            }
            Vec3 s = shortest.field_72307_f;
            Vec3 m = mop.field_72307_f;
            s = Vec3.func_72443_a((double)s.field_72450_a, (double)s.field_72448_b, (double)s.field_72449_c);
            m = Vec3.func_72443_a((double)m.field_72450_a, (double)m.field_72448_b, (double)m.field_72449_c);
            this.offsetVector(startVec, s);
            this.offsetVector(startVec, m);
            if (!(m.func_72433_c() < s.func_72433_c())) continue;
            shortest = mop;
        }
        return shortest;
    }

    private void offsetVector(Vec3 player, Vec3 v) {
        v.field_72450_a -= player.field_72450_a;
        v.field_72448_b -= player.field_72448_b;
        v.field_72449_c -= player.field_72449_c;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderCeramicsSelection(DrawBlockHighlightEvent event) {
        if (event.target.subHit == -1) {
            return;
        }
        Coord c = new Coord(event.player.field_70170_p, event.target);
        TileEntityGreenware clay = c.getTE(TileEntityGreenware.class);
        if (clay == null) {
            return;
        }
        event.setCanceled(true);
        EntityPlayer player = event.player;
        double partial = event.partialTicks;
        ClayLump lump = clay.parts.get(event.target.subHit);
        BlockRenderHelper block = Core.registry.clientTraceHelper;
        lump.toRotatedBlockBounds(clay, block);
        double widen = 0.002;
        double oX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partial;
        double oY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partial;
        double oZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partial;
        AxisAlignedBB bb = block.func_149633_g(c.w, c.x, c.y, c.z).func_72314_b(widen, widen, widen).func_72325_c(-oX, -oY, -oZ);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        float r = 255.0f;
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        TileEntityGreenware.drawOutlinedBoundingBox(bb);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static void drawOutlinedBoundingBox(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78381_a();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        return bb;
    }

    @Override
    public void setBlockBounds(Block b) {
        super.setBlockBounds(b);
    }

    @Override
    public boolean addCollisionBoxesToList(Block ignore, AxisAlignedBB aabb, List list, Entity entity) {
        boolean remote = entity != null && entity.field_70170_p != null ? entity.field_70170_p.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        BlockRenderHelper block = remote ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        ClayState state = this.getState();
        if (state == ClayState.WET) {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            AxisAlignedBB a = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        for (ClayLump lump : this.parts) {
            lump.toRotatedBlockBounds(this, block);
            AxisAlignedBB a = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!aabb.func_72326_a(a)) continue;
            list.add(a);
        }
        return true;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        if (this.parts.size() == 0) {
            return Blocks.field_150435_aG.func_149733_h(0);
        }
        return this.getIcon(this.parts.get(0), dir.ordinal());
    }

    @Override
    public ItemStack getDroppedBlock() {
        return this.getItem();
    }

    public static enum ClayState {
        WET("Wet Clay"),
        DRY("Bone-Dry Greenware"),
        BISQUED("Bisqued"),
        UNFIRED_GLAZED("Glazed Bisqueware"),
        HIGHFIRED("Highfire Glazed");

        public String english;

        private ClayState(String en) {
            this.english = en;
        }
    }

    public static class ClayLump {
        public byte minX;
        public byte minY;
        public byte minZ;
        public byte maxX;
        public byte maxY;
        public byte maxZ;
        public Block icon_id;
        public byte icon_md;
        public byte icon_side;
        public Quaternion quat;
        public int raw_color = -1;

        void write(ByteArrayDataOutput out) {
            out.writeByte((int)this.minX);
            out.writeByte((int)this.minY);
            out.writeByte((int)this.minZ);
            out.writeByte((int)this.maxX);
            out.writeByte((int)this.maxY);
            out.writeByte((int)this.maxZ);
            out.writeShort(Block.func_149682_b((Block)this.icon_id));
            out.writeByte((int)this.icon_md);
            out.writeByte((int)this.icon_side);
            this.quat.write(out);
        }

        void write(NBTTagCompound tag) {
            tag.func_74774_a("lx", this.minX);
            tag.func_74774_a("ly", this.minY);
            tag.func_74774_a("lz", this.minZ);
            tag.func_74774_a("hx", this.maxX);
            tag.func_74774_a("hy", this.maxY);
            tag.func_74774_a("hz", this.maxZ);
            String iname = FzUtil.getName(this.icon_id);
            if (iname != null) {
                tag.func_74778_a("icon_idC", iname);
            }
            tag.func_74774_a("icon_md", this.icon_md);
            tag.func_74774_a("icon_sd", this.icon_side);
            this.quat.writeToTag(tag, "r");
        }

        void write(ArrayList<Object> out) {
            out.add(this.minX);
            out.add(this.minY);
            out.add(this.minZ);
            out.add(this.maxX);
            out.add(this.maxY);
            out.add(this.maxZ);
            out.add((short)FzUtil.getId(this.icon_id));
            out.add(this.icon_md);
            out.add(this.icon_side);
            out.add(this.quat);
        }

        ClayLump read(DataInput in) throws IOException {
            this.minX = in.readByte();
            this.minY = in.readByte();
            this.minZ = in.readByte();
            this.maxX = in.readByte();
            this.maxY = in.readByte();
            this.maxZ = in.readByte();
            this.icon_id = FzUtil.getBlock(in.readShort());
            this.icon_md = in.readByte();
            this.icon_side = in.readByte();
            this.quat = Quaternion.read(in);
            return this;
        }

        ClayLump read(NBTTagCompound tag) {
            this.minX = tag.func_74771_c("lx");
            this.minY = tag.func_74771_c("ly");
            this.minZ = tag.func_74771_c("lz");
            this.maxX = tag.func_74771_c("hx");
            this.maxY = tag.func_74771_c("hy");
            this.maxZ = tag.func_74771_c("hz");
            this.icon_id = tag.func_74764_b("icon_id") ? FzUtil.getBlock(tag.func_74765_d("icon_id")) : FzUtil.getBlockFromName(tag.func_74779_i("icon_idC"));
            this.icon_md = tag.func_74771_c("icon_md");
            this.icon_side = tag.func_74764_b("icon_sd") ? tag.func_74771_c("icon_sd") : (byte)-1;
            this.quat = Quaternion.loadFromTag(tag, "r");
            return this;
        }

        void offset(int dx, int dy, int dz) {
            this.minX = (byte)(this.minX + dx);
            this.maxX = (byte)(this.maxX + dx);
            this.minY = (byte)(this.minY + dy);
            this.maxY = (byte)(this.maxY + dy);
            this.minZ = (byte)(this.minZ + dz);
            this.maxZ = (byte)(this.maxZ + dz);
        }

        ClayLump asDefault() {
            this.minZ = (byte)4;
            this.minX = (byte)4;
            this.minY = 0;
            this.maxZ = (byte)12;
            this.maxX = (byte)12;
            this.maxY = (byte)10;
            this.offset(16, 17, 16);
            this.icon_id = Core.registry.resource_block;
            this.icon_md = (byte)ResourceType.BISQUE.md;
            this.icon_side = (byte)-1;
            this.quat = new Quaternion();
            return this;
        }

        public void toBlockBounds(Block b) {
            b.func_149676_a((float)(this.minX - 16) / 16.0f, (float)(this.minY - 16) / 16.0f, (float)(this.minZ - 16) / 16.0f, (float)(this.maxX - 16) / 16.0f, (float)(this.maxY - 16) / 16.0f, (float)(this.maxZ - 16) / 16.0f);
        }

        public void toRotatedBlockBounds(TileEntityGreenware gw, BlockRenderHelper b) {
            this.toBlockBounds(b);
            b.beginNoIIcons();
            b.rotateMiddle(this.quat);
            b.rotateCenter(gw.rotation_quat);
            b.setBlockBoundsBasedOnRotation();
        }

        public ClayLump copy() {
            ClayLump ret = new ClayLump();
            ret.minX = this.minX;
            ret.minY = this.minY;
            ret.minZ = this.minZ;
            ret.maxX = this.maxX;
            ret.maxY = this.maxY;
            ret.maxZ = this.maxZ;
            ret.icon_id = this.icon_id;
            ret.icon_md = this.icon_md;
            ret.quat = new Quaternion(this.quat);
            return ret;
        }
    }
}

