/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.charge.ChargeSparks;
import factorization.charge.TileEntityLeydenJar;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.FactorizationBlockRender;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BlockRenderLeydenJar
extends FactorizationBlockRender {
    private WeakHashMap<ItemStack, ChargeSparks> sparkMap = new WeakHashMap();

    @Override
    public boolean render(RenderBlocks rb) {
        IIcon glass = BlockIcons.leyden_glass_side;
        IIcon knob = BlockIcons.leyden_knob;
        BlockRenderHelper block = BlockRenderHelper.instance;
        float inset = 0.0625f;
        float jarHeight = 1.0f;
        float metal_height = 0.3125f;
        float knob_in = 0.3125f;
        float knob_height = 0.1875f;
        float post_in = 0.4375f;
        float dz = 0.015625f;
        boolean airAbove = true;
        if (this.world_mode) {
            airAbove = this.w.func_147437_c(this.x, this.y + 1, this.z);
        }
        block.func_149676_a(inset, 0.0f, inset, 1.0f - inset, jarHeight, 1.0f - inset);
        block.useTextures(null, BlockIcons.leyden_glass, glass, glass, glass, glass);
        this.renderBlock(rb, block);
        block.useTexture(knob);
        float d = 0.3125f;
        block.func_149676_a(knob_in, 0.015625f, knob_in, 1.0f - knob_in, knob_height, 1.0f - knob_in);
        if (!this.world_mode) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlock(rb, block);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        } else {
            ++this.y;
            if (airAbove) {
                this.renderBlock(rb, block);
            }
            --this.y;
        }
        IIcon leyden_metal = BlockIcons.leyden_metal;
        this.renderCauldron(rb, BlockIcons.leyden_rim, leyden_metal, metal_height);
        block.useTextures(null, airAbove ? null : leyden_metal, leyden_metal, leyden_metal, leyden_metal, leyden_metal);
        block.func_149676_a(post_in, 0.0625f, post_in, 1.0f - post_in, jarHeight, 1.0f - post_in);
        this.renderBlock(rb, block);
        if (!this.world_mode && this.is != null && this.is.func_77942_o()) {
            ChargeSparks sparks;
            TileEntityLeydenJar jar = (TileEntityLeydenJar)FactoryType.LEYDENJAR.getRepresentative();
            jar.onPlacedBy(null, this.is, 0);
            if (!this.sparkMap.containsKey(this.is)) {
                sparks = new ChargeSparks(10);
                this.sparkMap.put(this.is, sparks);
            } else {
                sparks = this.sparkMap.get(this.is);
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                jar.updateSparks(sparks);
            } else {
                long now = mc.field_71441_e.func_82737_E();
                if (now != sparks.last_update) {
                    sparks.last_update = now;
                    jar.updateSparks(sparks);
                }
            }
            if (this.renderType == IItemRenderer.ItemRenderType.ENTITY || this.renderType == IItemRenderer.ItemRenderType.EQUIPPED || this.renderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                float t = -0.5f;
                GL11.glTranslatef((float)t, (float)t, (float)t);
                sparks.render();
                GL11.glTranslatef((float)(t *= -1.0f), (float)t, (float)t);
            } else {
                sparks.render();
            }
        }
        return true;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEYDENJAR;
    }
}

