/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractPage;
import factorization.docs.DocViewer;
import factorization.docs.TextWord;
import factorization.docs.Word;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;

public class WordPage
extends AbstractPage {
    ArrayList<ArrayList<Word>> text = new ArrayList();
    Object figure;
    int lineHeight;
    int lineLen = 0;
    FontRenderer font;

    WordPage(FontRenderer font) {
        this.font = font;
        this.lineHeight = font.field_78288_b + 2;
        this.nl();
    }

    void add(Word word) {
        if (word instanceof TextWord) {
            TextWord tw = (TextWord)word;
            if (tw.text == "\t") {
                word = new TextWord("    ", word.getLink());
            } else if (this.lineLen == 0 && tw.text.trim().isEmpty()) {
                return;
            }
        }
        this.text.get(this.text.size() - 1).add(word);
        this.lineLen += word.getWidth(this.font);
    }

    void nl() {
        Word l;
        ArrayList<Word> last;
        if (!this.text.isEmpty() && !(last = this.text.get(this.text.size() - 1)).isEmpty() && (l = last.get(last.size() - 1)) instanceof TextWord) {
            TextWord tw = (TextWord)l;
            if (tw.text.trim().length() == 0) {
                last.remove(last.size() - 1);
            }
        }
        this.text.add(new ArrayList());
        this.lineLen = 0;
    }

    Word click(int relativeX, int relativeY) {
        int y = 0;
        block0: for (ArrayList<Word> line : this.text) {
            if (y > relativeY) break;
            if ((y += this.lineHeight) < relativeY || line.isEmpty()) continue;
            int x = 0;
            for (Word word : line) {
                int width = word.getWidth(this.font);
                if (x <= relativeX && relativeX <= x + width) {
                    return word;
                }
                if ((x += width) <= relativeX) continue;
                break block0;
            }
        }
        return null;
    }

    @Override
    void draw(DocViewer doc, int ox, int oy) {
        int y = 0;
        for (ArrayList<Word> line : this.text) {
            int x = 0;
            for (Word word : line) {
                x += word.draw(doc, ox + x, oy + y);
            }
            y += this.lineHeight;
        }
    }
}

