/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.common.FzConfig;
import factorization.misc.BuffNametags;
import factorization.misc.Embarkener;
import factorization.misc.LagssieWatchDog;
import factorization.misc.MiscNet;
import factorization.misc.MiscProxy;
import factorization.misc.MobEqualizer;
import factorization.misc.ProperProjectilePhysics;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DungeonHooks;

@Mod(modid="factorization.misc", name="Factorization Miscellaneous Nonsense", version="1.7.10-0.8.83", dependencies="required-after: factorization")
public class MiscellaneousNonsense {
    public static final String modId = "factorization.misc";
    public static final String name = "Factorization Miscellaneous Nonsense";
    public static MiscNet net;
    @SidedProxy(clientSide="factorization.misc.MiscClientProxy", serverSide="factorization.misc.MiscProxy")
    public static MiscProxy proxy;
    public static MiscellaneousNonsense instance;
    public static int newMaxChatLength;
    private final double expected_tick_time_ms = 50.0;
    private float last_tps = -1.0f;
    private int measurements = 0;
    private boolean launched = false;
    static final int check_time = 1200;
    int checks = 1200;

    public MiscellaneousNonsense() {
        instance = this;
    }

    @Mod.EventHandler
    public void setParent(FMLPreInitializationEvent event) {
        event.getModMetadata().parent = "factorization";
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        DungeonHooks.addDungeonMob((String)"Creeper", (int)1);
        String[] THATS_SOME_VERY_NICE_SOURCE_CODE_YOU_HAVE_THERE = new String[]{"##  ##", "##  ##", "  ##  ", " #### ", " #  # "};
        proxy.initializeClient();
        proxy.registerLoadAlert();
        Core.loadBus(this);
        if (FzConfig.equal_opportunities_for_mobs) {
            Core.loadBus(new MobEqualizer());
        }
        if (FzConfig.embarken_wood) {
            Core.loadBus(new Embarkener());
        }
        if (FzConfig.proper_projectile_physics) {
            Core.loadBus(new ProperProjectilePhysics());
        }
        if (FzConfig.buffed_nametags) {
            Core.loadBus(new BuffNametags());
        }
        if (FzConfig.limit_integrated_server && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Core.loadBus(new TickSynchronizer());
        }
    }

    public float getTpsRatio() {
        MinecraftServer ms = MinecraftServer.func_71276_C();
        double ticks_time_ms = MathHelper.func_76127_a((long[])ms.field_71311_j) * 1.0E-6;
        return (float)Math.min(50.0 / ticks_time_ms, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        MinecraftServer ms = MinecraftServer.func_71276_C();
        this.rockets(ms);
        if (ms.func_71259_af() < ms.field_71311_j.length) {
            return;
        }
        if (this.measurements++ != FzConfig.tps_reporting_interval) {
            return;
        }
        this.measurements = 0;
        float tps = this.getTpsRatio();
        if (tps != this.last_tps) {
            FMLProxyPacket packet = MiscNet.makeTpsReportPacket(this.getTpsRatio());
            MiscNet.channel.sendToAll(packet);
            this.last_tps = tps;
        }
    }

    @SubscribeEvent
    public void patLagssie(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++LagssieWatchDog.ticks;
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer ms = MinecraftServer.func_71276_C();
        StatisticsFile sfw = FzUtil.getStatsFile(event.player);
        if (sfw != null && !sfw.func_77443_a(AchievementList.field_76004_f) && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            sfw.func_150873_a(event.player, (StatBase)AchievementList.field_76004_f, -1);
            sfw.func_150873_a(event.player, (StatBase)AchievementList.field_76004_f, 300);
            Core.logInfo("Achievement Get! %s, you've opened your inventory hundreds of times already! Yes! You're welcome!", event.player.func_70005_c_());
        }
        if (ms.func_71259_af() >= ms.field_71311_j.length) {
            MiscNet.channel.sendTo(MiscNet.makeTpsReportPacket(this.getTpsRatio()), (EntityPlayerMP)event.player);
        }
        this.fixReachDistance((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void fixReachDistance(PlayerEvent.PlayerRespawnEvent event) {
        this.fixReachDistance((EntityPlayerMP)event.player);
    }

    public void fixReachDistance(EntityPlayerMP player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double old_rd = player.field_71134_c.getBlockReachDistance();
        double new_rd = old_rd + 1.0;
        player.field_71134_c.setBlockReachDistance(new_rd);
    }

    public static void lag() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void rockets(MinecraftServer ms) {
        Calendar cal;
        this.launched = false;
        if (this.checks-- > 0 || this.launched) {
            return;
        }
        this.checks = 1200;
        boolean right_day = false;
        if (ms.field_71305_c == null && ms.field_71305_c.length > 0 && (cal = ms.field_71305_c[0].func_83015_S()).get(5) == 21 && cal.get(2) == 11) {
            right_day = true;
        }
        if (!right_day) {
            return;
        }
        World w = ms.func_130014_f_();
        if (w == null) {
            return;
        }
        float angle = w.func_72826_c(1.0f);
        if (!((double)angle > 0.3) || !((double)angle < 0.7)) {
            return;
        }
        List players = w.field_73010_i;
        if (players.isEmpty()) {
            return;
        }
        HashSet<Chunk> loadedChunks = new HashSet<Chunk>();
        for (EntityPlayer player : players) {
            int d = 3;
            Coord p = new Coord((Entity)player);
            for (int dx = -d; dx <= d; ++dx) {
                for (int dz = -d; dz <= d; ++dz) {
                    Coord vis = p.add(dx * 16, 0, dz * 16);
                    if (!vis.blockExists()) continue;
                    loadedChunks.add(vis.getChunk());
                }
            }
        }
        ItemStack red_is = new ItemStack(Items.field_151152_bP);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Flight", (byte)3);
        NBTTagList explosions = new NBTTagList();
        NBTTagCompound explo = new NBTTagCompound();
        explo.func_74757_a("Trail", true);
        explo.func_74757_a("Flicker", true);
        int[] colors = new int[]{0xFFFF25};
        explo.func_74783_a("Colors", colors);
        explo.func_74783_a("FadeColors", colors);
        explosions.func_74742_a((NBTBase)explo);
        explo = new NBTTagCompound();
        explo.func_74757_a("Trail", true);
        explo.func_74757_a("Flicker", true);
        colors = new int[]{0xFF2525};
        explo.func_74783_a("Colors", colors);
        explo.func_74783_a("FadeColors", colors);
        explo.func_74774_a("Type", (byte)2);
        explosions.func_74742_a((NBTBase)explo);
        tag.func_74782_a("Explosions", (NBTBase)explosions);
        NBTTagCompound wrap = new NBTTagCompound();
        wrap.func_74782_a("Fireworks", (NBTBase)tag);
        red_is.func_77982_d(wrap);
        ArrayList chunks = new ArrayList(loadedChunks);
        Collections.shuffle(chunks);
        int rocketCount = 206;
        for (Chunk chunk : chunks) {
            if (w.field_73012_v.nextBoolean()) continue;
            if (rocketCount <= 0) break;
            --rocketCount;
            int dx = w.field_73012_v.nextInt(16);
            int dz = w.field_73012_v.nextInt(16);
            int x = chunk.field_76635_g * 16 + dx;
            int z = chunk.field_76647_h * 16 + dz;
            int y = chunk.func_76611_b(dx, dz);
            w.func_72838_d((Entity)new EntityFireworkRocket(w, (double)x, (double)y, (double)z, red_is));
        }
    }

    @Mod.EventHandler
    public void registerLightFixer(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public String func_71517_b() {
                return "skylight-fix";
            }

            public String func_71518_a(ICommandSender var1) {
                return "/skylight-fix radius";
            }

            public void func_71515_b(ICommandSender sender, String[] args) {
                if (args.length == 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Missing radius"));
                    return;
                }
                int radius = Integer.parseInt(args[0]);
                ChunkCoordinates pos = sender.func_82114_b();
                World w = sender.func_130014_f_();
                for (int dx = -radius; dx <= radius; ++dx) {
                    block1: for (int dz = -radius; dz <= radius; ++dz) {
                        int x = pos.field_71574_a + dx;
                        int z = pos.field_71573_c + dz;
                        Coord at = new Coord(w, x, 0, z);
                        for (int y = 255; y > 50; --y) {
                            at.y = y;
                            if (!at.isAir()) continue block1;
                            if (at.getLightLevelSky() == 15) continue;
                            new Notice(at, "X", new String[0]).withStyle(Style.DRAWFAR, Style.FORCE).send((EntityPlayer)sender);
                            at.w.func_72915_b(EnumSkyBlock.Sky, at.x, at.y, at.z, 15);
                        }
                    }
                }
            }
        });
    }

    static {
        newMaxChatLength = 250;
    }

    public static class TickSynchronizer {
        long pokeValue = 0L;
        long serversLastSeenPoke = 0L;
        Minecraft mc = Minecraft.func_71410_x();
        static final boolean enabled = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void serverTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                return;
            }
            if (this.pokeValue % 5L != 0L && !TickSynchronizer.isPlayerInDanger((EntityPlayer)this.mc.field_71439_g)) {
                return;
            }
            if (this.pokeValue != this.serversLastSeenPoke) {
                this.serversLastSeenPoke = this.pokeValue;
                return;
            }
            TickSynchronizer tickSynchronizer = this;
            synchronized (tickSynchronizer) {
                long originalPoke = this.pokeValue;
                long maxWaitTime = 1000L;
                do {
                    try {
                        this.wait(maxWaitTime);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                } while (originalPoke == this.pokeValue);
            }
            this.serversLastSeenPoke = this.pokeValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                return;
            }
            ++this.pokeValue;
            TickSynchronizer tickSynchronizer = this;
            synchronized (tickSynchronizer) {
                this.notifyAll();
            }
        }

        static boolean isPlayerInDanger(EntityPlayer player) {
            if (player == null || !player.func_70089_S()) {
                return false;
            }
            if (player.func_70027_ad() && player.func_70660_b(Potion.field_76426_n) == null) {
                return false;
            }
            if (player.field_70737_aN > 0) {
                return true;
            }
            if (player.func_70086_ai() != 300) {
                return true;
            }
            if (player.field_70143_R > 1.0f) {
                return true;
            }
            if (player.field_70173_aa < 200) {
                return true;
            }
            if (player.func_71024_bL().func_75116_a() <= 2) {
                return true;
            }
            if (player.field_70170_p.func_72912_H().func_76076_i() != 0) {
                return true;
            }
            for (PotionEffect pot : player.func_70651_bq()) {
                int id = pot.func_76456_a();
                if (id != Potion.field_82731_v.field_76415_H && id != Potion.field_76436_u.field_76415_H && id != Potion.field_76437_t.field_76415_H && id != Potion.field_76438_s.field_76415_H) continue;
                return true;
            }
            return false;
        }
    }
}

