/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.servo.ServoMotor;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ItemCraftingComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemServoMotor
extends ItemCraftingComponent {
    public ItemServoMotor() {
        super("servo/servo");
        Core.tab(this, Core.TabType.SERVOS);
        this.func_77625_d(16);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float vecX, float vecY, float vecZ) {
        return false;
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Coord c = new Coord(w, x, y, z);
        if (c.getTE(TileEntityServoRail.class) == null) {
            return false;
        }
        if (w.field_72995_K) {
            return false;
        }
        ServoMotor motor = new ServoMotor(w);
        motor.field_70165_t = c.x;
        motor.field_70163_u = c.y;
        motor.field_70161_v = c.z;
        ForgeDirection top = ForgeDirection.getOrientation((int)side);
        ArrayList<FzOrientation> valid = new ArrayList<FzOrientation>();
        motor.motionHandler.beforeSpawn();
        ForgeDirection playerAngle = ForgeDirection.getOrientation((int)FzUtil.determineOrientation(player));
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            FzOrientation t;
            if (top == fd || top.getOpposite() == fd || !motor.motionHandler.validDirection(fd, false) || (t = FzOrientation.fromDirection(fd).pointTopTo(top)) == FzOrientation.UNKNOWN) continue;
            if (fd == playerAngle) {
                valid.clear();
                valid.add(t);
                break;
            }
            valid.add(t);
        }
        final Vec3 vP = Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ).func_72432_b();
        Collections.sort(valid, new Comparator<FzOrientation>(){

            @Override
            public int compare(FzOrientation a, FzOrientation b) {
                double theta_b;
                double dpA = vP.func_72430_b(Vec3.func_72443_a((double)a.facing.offsetX, (double)a.facing.offsetY, (double)a.facing.offsetZ));
                double dpB = vP.func_72430_b(Vec3.func_72443_a((double)b.facing.offsetX, (double)b.facing.offsetY, (double)b.facing.offsetZ));
                double theta_a = Math.acos(dpA);
                if (theta_a > (theta_b = Math.acos(dpB))) {
                    return 1;
                }
                if (theta_a < theta_b) {
                    return -1;
                }
                return 0;
            }
        });
        if (!valid.isEmpty()) {
            motor.motionHandler.orientation = (FzOrientation)((Object)valid.get(0));
        }
        motor.motionHandler.prevOrientation = motor.motionHandler.orientation;
        if (!player.field_71075_bZ.field_75098_d) {
            --is.field_77994_a;
        }
        motor.spawnServoMotor();
        return true;
    }
}

