/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.FzColor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.servo.Executioner;
import factorization.servo.Instruction;
import factorization.servo.ServoComponent;
import factorization.shared.Core;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;

public class ServoStack
implements IDataSerializable,
Iterable {
    private ArrayDeque<Object> contents = new ArrayDeque();
    private final int maxSize = 16;
    private final Executioner executioner;
    static final byte INSTRUCTION_ID = 9;

    public ServoStack(Executioner executioner) {
        this.executioner = executioner;
    }

    public void setContentsList(Collection<Object> obj) {
        this.clear();
        this.contents.addAll(obj);
    }

    public void clear() {
        this.contents.clear();
        this.executioner.stacks_changed = true;
    }

    public boolean push(Object o) {
        if (o == null) {
            Core.logSevere("Tried to push null!", new Object[0]);
            Thread.dumpStack();
            return false;
        }
        if (this.contents.size() >= 16) {
            return false;
        }
        this.contents.addFirst(o);
        this.executioner.stacks_changed = true;
        return true;
    }

    public boolean append(Object o) {
        if (o == null) {
            Core.logSevere("Tried to append null!", new Object[0]);
            Thread.dumpStack();
            return false;
        }
        if (this.contents.size() >= 16) {
            return false;
        }
        this.contents.add(o);
        this.executioner.stacks_changed = true;
        return true;
    }

    public void forceAppend(Object o) {
        this.contents.add(o);
        this.executioner.stacks_changed = true;
    }

    public Object pop() {
        if (this.contents.isEmpty()) {
            return null;
        }
        this.executioner.stacks_changed = true;
        return this.contents.removeFirst();
    }

    public Object peek() {
        if (this.contents.isEmpty()) {
            return null;
        }
        return this.contents.getFirst();
    }

    public Object popEnd() {
        if (this.contents.isEmpty()) {
            return null;
        }
        this.executioner.stacks_changed = true;
        return this.contents.removeLast();
    }

    public <E> E popType(Class<? extends E> eClass) {
        return this.popType(eClass, true);
    }

    public Object remove(int index) {
        if (index >= this.contents.size()) {
            return null;
        }
        return this.contents.remove(index);
    }

    public <E> E findType(Class<? extends E> eClass) {
        return this.popType(eClass, false);
    }

    private <E> E popType(Class<? extends E> eClass, boolean remove) {
        Iterator<Object> it = this.contents.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null) {
                it.remove();
                continue;
            }
            if (o.getClass() != eClass) continue;
            if (remove) {
                this.executioner.stacks_changed = true;
                it.remove();
            }
            return (E)o;
        }
        return null;
    }

    public Iterator<Object> iterator() {
        return this.contents.iterator();
    }

    public Iterator<Object> descendingIterator() {
        return this.contents.descendingIterator();
    }

    public int getMaxSize() {
        return 16;
    }

    public int getFreeSpace() {
        return Math.max(0, 16 - this.contents.size());
    }

    public int getSize() {
        return this.contents.size();
    }

    public void writeObject(DataHelper data, String entryName, Object value) throws IOException {
        if (value instanceof Instruction) {
            NBTTagCompound tag = new NBTTagCompound();
            ((Instruction)value).save(tag);
            data.asSameShare(entryName + ".type").putByte((byte)9);
            data.asSameShare(entryName).put(tag);
        } else {
            TypeInfo ti = TypeInfo.forObject(value);
            data.asSameShare(entryName + ".type").putByte(ti.id);
            data.asSameShare(entryName).put(value);
        }
    }

    public Object readObject(DataHelper data, String entryName) throws IOException {
        byte id = data.asSameShare(entryName + ".type").putByte((byte)-1);
        if (id == -1) {
            throw new IOException("Missing .type for " + entryName);
        }
        if (id == 9) {
            NBTTagCompound tag = data.asSameShare(entryName).putTag(new NBTTagCompound());
            return (Instruction)ServoComponent.load(tag);
        }
        TypeInfo ti = TypeInfo.forId(id);
        return data.asSameShare(entryName).put(ti.defaultValue);
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        int length = data.asSameShare(prefix + "_size").putInt(this.contents.size());
        if (length == 0) {
            if (data.isReader()) {
                this.contents.clear();
            }
            return this;
        }
        prefix = prefix + "#";
        if (data.isWriter()) {
            int i = 0;
            for (Object o : this.contents) {
                this.writeObject(data, prefix + i++, o);
            }
        } else {
            this.contents.clear();
            for (int i = 0; i < length; ++i) {
                Object n = this.readObject(data, prefix + i);
                if (n == null) continue;
                this.contents.add(n);
            }
        }
        return this;
    }

    public DataHelper getDataHelper(boolean reader) {
        return new DataServoStack(reader);
    }

    public String toString() {
        return this.contents.toString();
    }

    private class DataServoStack
    extends DataHelper {
        final boolean reader;

        public DataServoStack(boolean reader) {
            this.reader = reader;
        }

        @Override
        protected boolean shouldStore(Share share) {
            return true;
        }

        @Override
        public boolean isReader() {
            return this.reader;
        }

        @Override
        protected <E> Object putImplementation(E value) throws IOException {
            if (this.reader) {
                Object ret = ServoStack.this.popType(value.getClass());
                if (ret == null) {
                    throw new IOException();
                }
                return ret;
            }
            ServoStack.this.push(value);
            return value;
        }
    }

    private static final class TypeInfo {
        final byte id;
        final Class theClass;
        final Object defaultValue;
        private static byte count = (byte)10;
        private static TypeInfo[] typeInfo = new TypeInfo[]{TypeInfo.def(Boolean.class, false), TypeInfo.def(Byte.class, (byte)0), TypeInfo.def(Short.class, (short)0), TypeInfo.def(Integer.class, 0), TypeInfo.def(Long.class, 0L), TypeInfo.def(Float.class, Float.valueOf(0.0f)), TypeInfo.def(Double.class, 0.0), TypeInfo.def(String.class, ""), TypeInfo.def(FzColor.class, FzColor.BLACK)};

        TypeInfo(byte id, Class theClass, Object defaultValue) {
            this.id = id;
            this.theClass = theClass;
            this.defaultValue = defaultValue;
        }

        private static <O> TypeInfo def(Class<O> theClass, O def) {
            byte by = count;
            count = (byte)(by + 1);
            return new TypeInfo(by, theClass, def);
        }

        public static TypeInfo forObject(Object o) {
            Class<?> theClass = o.getClass();
            int id = -1;
            for (TypeInfo ti : typeInfo) {
                if (ti.theClass != theClass) continue;
                return ti;
            }
            throw new IllegalArgumentException("Can't handle: " + o);
        }

        public static TypeInfo forId(byte id) {
            for (TypeInfo ti : typeInfo) {
                if (ti.id != id) continue;
                return ti;
            }
            throw new IllegalArgumentException("Unknown type id: " + id);
        }
    }
}

