/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.api.IChargeConductor;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.servo.Decorator;
import factorization.servo.GuiCommentEditor;
import factorization.servo.ServoComponent;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;

public class TileEntityServoRail
extends TileEntityCommon
implements IChargeConductor {
    public static final float width = 0.4375f;
    Charge charge = new Charge(this);
    Decorator decoration = null;
    public byte priority = 0;
    String comment = "";
    FzColor color = FzColor.NO_COLOR;
    private String decor_tag_key = "decor";

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SERVORAIL;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Wire;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    public void func_145845_h() {
        this.charge.update();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.charge.writeToNBT(tag);
        tag.func_74774_a("priority", this.priority);
        tag.func_74774_a("color", this.color.toOrdinal());
        tag.func_74778_a("rem", this.comment);
        if (this.decoration != null) {
            NBTTagCompound decor = new NBTTagCompound();
            this.decoration.save(decor);
            tag.func_74782_a(this.decor_tag_key, (NBTBase)decor);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        NBTTagCompound dtag;
        ServoComponent component;
        super.func_145839_a(tag);
        this.charge.readFromNBT(tag);
        this.priority = tag.func_74771_c("priority");
        this.color = tag.func_74764_b("color") ? FzColor.fromOrdinal(tag.func_74771_c("color")) : FzColor.NO_COLOR;
        this.comment = tag.func_74779_i("rem");
        if (tag.func_74764_b(this.decor_tag_key) && (component = ServoComponent.load(dtag = tag.func_74775_l(this.decor_tag_key))) instanceof Decorator) {
            this.decoration = (Decorator)component;
        }
    }

    boolean has(ForgeDirection dir) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        return te instanceof TileEntityServoRail;
    }

    public boolean fillSideInfo(boolean[] sides) {
        boolean any = false;
        for (int i = 0; i < 6; ++i) {
            boolean flag;
            sides[i] = flag = this.has(ForgeDirection.getOrientation((int)i));
            any |= flag;
        }
        return any;
    }

    private boolean getCollisionBoxes(AxisAlignedBB aabb, List list, Entity entity) {
        AxisAlignedBB a;
        float high;
        float low;
        boolean remote = entity != null && entity.field_70170_p != null ? entity.field_70170_p.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        BlockRenderHelper block = remote ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        boolean[] sides = new boolean[6];
        this.fillSideInfo(sides);
        int count = 0;
        float f = 0.4375f;
        if (sides[0] || sides[1]) {
            ++count;
            low = sides[0] ? 0.0f : f;
            high = sides[1] ? 1.0f : 1.0f - f;
            block.func_149676_a(f, low, f, 1.0f - f, high, 1.0f - f);
            a = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        if (sides[2] || sides[3]) {
            ++count;
            low = sides[2] ? 0.0f : f;
            high = sides[3] ? 1.0f : 1.0f - f;
            block.func_149676_a(f, f, low, 1.0f - f, 1.0f - f, high);
            a = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        if (sides[4] || sides[5]) {
            ++count;
            low = sides[4] ? 0.0f : f;
            high = sides[5] ? 1.0f : 1.0f - f;
            block.func_149676_a(low, f, f, high, 1.0f - f, 1.0f - f);
            a = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        if (count == 0) {
            block.func_149676_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
            AxisAlignedBB a2 = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (aabb == null || aabb.func_72326_a(a2)) {
                list.add(a2);
            }
        }
        return true;
    }

    @Override
    public boolean addCollisionBoxesToList(Block ignore, AxisAlignedBB aabb, List list, Entity entity) {
        if (this.decoration != null && this.decoration.collides()) {
            float f = this.decoration.getSize();
            boolean remote = entity != null && entity.field_70170_p != null ? entity.field_70170_p.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
            BlockRenderHelper block = remote ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
            block.func_149676_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
            AxisAlignedBB a = block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
                return true;
            }
        }
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        ArrayList boxes = new ArrayList(4);
        this.getCollisionBoxes(null, boxes, null);
        BlockRenderHelper b = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? Core.registry.serverTraceHelper : Core.registry.clientTraceHelper;
        for (AxisAlignedBB ab : boxes) {
            ab = ab.func_72325_c((double)(-this.field_145851_c), (double)(-this.field_145848_d), (double)(-this.field_145849_e));
            float d = 0.0625f;
            b.func_149676_a((float)ab.field_72340_a - d, (float)ab.field_72338_b - d, (float)ab.field_72339_c - d, (float)ab.field_72336_d + d, (float)ab.field_72337_e + d, (float)ab.field_72334_f + d);
            MovingObjectPosition mop = b.func_149731_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
            if (mop == null) continue;
            return mop;
        }
        return null;
    }

    @Override
    public void setBlockBounds(Block b) {
        float f = 0.4375f;
        b.func_149676_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.servo$rail;
    }

    public void setDecoration(Decorator newDecor) {
        this.decoration = newDecor;
        if (this.decoration != null) {
            this.decoration.onPlacedOnRail(this);
        }
        this.func_70296_d();
    }

    public Decorator getDecoration() {
        return this.decoration;
    }

    void showDecorNotification(EntityPlayer player) {
        String info = this.decoration == null ? null : this.decoration.getInfo();
        info = info == null ? "" : info;
        Coord here = this.getCoord();
        boolean powered = here.isWeaklyPowered();
        if (this.comment.length() > 0) {
            if (info.length() > 0) {
                info = info + "\n";
            }
            info = info + EnumChatFormatting.ITALIC + this.comment;
        }
        if (this.color != FzColor.NO_COLOR) {
            info = info + "\n" + (Object)((Object)this.color);
        }
        if (info.length() > 0 || powered) {
            Notice notice = new Notice(here, StringUtils.strip((String)info, (String)"\n"), new String[0]);
            if (powered) {
                notice.withItem(new ItemStack(Blocks.field_150429_aA));
                notice.withStyle(Style.DRAWITEM);
            }
            notice.send(player);
        }
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        FzColor newColor;
        Coord here = this.getCoord();
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        boolean ret = false;
        if (this.decoration != null) {
            ret = this.decoration.onClick(entityplayer, here, side);
        }
        if (!ret && this.color == FzColor.NO_COLOR && (newColor = FzColor.fromItem(entityplayer.func_70694_bm())) != this.color) {
            this.color = newColor;
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                ItemStack held = entityplayer.func_70694_bm();
                entityplayer.func_70062_b(0, FzUtil.normalDecr(held));
            }
            ret = true;
        }
        if (ret) {
            here.syncAndRedraw();
        }
        if (entityplayer instanceof EntityPlayerMP) {
            this.showDecorNotification(entityplayer);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.ServoRailDecor) {
            this.color = FzColor.fromOrdinal(input.readByte());
            this.comment = input.readBoolean() ? "x" : null;
            boolean has_decor = input.readBoolean();
            if (has_decor) {
                ServoComponent sc = ServoComponent.readFromPacket(input);
                if (!(sc instanceof Decorator)) {
                    return false;
                }
                this.decoration = (Decorator)sc;
                this.decoration.afterClientLoad(this);
                this.getCoord().redraw();
            }
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.ServoRailEditComment) {
            this.comment = input.readUTF();
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiCommentEditor(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.ServoRailEditComment) {
            this.comment = input.readUTF();
            return true;
        }
        return super.handleMessageFromClient(messageType, input);
    }

    @Override
    public FMLProxyPacket getDescriptionPacket() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte c = this.color.toOrdinal();
            dos.writeByte(c);
            dos.writeBoolean(this.comment != null && this.comment.length() > 0);
            dos.writeBoolean(this.decoration != null);
            if (this.decoration != null) {
                this.decoration.writeToPacket(dos);
            }
        }
        catch (Throwable e) {
            Core.logWarning("Component packet error at %s %s:", this, this.getCoord());
            e.printStackTrace();
            this.decoration = null;
            new Notice(this, "Component packet error!\nSee console log.", new String[0]).withStyle(Style.FORCE, Style.LONG).sendToAll();
            return super.getDescriptionPacket();
        }
        return this.getDescriptionPacketWith(new Object[]{NetworkFactorization.MessageType.ServoRailDecor, baos.toByteArray()});
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (this.decoration == null) {
            return;
        }
        if (!this.decoration.isFreeToPlace()) {
            this.getCoord().spawnItem(this.decoration.toItem());
        }
    }

    @Override
    public ItemStack getPickedBlock() {
        Decorator decoration = this.getDecoration();
        if (decoration != null) {
            return decoration.toItem();
        }
        return this.getDroppedBlock();
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, FzColor fzColor) {
        if (fzColor != this.color) {
            this.color = fzColor;
            this.getCoord().markBlockForUpdate();
            return true;
        }
        return false;
    }
}

