/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.IEntityMessage;
import factorization.api.Quaternion;
import factorization.api.VectorUV;
import factorization.common.Command;
import factorization.common.FactoryType;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.FzUtil;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkFactorization {
    public static final ItemStack EMPTY_ITEMSTACK = new ItemStack(Blocks.field_150350_a);
    private static byte message_type_count = 0;

    private void writeObjects(ByteArrayOutputStream outputStream, DataOutputStream output, Object ... items) throws IOException {
        for (Object item : items) {
            if (item == null) {
                throw new RuntimeException("Argument is null!");
            }
            if (item instanceof Integer) {
                output.writeInt((Integer)item);
                continue;
            }
            if (item instanceof Byte) {
                output.writeByte(((Byte)item).byteValue());
                continue;
            }
            if (item instanceof Short) {
                output.writeShort(((Short)item).shortValue());
                continue;
            }
            if (item instanceof String) {
                output.writeUTF((String)item);
                continue;
            }
            if (item instanceof Boolean) {
                output.writeBoolean((Boolean)item);
                continue;
            }
            if (item instanceof Float) {
                output.writeFloat(((Float)item).floatValue());
                continue;
            }
            if (item instanceof ItemStack) {
                ItemStack is = (ItemStack)item;
                NBTTagCompound tag = new NBTTagCompound();
                is.func_77955_b(tag);
                CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
                continue;
            }
            if (item instanceof VectorUV) {
                VectorUV v = (VectorUV)item;
                output.writeFloat((float)v.x);
                output.writeFloat((float)v.y);
                output.writeFloat((float)v.z);
                continue;
            }
            if (item instanceof DeltaCoord) {
                DeltaCoord dc = (DeltaCoord)item;
                dc.write(output);
                continue;
            }
            if (item instanceof Quaternion) {
                Quaternion q = (Quaternion)item;
                q.write(output);
                continue;
            }
            if (item instanceof byte[]) {
                byte[] b = (byte[])item;
                output.write(b, 0, b.length);
                continue;
            }
            if (item instanceof MessageType) {
                MessageType mt = (MessageType)((Object)item);
                mt.write(output);
                continue;
            }
            throw new RuntimeException("Don't know how to serialize " + item.getClass() + " (" + item + ")");
        }
    }

    public void prefixTePacket(DataOutputStream output, Coord src, MessageType messageType) throws IOException {
        messageType.write(output);
        output.writeInt(src.x);
        output.writeInt(src.y);
        output.writeInt(src.z);
    }

    public FMLProxyPacket TEmessagePacket(Coord src, MessageType messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            this.prefixTePacket(output, src, messageType);
            this.writeObjects(outputStream, output, items);
            return FzNetDispatch.generate(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void prefixEntityPacket(DataOutputStream output, Entity to, MessageType messageType) throws IOException {
        messageType.write(output);
        output.writeInt(to.func_145782_y());
    }

    public FMLProxyPacket entityPacket(ByteArrayOutputStream outputStream) throws IOException {
        outputStream.flush();
        return FzNetDispatch.generate(outputStream);
    }

    public FMLProxyPacket entityPacket(Entity to, MessageType messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            this.prefixEntityPacket(output, to, messageType);
            this.writeObjects(outputStream, output, items);
            return this.entityPacket(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendCommand(EntityPlayer player, Command cmd, byte arg) {
        try {
            ByteBuf buf = Unpooled.buffer();
            ByteBufOutputStream bo = new ByteBufOutputStream(buf);
            MessageType.factorizeCmdChannel.write((DataOutput)bo);
            bo.writeByte((int)cmd.id);
            bo.writeByte((int)arg);
            FzNetDispatch.addPacket(FzNetDispatch.generate(bo), player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void broadcastMessage(EntityPlayer who, Coord src, MessageType messageType, Object ... msg) {
        if (who != null) {
            FMLProxyPacket toSend = this.TEmessagePacket(src, messageType, msg);
            FzNetDispatch.addPacket(toSend, who);
        } else {
            FMLProxyPacket toSend = this.TEmessagePacket(src, messageType, msg);
            FzNetDispatch.addPacketFrom((Packet)toSend, src);
        }
    }

    public void broadcastPacket(EntityPlayer who, Coord src, FMLProxyPacket toSend) {
        if (who != null) {
            FzNetDispatch.addPacket(toSend, who);
        } else {
            FzNetDispatch.addPacketFrom((Packet)toSend, src);
        }
    }

    void handleTE(DataInput input, MessageType messageType, EntityPlayer player) {
        try {
            World world = player.field_70170_p;
            int x = input.readInt();
            int y = input.readInt();
            int z = input.readInt();
            Coord here = new Coord(world, x, y, z);
            if (Core.debug_network) {
                Core.logFine("FactorNet: " + (Object)((Object)messageType) + "      " + here, new Object[0]);
            }
            if (!here.blockExists() && world.field_72995_K) {
                return;
            }
            if (messageType == MessageType.DescriptionRequest && !world.field_72995_K) {
                TileEntityCommon tec = here.getTE(TileEntityCommon.class);
                if (tec != null) {
                    FzNetDispatch.addPacket(tec.getDescriptionPacket(), player);
                }
                return;
            }
            if (messageType == MessageType.RedrawOnClient && world.field_72995_K) {
                world.func_147471_g(x, y, z);
                return;
            }
            if ((messageType == MessageType.FactoryType || messageType == MessageType.FactoryTypeWithSecondMessage) && world.field_72995_K) {
                FactoryType ft = FactoryType.fromMd(input.readInt());
                byte extraData = input.readByte();
                byte extraData2 = input.readByte();
                messageType = messageType == MessageType.FactoryTypeWithSecondMessage ? MessageType.read(input) : null;
                TileEntityCommon spawn = here.getTE(TileEntityCommon.class);
                if (spawn != null && spawn.getFactoryType() != ft) {
                    world.func_147475_p(x, y, z);
                    spawn = null;
                }
                if (spawn == null) {
                    spawn = ft.makeTileEntity();
                    spawn.func_145834_a(world);
                    world.func_147455_a(x, y, z, (TileEntity)spawn);
                    here.redraw();
                }
                spawn.useExtraInfo(extraData);
                spawn.useExtraInfo2(extraData2);
            }
            if (messageType == null) {
                return;
            }
            TileEntityCommon tec = here.getTE(TileEntityCommon.class);
            if (tec == null) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
                return;
            }
            boolean handled = here.w.field_72995_K ? tec.handleMessageFromServer(messageType, input) : tec.handleMessageFromClient(messageType, input);
            if (!handled) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleForeignMessage(World world, int x, int y, int z, TileEntity ent, MessageType messageType, DataInput input) throws IOException {
        if (world.field_72995_K) {
            Coord here = new Coord(world, x, y, z);
            switch (messageType) {
                case PlaySound: {
                    Sound.receive(here, input);
                    break;
                }
                default: {
                    if (here.blockExists()) {
                        Core.logFine("Got unhandled message: " + (Object)((Object)messageType) + " for " + here, new Object[0]);
                        break;
                    }
                    Core.logFine("Got message to unloaded chunk: " + (Object)((Object)messageType) + " for " + here, new Object[0]);
                }
            }
        }
    }

    boolean handleForeignEntityMessage(Entity ent, MessageType messageType, DataInput input) throws IOException {
        if (messageType == MessageType.EntityParticles) {
            Random rand = new Random();
            double px = rand.nextGaussian() * 0.02;
            double py = rand.nextGaussian() * 0.02;
            double pz = rand.nextGaussian() * 0.02;
            int count = input.readByte();
            String type = input.readUTF();
            for (int i = 0; i < count; ++i) {
                ent.field_70170_p.func_72869_a(type, ent.field_70165_t + (double)(rand.nextFloat() * ent.field_70130_N) * 2.0 - (double)ent.field_70130_N, ent.field_70163_u + 0.5 + (double)(rand.nextFloat() * ent.field_70131_O), ent.field_70161_v + (double)(rand.nextFloat() * ent.field_70130_N) * 2.0 - (double)ent.field_70130_N, px, py, pz);
            }
            return true;
        }
        return false;
    }

    void handleCmd(DataInput data, EntityPlayer player) throws IOException {
        byte s = data.readByte();
        byte arg = data.readByte();
        Command.fromNetwork(player, s, arg);
    }

    void handleEntity(MessageType messageType, DataInput input, EntityPlayer player) {
        try {
            boolean handled;
            World world = player.field_70170_p;
            int entityId = input.readInt();
            Entity to = world.func_73045_a(entityId);
            if (to == null) {
                if (Core.dev_environ) {
                    Core.logFine("Packet to unknown entity #%s: %s", new Object[]{entityId, messageType});
                }
                return;
            }
            if (!(to instanceof IEntityMessage)) {
                if (!this.handleForeignEntityMessage(to, messageType, input)) {
                    Core.logFine("Packet to inappropriate entity #%s: %s", new Object[]{entityId, messageType});
                }
                return;
            }
            IEntityMessage iem = (IEntityMessage)to;
            if (Core.debug_network) {
                Core.logFine("EntityNet: " + (Object)((Object)messageType) + "      " + to, new Object[0]);
            }
            if (!(handled = world.field_72995_K ? iem.handleMessageFromServer(messageType, input) : iem.handleMessageFromClient(messageType, input)) && !this.handleForeignEntityMessage(to, messageType, input)) {
                Core.logFine("Got unhandled message: " + (Object)((Object)messageType) + " for " + iem, new Object[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack nullItem(ItemStack is) {
        return is == null ? EMPTY_ITEMSTACK : is;
    }

    public static ItemStack denullItem(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (FzUtil.getId(is) == FzUtil.getId(Blocks.field_150350_a)) {
            return null;
        }
        return is;
    }

    static /* synthetic */ byte access$008() {
        byte by = message_type_count;
        message_type_count = (byte)(by + 1);
        return by;
    }

    public static enum MessageType {
        factorizeCmdChannel,
        PlaySound,
        EntityParticles(true),
        DrawActive,
        FactoryType,
        FactoryTypeWithSecondMessage,
        DescriptionRequest,
        DataHelperEdit,
        RedrawOnClient,
        DataHelperEditOnEntity(true),
        OpenDataHelperGui,
        OpenDataHelperGuiOnEntity(true),
        TileEntityMessageOnEntity(true),
        BarrelDescription,
        BarrelItem,
        BarrelCount,
        BarrelDoubleClickHack,
        BatteryLevel,
        LeydenjarLevel,
        MirrorDescription,
        TurbineWater,
        TurbineSpeed,
        HeaterHeat,
        LaceratorSpeed,
        MixerSpeed,
        FanturpellerSpeed,
        CrystallizerInfo,
        WireFace,
        SculptDescription,
        SculptNew,
        SculptMove,
        SculptRemove,
        SculptState,
        ExtensionInfo,
        RocketState,
        ServoRailDecor,
        ServoRailEditComment,
        CompressionCrafter,
        CompressionCrafterBeginCrafting,
        CompressionCrafterBounds,
        servo_brief(true),
        servo_item(true),
        servo_complete(true),
        servo_stopped(true);

        public boolean isEntityMessage;
        private static final MessageType[] valuesCache;
        private final byte id = NetworkFactorization.access$008();

        private MessageType() {
            this(false);
        }

        private MessageType(boolean isEntity) {
            if (this.id < 0) {
                throw new IllegalArgumentException("Too many message types!");
            }
            this.isEntityMessage = isEntity;
        }

        private static MessageType fromId(byte id) {
            if (id < 0 || id >= valuesCache.length) {
                return null;
            }
            return valuesCache[id];
        }

        public static MessageType read(DataInput in) throws IOException {
            byte b = in.readByte();
            MessageType mt = MessageType.fromId(b);
            if (mt == null) {
                throw new IOException("Unknown type: " + b);
            }
            return mt;
        }

        public void write(DataOutput out) throws IOException {
            out.writeByte(this.id);
        }

        static {
            valuesCache = MessageType.values();
        }
    }
}

