/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum Sound {
    rightClick("random.click", 1.0, 1.25),
    leftClick("random.click", 1.0, 0.75),
    routerCluck("mob.chicken.say", 0.5, 0.66, false),
    stamperUse("tile.piston.in", 0.1, 1.1, false),
    makerUse("tile.piston.out", 0.08, 1.25, false),
    bagSlurp("random.drink", 0.6, 8.0, false),
    demonSqueek("mob.enderman.scream", 0.9, 8.0, true),
    wandCool("random.fizz", 0.2, 0.5, true),
    acidBurn("random.fizz", 1.0, 1.0, true),
    caliometricDigest("random.burp", 1.0, 0.5, true),
    barrelPunt("mob.zombie.infect", 0.9, 1.5, true),
    barrelPunt2("mob.zombie.infect", 0.9, 3.5, true),
    socketInstall("dig.wood", 1.0, 1.0, true),
    servoInstall("mob.slime.attack", 1.0, 1.0, true);

    String src;
    float volume;
    float pitch;
    int index;
    boolean share;

    void init(String src, double volume, double pitch) {
        this.src = src;
        this.volume = (float)volume;
        this.pitch = (float)pitch;
        this.index = sound.list.size();
        sound.list.add(this);
    }

    private Sound(String src, double volume, double pitch) {
        this.init(src, volume, pitch);
        this.share = false;
    }

    private Sound(String src, double volume, double pitch, boolean share) {
        this.init(src, volume, pitch);
        this.share = share;
    }

    void share(World w, int x, int y, int z) {
        if (!this.share) {
            return;
        }
        if (w.field_72995_K) {
            return;
        }
        Core.network.broadcastMessage(null, new Coord(w, x, y, z), NetworkFactorization.MessageType.PlaySound, this.index);
    }

    public static void receive(Coord coord, DataInput input) {
        try {
            int index = input.readInt();
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player == null) {
                return;
            }
            sound.list.get(index).playAt(coord);
        }
        catch (IOException e) {
            return;
        }
    }

    public void playAt(Coord c) {
        this.playAt(c.w, c.x, c.y, c.z);
    }

    @Deprecated
    public void playAt(Entity ent) {
        ent.field_70170_p.func_72956_a(ent, this.src, this.volume, this.pitch);
        this.share(ent.field_70170_p, (int)ent.field_70165_t, (int)(ent.field_70163_u - (double)ent.field_70129_M), (int)ent.field_70161_v);
    }

    public void playAt(World world, double x, double y, double z) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            world.func_72980_b(x, y, z, this.src, this.volume, this.pitch, false);
        }
        this.share(world, (int)x, (int)y, (int)z);
    }

    public void playAt(TileEntity ent) {
        this.playAt(ent.func_145831_w(), ent.field_145851_c, ent.field_145848_d, ent.field_145849_e);
    }

    public void play() {
        Core.proxy.playSoundFX(this.src, this.volume, this.pitch);
    }

    static class sound {
        static ArrayList<Sound> list = new ArrayList();

        sound() {
        }
    }
}

