/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.api.IChargeConductor;
import factorization.api.ICoord;
import factorization.api.IFactoryType;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.NetworkFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityCommon
extends TileEntity
implements ICoord,
IFactoryType {
    protected static Random rand = new Random();
    public String customName = null;
    private long pulseTime = -1000L;
    public static final ForgeDirection[] empty_rotation_array = new ForgeDirection[0];
    public static final ForgeDirection[] flat_rotation_array = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final ForgeDirection[] full_rotation_array = new ForgeDirection[6];

    public abstract BlockClass getBlockClass();

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.error;
    }

    public FMLProxyPacket getDescriptionPacket() {
        FMLProxyPacket p = Core.network.TEmessagePacket(this.getCoord(), NetworkFactorization.MessageType.FactoryType, this.getFactoryType().md, this.getExtraInfo(), this.getExtraInfo2());
        return p;
    }

    protected void onRemove() {
        if (this instanceof IChargeConductor) {
            ((IChargeConductor)((Object)this)).getCharge().remove();
        }
    }

    protected byte getExtraInfo() {
        return 0;
    }

    protected byte getExtraInfo2() {
        return 0;
    }

    protected void useExtraInfo(byte b) {
    }

    protected void useExtraInfo2(byte b) {
    }

    protected void sendFullDescription(EntityPlayer player) {
    }

    public boolean canPlaceAgainst(EntityPlayer player, Coord c, int side) {
        return true;
    }

    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        this.onPlacedBy(player, is, side);
    }

    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        this.loadFromStack(is);
    }

    public void loadFromStack(ItemStack is) {
        this.customName = FzUtil.getCustomItemName(is);
    }

    protected boolean removedByPlayer(EntityPlayer player) {
        return Core.registry.resource_block.removedByPlayer(this.field_145850_b, player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void neighborChanged() {
    }

    public void pulse() {
        Coord here = this.getCoord();
        if (here.w.field_72995_K) {
            return;
        }
        long now = this.field_145850_b.func_82737_E();
        if (this.pulseTime + 4L >= now) {
            return;
        }
        this.pulseTime = now;
        here.notifyNeighbors();
        here.scheduleUpdate(4);
    }

    public boolean power() {
        return this.pulseTime + 4L > this.field_145850_b.func_82737_E();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        this.setBlockBounds(Core.registry.resource_block);
        AxisAlignedBB ret = Core.registry.resource_block.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Core.registry.resource_block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return ret;
    }

    public boolean addCollisionBoxesToList(Block block, AxisAlignedBB aabb, List list, Entity entity) {
        return false;
    }

    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        return Blocks.field_150348_b.func_149731_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
    }

    public void setBlockBounds(Block b) {
        b.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    protected FMLProxyPacket getDescriptionPacketWith(Object ... args) {
        Object[] suffix = new Object[args.length + 3];
        suffix[0] = this.getFactoryType().md;
        suffix[1] = this.getExtraInfo();
        suffix[2] = this.getExtraInfo2();
        for (int i = 0; i < args.length; ++i) {
            suffix[i + 3] = args[i];
        }
        FMLProxyPacket p = Core.network.TEmessagePacket(this.getCoord(), NetworkFactorization.MessageType.FactoryTypeWithSecondMessage, suffix);
        return p;
    }

    @Override
    public Coord getCoord() {
        return new Coord(this);
    }

    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        FactoryType type = this.getFactoryType();
        if (type.hasGui) {
            if (!entityplayer.field_70170_p.field_72995_K) {
                this.sendFullDescription(entityplayer);
                entityplayer.openGui((Object)Core.instance, type.gui, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public boolean isBlockSolidOnSide(int side) {
        return true;
    }

    public boolean takeUpgrade(ItemStack is) {
        return false;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74778_a("ver", "1.7.10-0.8.83");
        if (this.customName != null) {
            tag.func_74778_a("customName", this.customName);
        }
        if (this.field_145850_b != null && this.power()) {
            tag.func_74772_a("rps", this.pulseTime);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("customName")) {
            this.customName = tag.func_74779_i("customName");
        }
        if (tag.func_74764_b("rps")) {
            this.pulseTime = tag.func_74763_f("rps");
        }
    }

    protected final void writeBuffer(String bufferName, NBTTagCompound tag, ArrayList<ItemStack> outputBuffer) {
        if (outputBuffer.size() > 0) {
            NBTTagList buffer = new NBTTagList();
            for (ItemStack item : outputBuffer) {
                if (item == null) continue;
                NBTTagCompound btag = new NBTTagCompound();
                item.func_77955_b(btag);
                buffer.func_74742_a((NBTBase)btag);
            }
            tag.func_74782_a(bufferName, (NBTBase)buffer);
        }
    }

    protected final void readBuffer(String bufferName, NBTTagCompound tag, ArrayList<ItemStack> outputBuffer) {
        NBTTagList buffer;
        int bufferSize;
        outputBuffer.clear();
        if (tag.func_74764_b(bufferName) && (bufferSize = (buffer = tag.func_150295_c(bufferName, 10)).func_74745_c()) > 0) {
            for (int i = 0; i < bufferSize; ++i) {
                NBTTagCompound it = buffer.func_150305_b(i);
                outputBuffer.add(ItemStack.func_77949_a((NBTTagCompound)it));
            }
        }
    }

    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        return false;
    }

    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, DataInput input) throws IOException {
        return false;
    }

    public void broadcastMessage(EntityPlayer who, NetworkFactorization.MessageType messageType, Object ... msg) {
        Core.network.broadcastMessage(who, this.getCoord(), messageType, msg);
    }

    public void broadcastMessage(EntityPlayer who, FMLProxyPacket toSend) {
        Core.network.broadcastPacket(who, this.getCoord(), toSend);
    }

    public void func_145843_s() {
        if (this instanceof IChargeConductor) {
            IChargeConductor me = (IChargeConductor)((Object)this);
            me.getCharge().invalidate();
        }
        super.func_145843_s();
    }

    public boolean rotate(ForgeDirection axis) {
        return false;
    }

    public ForgeDirection[] getValidRotations() {
        return empty_rotation_array;
    }

    public int getDynamicLight() {
        return 0;
    }

    public int getComparatorValue(ForgeDirection side) {
        if (this instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)this));
        }
        return 0;
    }

    public String toString() {
        return super.toString() + " a " + (Object)((Object)this.getFactoryType()) + " at " + this.getCoord();
    }

    public ItemStack getDroppedBlock() {
        return new ItemStack((Item)Core.registry.item_factorization, 1, this.getFactoryType().md);
    }

    public ItemStack getPickedBlock() {
        return this.getDroppedBlock();
    }

    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
    }

    public void representYoSelf() {
        Core.loadBus(this);
    }

    public void mappingsChanged(FMLModIdMappingEvent event) {
    }

    public void spawnDisplayTickParticles(Random rand) {
    }

    public boolean recolourBlock(ForgeDirection side, FzColor fzColor) {
        return false;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            TileEntityCommon.full_rotation_array[i] = ForgeDirection.getOrientation((int)i);
        }
    }
}

