/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.TreecapitatorMod;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import bspkrs.util.config.ConfigCategory;
import bspkrs.util.config.Configuration;
import bspkrs.util.config.Property;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ThirdPartyModConfig {
    private final String modID;
    private List<ItemID> axeList;
    private List<ItemID> shearsList;
    private boolean overrideIMC;
    private Map<String, TreeDefinition> treesMap;
    private boolean isChanged = false;
    private static List<String> orderedKeys = new ArrayList<String>();
    private static Set<String> validKeys = new HashSet<String>();

    protected ThirdPartyModConfig(boolean init) {
        this.modID = "minecraft";
        this.overrideIMC = TCSettings.userConfigOverridesIMC;
        if (init) {
            this.axeList = new ArrayList<ItemID>(ToolRegistry.instance().vanillaAxeList());
            this.shearsList = new ArrayList<ItemID>(ToolRegistry.instance().vanillaShearsList());
            this.treesMap = TreeRegistry.instance().vanillaTrees();
        } else {
            this.axeList = new ArrayList<ItemID>();
            this.shearsList = new ArrayList<ItemID>();
            this.treesMap = new TreeMap<String, TreeDefinition>();
        }
    }

    protected ThirdPartyModConfig() {
        this(true);
    }

    protected ThirdPartyModConfig(String modID) {
        this.modID = modID;
        this.overrideIMC = TCSettings.userConfigOverridesIMC;
        this.axeList = new ArrayList<ItemID>();
        this.shearsList = new ArrayList<ItemID>();
        this.treesMap = new TreeMap<String, TreeDefinition>();
    }

    public void merge(ThirdPartyModConfig toMerge) {
        if (!this.modID.equals(toMerge.modID)) {
            throw new IllegalArgumentException(String.format("Cannot merge ThirdPartyModConfig objects with different modID values! this.modID: %s  toMerge.modID: %s", this.modID, toMerge.modID));
        }
        this.overrideIMC = this.overrideIMC || toMerge.overrideIMC;
        for (ItemID itemID : toMerge.axeList) {
            if (this.axeList.contains(itemID)) continue;
            this.axeList.add(itemID);
        }
        for (ItemID itemID : toMerge.shearsList) {
            if (this.shearsList.contains(itemID)) continue;
            this.shearsList.add(itemID);
        }
        for (Map.Entry entry : toMerge.treesMap.entrySet()) {
            if (this.treesMap.containsKey(entry.getKey())) {
                this.treesMap.get(entry.getKey()).appendWithSettings((TreeDefinition)entry.getValue());
                continue;
            }
            for (Map.Entry<String, TreeDefinition> entry2 : this.treesMap.entrySet()) {
                if (!((TreeDefinition)entry.getValue()).hasCommonLog(entry2.getValue())) continue;
                entry2.getValue().appendWithSettings((TreeDefinition)entry.getValue());
            }
            this.treesMap.put((String)entry.getKey(), (TreeDefinition)entry.getValue());
        }
        this.isChanged = true;
    }

    public static boolean isValidNBT(NBTTagCompound tpModCfg) {
        for (String s : tpModCfg.func_150296_c()) {
            if (validKeys.contains(s)) continue;
            TCLog.warning("Unknown tag \"%s\" found while verifying a ThirdPartyModConfig NBTTagCompound object", s);
        }
        if (!tpModCfg.func_74764_b("modID")) {
            TCLog.severe("ThirdPartyModConfig NBTTagCompound objects must contain a string tag with the key \"%s\"", "modID");
            return false;
        }
        if (tpModCfg.func_74764_b("trees")) {
            NBTTagList treeList = tpModCfg.func_150295_c("trees", 10);
            for (int i = 0; i < treeList.func_74745_c(); ++i) {
                if (TreeDefinition.isValidNBT(treeList.func_150305_b(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static ThirdPartyModConfig readFromNBT(NBTTagCompound tpModCfg) {
        ThirdPartyModConfig tpmc = new ThirdPartyModConfig(tpModCfg.func_74779_i("modID"));
        if (tpModCfg.func_74764_b("axeIDList")) {
            for (ItemID itemID : ListUtils.getDelimitedStringAsItemIDList((String)tpModCfg.func_74779_i("axeIDList"), (String)";")) {
                tpmc.addAxe(itemID);
            }
        }
        if (tpModCfg.func_74764_b("shearsIDList")) {
            for (ItemID itemID : ListUtils.getDelimitedStringAsItemIDList((String)tpModCfg.func_74779_i("shearsIDList"), (String)";")) {
                tpmc.addShears(itemID);
            }
        }
        if (tpModCfg.func_74764_b("trees")) {
            NBTTagList treeList = tpModCfg.func_150295_c("trees", 10);
            for (int i = 0; i < treeList.func_74745_c(); ++i) {
                NBTTagCompound tree = treeList.func_150305_b(i);
                tpmc.addTreeDef(tree.func_74779_i("treeName"), new TreeDefinition(tree));
            }
        }
        tpmc.isChanged = true;
        return tpmc;
    }

    public void writeToNBT(NBTTagCompound tpModCfg) {
        tpModCfg.func_74778_a("modID", this.modID);
        if (this.axeList.size() > 0) {
            tpModCfg.func_74778_a("axeIDList", ListUtils.getListAsDelimitedString(this.axeList, (String)"; "));
        }
        if (this.shearsList.size() > 0) {
            tpModCfg.func_74778_a("shearsIDList", ListUtils.getListAsDelimitedString(this.shearsList, (String)"; "));
        }
        NBTTagList treeList = new NBTTagList();
        for (Map.Entry<String, TreeDefinition> e : this.treesMap.entrySet()) {
            NBTTagCompound tree = new NBTTagCompound();
            e.getValue().writeToNBT(tree);
            tree.func_74778_a("treeName", e.getKey());
            treeList.func_74742_a((NBTBase)tree);
        }
        tpModCfg.func_74782_a("trees", (NBTBase)treeList);
    }

    public static ThirdPartyModConfig readFromConfiguration(Configuration config, String category) {
        ConfigCategory cc = config.getCategory(category);
        ThirdPartyModConfig tpmc = new ThirdPartyModConfig(config.get(category, "modID", "minecraft", (String)null, Property.Type.MOD_ID).setPropLanguageKey("bspkrs.tc.configgui.modID").getString());
        if (cc.containsKey("axeIDList")) {
            for (ItemID itemID : ListUtils.getDelimitedStringAsItemIDList((String)cc.get("axeIDList").setPropLanguageKey("bspkrs.tc.configgui.axeIDList").getString(), (String)";")) {
                tpmc.addAxe(itemID);
            }
        }
        if (cc.containsKey("shearsIDList")) {
            for (ItemID itemID : ListUtils.getDelimitedStringAsItemIDList((String)cc.get("shearsIDList").setPropLanguageKey("bspkrs.tc.configgui.shearsIDList").getString(), (String)";")) {
                tpmc.addShears(itemID);
            }
        }
        tpmc.overrideIMC = config.getBoolean("overrideIMC", category, TCSettings.userConfigOverridesIMC, "This setting controls whether or not the mod config section it appears in will override an IMC message sent by that mod.", "bspkrs.tc.configgui.overrideIMC");
        TreecapitatorMod.proxy.addGuiConfigCustomCategoryListEntry(config, category);
        cc.setPropertyOrder(orderedKeys);
        for (ConfigCategory ctgy : cc.getChildren()) {
            tpmc.addTreeDef(ctgy.getName(), new TreeDefinition(config, ctgy.getQualifiedName()));
        }
        return tpmc;
    }

    public void writeToConfiguration(Configuration config, String category) {
        config.get(category, "modID", this.modID, (String)null, Property.Type.MOD_ID).setPropLanguageKey("bspkrs.tc.configgui.modID");
        config.get(category, "axeIDList", ListUtils.getListAsDelimitedString(this.axeList, (String)"; ")).setPropLanguageKey("bspkrs.tc.configgui.axeIDList");
        config.get(category, "shearsIDList", ListUtils.getListAsDelimitedString(this.shearsList, (String)"; ")).setPropLanguageKey("bspkrs.tc.configgui.shearsIDList");
        config.getBoolean("overrideIMC", category, this.overrideIMC, "This setting controls whether or not the mod config section it appears in will override an IMC message sent by that mod.", "bspkrs.tc.configgui.overrideIMC");
        for (Map.Entry<String, TreeDefinition> e : this.treesMap.entrySet()) {
            if (!e.getKey().startsWith(category)) {
                e.getValue().writeToConfiguration(config, category + "." + e.getKey());
                continue;
            }
            e.getValue().writeToConfiguration(config, e.getKey());
        }
        TreecapitatorMod.proxy.addGuiConfigCustomCategoryListEntry(config, category);
        config.setCategoryPropertyOrder(category, orderedKeys);
        this.isChanged = false;
    }

    public ThirdPartyModConfig addTreeDef(String key, TreeDefinition tree) {
        if (!this.treesMap.containsKey(key)) {
            this.treesMap.put(key, tree);
        } else {
            this.treesMap.get(key).appendWithSettings(tree);
        }
        this.isChanged = true;
        return this;
    }

    public ThirdPartyModConfig addAxe(ItemID axe) {
        if (!this.axeList.contains(axe)) {
            this.axeList.add(axe);
        }
        this.isChanged = true;
        return this;
    }

    public ThirdPartyModConfig addShears(ItemID shears) {
        if (!this.shearsList.contains(shears)) {
            this.shearsList.add(shears);
        }
        this.isChanged = true;
        return this;
    }

    public ThirdPartyModConfig registerTrees() {
        for (Map.Entry<String, TreeDefinition> e : this.treesMap.entrySet()) {
            TreeRegistry.instance().registerTree(e.getKey(), e.getValue());
        }
        return this;
    }

    public ThirdPartyModConfig registerTools() {
        for (ItemID axe : this.axeList) {
            if (axe.id.trim().isEmpty()) continue;
            ToolRegistry.instance().registerAxe(axe);
        }
        for (ItemID shears : this.shearsList) {
            if (shears.id.trim().isEmpty()) continue;
            ToolRegistry.instance().registerShears(shears);
        }
        return this;
    }

    public String modID() {
        return this.modID;
    }

    public boolean overrideIMC() {
        return this.overrideIMC;
    }

    public ThirdPartyModConfig setOverrideIMC(boolean bol) {
        this.overrideIMC = bol;
        return this;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    static {
        orderedKeys.add("modID");
        orderedKeys.add("axeIDList");
        orderedKeys.add("shearsIDList");
        orderedKeys.add("overrideIMC");
        validKeys.add("modID");
        validKeys.add("axeIDList");
        validKeys.add("shearsIDList");
        validKeys.add("overrideIMC");
    }
}

