/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.theme;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.segment.ISegment;
import greymerk.roguelike.catacomb.segment.Segment;
import greymerk.roguelike.catacomb.theme.IBlockSet;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class ThemeBase
implements ITheme {
    protected IBlockSet walls;
    protected IBlockSet decor;
    protected List<Segment> segments;
    protected Segment arch;

    public ThemeBase(IBlockSet walls, IBlockSet decor, List<Segment> segments, Segment arch) {
        this.walls = walls;
        this.decor = decor;
        this.segments = segments;
        this.arch = arch;
    }

    public ThemeBase(ThemeBase base, IBlockSet walls, IBlockSet decor, List<Segment> segments, Segment arch) {
        this.walls = walls == null ? base.walls : walls;
        this.decor = decor == null ? base.decor : decor;
        this.segments = segments == null ? base.segments : segments;
        this.arch = arch == null ? base.arch : arch;
    }

    public ThemeBase() {
    }

    @Override
    public IBlockFactory getPrimaryWall() {
        return this.walls.getFill();
    }

    @Override
    public MetaBlock getPrimaryStair() {
        return this.walls.getStair();
    }

    @Override
    public IBlockFactory getPrimaryPillar() {
        return this.walls.getPillar();
    }

    @Override
    public IBlockFactory getSecondaryPillar() {
        return this.decor.getPillar();
    }

    @Override
    public IBlockFactory getSecondaryWall() {
        return this.decor.getFill();
    }

    @Override
    public MetaBlock getSecondaryStair() {
        return this.decor.getStair();
    }

    @Override
    public void genSegment(World world, Random rand, CatacombLevel level, Cardinal dir, Coord pos) {
        ISegment seg = this.pickSegment(world, rand, level, dir, pos);
        if (seg == null) {
            return;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        seg.generate(world, rand, level, dir, this, x, y, z);
    }

    private ISegment pickSegment(World world, Random rand, CatacombLevel level, Cardinal dir, Coord pos) {
        int x = pos.getX();
        int z = pos.getZ();
        if ((dir == Cardinal.NORTH || dir == Cardinal.SOUTH) && z % 3 == 0) {
            if (z % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return Segment.getSegment(this.segments.get(rand.nextInt(this.segments.size())));
        }
        if ((dir == Cardinal.WEST || dir == Cardinal.EAST) && x % 3 == 0) {
            if (x % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return Segment.getSegment(this.segments.get(rand.nextInt(this.segments.size())));
        }
        return null;
    }
}

