/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.InventorySlot;
import greymerk.roguelike.treasure.TreasureChestBase;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Iterator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityChest;

public class TreasureChestStarter
extends TreasureChestBase {
    private ItemStack getStarterLoot(int choice) {
        switch (choice) {
            case 4: {
                return new ItemStack(Items.field_151050_s);
            }
            case 3: {
                return new ItemStack(Items.field_151052_q);
            }
            case 2: {
                return Loot.getLoot(Loot.FOOD, this.rand, 0);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(Equipment.LEGS, this.rand, Quality.WOOD);
            }
        }
        return new ItemStack(Blocks.field_150478_aa, 1 + this.rand.nextInt(RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 7 : 3));
    }

    @Override
    protected void fillChest(TileEntityChest chest, int level) {
        int quantity = RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 15 : 5;
        Iterator<InventorySlot> itr = this.iterator();
        for (int i = 0; i < quantity; ++i) {
            ItemStack item = this.getStarterLoot(i % 5);
            if (!itr.hasNext()) continue;
            itr.next().set(item);
        }
        if (itr.hasNext()) {
            itr.next().set(this.book());
        }
    }

    private ItemStack book() {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        book.func_77983_a("author", (NBTBase)new NBTTagString("greymerk"));
        book.func_77983_a("title", (NBTBase)new NBTTagString("Memo"));
        String page1 = "Dear Eniko,\n\n Please stop storing the TNT under the floor, it's not very safe. One of these days there's going to be an accident and we'll be left with a smoking crater in the middle of the base.\n\n-greymerk\n";
        String page2 = "Roguelike Dungeons v1.3.4\nJune 29th 2014\n\nCredits\n\nAuthor: Greymerk\n\nBits: Drainedsoul\n\nIdeas: Eniko @enichan";
        NBTTagList pages = new NBTTagList();
        pages.func_74742_a((NBTBase)new NBTTagString(page1));
        pages.func_74742_a((NBTBase)new NBTTagString(page2));
        book.func_77983_a("pages", (NBTBase)pages);
        return book;
    }
}

