/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockFactory;
import greymerk.roguelike.worldgen.IBlockFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class BlockStripes
implements IBlockFactory {
    private List<IBlockFactory> blocks = new ArrayList<IBlockFactory>();

    public BlockStripes() {
    }

    public BlockStripes(JsonElement data) throws Exception {
        this();
        for (JsonElement entry : (JsonArray)data) {
            JsonObject d = entry.getAsJsonObject();
            String type = d.get("type").getAsString();
            JsonElement blockJson = d.get("data");
            IBlockFactory toAdd = BlockFactory.create(type, blockJson);
            this.addBlock(toAdd);
        }
    }

    public void addBlock(IBlockFactory toAdd) {
        this.blocks.add(toAdd);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z) {
        this.setBlock(world, rand, x, y, z, true, true);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z, boolean fillAir, boolean replaceSolid) {
        int size = this.blocks.size();
        int choice = (x % size + y % size + z % size) % size;
        IBlockFactory block = this.blocks.get(choice);
        block.setBlock(world, rand, x, y, z, fillAir, replaceSolid);
    }
}

