/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.eydamos.backpack.handler.EventHandlerRenderPlayer;
import de.eydamos.backpack.saves.PlayerSave;
import de.eydamos.backpack.util.BackpackUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class MessagePersonalBackpack
implements IMessage,
IMessageHandler<MessagePersonalBackpack, IMessage> {
    protected String playerUUID = "";
    protected int backpackDamage = -1;

    public MessagePersonalBackpack() {
    }

    public MessagePersonalBackpack(String UUID2) {
        this.playerUUID = UUID2;
    }

    public MessagePersonalBackpack(String UUID2, int damage) {
        this.playerUUID = UUID2;
        this.backpackDamage = damage;
    }

    public void fromBytes(ByteBuf buffer) {
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.backpackDamage = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerUUID);
        buffer.writeInt(this.backpackDamage);
    }

    public IMessage onMessage(MessagePersonalBackpack message, MessageContext ctx) {
        MessagePersonalBackpack returnMessage = null;
        if (BackpackUtil.isServerSide()) {
            PlayerSave playerSave = new PlayerSave(message.playerUUID);
            ItemStack backpack = playerSave.getPersonalBackpack();
            returnMessage = backpack != null ? new MessagePersonalBackpack(message.playerUUID, backpack.func_77960_j()) : new MessagePersonalBackpack(message.playerUUID);
        } else {
            EventHandlerRenderPlayer.backpackDamage.put(message.playerUUID, message.backpackDamage);
        }
        return returnMessage;
    }
}

