/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockAndMeta;
import assets.generator.BlockExtended;
import assets.generator.BlockProperties;
import assets.generator.PlacedBlock;
import assets.generator.PopulatorWalledCity;
import assets.generator.TemplateRule;
import assets.generator.WorldGenWalledCity;
import assets.generator.WorldGeneratorThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockVine;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Building {
    public static final int HIT_WATER = -666;
    public static final String EASY_CHEST = "EASY";
    public static final String MEDIUM_CHEST = "MEDIUM";
    public static final String HARD_CHEST = "HARD";
    public static final String TOWER_CHEST = "TOWER";
    public static final int DIR_NORTH = 0;
    public static final int DIR_EAST = 1;
    public static final int DIR_SOUTH = 2;
    public static final int DIR_WEST = 3;
    public static final int ROT_R = 1;
    public static final int R_HAND = 1;
    public static final int L_HAND = -1;
    public static final int SEA_LEVEL = 63;
    public static final int WORLD_MAX_Y = 255;
    protected final World world;
    protected final Random random;
    protected TemplateRule bRule;
    public int bWidth;
    public int bHeight;
    public int bLength;
    public final int bID;
    private final LinkedList<PlacedBlock> delayedBuildQueue;
    protected final WorldGeneratorThread wgt;
    protected boolean centerAligned;
    protected int i0;
    protected int j0;
    protected int k0;
    private int xI;
    private int yI;
    private int xK;
    private int yK;
    protected int bHand;
    protected int bDir;
    public static final int IGNORE_WATER = -1;
    public static final int PAINTING_BLOCK_OFFSET = 3;
    public static final String[] SPAWNERS = new String[]{"Zombie", "Skeleton", "Spider", "Creeper", "PigZombie", "Ghast", "Enderman", "CaveSpider", "Blaze", "Slime", "LavaSlime", "Villager", "SnowMan", "MushroomCow", "Sheep", "Cow", "Chicken", "Squid", "Wolf", "Giant", "Silverfish", "EnderDragon", "Ozelot", "VillagerGolem", "WitherBoss", "Bat", "Witch"};
    public static final int[] BED_META_TO_DIR = new int[]{2, 3, 0, 1};
    public static final int[] STAIRS_META_TO_DIR = new int[]{1, 3, 2, 0};
    public static final int[] LADDER_META_TO_DIR = new int[]{0, 2, 3, 1};
    public static final int[] TRAPDOOR_META_TO_DIR = new int[]{2, 0, 1, 3};
    public static final int[] VINES_META_TO_DIR = new int[]{0, 2, 3, 0, 0, 0, 0, 0, 1};
    public static final int[] DOOR_META_TO_DIR = new int[]{3, 0, 1, 2};
    public static final int[] BED_DIR_TO_META = new int[]{2, 3, 0, 1};
    public static final int[] BUTTON_DIR_TO_META = new int[]{4, 1, 3, 2};
    public static final int[] STAIRS_DIR_TO_META = new int[]{3, 0, 2, 1};
    public static final int[] LADDER_DIR_TO_META = new int[]{2, 5, 3, 4};
    public static final int[] TRAPDOOR_DIR_TO_META = new int[]{1, 2, 0, 3};
    public static final int[] VINES_DIR_TO_META = new int[]{4, 8, 1, 2};
    public static final int[] DOOR_DIR_TO_META = new int[]{3, 0, 1, 2};
    public static final int[] PAINTING_DIR_TO_FACEDIR = new int[]{0, 3, 2, 1};
    public static final int[] DIR_TO_I = new int[]{0, 1, 0, -1};
    public static final int[] DIR_TO_K = new int[]{-1, 0, 1, 0};
    public static final int[] DIR_TO_X = new int[]{0, 1, 0, -1};
    public static final int[] DIR_TO_Y = new int[]{1, 0, -1, 0};
    public static final BlockAndMeta WEST_FACE_TORCH_BLOCK = new BlockAndMeta(Blocks.field_150478_aa, BUTTON_DIR_TO_META[3]);
    public static final BlockAndMeta EAST_FACE_TORCH_BLOCK = new BlockAndMeta(Blocks.field_150478_aa, BUTTON_DIR_TO_META[1]);
    public static final BlockAndMeta NORTH_FACE_TORCH_BLOCK = new BlockAndMeta(Blocks.field_150478_aa, BUTTON_DIR_TO_META[0]);
    public static final BlockAndMeta SOUTH_FACE_TORCH_BLOCK = new BlockAndMeta(Blocks.field_150478_aa, BUTTON_DIR_TO_META[2]);
    public static final BlockAndMeta EAST_FACE_LADDER_BLOCK = new BlockAndMeta(Blocks.field_150468_ap, LADDER_DIR_TO_META[1]);
    public static final BlockAndMeta HOLE_BLOCK_LIGHTING = new BlockAndMeta(Blocks.field_150350_a, 0);
    public static final BlockAndMeta HOLE_BLOCK_NO_LIGHTING = new BlockAndMeta(Blocks.field_150350_a, 1);
    public static final BlockAndMeta PRESERVE_BLOCK = new BlockExtended(Blocks.field_150350_a, 0, "PRESERVE");
    public static final BlockAndMeta TOWER_CHEST_BLOCK = new BlockExtended((Block)Blocks.field_150486_ae, 0, "TOWER");
    public static final BlockAndMeta HARD_CHEST_BLOCK = new BlockExtended((Block)Blocks.field_150486_ae, 0, "HARD");
    public static final BlockAndMeta GHAST_SPAWNER = new BlockExtended(Blocks.field_150474_ac, 0, "Ghast");
    public static final int MAX_SPHERE_DIAM = 40;
    public static final int[][] SPHERE_SHAPE = new int[41][];
    public static final int[][][] CIRCLE_SHAPE = new int[41][][];
    public static final int[][][] CIRCLE_CRENEL = new int[41][][];
    private static final int LIGHTING_INVERSE_DENSITY = 10;
    private static final boolean[] randLightingHash;
    public static final String[] CHEST_TYPE_LABELS;
    public static final int[] DEFAULT_CHEST_TRIES;
    public static final Object[][][] DEFAULT_CHEST_ITEMS;

    public Building(int ID_, WorldGeneratorThread wgt_, TemplateRule buildingRule_, int dir_, int axXHand_, boolean centerAligned_, int[] dim, int[] alignPt) {
        this.bID = ID_;
        this.wgt = wgt_;
        this.world = this.wgt.world;
        this.bRule = buildingRule_;
        if (this.bRule == null) {
            this.bRule = TemplateRule.STONE_RULE;
        }
        this.bWidth = dim[0];
        this.bHeight = dim[1];
        this.bLength = dim[2];
        this.random = this.wgt.random;
        this.bHand = axXHand_;
        this.centerAligned = centerAligned_;
        this.setPrimaryAx(dir_);
        if (alignPt != null && alignPt.length == 3) {
            if (this.centerAligned) {
                this.setOrigin(alignPt[0] - this.xI * this.bWidth / 2, alignPt[1], alignPt[2] - this.xK * this.bWidth / 2);
            } else {
                this.setOrigin(alignPt[0], alignPt[1], alignPt[2]);
            }
        }
        this.delayedBuildQueue = new LinkedList();
    }

    public final int getI(int x, int y) {
        return this.i0 + this.yI * y + this.xI * x;
    }

    public final int[] getIJKPt(int x, int z, int y) {
        int[] pt = new int[]{this.i0 + this.yI * y + this.xI * x, this.j0 + z, this.k0 + this.yK * y + this.xK * x};
        return pt;
    }

    public final int getJ(int z) {
        return this.j0 + z;
    }

    public final int getK(int x, int y) {
        return this.k0 + this.yK * y + this.xK * x;
    }

    public final int[] getSurfaceIJKPt(int x, int y, int j, boolean wallIsSurface, int waterSurfaceBuffer) {
        int[] pt = this.getIJKPt(x, 0, y);
        pt[1] = Building.findSurfaceJ(this.world, pt[0], pt[2], j, wallIsSurface, waterSurfaceBuffer);
        return pt;
    }

    public final int getX(int[] pt) {
        return this.xI * (pt[0] - this.i0) + this.xK * (pt[2] - this.k0);
    }

    public final int getY(int[] pt) {
        return this.yI * (pt[0] - this.i0) + this.yK * (pt[2] - this.k0);
    }

    public final int getZ(int[] pt) {
        return pt[1] - this.j0;
    }

    public final String localCoordString(int x, int z, int y) {
        int[] pt = this.getIJKPt(x, z, y);
        return "(" + pt[0] + "," + pt[1] + "," + pt[2] + ")";
    }

    public int orientDirToBDir(int dir) {
        return this.bHand < 0 && dir % 2 == 1 ? this.bDir + dir + 2 & 3 : this.bDir + dir & 3;
    }

    public void setPainting(int[] pt, int metadata) {
        int dir = this.orientDirToBDir(LADDER_META_TO_DIR[metadata]);
        pt[0] = pt[0] - DIR_TO_I[dir];
        pt[2] = pt[2] - DIR_TO_K[dir];
        if (dir == 0) {
            pt[2] = pt[2] + 1;
        } else if (dir == 2) {
            pt[2] = pt[2] - 1;
        } else {
            pt[0] = dir == 3 ? pt[0] + 1 : pt[0] - 1;
        }
        EntityPainting entitypainting = new EntityPainting(this.world, pt[0], pt[1], pt[2], PAINTING_DIR_TO_FACEDIR[dir]);
        if (!this.world.field_72995_K && entitypainting.func_70518_d()) {
            this.world.func_72838_d((Entity)entitypainting);
        }
    }

    public void setPrimaryAx(int dir_) {
        this.bDir = dir_;
        switch (this.bDir) {
            case 0: {
                this.xI = this.bHand;
                this.yI = 0;
                this.xK = 0;
                this.yK = -1;
                break;
            }
            case 1: {
                this.xI = 0;
                this.yI = 1;
                this.xK = this.bHand;
                this.yK = 0;
                break;
            }
            case 2: {
                this.xI = -this.bHand;
                this.yI = 0;
                this.xK = 0;
                this.yK = 1;
                break;
            }
            case 3: {
                this.xI = 0;
                this.yI = -1;
                this.xK = -this.bHand;
                this.yK = 0;
            }
        }
    }

    public void setSignOrPost(int x2, int z2, int y2, boolean post, int sDir, String[] lines) {
        int[] pt = this.getIJKPt(x2, z2, y2);
        this.world.func_147465_d(pt[0], pt[1], pt[2], post ? Blocks.field_150472_an : Blocks.field_150444_as, sDir, 2);
        TileEntitySign tileentitysign = (TileEntitySign)this.world.func_147438_o(pt[0], pt[1], pt[2]);
        if (tileentitysign == null) {
            return;
        }
        System.arraycopy(lines, 0, tileentitysign.field_145915_a, 0, Math.min(lines.length, 4));
    }

    public void buildDown(int x, int z, int y, TemplateRule buildRule, int maxDepth, int foundationDepth, int reserveDepth) {
        int stopZ;
        for (stopZ = z; stopZ > z - maxDepth && this.isWallable(x, stopZ, y); --stopZ) {
        }
        stopZ = stopZ == z - maxDepth && this.isWallable(x, z - maxDepth, y) ? z - reserveDepth : (stopZ -= foundationDepth);
        for (int z1 = z; z1 > stopZ; --z1) {
            this.setBlockWithLightingLocal(x, z1, y, buildRule, false);
        }
    }

    protected final Block getBlockIdLocal(int x, int z, int y) {
        return this.world.func_147439_a(this.i0 + this.yI * y + this.xI * x, this.j0 + z, this.k0 + this.yK * y + this.xK * x);
    }

    protected final int getBlockMetadataLocal(int x, int z, int y) {
        return this.world.func_72805_g(this.i0 + this.yI * y + this.xI * x, this.j0 + z, this.k0 + this.yK * y + this.xK * x);
    }

    protected final String IDString() {
        String str = "ID=" + this.bID + " axes(Y,X)=";
        switch (this.bDir) {
            case 2: {
                return str + "(S," + (this.bHand > 0 ? "W)" : "E)");
            }
            case 0: {
                return str + "(N," + (this.bHand > 0 ? "E)" : "W)");
            }
            case 3: {
                return str + "(W," + (this.bHand > 0 ? "N)" : "S)");
            }
            case 1: {
                return str + "(E," + (this.bHand > 0 ? "S)" : "N)");
            }
        }
        return "Error - bad dir value for ID=" + this.bID;
    }

    protected final boolean isArtificialWallBlock(int x, int z, int y) {
        Block blockId = this.getBlockIdLocal(x, z, y);
        return BlockProperties.get((Block)blockId).isArtificial && (blockId != Blocks.field_150322_A || this.getBlockIdLocal(x, z + 1, y) != Blocks.field_150354_m && this.getBlockIdLocal(x, z + 2, y) != Blocks.field_150354_m);
    }

    protected final boolean isDoorway(int x, int z, int y) {
        return this.isFloor(x, z, y) && (this.isWallBlock(x + 1, z, y) && this.isWallBlock(x - 1, z, y) || this.isWallBlock(x, z, y + 1) && this.isWallBlock(x - 1, z, y - 1));
    }

    protected final boolean hasNoDoorway(int x, int z, int y) {
        return !this.isDoorway(x - 1, z, y) && !this.isDoorway(x + 1, z, y) && !this.isDoorway(x, z, y - 1) && !this.isDoorway(x - 1, z, y + 1);
    }

    protected boolean isObstructedFrame(int zstart, int ybuffer) {
        for (int z1 = zstart; z1 < this.bHeight; ++z1) {
            for (int x1 = 0; x1 < this.bWidth; ++x1) {
                if (!this.isArtificialWallBlock(x1, z1, this.bLength - 1)) continue;
                return true;
            }
            for (int y1 = ybuffer; y1 < this.bLength - 1; ++y1) {
                if (this.isArtificialWallBlock(0, z1, y1)) {
                    return true;
                }
                if (!this.isArtificialWallBlock(this.bWidth - 1, z1, y1)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isObstructedSolid(int[] pt1, int[] pt2) {
        for (int x1 = pt1[0]; x1 <= pt2[0]; ++x1) {
            for (int z1 = pt1[1]; z1 <= pt2[1]; ++z1) {
                for (int y1 = pt1[2]; y1 <= pt2[2]; ++y1) {
                    if (this.isWallable(x1, z1, y1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected final boolean isFloor(int x, int z, int y) {
        Block blkId1 = this.getBlockIdLocal(x, z, y);
        Block blkId2 = this.getBlockIdLocal(x, z - 1, y);
        return blkId1 == Blocks.field_150350_a && BlockProperties.get((Block)blkId2).isArtificial && blkId2 != Blocks.field_150468_ap;
    }

    protected final boolean isStairBlock(int x, int z, int y) {
        Block blkId = this.getBlockIdLocal(x, z, y);
        return blkId == Blocks.field_150333_U || BlockProperties.get((Block)blkId).isStair;
    }

    protected final boolean isWallable(int x, int z, int y) {
        return BlockProperties.get((Block)this.world.func_147439_a((int)(this.i0 + this.yI * y + this.xI * x), (int)(this.j0 + z), (int)(this.k0 + this.yK * y + this.xK * x))).isWallable;
    }

    protected final boolean isWallableIJK(int[] pt) {
        return pt != null && BlockProperties.get((Block)this.world.func_147439_a((int)pt[0], (int)pt[1], (int)pt[2])).isWallable;
    }

    protected final boolean isWallBlock(int x, int z, int y) {
        return BlockProperties.get((Block)this.world.func_147439_a((int)(this.i0 + this.yI * y + this.xI * x), (int)(this.j0 + z), (int)(this.k0 + this.yK * y + this.xK * x))).isArtificial;
    }

    public final void flushDelayed() {
        while (this.delayedBuildQueue.size() > 0) {
            PlacedBlock block = this.delayedBuildQueue.poll();
            this.setDelayed(block.get(), block.x, block.y, block.z, block.getMeta());
        }
    }

    protected void setDelayed(Block blc, int ... block) {
        if (BlockProperties.get((Block)blc).isStair) {
            BlockAndMeta temp = this.getDelayedStair(blc, block);
            blc = temp.get();
            block[3] = temp.getMeta();
        } else if (blc instanceof BlockVine) {
            if (block[3] == 0 && !Building.isSolidBlock(this.world.func_147439_a(block[0], block[1] + 1, block[2]))) {
                block[3] = 1;
            }
            if (block[3] != 0) {
                int dir = VINES_META_TO_DIR[block[3]];
                while (!Building.isSolidBlock(this.world.func_147439_a(block[0] + DIR_TO_I[dir], block[1], block[2] + DIR_TO_K[dir]))) {
                    if ((dir = (dir + 1) % 4) != VINES_META_TO_DIR[block[3]]) continue;
                    if (Building.isSolidBlock(this.world.func_147439_a(block[0], block[1] + 1, block[2]))) {
                        dir = -1;
                        break;
                    }
                    return;
                }
                int n = block[4] = dir == -1 ? 0 : VINES_DIR_TO_META[dir];
            }
        }
        if (blc == Blocks.field_150350_a && block[3] >= 3) {
            this.setPainting(block, block[3] - 3);
        } else if (blc == Blocks.field_150478_aa) {
            if (Blocks.field_150478_aa.func_149742_c(this.world, block[0], block[1], block[2])) {
                this.world.func_147465_d(block[0], block[1], block[2], blc, block[3], 3);
            }
        } else if (blc == Blocks.field_150426_aN) {
            this.world.func_147465_d(block[0], block[1], block[2], blc, block[3], 3);
        } else if (blc != null) {
            if (randLightingHash[block[0] & 7 | block[1] & 0x38 | block[2] & 0x1C0]) {
                this.world.func_147465_d(block[0], block[1], block[2], blc, block[3], 3);
            } else {
                Building.setBlockAndMetaNoLighting(this.world, block[0], block[1], block[2], blc, block[3]);
            }
        }
    }

    protected BlockAndMeta getDelayedStair(Block blc, int ... block) {
        int dirX = block[0] - DIR_TO_I[STAIRS_META_TO_DIR[block[3] % 4]];
        int dirZ = block[2] - DIR_TO_K[STAIRS_META_TO_DIR[block[3] % 4]];
        if (this.world.func_72976_f(dirX, dirZ) > block[1]) {
            Block adjId = this.world.func_147439_a(dirX, block[1], dirZ);
            Block aboveID = this.world.func_147439_a(block[0], block[1] + 1, block[2]);
            if (BlockProperties.get((Block)aboveID).isGround && BlockProperties.get((Block)adjId).isGround) {
                return new BlockAndMeta(blc, block[3]).stairToSolid();
            }
            if (!BlockProperties.get((Block)adjId).isWallable || !BlockProperties.get((Block)aboveID).isWallable) {
                return new BlockAndMeta(null, 0);
            }
        }
        return new BlockAndMeta(blc, block[3]);
    }

    protected final void recenterFromOldWidth(int oldWidth) {
        this.i0 += this.xI * (oldWidth - this.bWidth) / 2;
        this.k0 += this.xK * (oldWidth - this.bWidth) / 2;
    }

    protected final void setBlockLocal(int x, int z, int y, Block blockID) {
        this.setBlockLocal(x, z, y, blockID, 0);
    }

    protected final void setBlockLocal(int x, int z, int y, Block blockID, int metadata) {
        int[] pt = this.getIJKPt(x, z, y);
        if (blockID == Blocks.field_150350_a && this.world.func_147437_c(pt[0], pt[1], pt[2])) {
            return;
        }
        if (!(blockID instanceof BlockChest)) {
            this.emptyIfChest(pt);
        }
        if (BlockProperties.get((Block)blockID).isDelayed) {
            this.delayedBuildQueue.offer(new PlacedBlock(blockID, new int[]{pt[0], pt[1], pt[2], this.rotateMetadata(blockID, metadata)}));
        } else if (randLightingHash[x & 7 | y & 0x38 | z & 0x1C0]) {
            this.world.func_147465_d(pt[0], pt[1], pt[2], blockID, this.rotateMetadata(blockID, metadata), 2);
        } else {
            Building.setBlockAndMetaNoLighting(this.world, pt[0], pt[1], pt[2], blockID, this.rotateMetadata(blockID, metadata));
        }
        if (BlockProperties.get((Block)blockID).isDoor) {
            this.addDoorToNewListIfAppropriate(pt[0], pt[1], pt[2]);
        }
    }

    protected final void setBlockLocal(int x, int z, int y, BlockAndMeta block) {
        if (block instanceof BlockExtended) {
            this.setSpecialBlockLocal(x, z, y, block.get(), block.getMeta(), ((BlockExtended)block).info);
        } else {
            this.setBlockLocal(x, z, y, block.get(), block.getMeta());
        }
    }

    protected final void setBlockLocal(int x, int z, int y, TemplateRule rule) {
        this.setBlockLocal(x, z, y, rule.getBlockOrHole(this.random));
    }

    protected final void setBlockWithLightingLocal(int x, int z, int y, TemplateRule rule, boolean lighting) {
        this.setBlockWithLightingLocal(x, z, y, rule.getBlockOrHole(this.random), lighting);
    }

    protected final void removeBlockWithLighting(int x, int z, int y) {
        this.setBlockWithLightingLocal(x, z, y, TemplateRule.AIR_RULE, true);
    }

    protected final void setBlockWithLightingLocal(int x, int z, int y, BlockAndMeta block, boolean lighting) {
        if (block instanceof BlockExtended) {
            this.setSpecialBlockLocal(x, z, y, block.get(), block.getMeta(), ((BlockExtended)block).info);
        } else {
            this.setBlockWithLightingLocal(x, z, y, block.get(), block.getMeta(), lighting);
        }
    }

    protected final void setBlockWithLightingLocal(int x, int z, int y, Block blockID, int metadata, boolean lighting) {
        int[] pt = this.getIJKPt(x, z, y);
        if (blockID == Blocks.field_150350_a && this.world.func_147437_c(pt[0], pt[1], pt[2])) {
            return;
        }
        if (!(blockID instanceof BlockChest)) {
            this.emptyIfChest(pt);
        }
        if (BlockProperties.get((Block)blockID).isDelayed) {
            this.delayedBuildQueue.offer(new PlacedBlock(blockID, new int[]{pt[0], pt[1], pt[2], this.rotateMetadata(blockID, metadata)}));
        } else if (lighting) {
            this.world.func_147465_d(pt[0], pt[1], pt[2], blockID, this.rotateMetadata(blockID, metadata), 3);
        } else {
            Building.setBlockAndMetaNoLighting(this.world, pt[0], pt[1], pt[2], blockID, this.rotateMetadata(blockID, metadata));
        }
        if (BlockProperties.get((Block)blockID).isDoor) {
            this.addDoorToNewListIfAppropriate(pt[0], pt[1], pt[2]);
        }
    }

    protected final void setOrigin(int i0_, int j0_, int k0_) {
        this.i0 = i0_;
        this.j0 = j0_;
        this.k0 = k0_;
    }

    protected final void setOriginLocal(int i1, int j1, int k1, int x, int z, int y) {
        this.i0 = i1 + this.yI * y + this.xI * x;
        this.j0 = j1 + z;
        this.k0 = k1 + this.yK * y + this.xK * x;
    }

    protected final void setSpecialBlockLocal(int x, int z, int y, Block blockID, int metadata, String extra) {
        if (extra.equals("PRESERVE")) {
            return;
        }
        int[] pt = this.getIJKPt(x, z, y);
        if (blockID instanceof BlockAir) {
            if (extra.equals("WALL_STAIR") && metadata <= 0) {
                this.world.func_147465_d(pt[0], pt[1], pt[2], (Block)Blocks.field_150333_U, this.rotateMetadata((Block)Blocks.field_150333_U, -metadata), 2);
                return;
            }
            if (extra.equals("PAINTING") && metadata >= 3) {
                this.delayedBuildQueue.offer(new PlacedBlock(blockID, new int[]{pt[0], pt[1], pt[2], metadata}));
                return;
            }
            Block presentBlock = this.world.func_147439_a(pt[0], pt[1], pt[2]);
            if (!(presentBlock.isAir((IBlockAccess)this.world, pt[0], pt[1], pt[2]) || BlockProperties.get((Block)presentBlock).isWater || BlockProperties.get((Block)this.world.func_147439_a((int)(pt[0] - 1), (int)pt[1], (int)pt[2])).isWater || BlockProperties.get((Block)this.world.func_147439_a((int)pt[0], (int)pt[1], (int)(pt[2] - 1))).isWater || BlockProperties.get((Block)this.world.func_147439_a((int)(pt[0] + 1), (int)pt[1], (int)pt[2])).isWater || BlockProperties.get((Block)this.world.func_147439_a((int)pt[0], (int)pt[1], (int)(pt[2] + 1))).isWater || BlockProperties.get((Block)this.world.func_147439_a((int)pt[0], (int)(pt[1] + 1), (int)pt[2])).isWater)) {
                this.world.func_147468_f(pt[0], pt[1], pt[2]);
            }
        } else if (blockID instanceof BlockMobSpawner) {
            this.setMobSpawner(pt, blockID, metadata, extra);
        } else if (blockID instanceof BlockChest) {
            this.setLootChest(pt, blockID, metadata, extra);
        } else {
            this.world.func_147465_d(pt[0], pt[1], pt[2], blockID, metadata, 2);
        }
    }

    private void addDoorToNewListIfAppropriate(int par1, int par2, int par3) {
        int l;
        if (!(this.wgt instanceof WorldGenWalledCity)) {
            return;
        }
        int id = this.getKnownBuilding();
        if (id == -1) {
            ((PopulatorWalledCity)this.wgt.master).cityDoors.put(this.bID, new ArrayList());
            id = this.bID;
        }
        if ((l = ((BlockDoor)Blocks.field_150466_ao).func_150013_e((IBlockAccess)this.world, par1, par2, par3)) != 0 && l != 2) {
            int j1;
            int i1 = 0;
            for (j1 = -5; j1 < 0; ++j1) {
                if (!this.world.func_72937_j(par1, par2, par3 + j1)) continue;
                --i1;
            }
            for (j1 = 1; j1 <= 5; ++j1) {
                if (!this.world.func_72937_j(par1, par2, par3 + j1)) continue;
                ++i1;
            }
            if (i1 != 0) {
                ((PopulatorWalledCity)this.wgt.master).cityDoors.get(id).add(new VillageDoorInfo(par1, par2, par3, 0, i1 > 0 ? -2 : 2, 0));
            }
        } else {
            int j1;
            int i1 = 0;
            for (j1 = -5; j1 < 0; ++j1) {
                if (!this.world.func_72937_j(par1 + j1, par2, par3)) continue;
                --i1;
            }
            for (j1 = 1; j1 <= 5; ++j1) {
                if (!this.world.func_72937_j(par1 + j1, par2, par3)) continue;
                ++i1;
            }
            if (i1 != 0) {
                ((PopulatorWalledCity)this.wgt.master).cityDoors.get(id).add(new VillageDoorInfo(par1, par2, par3, i1 > 0 ? -2 : 2, 0, 0));
            }
        }
    }

    private void emptyIfChest(int[] pt) {
        if (pt != null && this.world.func_147439_a(pt[0], pt[1], pt[2]) instanceof BlockChest) {
            TileEntityChest tileentitychest = (TileEntityChest)this.world.func_147438_o(pt[0], pt[1], pt[2]);
            for (int m = 0; m < tileentitychest.func_70302_i_(); ++m) {
                tileentitychest.func_70299_a(m, null);
            }
        }
    }

    private ItemStack getChestItemstack(String chestType) {
        int idx;
        if (chestType.equals(TOWER_CHEST) && this.random.nextInt(4) == 0) {
            return new ItemStack(this.bRule.primaryBlock.get(), this.random.nextInt(10), this.bRule.primaryBlock.getMeta());
        }
        Object[][] itempool = this.wgt.chestItems.get(chestType);
        Object obj = itempool[1][idx = Building.pickWeightedOption(this.world.field_73012_v, Arrays.asList(itempool[3]), Arrays.asList(itempool[0]))];
        if (obj == null) {
            return null;
        }
        if (obj instanceof Block) {
            if (obj == Blocks.field_150350_a) {
                return null;
            }
            obj = Item.func_150898_a((Block)((Block)obj));
        }
        return new ItemStack((Item)obj, (Integer)Integer.class.cast(itempool[4][idx]) + this.random.nextInt((Integer)Integer.class.cast(itempool[5][idx]) - (Integer)Integer.class.cast(itempool[4][idx]) + 1), ((Integer)Integer.class.cast(itempool[2][idx])).intValue());
    }

    private int getKnownBuilding() {
        Set<Integer> keys = ((PopulatorWalledCity)this.wgt.master).cityDoors.keySet();
        for (int id = this.bID - 3; id < this.bID + 4; ++id) {
            if (!keys.contains(id)) continue;
            return id;
        }
        return -1;
    }

    private int rotateMetadata(Block blockID, int metadata) {
        int tempdata = 0;
        if (BlockProperties.get((Block)blockID).isStair) {
            if (metadata >= 4) {
                tempdata += 4;
                metadata -= 4;
            }
            return STAIRS_DIR_TO_META[this.orientDirToBDir(STAIRS_META_TO_DIR[metadata])] + tempdata;
        }
        if (BlockProperties.get((Block)blockID).isDoor) {
            if (metadata >= 8) {
                return metadata;
            }
            if (metadata >= 4) {
                tempdata += 4;
            }
            return DOOR_DIR_TO_META[this.orientDirToBDir(DOOR_META_TO_DIR[metadata % 4])] + tempdata;
        }
        if (blockID == Blocks.field_150442_at || blockID == Blocks.field_150430_aB || blockID == Blocks.field_150471_bO) {
            if (metadata - 8 > 0) {
                tempdata += 8;
                metadata -= 8;
            }
            if (metadata == 0 || blockID == Blocks.field_150442_at && metadata >= 5) {
                return metadata + tempdata;
            }
            return BUTTON_DIR_TO_META[this.orientDirToBDir(STAIRS_META_TO_DIR[metadata - 1])] + tempdata;
        }
        if (blockID == Blocks.field_150478_aa || blockID == Blocks.field_150429_aA || blockID == Blocks.field_150437_az) {
            if (metadata == 0 || metadata >= 5) {
                return metadata;
            }
            return BUTTON_DIR_TO_META[this.orientDirToBDir(STAIRS_META_TO_DIR[metadata - 1])];
        }
        if (blockID == Blocks.field_150468_ap || blockID == Blocks.field_150367_z || blockID == Blocks.field_150460_al || blockID == Blocks.field_150470_am || blockID == Blocks.field_150444_as || blockID == Blocks.field_150331_J || blockID == Blocks.field_150326_M || blockID == Blocks.field_150486_ae || blockID == Blocks.field_150438_bZ || blockID == Blocks.field_150409_cd) {
            if ((blockID == Blocks.field_150331_J || blockID == Blocks.field_150326_M) && metadata - 8 >= 0) {
                tempdata += 8;
                metadata -= 8;
            }
            if (metadata <= 1) {
                return metadata + tempdata;
            }
            return LADDER_DIR_TO_META[this.orientDirToBDir(LADDER_META_TO_DIR[metadata - 2])] + tempdata;
        }
        if (blockID == Blocks.field_150448_aq || blockID == Blocks.field_150318_D || blockID == Blocks.field_150319_E || blockID == Blocks.field_150408_cc) {
            switch (this.bDir) {
                case 0: {
                    if (metadata == 0) {
                        return 0;
                    }
                    if (metadata == 1) {
                        return 1;
                    }
                    if (metadata == 2) {
                        return 2;
                    }
                    if (metadata == 3) {
                        return 3;
                    }
                    if (metadata == 4) {
                        return this.bHand == 1 ? 4 : 5;
                    }
                    if (metadata == 5) {
                        return this.bHand == 1 ? 5 : 4;
                    }
                    if (metadata == 6) {
                        return this.bHand == 1 ? 6 : 9;
                    }
                    if (metadata == 7) {
                        return this.bHand == 1 ? 7 : 8;
                    }
                    if (metadata == 8) {
                        return this.bHand == 1 ? 8 : 7;
                    }
                    if (metadata == 9) {
                        return this.bHand == 1 ? 9 : 6;
                    }
                }
                case 1: {
                    if (metadata == 0) {
                        return 1;
                    }
                    if (metadata == 1) {
                        return 0;
                    }
                    if (metadata == 2) {
                        return 5;
                    }
                    if (metadata == 3) {
                        return 4;
                    }
                    if (metadata == 4) {
                        return this.bHand == 1 ? 2 : 3;
                    }
                    if (metadata == 5) {
                        return this.bHand == 1 ? 3 : 2;
                    }
                    if (metadata == 6) {
                        return this.bHand == 1 ? 7 : 6;
                    }
                    if (metadata == 7) {
                        return this.bHand == 1 ? 8 : 9;
                    }
                    if (metadata == 8) {
                        return this.bHand == 1 ? 9 : 8;
                    }
                    if (metadata == 9) {
                        return this.bHand == 1 ? 6 : 7;
                    }
                }
                case 2: {
                    if (metadata == 0) {
                        return 0;
                    }
                    if (metadata == 1) {
                        return 1;
                    }
                    if (metadata == 2) {
                        return 3;
                    }
                    if (metadata == 3) {
                        return 2;
                    }
                    if (metadata == 4) {
                        return this.bHand == 1 ? 5 : 4;
                    }
                    if (metadata == 5) {
                        return this.bHand == 1 ? 4 : 5;
                    }
                    if (metadata == 6) {
                        return this.bHand == 1 ? 8 : 7;
                    }
                    if (metadata == 7) {
                        return this.bHand == 1 ? 9 : 6;
                    }
                    if (metadata == 8) {
                        return this.bHand == 1 ? 6 : 9;
                    }
                    if (metadata == 9) {
                        return this.bHand == 1 ? 7 : 8;
                    }
                }
                case 3: {
                    if (metadata == 0) {
                        return 1;
                    }
                    if (metadata == 1) {
                        return 0;
                    }
                    if (metadata == 2) {
                        return 4;
                    }
                    if (metadata == 3) {
                        return 5;
                    }
                    if (metadata == 4) {
                        return this.bHand == 1 ? 3 : 2;
                    }
                    if (metadata == 5) {
                        return this.bHand == 1 ? 2 : 3;
                    }
                    if (metadata == 6) {
                        return this.bHand == 1 ? 9 : 8;
                    }
                    if (metadata == 7) {
                        return this.bHand == 1 ? 6 : 7;
                    }
                    if (metadata == 8) {
                        return this.bHand == 1 ? 7 : 6;
                    }
                    if (metadata != 9) break;
                    return this.bHand == 1 ? 8 : 9;
                }
            }
        } else {
            if (blockID == Blocks.field_150324_C || blockID == Blocks.field_150396_be || blockID == Blocks.field_150479_bC || blockID == Blocks.field_150423_aK || blockID == Blocks.field_150428_aP || blockID == Blocks.field_150416_aS || blockID == Blocks.field_150413_aR) {
                while (metadata >= 4) {
                    tempdata += 4;
                    metadata -= 4;
                }
                if (blockID == Blocks.field_150415_aT) {
                    return TRAPDOOR_DIR_TO_META[this.orientDirToBDir(TRAPDOOR_META_TO_DIR[metadata])] + tempdata;
                }
                return BED_DIR_TO_META[this.orientDirToBDir(BED_META_TO_DIR[metadata])] + tempdata;
            }
            if (blockID == Blocks.field_150395_bd) {
                if (metadata == 0) {
                    return 0;
                }
                if (metadata == 1 || metadata == 2 || metadata == 4 || metadata == 8) {
                    return VINES_DIR_TO_META[(this.bDir + VINES_META_TO_DIR[metadata]) % 4];
                }
                return 1;
            }
            if (blockID == Blocks.field_150472_an) {
                switch (this.bDir) {
                    case 0: {
                        if (metadata == 0) {
                            return this.bHand == 1 ? 0 : 8;
                        }
                        if (metadata == 1) {
                            return this.bHand == 1 ? 1 : 7;
                        }
                        if (metadata == 2) {
                            return this.bHand == 1 ? 2 : 6;
                        }
                        if (metadata == 3) {
                            return this.bHand == 1 ? 3 : 5;
                        }
                        if (metadata == 4) {
                            return 4;
                        }
                        if (metadata == 5) {
                            return this.bHand == 1 ? 5 : 3;
                        }
                        if (metadata == 6) {
                            return this.bHand == 1 ? 6 : 2;
                        }
                        if (metadata == 7) {
                            return this.bHand == 1 ? 7 : 1;
                        }
                        if (metadata == 8) {
                            return this.bHand == 1 ? 8 : 0;
                        }
                        if (metadata == 9) {
                            return this.bHand == 1 ? 9 : 15;
                        }
                        if (metadata == 10) {
                            return this.bHand == 1 ? 10 : 14;
                        }
                        if (metadata == 11) {
                            return this.bHand == 1 ? 11 : 13;
                        }
                        if (metadata == 12) {
                            return 12;
                        }
                        if (metadata == 13) {
                            return this.bHand == 1 ? 13 : 11;
                        }
                        if (metadata == 14) {
                            return this.bHand == 1 ? 14 : 10;
                        }
                        if (metadata == 15) {
                            return this.bHand == 1 ? 15 : 9;
                        }
                    }
                    case 1: {
                        if (metadata == 0) {
                            return this.bHand == 1 ? 4 : 12;
                        }
                        if (metadata == 1) {
                            return this.bHand == 1 ? 5 : 11;
                        }
                        if (metadata == 2) {
                            return this.bHand == 1 ? 6 : 10;
                        }
                        if (metadata == 3) {
                            return this.bHand == 1 ? 7 : 9;
                        }
                        if (metadata == 4) {
                            return 8;
                        }
                        if (metadata == 5) {
                            return this.bHand == 1 ? 9 : 7;
                        }
                        if (metadata == 6) {
                            return this.bHand == 1 ? 10 : 6;
                        }
                        if (metadata == 7) {
                            return this.bHand == 1 ? 11 : 5;
                        }
                        if (metadata == 8) {
                            return this.bHand == 1 ? 12 : 4;
                        }
                        if (metadata == 9) {
                            return this.bHand == 1 ? 13 : 3;
                        }
                        if (metadata == 10) {
                            return this.bHand == 1 ? 14 : 2;
                        }
                        if (metadata == 11) {
                            return this.bHand == 1 ? 15 : 1;
                        }
                        if (metadata == 12) {
                            return 0;
                        }
                        if (metadata == 13) {
                            return this.bHand == 1 ? 1 : 15;
                        }
                        if (metadata == 14) {
                            return this.bHand == 1 ? 2 : 14;
                        }
                        if (metadata == 15) {
                            return this.bHand == 1 ? 3 : 13;
                        }
                    }
                    case 2: {
                        if (metadata == 0) {
                            return this.bHand == 1 ? 8 : 0;
                        }
                        if (metadata == 1) {
                            return this.bHand == 1 ? 9 : 15;
                        }
                        if (metadata == 2) {
                            return this.bHand == 1 ? 10 : 14;
                        }
                        if (metadata == 3) {
                            return this.bHand == 1 ? 11 : 13;
                        }
                        if (metadata == 4) {
                            return 12;
                        }
                        if (metadata == 5) {
                            return this.bHand == 1 ? 13 : 11;
                        }
                        if (metadata == 6) {
                            return this.bHand == 1 ? 14 : 10;
                        }
                        if (metadata == 7) {
                            return this.bHand == 1 ? 15 : 9;
                        }
                        if (metadata == 8) {
                            return this.bHand == 1 ? 0 : 8;
                        }
                        if (metadata == 9) {
                            return this.bHand == 1 ? 1 : 7;
                        }
                        if (metadata == 10) {
                            return this.bHand == 1 ? 2 : 6;
                        }
                        if (metadata == 11) {
                            return this.bHand == 1 ? 3 : 5;
                        }
                        if (metadata == 12) {
                            return 4;
                        }
                        if (metadata == 13) {
                            return this.bHand == 1 ? 5 : 3;
                        }
                        if (metadata == 14) {
                            return this.bHand == 1 ? 6 : 2;
                        }
                        if (metadata == 15) {
                            return this.bHand == 1 ? 7 : 1;
                        }
                    }
                    case 3: {
                        if (metadata == 0) {
                            return this.bHand == 1 ? 12 : 4;
                        }
                        if (metadata == 1) {
                            return this.bHand == 1 ? 13 : 3;
                        }
                        if (metadata == 2) {
                            return this.bHand == 1 ? 14 : 2;
                        }
                        if (metadata == 3) {
                            return this.bHand == 1 ? 15 : 1;
                        }
                        if (metadata == 4) {
                            return 0;
                        }
                        if (metadata == 5) {
                            return this.bHand == 1 ? 1 : 15;
                        }
                        if (metadata == 6) {
                            return this.bHand == 1 ? 2 : 14;
                        }
                        if (metadata == 7) {
                            return this.bHand == 1 ? 3 : 13;
                        }
                        if (metadata == 8) {
                            return this.bHand == 1 ? 4 : 12;
                        }
                        if (metadata == 9) {
                            return this.bHand == 1 ? 5 : 11;
                        }
                        if (metadata == 10) {
                            return this.bHand == 1 ? 6 : 10;
                        }
                        if (metadata == 11) {
                            return this.bHand == 1 ? 7 : 9;
                        }
                        if (metadata == 12) {
                            return 8;
                        }
                        if (metadata == 13) {
                            return this.bHand == 1 ? 9 : 7;
                        }
                        if (metadata == 14) {
                            return this.bHand == 1 ? 10 : 6;
                        }
                        if (metadata != 15) break;
                        return this.bHand == 1 ? 11 : 5;
                    }
                }
            }
        }
        return metadata + tempdata;
    }

    private void setLootChest(int[] pt, Block chestBlock, int meta, String chestType) {
        if (this.world.func_147465_d(pt[0], pt[1], pt[2], chestBlock, meta, 2)) {
            TileEntityChest chest = (TileEntityChest)this.world.func_147438_o(pt[0], pt[1], pt[2]);
            if (this.wgt.chestTries != null && this.wgt.chestTries.containsKey(chestType)) {
                for (int m = 0; m < this.wgt.chestTries.get(chestType); ++m) {
                    ItemStack itemstack;
                    if (!this.random.nextBoolean() || (itemstack = this.getChestItemstack(chestType)) == null || chest == null) continue;
                    chest.func_70299_a(this.random.nextInt(chest.func_70302_i_()), itemstack);
                }
            }
        }
    }

    private void setMobSpawner(int[] pt, Block spawner, int metadata, String info) {
        TileEntityMobSpawner tileentitymobspawner;
        if (this.world.func_147465_d(pt[0], pt[1], pt[2], spawner, metadata, 2) && (tileentitymobspawner = (TileEntityMobSpawner)this.world.func_147438_o(pt[0], pt[1], pt[2])) != null) {
            if (info.equals("UPRIGHT")) {
                if (this.random.nextInt(3) == 0) {
                    this.setMobSpawner(tileentitymobspawner, 1, 3);
                } else {
                    this.setMobSpawner(tileentitymobspawner, 2, 0);
                }
            } else if (info.equals(EASY_CHEST)) {
                this.setMobSpawner(tileentitymobspawner, 2, 0);
            } else if (info.equals(MEDIUM_CHEST)) {
                this.setMobSpawner(tileentitymobspawner, 3, 0);
            } else if (info.equals(HARD_CHEST)) {
                this.setMobSpawner(tileentitymobspawner, 4, 0);
            } else {
                tileentitymobspawner.func_145881_a().func_98272_a(info);
            }
        }
    }

    private void setMobSpawner(TileEntityMobSpawner spawner, int nTypes, int offset) {
        String mob = "Pig";
        int n = this.random.nextInt(nTypes) + offset;
        if (n < SPAWNERS.length) {
            mob = SPAWNERS[n];
        }
        spawner.func_145881_a().func_98272_a(mob);
    }

    public static int distance(int[] pt1, int[] pt2) {
        return (int)Math.sqrt((pt1[0] - pt2[0]) * (pt1[0] - pt2[0]) + (pt1[1] - pt2[1]) * (pt1[1] - pt2[1]) + (pt1[2] - pt2[2]) * (pt1[2] - pt2[2]));
    }

    public static int findSurfaceJ(World world, int i, int k, int jinit, boolean wallIsSurface, int waterSurfaceBuffer) {
        if (world.field_73011_w.field_76575_d) {
            if (i % 2 == 1 ^ k % 2 == 1) {
                for (int j = 127; j > -1; --j) {
                    if (!world.func_147437_c(i, j, k)) continue;
                    while (j > -1) {
                        if (!BlockProperties.get((Block)world.func_147439_a((int)i, (int)j, (int)k)).isWallable) {
                            return j;
                        }
                        --j;
                    }
                }
            } else {
                for (int j = 0; j <= 127; ++j) {
                    if (!world.func_147437_c(i, j, k)) continue;
                    return j;
                }
            }
            return -1;
        }
        int minecraftHeight = world.func_72938_d(i, k).func_76611_b(i & 0xF, k & 0xF);
        if (minecraftHeight < jinit) {
            jinit = minecraftHeight;
        }
        for (int j = jinit; j >= 0; --j) {
            Block blockId = world.func_147439_a(i, j, k);
            if (!(BlockProperties.get((Block)blockId).isWallable || !wallIsSurface && BlockProperties.get((Block)blockId).isArtificial)) {
                return j;
            }
            if (waterSurfaceBuffer == -1 || !BlockProperties.get((Block)blockId).isWater) continue;
            return BlockProperties.get((Block)world.func_147439_a((int)i, (int)(j - waterSurfaceBuffer), (int)k)).isWater ? -666 : j;
        }
        return -1;
    }

    public static int flipDir(int dir) {
        return (dir + 2) % 4;
    }

    public static String metaValueCheck(Block blockID, int metadata) {
        if (metadata < 0 || metadata >= 16) {
            return "All Minecraft meta values should be between 0 and 15";
        }
        String fail = blockID.func_149739_a() + " meta value should be between";
        if (BlockProperties.get((Block)blockID).isStair) {
            return metadata < 8 ? null : fail + " 0 and 7";
        }
        if (blockID == Blocks.field_150448_aq) {
            return metadata < 10 ? null : fail + " 0 and 9";
        }
        if (blockID == Blocks.field_150430_aB || blockID == Blocks.field_150471_bO) {
            return metadata % 8 > 0 && metadata % 8 < 5 ? null : fail + " 1 and 4 or 9 and 12";
        }
        if (blockID == Blocks.field_150468_ap || blockID == Blocks.field_150367_z || blockID == Blocks.field_150460_al || blockID == Blocks.field_150470_am || blockID == Blocks.field_150444_as || blockID == Blocks.field_150331_J || blockID == Blocks.field_150326_M || blockID == Blocks.field_150486_ae || blockID == Blocks.field_150438_bZ || blockID == Blocks.field_150409_cd || blockID == Blocks.field_150318_D || blockID == Blocks.field_150319_E || blockID == Blocks.field_150408_cc) {
            return metadata % 8 < 6 ? null : fail + " 0 and 5 or 8 and 13";
        }
        if (blockID == Blocks.field_150423_aK || blockID == Blocks.field_150428_aP) {
            return metadata < 5 ? null : fail + " 0 and 4";
        }
        if (blockID == Blocks.field_150396_be) {
            return metadata < 8 ? null : fail + " 0 and 7";
        }
        if (blockID == Blocks.field_150376_bx || blockID == Blocks.field_150324_C) {
            return metadata % 8 < 4 ? null : fail + " 0 and 3 or 8 and 11";
        }
        if (blockID == Blocks.field_150478_aa || blockID == Blocks.field_150429_aA || blockID == Blocks.field_150437_az) {
            return metadata > 0 && metadata < 7 ? null : fail + " 1 and 6";
        }
        return null;
    }

    public static int pickWeightedOption(Random random, List<Object> weights, List<Object> options) {
        int i;
        int[] w = new int[weights.size()];
        int[] o = new int[options.size()];
        for (i = 0; i < w.length; ++i) {
            w[i] = (Integer)weights.get(i);
        }
        for (i = 0; i < o.length; ++i) {
            o[i] = (Integer)options.get(i);
        }
        return Building.pickWeightedOption(random, w, o);
    }

    public static int pickWeightedOption(Random random, int[] weights, int[] options) {
        int n;
        int sum = 0;
        for (n = 0; n < weights.length; ++n) {
            sum += weights[n];
        }
        if (sum <= 0) {
            System.err.println("Error selecting options, weightsum not positive!");
            return options[0];
        }
        int s = random.nextInt(sum);
        sum = 0;
        for (n = 0; n < weights.length; ++n) {
            if ((sum += weights[n]) <= s) continue;
            return options[n];
        }
        return options[options.length - 1];
    }

    public static int rotDir(int dir, int rotation) {
        return (dir + rotation + 4) % 4;
    }

    public static void setBlockAndMetaNoLighting(World world, int i, int j, int k, Block blockId, int meta) {
        if (i < -30000000 || k < -30000000 || i >= 30000000 || k >= 30000000 || j < 0 || j > 255) {
            return;
        }
        world.func_72964_e(i >> 4, k >> 4).func_150807_a(i & 0xF, j, k & 0xF, blockId, meta);
    }

    protected static void fillDown(int[] lowPt, int jtop, World world) {
        Block fillBlockId;
        while (BlockProperties.get((Block)world.func_147439_a((int)lowPt[0], (int)lowPt[1], (int)lowPt[2])).isArtificial) {
            lowPt[1] = lowPt[1] - 1;
        }
        Block oldSurfaceBlockId = world.func_147439_a(lowPt[0], lowPt[1], lowPt[2]);
        if (BlockProperties.get((Block)oldSurfaceBlockId).isOre) {
            oldSurfaceBlockId = Blocks.field_150348_b;
        }
        if (oldSurfaceBlockId == Blocks.field_150346_d || lowPt[1] <= 63 && oldSurfaceBlockId == Blocks.field_150354_m) {
            oldSurfaceBlockId = Blocks.field_150349_c;
        }
        if (oldSurfaceBlockId == Blocks.field_150350_a) {
            oldSurfaceBlockId = world.field_73011_w.field_76575_d ? Blocks.field_150424_aL : Blocks.field_150349_c;
        }
        Block block = fillBlockId = oldSurfaceBlockId == Blocks.field_150349_c ? Blocks.field_150346_d : oldSurfaceBlockId;
        while (lowPt[1] <= jtop) {
            Building.setBlockAndMetaNoLighting(world, lowPt[0], lowPt[1], lowPt[2], lowPt[1] == jtop ? oldSurfaceBlockId : fillBlockId, 0);
            lowPt[1] = lowPt[1] + 1;
        }
    }

    protected static int minOrMax(int[] a, boolean isMin) {
        if (isMin) {
            int min = Integer.MAX_VALUE;
            for (int i : a) {
                min = Math.min(min, i);
            }
            return min;
        }
        int max = Integer.MIN_VALUE;
        for (int i : a) {
            max = Math.max(max, i);
        }
        return max;
    }

    protected static int signum(int n, int wiggle) {
        if (n <= wiggle && -n <= wiggle) {
            return 0;
        }
        return n < 0 ? -1 : 1;
    }

    private static void circleShape(int diam) {
        int y;
        int y2;
        float rad = (float)diam / 2.0f;
        float[][] shape_density = new float[diam][diam];
        for (int x = 0; x < diam; ++x) {
            for (y2 = 0; y2 < diam; ++y2) {
                shape_density[y2][x] = (((float)x + 0.5f - rad) * ((float)x + 0.5f - rad) + ((float)y2 + 0.5f - rad) * ((float)y2 + 0.5f - rad)) / (rad * rad);
            }
        }
        int[] xheight = new int[diam];
        for (y2 = 0; y2 < diam; ++y2) {
            int x = 0;
            while (shape_density[y2][x] > 1.0f) {
                ++x;
            }
            xheight[y2] = x;
        }
        Building.CIRCLE_SHAPE[diam] = new int[diam][diam];
        Building.CIRCLE_CRENEL[diam] = new int[diam][diam];
        Building.SPHERE_SHAPE[diam] = new int[(diam + 1) / 2];
        int crenel_adj = 0;
        for (int x = 0; x < diam; ++x) {
            for (int y3 = 0; y3 < diam; ++y3) {
                Building.CIRCLE_SHAPE[diam][y3][x] = 0;
                Building.CIRCLE_CRENEL[diam][y3][x] = 0;
            }
        }
        for (y = 0; y < diam; ++y) {
            int x;
            int nextHeight = y == 0 || y == diam - 1 ? diam / 2 + 1 : xheight[y < diam / 2 ? y - 1 : y + 1] + (xheight[y] == xheight[y < diam / 2 ? y - 1 : y + 1] ? 1 : 0);
            if (y > 0 && xheight[y] == xheight[y - 1]) {
                ++crenel_adj;
            }
            for (x = 0; x < xheight[y]; ++x) {
                Building.CIRCLE_SHAPE[diam][y][x] = -1;
                Building.CIRCLE_SHAPE[diam][y][diam - x - 1] = -1;
                Building.CIRCLE_CRENEL[diam][y][x] = -1;
                Building.CIRCLE_CRENEL[diam][y][diam - x - 1] = -1;
            }
            while (x < nextHeight) {
                Building.CIRCLE_SHAPE[diam][y][x] = 1;
                Building.CIRCLE_SHAPE[diam][y][diam - x - 1] = 1;
                Building.CIRCLE_CRENEL[diam][y][x] = (x + crenel_adj) % 2;
                Building.CIRCLE_CRENEL[diam][y][diam - x - 1] = (x + crenel_adj + diam + 1) % 2;
                ++x;
            }
        }
        for (y = diam / 2; y < diam; ++y) {
            Building.SPHERE_SHAPE[diam][y - diam / 2] = 2 * (diam / 2 - xheight[y]) + (diam % 2 == 0 ? 0 : 1);
        }
    }

    private static boolean isSolidBlock(Block blockID) {
        return blockID.func_149688_o().func_76220_a();
    }

    static {
        for (int diam = 1; diam <= 40; ++diam) {
            Building.circleShape(diam);
        }
        Building.CIRCLE_SHAPE[6] = new int[][]{{-1, -1, 1, 1, -1, -1}, {-1, 1, 0, 0, 1, -1}, {1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 1}, {-1, 1, 0, 0, 1, -1}, {-1, -1, 1, 1, -1, -1}};
        Building.CIRCLE_CRENEL[6] = new int[][]{{-1, -1, 1, 0, -1, -1}, {-1, 0, 0, 0, 1, -1}, {1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1}, {-1, 1, 0, 0, 0, -1}, {-1, -1, 0, 1, -1, -1}};
        randLightingHash = new boolean[512];
        Random rand = new Random();
        for (int m = 0; m < randLightingHash.length; ++m) {
            Building.randLightingHash[m] = rand.nextInt(10) == 0;
        }
        CHEST_TYPE_LABELS = new String[]{EASY_CHEST, MEDIUM_CHEST, HARD_CHEST, TOWER_CHEST};
        DEFAULT_CHEST_TRIES = new int[]{4, 6, 6, 6};
        DEFAULT_CHEST_ITEMS = new Object[][][]{{{0, Items.field_151032_g, 0, 2, 1, 12}, {1, Items.field_151040_l, 0, 2, 1, 1}, {2, Items.field_151026_S, 0, 1, 1, 1}, {3, Items.field_151037_a, 0, 1, 1, 1}, {4, Items.field_151007_F, 0, 1, 1, 1}, {5, Items.field_151035_b, 0, 2, 1, 1}, {6, Items.field_151021_T, 0, 1, 1, 1}, {7, Items.field_151133_ar, 0, 1, 1, 1}, {8, Items.field_151024_Q, 0, 1, 1, 1}, {9, Items.field_151014_N, 0, 1, 10, 15}, {10, Items.field_151074_bl, 0, 2, 3, 8}, {11, Items.field_151068_bn, 5, 2, 1, 1}, {12, Items.field_151068_bn, 4, 1, 1, 1}}, {{0, Items.field_151010_B, 0, 2, 1, 1}, {1, Items.field_151117_aB, 0, 2, 1, 1}, {2, Blocks.field_150321_G, 0, 1, 8, 16}, {3, Items.field_151011_C, 0, 1, 1, 1}, {4, Items.field_151013_M, 0, 1, 0, 1}, {5, Items.field_151113_aN, 0, 1, 1, 1}, {6, Items.field_151036_c, 0, 3, 1, 1}, {7, Items.field_151148_bJ, 0, 1, 1, 1}, {8, Items.field_151034_e, 0, 2, 2, 3}, {9, Items.field_151111_aL, 0, 1, 1, 1}, {10, Items.field_151042_j, 0, 1, 5, 8}, {11, Items.field_151123_aH, 0, 1, 1, 3}, {12, Blocks.field_150343_Z, 0, 1, 1, 4}, {13, Items.field_151025_P, 0, 2, 8, 15}, {14, Items.field_151068_bn, 2, 1, 1, 1}, {15, Items.field_151068_bn, 37, 3, 1, 1}, {16, Items.field_151068_bn, 34, 1, 1, 1}, {17, Items.field_151068_bn, 9, 1, 1, 1}}, {{0, Blocks.field_150320_F, 0, 2, 6, 12}, {1, Blocks.field_150321_G, 0, 1, 8, 24}, {2, Items.field_151106_aX, 0, 2, 8, 18}, {3, Items.field_151056_x, 0, 1, 1, 1}, {4, Items.field_151143_au, 0, 1, 12, 24}, {5, Items.field_151137_ax, 0, 2, 12, 24}, {6, Items.field_151129_at, 0, 2, 1, 1}, {7, Items.field_151079_bi, 0, 1, 1, 1}, {8, Blocks.field_150474_ac, 0, 1, 2, 4}, {9, Items.field_151096_cd, 0, 1, 1, 1}, {10, Items.field_151153_ao, 0, 1, 4, 8}, {11, Blocks.field_150335_W, 0, 2, 8, 20}, {12, Items.field_151045_i, 0, 2, 1, 4}, {13, Items.field_151043_k, 0, 2, 30, 64}, {14, Items.field_151068_bn, 37, 3, 1, 1}, {15, Items.field_151068_bn, 49, 2, 1, 1}, {16, Items.field_151068_bn, 3, 2, 1, 1}}, {{0, Items.field_151032_g, 0, 1, 1, 12}, {1, Items.field_151115_aP, 0, 2, 1, 1}, {2, Items.field_151169_ag, 0, 1, 1, 1}, {3, Blocks.field_150321_G, 0, 1, 1, 12}, {4, Items.field_151042_j, 0, 1, 2, 3}, {5, Items.field_151052_q, 0, 1, 1, 1}, {6, Items.field_151036_c, 0, 1, 1, 1}, {7, Items.field_151110_aK, 0, 2, 8, 16}, {8, Items.field_151141_av, 0, 1, 1, 1}, {9, Items.field_151015_O, 0, 2, 3, 6}, {10, Items.field_151016_H, 0, 1, 2, 4}, {11, Items.field_151027_R, 0, 1, 1, 1}, {12, Blocks.field_150423_aK, 0, 1, 1, 5}, {13, Items.field_151074_bl, 0, 2, 1, 3}}};
    }
}

