/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockAndMeta;
import assets.generator.BlockProperties;
import assets.generator.Building;
import assets.generator.TemplateTML;
import assets.generator.WorldGeneratorThread;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BuildingTML
extends Building {
    final TemplateTML tmlt;

    public BuildingTML(int ID_, WorldGeneratorThread wgt, int bDir_, int axXHand_, boolean centerAligned_, TemplateTML tmlt_, int[] sourcePt) {
        super(ID_, wgt, null, bDir_, axXHand_, centerAligned_, new int[]{tmlt_.width, tmlt_.height, tmlt_.length}, sourcePt);
        this.tmlt = tmlt_;
        this.j0 -= this.tmlt.embed;
    }

    public void build() {
        int x;
        int y;
        int z;
        this.tmlt.setFixedRules(this.world.field_73012_v);
        int[][] base = this.tmlt.namedLayers.get("base");
        for (int y2 = 0; y2 < this.bLength; ++y2) {
            for (int x2 = 0; x2 < this.bWidth; ++x2) {
                if (base != null) {
                    this.buildDown(x2, -1, y2, this.tmlt.rules[base[y2][x2]], this.tmlt.leveling, 0, 0);
                    continue;
                }
                BuildingTML.fillDown(this.getSurfaceIJKPt(x2, y2, this.j0 - 1, true, -1), this.j0 - 1, this.world);
            }
        }
        for (z = this.bHeight; z < this.tmlt.cutIn + this.tmlt.embed; ++z) {
            for (y = 0; y < this.bLength; ++y) {
                for (x = 0; x < this.bWidth; ++x) {
                    this.setBlockLocal(x, z, y, Blocks.field_150350_a);
                }
            }
        }
        for (z = 0; z < this.bHeight; ++z) {
            for (y = 0; y < this.bLength; ++y) {
                for (x = 0; x < this.bWidth; ++x) {
                    this.setBlockLocal(x, z, y, this.tmlt.rules[this.tmlt.template[z][y][x]]);
                }
            }
        }
        this.flushDelayed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean queryCanBuild(int ybuffer) {
        if (this.j0 <= 0) {
            return false;
        }
        for (int y = 0; y < this.bLength; ++y) {
            for (int x = 0; x < this.bWidth; ++x) {
                if (this.j0 - this.getSurfaceIJKPt(x, y, this.j0 - 1, true, 3)[1] <= this.tmlt.leveling + 1) continue;
                return false;
            }
        }
        if (this.tmlt.waterHeight != -666) {
            int waterCheckHeight = this.tmlt.waterHeight + this.tmlt.embed + 1;
            if (BlockProperties.get((Block)this.getBlockIdLocal((int)0, (int)waterCheckHeight, (int)0)).isWater || BlockProperties.get((Block)this.getBlockIdLocal((int)0, (int)waterCheckHeight, (int)(this.bLength - 1))).isWater || BlockProperties.get((Block)this.getBlockIdLocal((int)(this.bWidth - 1), (int)waterCheckHeight, (int)0)).isWater || BlockProperties.get((Block)this.getBlockIdLocal((int)(this.bWidth - 1), (int)waterCheckHeight, (int)(this.bLength - 1))).isWater) {
                return false;
            }
        }
        if (this.wgt.isLayoutGenerator()) {
            int layoutCode;
            int n = layoutCode = this.tmlt.buildOverStreets ? 4 : 5;
            if (!this.wgt.layoutIsClear(this, this.tmlt.templateLayout, layoutCode)) return false;
            this.wgt.setLayoutCode(this, this.tmlt.templateLayout, 5);
            return true;
        } else {
            if (!this.isObstructedFrame(0, ybuffer)) return true;
            return false;
        }
    }

    @Override
    protected BlockAndMeta getDelayedStair(Block blc, int ... block) {
        return new BlockAndMeta(blc, block[3]);
    }
}

