/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockAndMeta;
import assets.generator.BlockProperties;
import assets.generator.Building;
import assets.generator.BuildingWall;
import assets.generator.TemplateRule;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BuildingTower
extends Building {
    public static final int FLOOR_HAUNTED_CHANCE = 50;
    public static final int HAUNTED_CHEST_CHANCE = 60;
    public static final int TOWER_UNIV_MIN_WIDTH = 5;
    public static final int TOWER_LEVELING = 12;
    public static final String[] ROOFSTYLE_NAMES = new String[]{"Crenel", "Steep", "Steep Trim", "Shallow", "Dome", "Cone", "Two Sided"};
    public static final int[] ROOF_STYLE_IDS = new int[ROOFSTYLE_NAMES.length];
    public static final int SURFACE_PORTAL_ODDS = 20;
    public static final int NETHER_PORTAL_ODDS = 10;
    public static final int BOOKSHELF_ODDS = 3;
    public static final int BED_ODDS = 5;
    public static final int CAULDRON_ODDS = 8;
    public static final int BREWING_STAND_ODDS = 8;
    public static final int ENCHANTMENT_TABLE_ODDS = 12;
    public static final int ROOF_CRENEL = 0;
    public static final int ROOF_STEEP = 1;
    public static final int ROOF_TRIM = 2;
    public static final int ROOF_SHALLOW = 3;
    public static final int ROOF_DOME = 4;
    public static final int ROOF_CONE = 5;
    public static final int ROOF_TWO_SIDED = 6;
    public static final int NORTH_FACE_DOOR_META = 3;
    public static final int EAST_FACE_DOOR_META = 0;
    public static final int SOUTH_FACE_DOOR_META = 1;
    public static final int WEST_FACE_DOOR_META = 2;
    public int baseHeight;
    public int roofStyle;
    public int minHorizDim;
    public final boolean PopulateFurniture;
    public final boolean MakeDoors;
    public final boolean circular;
    private BlockAndMeta[][][] buffer;
    private int[][] circle_shape;
    private TemplateRule roofRule;
    private TemplateRule SpawnerRule;
    private TemplateRule ChestRule;

    public void build(int doorOffset1, int doorOffset2, boolean hanging) {
        int z1;
        int y1;
        int x1;
        int z12;
        int y12;
        int x12;
        boolean undeadTower = false;
        boolean ghastTower = false;
        if (this.SpawnerRule != TemplateRule.RULE_NOT_PROVIDED) {
            if (this.SpawnerRule.hasUndeadSpawner()) {
                undeadTower = true;
            }
            boolean bl = ghastTower = this.roofStyle == 0 && this.SpawnerRule.getBlockOrHole(this.world.field_73012_v).equals((Object)GHAST_SPAWNER);
            if (ghastTower || this.random.nextInt(100) > this.SpawnerRule.chance) {
                undeadTower = false;
            }
        }
        if (undeadTower && this.bHeight - this.baseHeight < 9) {
            this.bHeight = this.baseHeight + 9;
        }
        if (this.baseHeight < 0) {
            this.baseHeight = 0;
        }
        this.buffer = new BlockAndMeta[this.bWidth + 2][this.bHeight + this.minHorizDim + 3][this.bLength + 2];
        for (x12 = 0; x12 < this.bWidth + 2; ++x12) {
            for (y12 = 0; y12 < this.bLength + 2; ++y12) {
                for (z12 = 0; z12 < this.bHeight + this.minHorizDim + 3; ++z12) {
                    this.buffer[x12][z12][y12] = PRESERVE_BLOCK;
                }
            }
        }
        for (x12 = 0; x12 < this.bWidth; ++x12) {
            for (y12 = 0; y12 < this.bLength; ++y12) {
                if (this.circular && this.circle_shape[x12][y12] < 0) continue;
                for (z12 = this.baseHeight - 1; z12 < this.bHeight; ++z12) {
                    this.buffer[x12 + 1][z12 + 1][y12 + 1] = this.circular && this.circle_shape[x12][y12] == 1 || !this.circular && (x12 == 0 || x12 == this.bWidth - 1 || y12 == 0 || y12 == this.bLength - 1) ? this.bRule.getBlockOrHole(this.world.field_73012_v) : HOLE_BLOCK_NO_LIGHTING;
                }
                for (z12 = -1; z12 < this.baseHeight - 1; ++z12) {
                    this.buffer[x12 + 1][z12 + 1][y12 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                }
                this.buildDown(x12, -2, y12, this.bRule, 12, 2, (this.bLength - y12 - 1) / 2);
            }
        }
        int sideWindowY = this.bLength / 2;
        for (int z13 = this.baseHeight - 1; z13 < this.bHeight - 3; z13 += 4) {
            BlockAndMeta spawnerBlock;
            boolean floorHasUndeadSpawner;
            int winDoorX1 = Math.min(Math.max(this.bWidth / 2 + (z13 == this.baseHeight - 1 ? doorOffset1 : 0), 1), this.bWidth - 2);
            int winDoorX2 = Math.min(Math.max(this.bWidth / 2 + (z13 == this.baseHeight - 1 ? doorOffset2 : 0), 1), this.bWidth - 2);
            int torchX1 = winDoorX1 + (winDoorX1 == this.bWidth - 2 ? -1 : 1);
            int torchX2 = winDoorX2 + (winDoorX2 == this.bWidth - 2 ? -1 : 1);
            boolean bl = floorHasUndeadSpawner = undeadTower && z13 > this.baseHeight - 1 && this.random.nextInt(100) < 50;
            if (z13 == this.baseHeight - 1 || !floorHasUndeadSpawner) {
                int winH = z13 > this.baseHeight - 1 ? 2 : 3;
                this.buildWindowOrDoor(0, z13 + 2, sideWindowY, -1, 0, winH);
                this.buildWindowOrDoor(this.bWidth - 1, z13 + 2, sideWindowY, 1, 0, winH);
                this.buildWindowOrDoor(winDoorX1, z13 + 2, 0, 0, -1, winH);
                this.buildWindowOrDoor(winDoorX2, z13 + 2, this.bLength - 1, 0, 1, winH);
            }
            for (int y13 = 1; y13 < this.bLength - 1; ++y13) {
                for (int x13 = 1; x13 < this.bWidth - 1; ++x13) {
                    if (this.circular && this.circle_shape[x13][y13] != 0) continue;
                    this.buffer[x13 + 1][z13 + 1][y13 + 1] = this.bRule.primaryBlock.get() == Blocks.field_150364_r ? new BlockAndMeta(Blocks.field_150344_f, 0) : this.bRule.getBlockOrHole(this.world.field_73012_v);
                }
            }
            if (!undeadTower && this.bRule.chance == 100) {
                this.buffer[torchX1 + 1][z13 + 3 + 1][1 + (this.circular && this.bLength == 6 ? 1 : 0) + 1] = NORTH_FACE_TORCH_BLOCK;
                this.buffer[torchX2 + 1][z13 + 3 + 1][this.bLength - 2 - (this.circular && this.bLength == 6 ? 1 : 0) + 1] = SOUTH_FACE_TORCH_BLOCK;
            }
            if (floorHasUndeadSpawner && z13 == this.baseHeight + 4 && this.bRule.chance == 100) {
                for (int x14 = this.bWidth / 2 - 1; x14 <= this.bWidth / 2 + 1; ++x14) {
                    int y14;
                    for (y14 = 1; y14 < Math.min(3, sideWindowY - 1); ++y14) {
                        if (this.circular && this.circle_shape[x14][y14] != 0) continue;
                        this.buffer[x14 + 1][z13 + 1][y14 + 1] = HOLE_BLOCK_LIGHTING;
                    }
                    for (y14 = this.bLength - Math.min(3, sideWindowY - 1); y14 < this.bLength - 1; ++y14) {
                        if (this.circular && this.circle_shape[x14][y14] != 0) continue;
                        this.buffer[x14 + 1][z13 + 1][y14 + 1] = HOLE_BLOCK_LIGHTING;
                    }
                }
            } else if (this.SpawnerRule != TemplateRule.RULE_NOT_PROVIDED && this.random.nextInt(100) < this.SpawnerRule.chance && !ghastTower && !(spawnerBlock = this.SpawnerRule.getNonAirBlock(this.world.field_73012_v)).equals((Object)GHAST_SPAWNER)) {
                this.buffer[this.bWidth / 2 + 1][z13 + 1 + 1][sideWindowY + 1] = spawnerBlock;
            }
            if (this.ChestRule != TemplateRule.RULE_NOT_PROVIDED && this.random.nextInt(100) < this.ChestRule.chance) {
                this.buffer[this.bWidth - 2 + 1][z13 + 1 + 1][sideWindowY - 1 + 1] = this.ChestRule.getNonAirBlock(this.world.field_73012_v);
            } else if (floorHasUndeadSpawner && this.random.nextInt(100) < 60) {
                BlockAndMeta blockAndMeta = this.buffer[this.bWidth - 2 + 1][z13 + 1 + 1][sideWindowY - 1 + 1] = z13 < 15 ? TOWER_CHEST_BLOCK : HARD_CHEST_BLOCK;
            }
            if (z13 != this.baseHeight - 1) continue;
            ++z13;
        }
        int topFloorHeight = (this.bHeight - this.baseHeight - 4) / 4 * 4 + this.baseHeight + 1;
        int ladderHeight = this.roofStyle == 0 ? this.bHeight : (this.bHeight - this.baseHeight < 8 ? 0 : topFloorHeight);
        for (int z14 = this.baseHeight; z14 < ladderHeight; ++z14) {
            this.buffer[2][z14 + 1][sideWindowY - 1 + 1] = EAST_FACE_LADDER_BLOCK;
        }
        this.buildRoof();
        if (undeadTower && this.roofStyle == 0) {
            this.buffer[2][this.bHeight > this.baseHeight + 12 ? this.baseHeight + 9 : this.bHeight + 1][sideWindowY - 1 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
        }
        int zLim = this.bRule.chance >= 100 ? this.buffer[0].length : this.propagateCollapse(this.bRule.chance);
        for (x1 = 1; x1 < this.buffer.length - 1; ++x1) {
            for (y1 = 1; y1 < this.buffer[0][0].length - 1; ++y1) {
                if (this.circular && this.circle_shape[x1 - 1][y1 - 1] < 0) continue;
                for (z1 = 0; z1 < Math.min(this.bHeight, zLim); ++z1) {
                    this.setBlockLocal(x1 - 1, z1 - 1, y1 - 1, this.buffer[x1][z1][y1]);
                }
            }
        }
        for (x1 = 0; x1 < this.buffer.length; ++x1) {
            for (y1 = 0; y1 < this.buffer[0][0].length; ++y1) {
                for (z1 = this.bHeight; z1 < zLim; ++z1) {
                    this.setBlockLocal(x1 - 1, z1 - 1, y1 - 1, this.buffer[x1][z1][y1]);
                }
            }
        }
        for (x1 = 1; x1 < this.bWidth - 1; ++x1) {
            if (this.isStairBlock(x1, this.baseHeight, -1) && this.getBlockIdLocal(x1, this.baseHeight, -2) == this.bRule.primaryBlock.get()) {
                this.setBlockLocal(x1, this.baseHeight, -1, this.bRule.primaryBlock);
            }
            if (!this.isStairBlock(x1, this.baseHeight, this.bLength) || this.getBlockIdLocal(x1, this.baseHeight, this.bLength + 1) != this.bRule.primaryBlock.get()) continue;
            this.setBlockLocal(x1, this.baseHeight, this.bLength, this.bRule.primaryBlock);
        }
        if (this.PopulateFurniture) {
            for (int z15 = this.baseHeight; z15 < this.bHeight - 2; z15 += 4) {
                for (int m = 0; m < this.bLength * this.bWidth / 25; ++m) {
                    if (!undeadTower && this.random.nextInt(5) == 0) {
                        this.populateBeds(z15);
                    }
                    if (this.bHeight - this.baseHeight > 8 && this.random.nextInt(3) == 0) {
                        this.populateBookshelves(z15);
                    }
                    if (this.random.nextInt(8) == 0) {
                        this.populateFurnitureColumn(z15, new BlockAndMeta[]{new BlockAndMeta((Block)Blocks.field_150383_bp, this.random.nextInt(4))});
                    }
                    if (z15 > 12 && this.random.nextInt(8) == 0) {
                        this.populateFurnitureColumn(z15, new BlockAndMeta[]{this.bRule.primaryBlock, new BlockAndMeta(Blocks.field_150382_bo, this.random.nextInt(2) + 1)});
                    }
                    if (z15 <= 20 || this.random.nextInt(12) != 0) continue;
                    this.populateFurnitureColumn(z15, new BlockAndMeta[]{new BlockAndMeta(Blocks.field_150381_bn, 0)});
                }
                if (z15 != this.baseHeight) continue;
                ++z15;
            }
        }
        if (ghastTower) {
            this.populateGhastSpawner(this.bHeight + 1);
        } else if (this.roofStyle == 0 && this.bHeight > 22) {
            this.populatePortal(this.bHeight + 1);
        }
        this.flushDelayed();
    }

    public void buildXYRotated(int p, int q, int r, BlockAndMeta block, boolean rotated) {
        if (rotated) {
            this.buffer[r][q][p] = block;
        } else {
            this.buffer[p][q][r] = block;
        }
    }

    public boolean isObstructedRoof(int ybuffer) {
        int rHeight;
        int rBuffer = this.roofStyle == 0 ? 1 : (this.roofStyle == 4 || this.roofStyle == 5 ? 0 : -1);
        int n = rHeight = this.roofStyle == 0 ? 2 : this.minHorizDim / 2;
        return this.isObstructedSolid(new int[]{rBuffer, this.bHeight, Math.max(rBuffer, ybuffer)}, new int[]{this.bWidth - 1 - rBuffer, this.bHeight + rHeight, this.bLength - 1 - rBuffer});
    }

    public int propagateCollapse(int buildChance) {
        int x;
        int xLim = this.buffer.length;
        int zLim = this.buffer[0].length;
        int yLim = this.buffer[0][0].length;
        int[][][] support = new int[xLim][zLim][yLim];
        for (x = 0; x < xLim; ++x) {
            for (int z = 1; z < zLim; ++z) {
                for (int y = 0; y < yLim; ++y) {
                    support[x][z][y] = 0;
                }
            }
        }
        for (x = 0; x < xLim; ++x) {
            for (int y = 0; y < yLim; ++y) {
                if (this.buffer[x][0][y].get() == Blocks.field_150350_a) continue;
                support[x][0][y] = 2;
            }
        }
        for (int z = 1; z < zLim; ++z) {
            int y;
            int x2;
            boolean levelCollapsed = true;
            for (x2 = 0; x2 < xLim; ++x2) {
                for (y = 0; y < yLim; ++y) {
                    if (this.buffer[x2][z][y].get() == Blocks.field_150350_a || !BlockProperties.get((Block)this.buffer[x2][z - 1][y].get()).isLoaded || support[x2][z - 1][y] <= 0) continue;
                    support[x2][z][y] = 2;
                    levelCollapsed = false;
                }
            }
            if (levelCollapsed) {
                return z;
            }
            for (int m = 0; m < 4; ++m) {
                for (int x3 = 0; x3 < xLim; ++x3) {
                    for (int y2 = 0; y2 < yLim; ++y2) {
                        if (this.buffer[x3][z][y2].get() == Blocks.field_150350_a || support[x3][z][y2] != 0) continue;
                        int neighbors = 0;
                        if (x3 < xLim - 1 && BlockProperties.get((Block)this.buffer[x3 + 1][z][y2].get()).isLoaded) {
                            neighbors += support[x3 + 1][z][y2];
                        }
                        if (x3 > 0 && BlockProperties.get((Block)this.buffer[x3 - 1][z][y2].get()).isLoaded) {
                            neighbors += support[x3 - 1][z][y2];
                        }
                        if (y2 < yLim - 1 && BlockProperties.get((Block)this.buffer[x3][z][y2 + 1].get()).isLoaded) {
                            neighbors += support[x3][z][y2 + 1];
                        }
                        if (y2 > 0 && BlockProperties.get((Block)this.buffer[x3][z][y2 - 1].get()).isLoaded) {
                            neighbors += support[x3][z][y2 - 1];
                        }
                        if (neighbors <= this.random.nextInt(4)) continue;
                        support[x3][z][y2] = 1;
                    }
                }
            }
            for (x2 = 0; x2 < xLim; ++x2) {
                for (y = 0; y < yLim; ++y) {
                    if (support[x2][z][y] != 0 || this.buffer[x2][z][y].equals((Object)Building.PRESERVE_BLOCK)) continue;
                    this.buffer[x2][z][y] = HOLE_BLOCK_LIGHTING;
                }
            }
        }
        return zLim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean queryCanBuild(int ybuffer, boolean overlapTowers) {
        int rooftopJ = this.j0 + this.bHeight + (this.roofStyle == 5 ? this.minHorizDim : this.minHorizDim / 2) + 2;
        if (rooftopJ > 255) {
            this.bHeight -= rooftopJ - 255;
        }
        if (this.bHeight < this.baseHeight + 4) {
            return false;
        }
        if (this.isObstructedRoof(ybuffer)) {
            return false;
        }
        if (this.wgt.isLayoutGenerator()) {
            int[] pt2;
            int[] pt1 = this.getIJKPt(overlapTowers ? this.bWidth / 4 : 0, 0, overlapTowers ? this.bLength / 4 : ybuffer);
            if (!this.wgt.layoutIsClear(pt1, pt2 = this.getIJKPt(overlapTowers ? 3 * this.bWidth / 4 - 1 : this.bWidth - 1, 0, overlapTowers ? 3 * this.bLength / 4 - 1 : this.bLength - 1), 4)) return false;
            this.wgt.setLayoutCode(pt1, pt2, 4);
            return true;
        } else {
            if (overlapTowers || !this.isObstructedFrame(3, ybuffer)) return true;
            return false;
        }
    }

    private void buildRoof() {
        int x1;
        int z1;
        int y1;
        int y12;
        int m;
        int x12;
        TemplateRule doubleStepRule;
        if (this.roofRule == TemplateRule.RULE_NOT_PROVIDED) {
            this.roofRule = this.roofStyle == 1 || this.roofStyle == 3 || this.roofStyle == 2 || this.roofStyle == 6 ? new TemplateRule(Blocks.field_150344_f, 0, "") : this.bRule;
        }
        int stepMeta = this.roofRule.primaryBlock.toStep().getMeta();
        TemplateRule stepRule = new TemplateRule((Block)Blocks.field_150333_U, stepMeta, this.roofRule.chance);
        TemplateRule templateRule = doubleStepRule = stepMeta == 2 ? new TemplateRule(Blocks.field_150344_f, 0, this.roofRule.chance) : new TemplateRule((Block)Blocks.field_150334_T, stepMeta, this.roofRule.chance);
        TemplateRule trimRule = this.roofStyle == 2 ? new TemplateRule(this.bRule.primaryBlock.get() == Blocks.field_150347_e ? Blocks.field_150364_r : Blocks.field_150347_e, 0, this.roofRule.chance) : stepRule;
        Block roof = this.roofRule.primaryBlock.toStair();
        TemplateRule northStairsRule = new TemplateRule(roof, STAIRS_DIR_TO_META[0], this.roofRule.chance);
        TemplateRule southStairsRule = new TemplateRule(roof, STAIRS_DIR_TO_META[2], this.roofRule.chance);
        TemplateRule eastStairsRule = new TemplateRule(roof, STAIRS_DIR_TO_META[1], this.roofRule.chance);
        TemplateRule westStairsRule = new TemplateRule(roof, STAIRS_DIR_TO_META[3], this.roofRule.chance);
        if (this.roofStyle == 0) {
            int y13;
            if (this.circular) {
                for (y13 = 0; y13 < this.bLength; ++y13) {
                    for (x12 = 0; x12 < this.bWidth; ++x12) {
                        if (this.circle_shape[x12][y13] >= 0) {
                            this.buffer[x12 + 1][this.bHeight + 1][y13 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                        }
                        if (CIRCLE_CRENEL[this.minHorizDim][x12][y13] != 1) continue;
                        this.buffer[x12 + 1][this.bHeight + 1 + 1][y13 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
            } else {
                for (y13 = 0; y13 < this.bLength; ++y13) {
                    for (x12 = 0; x12 < this.bWidth; ++x12) {
                        this.buffer[x12 + 1][this.bHeight + 1][y13 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
                for (m = 0; m < this.bWidth; m += 2) {
                    if (this.getBlockIdLocal(m, this.bHeight, -1) != this.bRule.primaryBlock.get() && this.getBlockIdLocal(m, this.bHeight - 1, -1) != this.bRule.primaryBlock.get()) {
                        BlockAndMeta blockAndMeta = this.buffer[m + 1][this.bHeight + 1 + 1][1] = (m + 1) % 2 == 0 ? HOLE_BLOCK_LIGHTING : this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    if (this.getBlockIdLocal(m, this.bHeight, this.bLength) == this.bRule.primaryBlock.get() || this.getBlockIdLocal(m, this.bHeight - 1, this.bLength) == this.bRule.primaryBlock.get()) continue;
                    this.buffer[m + 1][this.bHeight + 1 + 1][this.bLength - 1 + 1] = (m + 1) % 2 == 0 ? HOLE_BLOCK_LIGHTING : this.bRule.getBlockOrHole(this.world.field_73012_v);
                }
                for (m = 0; m < this.bLength; m += 2) {
                    if (this.getBlockIdLocal(-1, this.bHeight, m) != this.bRule.primaryBlock.get() && this.getBlockIdLocal(-1, this.bHeight - 1, m) != this.bRule.primaryBlock.get()) {
                        BlockAndMeta blockAndMeta = this.buffer[1][this.bHeight + 1 + 1][m + 1] = (m + 1) % 2 == 0 ? HOLE_BLOCK_LIGHTING : this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    if (this.getBlockIdLocal(this.bWidth, this.bHeight, m) == this.bRule.primaryBlock.get() || this.getBlockIdLocal(this.bWidth, this.bHeight - 1, m) == this.bRule.primaryBlock.get()) continue;
                    this.buffer[this.bWidth - 1 + 1][this.bHeight + 1 + 1][m + 1] = (m + 1) % 2 == 0 ? HOLE_BLOCK_LIGHTING : this.bRule.getBlockOrHole(this.world.field_73012_v);
                }
                for (y13 = 1; y13 < this.bLength - 1; ++y13) {
                    for (x12 = 1; x12 < this.bWidth - 1; ++x12) {
                        if (!this.isWallBlock(x12, this.bHeight, y13) || this.isWallBlock(x12 + 1, this.bHeight, y13) || this.isWallBlock(x12 - 1, this.bHeight, y13) || this.isWallBlock(x12, this.bHeight, y13 + 1) || this.isWallBlock(x12, this.bHeight, y13 - 1)) continue;
                        this.buffer[x12 + 1][this.bHeight + 1 - 1 + 1][y13 + 1] = HOLE_BLOCK_LIGHTING;
                    }
                }
            }
            this.buffer[2][this.bHeight + 1][this.bLength / 2] = EAST_FACE_LADDER_BLOCK;
            this.buffer[2][this.bHeight + 2][this.bLength / 2] = new BlockAndMeta(Blocks.field_150415_aT, 3);
        } else if (this.roofStyle == 1 || this.roofStyle == 2 || this.roofStyle == 3 && (this.bWidth < 6 || this.bLength < 6)) {
            for (m = 0; m < (this.minHorizDim + 1) / 2; ++m) {
                for (x12 = m; x12 < this.bWidth - m; ++x12) {
                    for (y12 = m; y12 < this.bLength - m; ++y12) {
                        this.buffer[x12 + 1][this.bHeight + m + 1][y12 + 1] = HOLE_BLOCK_LIGHTING;
                        if (m != (this.bWidth + 1) / 2 - 1) continue;
                        this.buffer[x12 + 1][this.bHeight + m + 1 + 1][y12 + 1] = trimRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    this.buffer[x12 + 1][this.bHeight + m + 1][m - 1 + 1] = northStairsRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[x12 + 1][this.bHeight + m + 1][this.bLength - m + 1] = southStairsRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[x12 + 1][this.bHeight + m + 1][m + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[x12 + 1][this.bHeight + m + 1][this.bLength - m - 1 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                }
                for (y1 = m; y1 < this.bLength - m; ++y1) {
                    this.buffer[m - 1 + 1][this.bHeight + m + 1][y1 + 1] = eastStairsRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[this.bWidth - m + 1][this.bHeight + m + 1][y1 + 1] = westStairsRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[m + 1][this.bHeight + m + 1][y1 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[this.bWidth - m - 1 + 1][this.bHeight + m + 1][y1 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                }
                this.buffer[m - 1 + 1][this.bHeight + m + 1][m - 1 + 1] = trimRule.getBlockOrHole(this.world.field_73012_v);
                this.buffer[m - 1 + 1][this.bHeight + m + 1][this.bLength - m + 1] = trimRule.getBlockOrHole(this.world.field_73012_v);
                this.buffer[this.bWidth - m + 1][this.bHeight + m + 1][m - 1 + 1] = trimRule.getBlockOrHole(this.world.field_73012_v);
                this.buffer[this.bWidth - m + 1][this.bHeight + m + 1][this.bLength - m + 1] = trimRule.getBlockOrHole(this.world.field_73012_v);
            }
        } else if (this.roofStyle == 3) {
            for (int z12 = -1; z12 < (this.minHorizDim + 1) / 2; ++z12) {
                int x13;
                z1 = (z12 + 1) / 2;
                if ((z12 + 1) % 2 == 0) {
                    for (y12 = z12 + 1; y12 < this.bLength - 2 * z1; ++y12) {
                        this.buffer[z12 + 1][z1 + this.bHeight + 1][y12 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                        this.buffer[this.bWidth - z12 - 1 + 1][z1 + this.bHeight + 1][y12 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    for (x1 = z12 + 1; x1 < this.bWidth - 2 * z1; ++x1) {
                        this.buffer[x1 + 1][z1 + this.bHeight + 1][z12 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                        this.buffer[x1 + 1][z1 + this.bHeight + 1][this.bLength - z12 - 1 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    this.buffer[z12 + 1][z1 + this.bHeight + 1][z12 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[z12 + 1][z1 + this.bHeight + 1][this.bLength - z12 - 1 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[this.bWidth - z12 - 1 + 1][z1 + this.bHeight + 1][z12 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    this.buffer[this.bWidth - z12 - 1 + 1][z1 + this.bHeight + 1][this.bLength - z12 - 1 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    continue;
                }
                for (y12 = z12; y12 < this.bLength - z12; ++y12) {
                    for (x13 = z12; x13 < this.bWidth - z12; ++x13) {
                        this.buffer[x13 + 1][z1 + this.bHeight + 1][y12 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
                for (y12 = z12 + 2; y12 < this.bLength - z12 - 2; ++y12) {
                    for (x13 = z12 + 2; x13 < this.bWidth - z12 - 2; ++x13) {
                        this.buffer[x13 + 1][z1 + this.bHeight + 1][y12 + 1] = HOLE_BLOCK_LIGHTING;
                    }
                }
                this.buffer[z12 + 1][z1 + this.bHeight + 1 + 1][z12 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                this.buffer[z12 + 1][z1 + this.bHeight + 1 + 1][this.bLength - z12 - 1 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                this.buffer[this.bWidth - z12 - 1 + 1][z1 + this.bHeight + 1 + 1][z12 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
                this.buffer[this.bWidth - z12 - 1 + 1][z1 + this.bHeight + 1 + 1][this.bLength - z12 - 1 + 1] = stepRule.getBlockOrHole(this.world.field_73012_v);
            }
        } else if (this.roofStyle == 4) {
            for (int z12 = 0; z12 < (this.minHorizDim + 1) / 2; ++z12) {
                int diam = SPHERE_SHAPE[this.minHorizDim][z12];
                for (y12 = 0; y12 < diam; ++y12) {
                    for (int x14 = 0; x14 < diam; ++x14) {
                        if (CIRCLE_SHAPE[diam][x14][y12] >= 0) {
                            BlockAndMeta blockAndMeta = this.buffer[x14 + (this.bWidth - diam) / 2 + 1][this.bHeight + z12 + 1 + 1][y12 + (this.bLength - diam) / 2 + 1] = CIRCLE_SHAPE[diam][x14][y12] == 1 || z12 >= (this.minHorizDim + 1) / 2 - 2 ? this.roofRule.getBlockOrHole(this.world.field_73012_v) : HOLE_BLOCK_LIGHTING;
                        }
                        if (z12 >= (this.minHorizDim - 1) / 2) continue;
                        int nextDiam = SPHERE_SHAPE[this.minHorizDim][z12 + 1];
                        int x2 = x14 - (diam - nextDiam) / 2;
                        int y2 = y12 - (diam - nextDiam) / 2;
                        if (CIRCLE_SHAPE[diam][x14][y12] != 0 || x2 >= 0 && y2 >= 0 && x2 < nextDiam && y2 < nextDiam && CIRCLE_SHAPE[nextDiam][x2][y2] == 0) continue;
                        this.buffer[x14 + (this.bWidth - diam) / 2 + 1][this.bHeight + z12 + 1 + 1][y12 + (this.bLength - diam) / 2 + 1] = this.roofRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
            }
        } else if (this.roofStyle == 5) {
            int prevDiam = 0;
            for (z1 = 0; z1 < this.minHorizDim + 1; ++z1) {
                int diam = this.minHorizDim % 2 == 0 ? 2 * ((this.minHorizDim - z1 + 1) / 2) : 2 * ((this.minHorizDim - z1) / 2) + 1;
                for (int y14 = 0; y14 < diam; ++y14) {
                    for (int x15 = 0; x15 < diam; ++x15) {
                        if (CIRCLE_SHAPE[diam][x15][y14] >= 0) {
                            BlockAndMeta blockAndMeta = this.buffer[x15 + (this.bWidth - diam) / 2 + 1][this.bHeight + z1 + 1 + 1][y14 + (this.bLength - diam) / 2 + 1] = CIRCLE_SHAPE[diam][x15][y14] == 1 ? this.roofRule.getBlockOrHole(this.world.field_73012_v) : HOLE_BLOCK_LIGHTING;
                        }
                        if (z1 <= 0 || CIRCLE_SHAPE[diam][x15][y14] == 0 || CIRCLE_SHAPE[prevDiam][x15 + (prevDiam - diam) / 2][y14 + (prevDiam - diam) / 2] != 0) continue;
                        this.buffer[x15 + (this.bWidth - diam) / 2 + 1][this.bHeight + z1 + 1][y14 + (this.bLength - diam) / 2 + 1] = this.roofRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
                prevDiam = diam;
            }
        } else if (this.roofStyle == 6) {
            boolean rot = this.bLength > this.minHorizDim;
            int minAxLen = rot ? this.bWidth : this.bLength;
            int maxAxLen = rot ? this.bLength : this.bWidth;
            BlockAndMeta forwardsStairsRule = rot ? eastStairsRule.getBlockOrHole(this.world.field_73012_v) : northStairsRule.getBlockOrHole(this.world.field_73012_v);
            BlockAndMeta backwardsStirRule = rot ? westStairsRule.getBlockOrHole(this.world.field_73012_v) : southStairsRule.getBlockOrHole(this.world.field_73012_v);
            for (int m2 = 0; m2 <= this.minHorizDim / 2; ++m2) {
                for (int p = 0; p < maxAxLen; ++p) {
                    for (int r = m2 + 1; r < minAxLen - m2 - 1; ++r) {
                        this.buildXYRotated(p + 1, this.bHeight + m2 + 1, r + 1, HOLE_BLOCK_LIGHTING, rot);
                    }
                    this.buildXYRotated(p + 1, this.bHeight + m2 + 1, m2 - 1 + 1, forwardsStairsRule, rot);
                    this.buildXYRotated(p + 1, this.bHeight + m2 + 1, minAxLen - m2 + 1, backwardsStirRule, rot);
                    if (this.minHorizDim % 2 == 0 && m2 == this.minHorizDim / 2) continue;
                    this.buildXYRotated(p + 1, this.bHeight + m2 + 1, m2 + 1, doubleStepRule.getBlockOrHole(this.world.field_73012_v), rot);
                    this.buildXYRotated(p + 1, this.bHeight + m2 + 1, minAxLen - m2 - 1 + 1, doubleStepRule.getBlockOrHole(this.world.field_73012_v), rot);
                }
                for (int r = m2; r < minAxLen - m2; ++r) {
                    if (this.minHorizDim % 2 == 1 && m2 == this.minHorizDim / 2) continue;
                    this.buildXYRotated(1, this.bHeight + m2 + 1, r + 1, this.circular && this.circle_shape[0][r] < 0 ? doubleStepRule.getBlockOrHole(this.world.field_73012_v) : this.bRule.getBlockOrHole(this.world.field_73012_v), rot);
                    this.buildXYRotated(maxAxLen - 1 + 1, this.bHeight + m2 + 1, r + 1, this.circular && this.circle_shape[this.bLength - 1][r] < 0 ? doubleStepRule.getBlockOrHole(this.world.field_73012_v) : this.bRule.getBlockOrHole(this.world.field_73012_v), rot);
                }
            }
        }
        if (this.circular && (this.roofStyle == 1 || this.roofStyle == 2 || this.roofStyle == 3 || this.roofStyle == 6)) {
            for (int x16 = 0; x16 < this.minHorizDim; ++x16) {
                for (y1 = 0; y1 < this.minHorizDim; ++y1) {
                    if (this.circle_shape[x16][y1] < 0) {
                        this.buffer[x16 + 1][this.bHeight + 1][y1 + 1] = doubleStepRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    if (this.circle_shape[x16][y1] != 1) continue;
                    for (int z13 = this.bHeight; z13 < this.bHeight + this.minHorizDim && this.buffer[x16 + 1][z13 + 1][y1 + 1] == HOLE_BLOCK_LIGHTING; ++z13) {
                        this.buffer[x16 + 1][z13 + 1][y1 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
            }
        }
        if (this.roofStyle == 4 || this.roofStyle == 5) {
            int xBuff = (this.bWidth - this.minHorizDim) / 2;
            int yBuff = (this.bLength - this.minHorizDim) / 2;
            for (x1 = 0; x1 < this.minHorizDim; ++x1) {
                for (int y15 = 0; y15 < this.minHorizDim; ++y15) {
                    if (this.circle_shape[x1][y15] >= 0) {
                        this.buffer[x1 + xBuff + 1][this.bHeight + 1][y15 + yBuff + 1] = this.circle_shape[x1][y15] == 0 ? HOLE_BLOCK_LIGHTING : this.bRule.getBlockOrHole(this.world.field_73012_v);
                        continue;
                    }
                    if (this.circular) continue;
                    this.buffer[x1 + xBuff + 1][this.bHeight + 1][y15 + yBuff + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                }
            }
            if (!this.circular) {
                for (y12 = 0; y12 < this.minHorizDim; ++y12) {
                    int x17;
                    for (x17 = 0; x17 < xBuff; ++x17) {
                        this.buffer[x17 + 1][this.bHeight + 1][y12 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    for (x17 = xBuff + this.minHorizDim; x17 < this.bWidth; ++x17) {
                        this.buffer[x17 + 1][this.bHeight + 1][y12 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
                for (x1 = 0; x1 < this.minHorizDim; ++x1) {
                    int y16;
                    for (y16 = 0; y16 < yBuff; ++y16) {
                        this.buffer[x1 + 1][this.bHeight + 1][y16 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                    for (y16 = yBuff + this.minHorizDim; y16 < this.bLength; ++y16) {
                        this.buffer[x1 + 1][this.bHeight + 1][y16 + 1] = this.bRule.getBlockOrHole(this.world.field_73012_v);
                    }
                }
            }
        }
    }

    private void populateBookshelves(int z) {
        int x1 = this.random.nextInt(this.bWidth - 2) + 1;
        int y1 = this.random.nextInt(this.bLength - 2) + 1;
        int dir = this.random.nextInt(4);
        int xinc = DIR_TO_X[dir];
        int yinc = DIR_TO_Y[dir];
        while (true) {
            if (x1 < 1 || x1 >= this.bWidth - 1 || y1 < 1 || y1 >= this.bLength - 1 || !this.isFloor(x1, z, y1)) {
                return;
            }
            if (BlockProperties.get((Block)this.getBlockIdLocal((int)(x1 + xinc), (int)z, (int)(y1 + yinc))).isArtificial && BlockProperties.get((Block)this.getBlockIdLocal((int)(x1 + xinc), (int)(z - 1), (int)(y1 + yinc))).isArtificial && this.getBlockIdLocal(x1 + xinc, z - 1, y1 + yinc) != Blocks.field_150468_ap) break;
            x1 += xinc;
            y1 += yinc;
        }
        for (int m = 0; m < 2; ++m) {
            for (int z1 = z; z1 < z + 1 + this.random.nextInt(3) && this.getBlockIdLocal(x1, z1, y1) == Blocks.field_150350_a && this.isWallBlock(x1 + xinc, z1, y1 + yinc); ++z1) {
                this.setBlockLocal(x1, z1, y1, Blocks.field_150342_X);
            }
            if (!this.isFloor(x1 += DIR_TO_X[(dir + 1) % 4], z, y1 += DIR_TO_Y[(dir + 1) % 4])) break;
        }
    }

    private boolean populatePortal(int z) {
        int y1;
        if (this.world.field_73011_w.field_76575_d ? this.random.nextInt(10) != 0 : this.random.nextInt(20) != 0) {
            return false;
        }
        boolean hasSupport = false;
        for (y1 = this.bLength / 2 - 2; y1 < this.bLength / 2 + 2; ++y1) {
            if (this.getBlockIdLocal(this.bWidth / 2, z, y1) != Blocks.field_150350_a) {
                return false;
            }
            if (this.getBlockIdLocal(this.bWidth / 2, z - 1, y1) == Blocks.field_150350_a) continue;
            hasSupport = true;
        }
        if (!hasSupport) {
            return false;
        }
        for (y1 = this.bLength / 2 - 2; y1 < this.bLength / 2 + 2; ++y1) {
            this.setBlockLocal(this.bWidth / 2, z, y1, Blocks.field_150343_Z);
            this.setBlockLocal(this.bWidth / 2, z + 4, y1, Blocks.field_150343_Z);
        }
        for (int z1 = z + 1; z1 < z + 4; ++z1) {
            this.setBlockLocal(this.bWidth / 2, z1, this.bLength / 2 - 2, Blocks.field_150343_Z);
            this.setBlockLocal(this.bWidth / 2, z1, this.bLength / 2 - 1, (Block)Blocks.field_150427_aO);
            this.setBlockLocal(this.bWidth / 2, z1, this.bLength / 2, (Block)Blocks.field_150427_aO);
            this.setBlockLocal(this.bWidth / 2, z1, this.bLength / 2 + 1, Blocks.field_150343_Z);
        }
        return true;
    }

    public BuildingTower(int ID_, Building parent, boolean circular_, int roofStyle_, int dir_, int axXHand_, boolean centerAligned_, int TWidth_, int THeight_, int TLength_, int[] sourcePt) {
        super(ID_, parent.wgt, parent.bRule, dir_, axXHand_, centerAligned_, new int[]{TWidth_, THeight_, TLength_}, sourcePt);
        this.baseHeight = 0;
        this.roofStyle = roofStyle_;
        this.minHorizDim = Math.min(this.bWidth, this.bLength);
        this.circle_shape = CIRCLE_SHAPE[this.minHorizDim];
        this.circular = circular_;
        this.ChestRule = TemplateRule.RULE_NOT_PROVIDED;
        this.roofRule = this.bRule;
        this.SpawnerRule = TemplateRule.RULE_NOT_PROVIDED;
        this.PopulateFurniture = false;
        this.MakeDoors = false;
        if (this.circular) {
            this.bLength = this.bWidth = this.minHorizDim;
        }
    }

    public BuildingTower(int ID_, BuildingWall wall, int dir_, int axXHand_, boolean centerAligned_, int TWidth_, int THeight_, int TLength_, int[] sourcePt) {
        super(ID_, wall.wgt, wall.towerRule, dir_, axXHand_, centerAligned_, new int[]{TWidth_, THeight_, TLength_}, sourcePt);
        this.baseHeight = wall.WalkHeight;
        this.roofStyle = wall.roofStyle;
        this.minHorizDim = Math.min(this.bWidth, this.bLength);
        this.circle_shape = CIRCLE_SHAPE[this.minHorizDim];
        this.circular = wall.circular;
        this.ChestRule = wall.ws.ChestRule;
        this.roofRule = wall.roofRule;
        this.SpawnerRule = wall.ws.SpawnerRule;
        this.PopulateFurniture = wall.ws.PopulateFurniture;
        this.MakeDoors = wall.ws.MakeDoors;
        if (this.circular) {
            this.bLength = this.bWidth = this.minHorizDim;
        }
    }

    private void buildWindowOrDoor(int x, int z, int y, int xFace, int yFace, int height) {
        boolean buildWoodDoor = false;
        if (this.isFloor(x + xFace, z - 1, y + yFace) || this.isFloor(x + xFace, z - 2, y + yFace)) {
            --z;
            if (this.MakeDoors) {
                buildWoodDoor = true;
            }
        }
        if (!BlockProperties.get((Block)this.getBlockIdLocal((int)x, (int)(z + height - 2), (int)(y + yFace))).isWallable) {
            return;
        }
        if (buildWoodDoor) {
            int metadata = xFace == 0 ? (yFace > 0 ? 1 : 3) : (xFace > 0 ? 2 : 0);
            this.buffer[x + 1][z + 1][y + 1] = new BlockAndMeta(Blocks.field_150466_ao, metadata);
            this.buffer[x + 1][z + 1 + 1][y + 1] = new BlockAndMeta(Blocks.field_150466_ao, this.random.nextBoolean() ? 8 : 9);
            if (this.isFloor(x + xFace, z - 1, y + yFace) && x + xFace + 1 >= 0 && x + xFace + 1 < this.buffer.length && y + yFace + 1 >= 0 && y + yFace + 1 < this.buffer[0][0].length) {
                this.buffer[x + xFace + 1][z - 1 + 1][y + yFace + 1] = this.bRule.primaryBlock.toStep();
            }
        } else {
            for (int z1 = z; z1 < z + height; ++z1) {
                this.buffer[x + 1][z1 + 1][y + 1] = HOLE_BLOCK_LIGHTING;
            }
        }
        if (this.isFloor(x + xFace, z + 2, y + yFace) && this.isWallBlock(x + xFace, z, y + yFace) && x + xFace + 1 >= 0 && x + xFace + 1 < this.buffer.length && y + yFace + 1 >= 0 && y + yFace + 1 < this.buffer[0][0].length) {
            this.buffer[x + xFace + 1][z + 1 + 1][y + yFace + 1] = HOLE_BLOCK_LIGHTING;
        }
    }

    private void populateBeds(int z) {
        int dir = this.random.nextInt(4);
        int x1 = this.random.nextInt(this.bWidth - 2) + 1;
        int y1 = this.random.nextInt(this.bLength - 2) + 1;
        int x2 = x1 + DIR_TO_X[dir];
        int y2 = y1 + DIR_TO_Y[dir];
        if (this.isFloor(x1, z, y1) && this.hasNoDoorway(x1, z, y1) && this.isFloor(x2, z, y2) && this.hasNoDoorway(x2, z, y2)) {
            this.setBlockLocal(x1, z, y1, Blocks.field_150324_C, dir + 8);
            this.setBlockLocal(x2, z, y2, Blocks.field_150324_C, dir);
        }
    }

    private void populateFurnitureColumn(int z, BlockAndMeta[] block) {
        int y1;
        int x1 = this.random.nextInt(this.bWidth - 2) + 1;
        if (this.isFloor(x1, z, y1 = this.random.nextInt(this.bLength - 2) + 1) && this.hasNoDoorway(x1, z, y1)) {
            for (int z1 = 0; z1 < block.length; ++z1) {
                this.setBlockLocal(x1, z + z1, y1, block[z1]);
            }
        }
    }

    private boolean populateGhastSpawner(int z) {
        for (int tries = 0; tries < 5; ++tries) {
            int y1;
            int x1 = this.random.nextInt(this.bWidth - 2) + 1;
            if (!this.isFloor(x1, z, y1 = this.random.nextInt(this.bLength - 2) + 1)) continue;
            this.setBlockLocal(x1, z, y1, GHAST_SPAWNER);
            return true;
        }
        return false;
    }

    static {
        for (int m = 0; m < ROOFSTYLE_NAMES.length; ++m) {
            BuildingTower.ROOF_STYLE_IDS[m] = m;
        }
    }
}

