/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BuildingExplorationHandler;
import assets.generator.TemplateWall;
import assets.generator.WorldGenGreatWall;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;

@Mod(modid="GreatWallMod", name="Great Wall Mod", version="0.1.6", dependencies="after:ExtraBiomes,BiomesOPlenty", acceptableRemoteVersions="*")
public class PopulatorGreatWall
extends BuildingExplorationHandler {
    @Mod.Instance(value="GreatWallMod")
    public static PopulatorGreatWall instance;
    public float CurveBias = 0.5f;
    public int LengthBiasNorm = 200;
    public int BacktrackLength = 9;
    public ArrayList<TemplateWall> wallStyles = null;
    public int[] placedCoords = null;
    public World placedWorld = null;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.settingsFileName = "GreatWallSettings.txt";
        this.templateFolderName = "greatwall";
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/GotoLink/Generatormods/master/update.xml", "https://raw.github.com/GotoLink/Generatormods/master/changelog.md");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataFiles() {
        try {
            this.initializeLogging("Loading options and templates for the Great Wall Mod.");
            this.getGlobalOptions();
            File stylesDirectory = new File(CONFIG_DIRECTORY, this.templateFolderName);
            this.wallStyles = TemplateWall.loadWallStylesFromDir(stylesDirectory, this);
            this.finalizeLoading(true, "wall");
        }
        catch (Exception e) {
            this.errFlag = true;
            this.logOrPrint("There was a problem loading the great wall mod: " + e.getMessage(), "SEVERE");
            this.lw.println("There was a problem loading the great wall mod: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (this.lw != null) {
                this.lw.close();
            }
        }
        if ((double)this.GlobalFrequency < 1.0E-6) {
            this.errFlag = true;
        }
        this.dataFilesLoaded = true;
    }

    @Override
    public final void generate(World world, Random random, int i, int k) {
        if (random.nextFloat() < this.GlobalFrequency) {
            new WorldGenGreatWall(this, world, random, i, k, this.TriesPerChunk, (double)this.GlobalFrequency).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadGlobalOptions(BufferedReader br) {
        try {
            String read = br.readLine();
            while (read != null) {
                this.readGlobalOptions(this.lw, read);
                if (read.startsWith("CurveBias")) {
                    this.CurveBias = PopulatorGreatWall.readFloatParam(this.lw, this.CurveBias, ":", read);
                }
                if (read.startsWith("LengthBiasNorm")) {
                    this.LengthBiasNorm = PopulatorGreatWall.readIntParam(this.lw, this.LengthBiasNorm, ":", read);
                }
                if (read.startsWith("BacktrackLength")) {
                    this.BacktrackLength = PopulatorGreatWall.readIntParam(this.lw, this.BacktrackLength, ":", read);
                }
                this.readChestItemsList(this.lw, read, br);
                read = br.readLine();
            }
            if (this.TriesPerChunk > 100) {
                this.TriesPerChunk = 100;
            }
            if ((double)this.CurveBias < 0.0) {
                this.CurveBias = 0.0f;
            }
            if ((double)this.CurveBias > 1.0) {
                this.CurveBias = 1.0f;
            }
        }
        catch (IOException e) {
            this.lw.println(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void writeGlobalOptions(PrintWriter pw) {
        this.printGlobalOptions(pw, true);
        pw.println();
        pw.println("<-BacktrackLength - length of backtracking for wall planning if a dead end is hit->");
        pw.println("<-CurveBias - strength of the bias towards curvier walls. Value should be between 0.0 and 1.0.->");
        pw.println("<-LengthBiasNorm - wall length at which there is no penalty for generation>");
        pw.println("BacktrackLength:" + this.BacktrackLength);
        pw.println("CurveBias:" + this.CurveBias);
        pw.println("LengthBiasNorm:" + this.LengthBiasNorm);
        pw.println();
        this.printDefaultChestItems(pw);
        if (pw != null) {
            pw.close();
        }
    }

    public String toString() {
        return "GreatWallMod";
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        if (!this.dataFilesLoaded) {
            this.loadDataFiles();
        }
        if (!this.errFlag) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)1);
        }
    }
}

