/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockAndMeta;
import assets.generator.BlockExtended;
import assets.generator.Building;
import cpw.mods.fml.common.registry.GameData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.init.Blocks;

public class TemplateRule {
    public static final int FIXED_FOR_BUILDING = 5;
    public static final TemplateRule RULE_NOT_PROVIDED = null;
    public static final String BLOCK_NOT_REGISTERED_ERROR_PREFIX = "Error reading rule: BlockID ";
    public static final String SPECIAL_AIR = "PRESERVE";
    public static final String SPECIAL_STAIR = "WALL_STAIR";
    public static final String SPECIAL_PAINT = "PAINTING";
    public static final TemplateRule AIR_RULE = new TemplateRule(Blocks.field_150350_a, 0, null);
    public static final TemplateRule STONE_RULE = new TemplateRule(Blocks.field_150348_b, 0, null);
    private Block[] blockIDs;
    private int[] blockMDs;
    private String[] extraData;
    public int chance = 100;
    public int condition = 0;
    public BlockAndMeta primaryBlock = null;
    private BlockAndMeta fixedRuleChosen = null;

    public TemplateRule(String rule, boolean checkMetaValue) throws Exception {
        String[] items = rule.split(",");
        int numblocks = items.length - 2;
        if (numblocks < 1) {
            throw new Exception("Error reading rule: No blockIDs specified for rule!");
        }
        this.condition = Integer.parseInt(items[0].trim());
        this.chance = Integer.parseInt(items[1].trim());
        this.blockIDs = new Block[numblocks];
        this.blockMDs = new int[numblocks];
        this.extraData = new String[numblocks];
        for (int i = 0; i < numblocks; ++i) {
            String checkStr;
            String[] data = items[i + 2].trim().split("-", 2);
            if (data[0].equals(SPECIAL_AIR)) {
                this.blockIDs[i] = Building.PRESERVE_BLOCK.get();
                this.blockMDs[i] = Building.PRESERVE_BLOCK.getMeta();
                this.extraData[i] = data[0];
            } else if (data[0].equals(SPECIAL_STAIR) || data[0].equals(SPECIAL_PAINT)) {
                this.blockIDs[i] = Blocks.field_150350_a;
                int x = 0;
                if (data.length > 1) {
                    try {
                        x = Integer.parseInt(data[1]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.blockMDs[i] = data[0].startsWith(SPECIAL_STAIR.substring(0, 1)) ? -x : 3 + x;
                this.extraData[i] = data[0];
            } else {
                Block temp;
                try {
                    temp = (Block)GameData.blockRegistry.func_148754_a(Integer.parseInt(data[0]));
                }
                catch (Exception e) {
                    temp = (Block)GameData.blockRegistry.func_82594_a(data[0]);
                }
                if (temp != null) {
                    this.blockIDs[i] = temp;
                    if (data.length > 1) {
                        String[] txt = data[1].split("-", 2);
                        try {
                            this.blockMDs[i] = Integer.parseInt(txt[0]);
                        }
                        catch (Exception e) {
                            this.blockMDs[i] = 0;
                        }
                        if (txt.length > 1 && this.isSpecial(temp)) {
                            this.extraData[i] = txt[1];
                        }
                    } else {
                        this.blockMDs[i] = 0;
                    }
                } else {
                    throw new Exception(BLOCK_NOT_REGISTERED_ERROR_PREFIX + data[0] + " unknown!");
                }
            }
            if (!checkMetaValue || this.blockIDs[i] instanceof BlockAir || (checkStr = Building.metaValueCheck(this.blockIDs[i], this.blockMDs[i])) == null) continue;
            throw new Exception("Error reading rule: " + rule + "\nBad meta value " + this.blockMDs[i] + ". " + checkStr);
        }
        this.primaryBlock = this.getPrimaryBlock();
    }

    public TemplateRule(Block block, int meta, String extra) {
        this.blockIDs = new Block[]{block};
        this.blockMDs = new int[]{meta};
        if (extra != null) {
            this.extraData = new String[]{extra};
        }
        this.primaryBlock = this.getPrimaryBlock();
    }

    public TemplateRule(Block block, int meta, int chance_) {
        this(block, meta, null, chance_);
    }

    public TemplateRule(Block block, int meta, String extra, int chance_) {
        this(block, meta, extra);
        this.chance = chance_;
    }

    public TemplateRule(Block[] blockIDs_, int[] blockMDs_, int chance_) {
        this.blockIDs = blockIDs_;
        this.blockMDs = blockMDs_;
        this.chance = chance_;
        this.primaryBlock = this.getPrimaryBlock();
    }

    public TemplateRule(Block[] blockIDs_, int[] blockMDs_, String[] extra, int chance_) {
        this.blockIDs = blockIDs_;
        this.blockMDs = blockMDs_;
        this.extraData = extra;
        this.chance = chance_;
        this.primaryBlock = this.getPrimaryBlock();
    }

    public void setFixedRule(Random random) {
        if (this.condition == 5) {
            int m = random.nextInt(this.blockIDs.length);
            this.fixedRuleChosen = this.extraData != null && this.extraData[m] != null && !this.extraData[m].equals("") ? new BlockExtended(this.blockIDs[m], this.blockMDs[m], this.extraData[m]) : new BlockAndMeta(this.blockIDs[m], this.blockMDs[m]);
        } else {
            this.fixedRuleChosen = null;
        }
    }

    public TemplateRule getFixedRule(Random random) {
        if (this.condition != 5) {
            return this;
        }
        int m = random.nextInt(this.blockIDs.length);
        if (this.extraData != null && this.extraData[m] != null && !this.extraData[m].equals("")) {
            return new TemplateRule(this.blockIDs[m], this.blockMDs[m], this.extraData[m], this.chance);
        }
        return new TemplateRule(this.blockIDs[m], this.blockMDs[m], this.chance);
    }

    public BlockAndMeta getBlockOrHole(Random random) {
        if (this.chance >= 100 || random.nextInt(100) < this.chance) {
            if (this.fixedRuleChosen != null) {
                return this.fixedRuleChosen;
            }
            int m = random.nextInt(this.blockIDs.length);
            if (this.extraData != null && this.extraData[m] != null && !this.extraData[m].equals("")) {
                return new BlockExtended(this.blockIDs[m], this.blockMDs[m], this.extraData[m]);
            }
            return new BlockAndMeta(this.blockIDs[m], this.blockMDs[m]);
        }
        return Building.HOLE_BLOCK_LIGHTING;
    }

    public boolean isPreserveRule() {
        for (int i = 0; i < this.blockIDs.length; ++i) {
            if (this.blockIDs[i] != Building.PRESERVE_BLOCK.get()) {
                return false;
            }
            if (this.blockMDs[i] != Building.PRESERVE_BLOCK.getMeta()) {
                return false;
            }
            if (this.extraData[i] != null && this.extraData[i].equals(SPECIAL_AIR)) continue;
            return false;
        }
        return true;
    }

    public boolean hasUndeadSpawner() {
        if (this.extraData != null) {
            for (int i = 0; i < this.blockIDs.length; ++i) {
                String txt;
                if (!(this.blockIDs[i] instanceof BlockMobSpawner) || (txt = this.extraData[i]) == null || !txt.equals("Zombie") && !txt.equals("Skeleton") && !txt.equals("Creeper") && !txt.equals("EASY") && !txt.equals("UPRIGHT")) continue;
                return true;
            }
        }
        return false;
    }

    public BlockAndMeta getNonAirBlock(Random random) {
        int m = random.nextInt(this.blockIDs.length);
        if (this.extraData != null && this.extraData[m] != null && !this.extraData[m].equals("")) {
            return new BlockExtended(this.blockIDs[m], this.blockMDs[m], this.extraData[m]);
        }
        return new BlockAndMeta(this.blockIDs[m], this.blockMDs[m]);
    }

    public String toString() {
        String str = this.condition + "," + this.chance;
        for (int m = 0; m < this.blockIDs.length; ++m) {
            str = str + "," + GameData.blockRegistry.func_148750_c((Object)this.blockIDs[m]) + "-" + this.blockMDs[m];
            if (this.extraData == null || this.extraData[m] == null || this.extraData[m].equals("")) continue;
            str = str + "-" + this.extraData[m];
        }
        return str;
    }

    private BlockAndMeta getPrimaryBlock() {
        int[] hist = new int[this.blockIDs.length];
        for (int l = 0; l < hist.length; ++l) {
            for (int m = 0; m < hist.length; ++m) {
                if (this.blockIDs[l] != this.blockIDs[m]) continue;
                int n = l;
                hist[n] = hist[n] + 1;
            }
        }
        int maxFreq = 0;
        int pos = 0;
        for (int l = 0; l < hist.length; ++l) {
            if (hist[l] <= maxFreq) continue;
            maxFreq = hist[l];
            pos = l;
        }
        if (this.extraData != null && this.extraData[pos] != null && !this.extraData[pos].equals("")) {
            return new BlockExtended(this.blockIDs[pos], this.blockMDs[pos], this.extraData[pos]);
        }
        return new BlockAndMeta(this.blockIDs[pos], this.blockMDs[pos]);
    }

    public boolean isSpecial(Block block) {
        return block instanceof BlockAir || block instanceof BlockMobSpawner || block instanceof BlockChest;
    }
}

