/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockProperties;
import assets.generator.Building;
import assets.generator.BuildingDoubleWall;
import assets.generator.BuildingUndergroundEntranceway;
import assets.generator.PopulatorWalledCity;
import assets.generator.TemplateWall;
import assets.generator.WorldGeneratorThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class WorldGenUndergroundCity
extends WorldGeneratorThread {
    private static final float P_CHILDREN = 0.8f;
    private static final int MAX_CHILDREN = 3;
    public static final int MIN_DIAM = 11;
    public static final int MAX_DIAM = 30;
    private static final int DIAM_INCREMENT = 3;
    private static final int Z_SHIFT = 12;
    private static final float HORIZ_SHIFT_SIGMA = 0.2f;
    private static final float THETA_SHIFT_SIGMA = 5.0f;
    private List<int[]> hollows = new ArrayList<int[]>();
    private List<BuildingDoubleWall> streets = new ArrayList<BuildingDoubleWall>();
    private double cavernMass = 0.0;
    private double cavernMass_i = 0.0;
    private double cavernMass_k = 0.0;
    TemplateWall pws;

    public WorldGenUndergroundCity(PopulatorWalledCity wc, World world, Random random, int chunkI, int chunkK, int triesPerChunk, double chunkTryProb) {
        super(wc, world, random, chunkI, chunkK, triesPerChunk, chunkTryProb);
    }

    @Override
    public boolean generate(int i0, int j0, int k0) {
        this.pws = TemplateWall.pickBiomeWeightedWallStyle(((PopulatorWalledCity)this.master).undergroundCityStyles, this.world, i0, k0, this.world.field_73012_v, true);
        if (this.pws == null) {
            return false;
        }
        if (!((PopulatorWalledCity)this.master).cityIsSeparated(this.world, i0, k0, 1)) {
            return false;
        }
        this.hollow(i0, j0, k0, 30);
        if (this.hollows.size() == 0) {
            return false;
        }
        ((PopulatorWalledCity)this.master).cityLocations.get(this.world).add(new int[]{i0, k0, 1});
        ((PopulatorWalledCity)this.master).saveCityLocations(this.world);
        this.master.logOrPrint("\n***** Building " + this.pws.name + " city with " + this.hollows.size() + " hollows at (" + i0 + "," + j0 + "," + k0 + "). ******\n", "FINER");
        List<BuildingUndergroundEntranceway> entranceways = this.buildEntranceways();
        this.fillHollows();
        for (BuildingUndergroundEntranceway entranceway : entranceways) {
            if (entranceway.street.bLength <= 1) continue;
            entranceway.street.buildFromTML();
            entranceway.street.makeBuildings(true, true, false, false, false);
        }
        for (BuildingDoubleWall street : this.streets) {
            street.buildTowers(true, true, false, this.pws.StreetDensity > 10, false);
        }
        return true;
    }

    private List<BuildingUndergroundEntranceway> buildEntranceways() {
        if (!this.pws.MakeUndergroundEntranceways) {
            return new ArrayList<BuildingUndergroundEntranceway>();
        }
        int[] center = new int[]{(int)(this.cavernMass_i / this.cavernMass), 256, (int)(this.cavernMass_k / this.cavernMass)};
        int[] pole = new int[]{center[0] + 100, center[1], center[2]};
        ArrayList<BuildingUndergroundEntranceway> entranceways = new ArrayList<BuildingUndergroundEntranceway>();
        for (int attempts = 0; attempts < Math.min(20, this.hollows.size()); ++attempts) {
            int[] hollow = this.getFarthestHollowFromPt(pole);
            int diam = Building.SPHERE_SHAPE[hollow[3]][hollow[3] / 3];
            int axDir = Math.abs(center[0] - hollow[0]) > Math.abs(center[2] - hollow[2]) ? (hollow[0] > center[0] ? 2 : 0) : (hollow[2] > center[2] ? 3 : 1);
            int[] pt = new int[]{hollow[0] + (Math.abs(axDir) == 1 ? hollow[3] / 2 : (axDir == 2 ? (hollow[3] + diam) / 2 : (hollow[3] - diam) / 2 + 1)), hollow[1] - hollow[3] / 3, hollow[2] + (Math.abs(axDir) == 2 ? hollow[3] / 2 : (axDir == 3 ? (hollow[3] + diam) / 2 : (hollow[3] - diam) / 2 + 1))};
            boolean separated = true;
            for (BuildingUndergroundEntranceway entranceway : entranceways) {
                if (Building.distance(entranceway.getIJKPt(0, 0, 0), pt) >= 400) continue;
                separated = false;
            }
            BuildingUndergroundEntranceway entranceway = new BuildingUndergroundEntranceway(attempts, this, this.pws, axDir, pt);
            if (separated && entranceway.build()) {
                entranceways.add(entranceway);
                ((PopulatorWalledCity)this.master).chatBuildingCity("Built an underground entranceway at (" + hollow[0] + "," + hollow[1] + "," + hollow[2] + ").", null);
            }
            pole[0] = center[0] + (center[2] - hollow[2]) / 2;
            pole[2] = center[2] + (hollow[0] - center[0]) / 2;
            if (entranceways.size() >= 4) break;
        }
        return entranceways;
    }

    private void fillHollows() {
        int successes = 0;
        for (int tries = 0; tries < this.pws.StreetDensity * 4; ++tries) {
            int[] hollow = this.hollows.get(this.random.nextInt(this.hollows.size()));
            int[] pt = new int[]{this.random.nextInt(hollow[3]), 0, this.random.nextInt(hollow[3])};
            if (Building.CIRCLE_SHAPE[hollow[3]][pt[0]][pt[2]] != 0) continue;
            pt[0] = pt[0] + hollow[0];
            pt[2] = pt[2] + hollow[2];
            pt[1] = Building.findSurfaceJ(this.world, pt[0], pt[2], hollow[1] - (hollow[3] + 1) / 2, false, -1) + 1;
            TemplateWall sws = TemplateWall.pickBiomeWeightedWallStyle(this.pws.streets, this.world, pt[0], pt[2], this.world.field_73012_v, true);
            sws.MergeWalls = true;
            BuildingDoubleWall street = new BuildingDoubleWall(tries, this, sws, this.random.nextInt(4), 1, pt);
            if (street.plan()) {
                street.build(-1);
                this.streets.add(street);
                ++successes;
            }
            if (successes > Math.min(this.hollows.size() * this.pws.StreetDensity, 4 * this.pws.StreetDensity)) break;
        }
    }

    private int[] getFarthestHollowFromPt(int[] pt) {
        int[] farthestHollow = null;
        int maxDist = -1;
        for (int[] h : this.hollows) {
            int dist = Building.distance(pt, h);
            if (dist <= maxDist) continue;
            maxDist = dist;
            farthestHollow = h;
        }
        return farthestHollow;
    }

    private boolean hollow(int i, int j, int k, int diam) {
        if (diam < 11) {
            return false;
        }
        if (j - diam / 2 < 10 || j + diam / 2 > Building.findSurfaceJ(this.world, i + diam / 2, k + diam / 2, 255, false, -1) - 3) {
            return false;
        }
        this.hollows.add(new int[]{i, j, k, diam, 0});
        if (diam == 30) {
            ((PopulatorWalledCity)this.master).chatBuildingCity("** Building underground city... **", null);
        }
        for (int z1 = 0; z1 < (diam + 1) / 2; ++z1) {
            int x1;
            int y1;
            int x12;
            int y12;
            int top_diam = Building.SPHERE_SHAPE[diam][z1];
            int offset = (diam - top_diam) / 2;
            for (y12 = 0; y12 < top_diam; ++y12) {
                for (x12 = 0; x12 < top_diam; ++x12) {
                    if (Building.CIRCLE_SHAPE[top_diam][x12][y12] < 0) continue;
                    Building.setBlockAndMetaNoLighting(this.world, i + offset + x12, j + z1, k + offset + y12, Blocks.field_150350_a, 0);
                }
            }
            for (y12 = 0; y12 < top_diam; ++y12) {
                for (x12 = 0; x12 < top_diam; ++x12) {
                    if (Building.CIRCLE_SHAPE[top_diam][x12][y12] < 0) continue;
                    for (int z2 = z1 + 1; z2 <= z1 + 3; ++z2) {
                        if (!BlockProperties.get((Block)this.world.func_147439_a((int)(i + offset + x12), (int)(j + z2), (int)(k + offset + y12))).isFlowing) continue;
                        this.world.func_147465_d(i + offset + x12, j + z2, k + offset + y12, Blocks.field_150348_b, 0, 2);
                    }
                }
            }
            int bottom_diam = Building.SPHERE_SHAPE[diam][2 * z1 / 3];
            offset = (diam - bottom_diam) / 2;
            if (z1 <= 0) continue;
            for (y1 = 0; y1 < bottom_diam; ++y1) {
                for (x1 = 0; x1 < bottom_diam; ++x1) {
                    if (Building.CIRCLE_SHAPE[bottom_diam][x1][y1] < 0) continue;
                    Building.setBlockAndMetaNoLighting(this.world, i + offset + x1, j - z1, k + offset + y1, Blocks.field_150350_a, 0);
                }
            }
            for (y1 = 0; y1 < bottom_diam; ++y1) {
                for (x1 = 0; x1 < bottom_diam; ++x1) {
                    if (Building.CIRCLE_SHAPE[bottom_diam][x1][y1] < 0) continue;
                    Block blockId = this.world.func_147439_a(i + offset + x1, j - z1 - 1, k + offset + y1);
                    if (!BlockProperties.get((Block)blockId).isOre || blockId == Blocks.field_150365_q) continue;
                    this.world.func_147465_d(i + offset + x1, j - z1 - 1, k + offset + y1, Blocks.field_150348_b, 0, 2);
                }
            }
        }
        int hollowMass = diam * diam * diam;
        this.cavernMass += (double)hollowMass;
        this.cavernMass_i += (double)(hollowMass * i);
        this.cavernMass_k += (double)(hollowMass * k);
        int successes = 0;
        for (int tries = 0; tries < (diam >= 24 ? 10 : 3); ++tries) {
            if (!(this.random.nextFloat() < 0.8f)) continue;
            float theta = diam >= 24 ? this.random.nextFloat() * 6.283185f : (float)Math.atan((this.cavernMass * (double)i - this.cavernMass_i) / (this.cavernMass * (double)k - this.cavernMass_k)) + 5.0f * this.random.nextFloat() * (this.random.nextFloat() - 0.5f);
            float rshift = (float)Building.SPHERE_SHAPE[diam][diam / 3] + (float)diam * (0.1f - 0.2f * this.random.nextFloat());
            if (this.hollow(i + (int)(MathHelper.func_76126_a((float)theta) * rshift), j + this.random.nextInt(this.random.nextInt(12) + 1) - 3, k + (int)(MathHelper.func_76134_b((float)theta) * rshift), diam - 3)) {
                ++successes;
            }
            if (successes >= 3) break;
        }
        return true;
    }
}

