/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankMaterial;
import net.zarathul.simplefluidtanks.blocks.WrenchableBlock;
import net.zarathul.simplefluidtanks.common.BlockCoords;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.rendering.TankBlockRenderer;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class TankBlock
extends WrenchableBlock {
    private final HashSet<BlockCoords> ignorePreDestroyEvent;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public TankBlock() {
        super(TankMaterial.tankMaterial);
        this.func_149663_c("tankBlock");
        this.func_149647_a(SimpleFluidTanks.creativeTab);
        this.func_149711_c(Config.tankBlockHardness);
        this.func_149752_b(Config.tankBlockResistance);
        this.func_149672_a(field_149778_k);
        this.setHarvestLevel("pickaxe", 2);
        this.ignorePreDestroyEvent = new HashSet();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon[] getIcons() {
        return this.icons;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[]{iconRegister.func_94245_a("simplefluidtanks:tank_closed"), iconRegister.func_94245_a("simplefluidtanks:tank_open"), iconRegister.func_94245_a("simplefluidtanks:tank_top_bottom"), iconRegister.func_94245_a("simplefluidtanks:tank_left_right"), iconRegister.func_94245_a("simplefluidtanks:tank_top_right"), iconRegister.func_94245_a("simplefluidtanks:tank_bottom_right"), iconRegister.func_94245_a("simplefluidtanks:tank_bottom_left"), iconRegister.func_94245_a("simplefluidtanks:tank_top_left"), iconRegister.func_94245_a("simplefluidtanks:tank_left_right_top"), iconRegister.func_94245_a("simplefluidtanks:tank_top_bottom_right"), iconRegister.func_94245_a("simplefluidtanks:tank_left_right_bottom"), iconRegister.func_94245_a("simplefluidtanks:tank_top_bottom_left"), iconRegister.func_94245_a("simplefluidtanks:tank_top"), iconRegister.func_94245_a("simplefluidtanks:tank_bottom"), iconRegister.func_94245_a("simplefluidtanks:tank_left"), iconRegister.func_94245_a("simplefluidtanks:tank_right")};
    }

    public void func_149725_f(World world, int x, int y, int z, int par5) {
        if (!world.field_72995_K) {
            BlockCoords tankCoords = new BlockCoords(x, y, z);
            if (this.ignorePreDestroyEvent.contains(tankCoords)) {
                this.ignorePreDestroyEvent.remove(tankCoords);
                return;
            }
            ValveBlockEntity valveEntity = this.getValve((IBlockAccess)world, x, y, z);
            if (valveEntity != null) {
                valveEntity.disbandMultiblock();
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return TankBlockRenderer.id;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int unknown) {
        return new TankBlockEntity();
    }

    @Override
    protected void handleToolWrenchClick(World world, int x, int y, int z, EntityPlayer player, ItemStack equippedItemStack) {
        if (player.func_70093_af()) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, x, y, z);
            ValveBlockEntity valveEntity = null;
            if (tankEntity != null && tankEntity.isPartOfTank()) {
                valveEntity = tankEntity.getValve();
                this.ignorePreDestroyEvent.add(new BlockCoords(x, y, z));
            }
            world.func_147468_f(x, y, z);
            this.func_149697_b(world, x, y, z, 0, 0);
            if (valveEntity != null) {
                valveEntity.formMultiblock();
            }
        }
    }

    private ValveBlockEntity getValve(IBlockAccess world, int x, int y, int z) {
        TankBlockEntity tankEntity = Utils.getTileEntityAt(world, TankBlockEntity.class, x, y, z);
        if (tankEntity != null) {
            ValveBlockEntity valveEntity = tankEntity.getValve();
            return valveEntity;
        }
        return null;
    }
}

