/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankMaterial;
import net.zarathul.simplefluidtanks.blocks.WrenchableBlock;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class ValveBlock
extends WrenchableBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTank;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconIo;

    public ValveBlock() {
        super(TankMaterial.tankMaterial);
        this.func_149663_c("valveBlock");
        this.func_149647_a(SimpleFluidTanks.creativeTab);
        this.func_149711_c(Config.valveBlockHardness);
        this.func_149752_b(Config.valveBlockResistance);
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == meta ? this.iconIo : (side == 1 ? this.iconTank : this.icon);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt(blockAccess, ValveBlockEntity.class, x, y, z);
        if (valveEntity != null && valveEntity.hasTanks()) {
            if (valveEntity.isFacingTank(side)) {
                return this.iconTank;
            }
            return this.iconIo;
        }
        return this.func_149691_a(side, blockAccess.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("simplefluidtanks:valve");
        this.iconTank = iconRegister.func_94245_a("simplefluidtanks:valve_tank");
        this.iconIo = iconRegister.func_94245_a("simplefluidtanks:valve_io");
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new ValveBlockEntity();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack items) {
        super.func_149689_a(world, x, y, z, player, items);
        if (!world.field_72995_K) {
            int direction;
            int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (l) {
                case 1: {
                    direction = 5;
                    break;
                }
                case 2: {
                    direction = 3;
                    break;
                }
                case 3: {
                    direction = 4;
                    break;
                }
                default: {
                    direction = 2;
                }
            }
            world.func_72921_c(x, y, z, direction, 2);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        ValveBlockEntity valveEntity;
        super.func_149726_b(world, x, y, z);
        if (!world.field_72995_K && (valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, x, y, z)) != null) {
            valveEntity.formMultiblock();
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int par5) {
        ValveBlockEntity valveEntity;
        if (!world.field_72995_K && (valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, x, y, z)) != null) {
            valveEntity.disbandMultiblock();
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        ItemStack equippedItemStack;
        if (!world.field_72995_K && (equippedItemStack = player.func_71045_bC()) != null && (equippedItemStack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)equippedItemStack))) {
            this.handleContainerClick(world, x, y, z, player, equippedItemStack);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, x, y, z);
        if (valveEntity != null) {
            float capacity = valveEntity.getCapacity();
            float fluidAmount = valveEntity.getFluidAmount();
            int signalStrength = capacity != 0.0f ? (int)Math.floor(fluidAmount / capacity * 14.0f) + (fluidAmount > 0.0f ? 1 : 0) : 0;
            return signalStrength;
        }
        return 0;
    }

    @Override
    protected void handleToolWrenchClick(World world, int x, int y, int z, EntityPlayer player, ItemStack equippedItemStack) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, x, y, z);
        if (player.func_70093_af()) {
            if (valveEntity != null) {
                valveEntity.disbandMultiblock();
            }
            world.func_147468_f(x, y, z);
            this.func_149697_b(world, x, y, z, 0, 0);
        } else if (valveEntity != null) {
            valveEntity.formMultiblock();
        }
    }

    private void handleContainerClick(World world, int x, int y, int z, EntityPlayer player, ItemStack equippedItemStack) {
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)world, ValveBlockEntity.class, x, y, z);
        if (valveEntity != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)equippedItemStack) || Utils.isEmptyComplexContainer(equippedItemStack) || equippedItemStack.func_77973_b() instanceof IFluidContainerItem && player.func_70093_af()) {
                this.fillContainerFromTank(world, x, y, z, player, equippedItemStack, valveEntity);
            } else {
                this.drainContainerIntoTank(world, x, y, z, player, equippedItemStack, valveEntity);
            }
        }
    }

    private void fillContainerFromTank(World world, int x, int y, int z, EntityPlayer player, ItemStack equippedItemStack, ValveBlockEntity valveEntity) {
        if (valveEntity.getFluid() == null) {
            return;
        }
        if (equippedItemStack.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)equippedItemStack.func_77973_b();
            int fillFluidAmount = containerItem.fill(equippedItemStack, valveEntity.getFluid(), true);
            valveEntity.drain(null, fillFluidAmount, true);
        } else {
            FluidStack drainedFluid;
            int containerCapacity;
            ItemStack filledContainer = Utils.fillFluidContainer(valveEntity.getFluid(), equippedItemStack);
            if (filledContainer != null && (containerCapacity = Utils.getFluidContainerCapacity(valveEntity.getFluid(), equippedItemStack)) > 0 && (drainedFluid = valveEntity.drain(null, containerCapacity, true)) != null && drainedFluid.amount == containerCapacity) {
                if (--equippedItemStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                if (!player.field_71071_by.func_70441_a(filledContainer)) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, filledContainer));
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
            }
        }
    }

    private void drainContainerIntoTank(World world, int x, int y, int z, EntityPlayer player, ItemStack equippedItemStack, ValveBlockEntity valveEntity) {
        if (valveEntity.isFull()) {
            return;
        }
        if (equippedItemStack.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)equippedItemStack.func_77973_b();
            FluidStack containerFluid = containerItem.getFluid(equippedItemStack);
            FluidStack tankFluid = valveEntity.getFluid();
            if (tankFluid == null || tankFluid.isFluidEqual(containerFluid)) {
                int drainAmount = Math.min(valveEntity.getRemainingCapacity(), containerFluid.amount);
                FluidStack drainFluid = containerItem.drain(equippedItemStack, drainAmount, true);
                valveEntity.fill(null, drainFluid, true);
            }
        } else {
            FluidStack containerFluid = Utils.getFluidForFilledItem(equippedItemStack);
            if (valveEntity.fill(null, containerFluid, true) > 0 && !player.field_71075_bZ.field_75098_d) {
                ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)equippedItemStack);
                if (--equippedItemStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                if (!player.field_71071_by.func_70441_a(emptyContainer)) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, emptyContainer));
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
            }
        }
    }
}

