/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import net.zarathul.simplefluidtanks.common.BlockCoords;

public class BasicAStar {
    private final PriorityQueue<Node> unvisitedNodes = new PriorityQueue();
    private final HashSet<BlockCoords> visitedBlocks = new HashSet();
    private final HashMap<BlockCoords, Integer> minCosts = new HashMap();
    private HashSet<BlockCoords> passableBlocks;

    public BasicAStar() {
    }

    public BasicAStar(Collection<BlockCoords> passableBlocks) {
        this();
        this.passableBlocks = new HashSet<BlockCoords>(passableBlocks);
    }

    public Node getShortestPath(BlockCoords start, BlockCoords goal) {
        if (start == null || goal == null) {
            return null;
        }
        this.visitedBlocks.clear();
        this.unvisitedNodes.clear();
        this.minCosts.clear();
        Node currentNode = new Node();
        currentNode.block = start;
        this.computeCosts(currentNode, goal);
        this.unvisitedNodes.offer(currentNode);
        while (!currentNode.block.equals(goal) && !this.unvisitedNodes.isEmpty()) {
            currentNode = this.unvisitedNodes.poll();
            this.visitedBlocks.add(currentNode.block);
            this.getAdjacentNodes(currentNode, goal);
        }
        return currentNode.block.equals(goal) ? currentNode : null;
    }

    public void setPassableBlocks(Collection<BlockCoords> passableBlocks) {
        this.passableBlocks = new HashSet<BlockCoords>(passableBlocks);
    }

    private void computeCosts(Node node, BlockCoords goal) {
        int currentCost = node.hasParent() ? node.parent.currentCost + this.getMovementCost(node.parent.block, node.block) : 0;
        int estimatedRemainingCost = this.getEstimatedRemainingCost(node.block, goal);
        node.currentCost = currentCost;
        node.estimatedTotalCost = currentCost + estimatedRemainingCost;
    }

    private int getEstimatedRemainingCost(BlockCoords start, BlockCoords goal) {
        int dx = Math.abs(start.x - goal.x);
        int dy = Math.abs(start.y - goal.y);
        return dx + dy;
    }

    private int getMovementCost(BlockCoords from, BlockCoords to) {
        if (from.equals(to)) {
            return 0;
        }
        if (this.passableBlocks.contains(to)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private void getAdjacentNodes(Node node, BlockCoords goal) {
        BlockCoords[] neighborBlocks;
        for (BlockCoords neighborBlock : neighborBlocks = new BlockCoords[]{node.block.offset(5), node.block.offset(4), node.block.offset(3), node.block.offset(2)}) {
            if (!this.passableBlocks.contains(neighborBlock) || this.visitedBlocks.contains(neighborBlock)) continue;
            Node newNode = new Node();
            newNode.block = neighborBlock;
            newNode.parent = node;
            this.computeCosts(newNode, goal);
            Integer minCost = this.minCosts.get(newNode.block);
            if (minCost != null && newNode.currentCost < minCost) {
                this.unvisitedNodes.remove(newNode);
                minCost = null;
            }
            if (minCost != null) continue;
            this.unvisitedNodes.offer(newNode);
            this.minCosts.put(newNode.block, newNode.currentCost);
        }
    }

    public class Node
    implements Comparable<Node> {
        public int currentCost;
        public int estimatedTotalCost;
        public BlockCoords block;
        public Node parent;

        public Node() {
            this.currentCost = 0;
            this.estimatedTotalCost = 0;
            this.block = null;
            this.parent = null;
        }

        public Node(Node other) {
            this.currentCost = other.currentCost;
            this.estimatedTotalCost = other.estimatedTotalCost;
            this.block = other.block;
            this.parent = other.parent;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        private Node first() {
            Node currentNode = this;
            while (currentNode.parent != null) {
                currentNode = currentNode.parent;
            }
            return currentNode;
        }

        @Override
        public int compareTo(Node other) {
            return Integer.compare(this.estimatedTotalCost, other.estimatedTotalCost);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            return !(this.block == null ? other.block != null : !this.block.equals(other.block));
        }
    }
}

