/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.common;

import java.util.ArrayList;
import java.util.Collection;
import net.zarathul.simplefluidtanks.common.Direction;

public class BlockCoords {
    public final int x;
    public final int y;
    public final int z;

    public BlockCoords(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static ArrayList<BlockCoords> offsetBy(Collection<BlockCoords> blocks, int ... offsets) {
        if (blocks == null || offsets == null || offsets.length < 3) {
            throw new IllegalArgumentException();
        }
        ArrayList<BlockCoords> offsetBlocks = new ArrayList<BlockCoords>(blocks.size());
        for (BlockCoords block : blocks) {
            offsetBlocks.add(new BlockCoords(block.x + offsets[0], block.y + offsets[1], block.z + offsets[2]));
        }
        return offsetBlocks;
    }

    public static BlockCoords offset(int direction, int amount, int ... coords) {
        if (coords == null || coords.length < 3 || !Direction.vanillaSideOffsets.containsKey(direction)) {
            throw new IllegalArgumentException();
        }
        Direction.DirectionalOffset offset = Direction.vanillaSideOffsets.get(direction);
        return new BlockCoords(coords[0] + offset.x * amount, coords[1] + offset.y * amount, coords[2] + offset.z * amount);
    }

    public BlockCoords offset(int direction) {
        return this.offset(direction, 1);
    }

    public BlockCoords offset(int direction, int amount) {
        return BlockCoords.offset(direction, amount, this.x, this.y, this.z);
    }

    public BlockCoords offsetBy(int ... offsets) {
        if (offsets == null || offsets.length < 3) {
            throw new IllegalArgumentException();
        }
        return new BlockCoords(this.x + offsets[0], this.y + offsets[1], this.z + offsets[2]);
    }

    public int getDistanceTo(BlockCoords block) {
        if (block == null) {
            return -1;
        }
        int distance = Math.abs(this.x - block.x) + Math.abs(this.y - block.y) + Math.abs(this.z - block.z);
        return distance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockCoords)) {
            return false;
        }
        BlockCoords other = (BlockCoords)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "[x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

