/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.common;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;

public class Direction {
    public static final int YNEG = 0;
    public static final int YPOS = 1;
    public static final int ZNEG = 2;
    public static final int ZPOS = 3;
    public static final int XNEG = 4;
    public static final int XPOS = 5;
    public static final ImmutableList<Integer> sidesToBitFlagsMappings = ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)8, (Object)16, (Object)32);
    public static final Map<Integer, Integer> vanillaSideOpposites = Collections.unmodifiableMap(new HashMap<Integer, Integer>(){
        {
            this.put(0, 1);
            this.put(1, 0);
            this.put(2, 3);
            this.put(3, 2);
            this.put(4, 5);
            this.put(5, 4);
        }
    });
    public static final Map<Integer, DirectionalOffset> vanillaSideOffsets = Collections.unmodifiableMap(new HashMap<Integer, DirectionalOffset>(){
        {
            this.put(0, DirectionalOffset.YNEG);
            this.put(1, DirectionalOffset.YPOS);
            this.put(2, DirectionalOffset.ZNEG);
            this.put(3, DirectionalOffset.ZPOS);
            this.put(4, DirectionalOffset.XNEG);
            this.put(5, DirectionalOffset.XPOS);
        }
    });
    public static final Map<Integer, ForgeDirection> vanillaToForgeMapping = Collections.unmodifiableMap(new HashMap<Integer, ForgeDirection>(){
        {
            this.put(0, ForgeDirection.DOWN);
            this.put(1, ForgeDirection.UP);
            this.put(2, ForgeDirection.NORTH);
            this.put(3, ForgeDirection.SOUTH);
            this.put(4, ForgeDirection.WEST);
            this.put(5, ForgeDirection.EAST);
        }
    });
    public static final Map<ForgeDirection, Integer> forgeToVanillaMapping = Collections.unmodifiableMap(new HashMap<ForgeDirection, Integer>(){
        {
            this.put(ForgeDirection.UP, 1);
            this.put(ForgeDirection.DOWN, 0);
            this.put(ForgeDirection.EAST, 5);
            this.put(ForgeDirection.WEST, 4);
            this.put(ForgeDirection.SOUTH, 3);
            this.put(ForgeDirection.NORTH, 2);
        }
    });

    public static int fromForge(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return -1;
        }
        return forgeToVanillaMapping.get(direction);
    }

    public static ForgeDirection toForge(int side) {
        if (side >= 0 && side <= 5) {
            return vanillaToForgeMapping.get(side);
        }
        return ForgeDirection.UNKNOWN;
    }

    public static enum DirectionalOffset {
        YNEG(0, -1, 0),
        YPOS(0, 1, 0),
        ZNEG(0, 0, -1),
        ZPOS(0, 0, 1),
        XNEG(-1, 0, 0),
        XPOS(1, 0, 0);

        public final int x;
        public final int y;
        public final int z;

        private DirectionalOffset(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

