/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.common;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.zarathul.simplefluidtanks.common.BlockCoords;
import net.zarathul.simplefluidtanks.configuration.Config;

public final class Utils {
    public static final ItemStack FILLED_BOTTLE = new ItemStack((Item)Items.field_151068_bn);
    private static FluidContainerRegistry.FluidContainerData[] cachedFluidContainerData = null;
    private static final Predicate<String> stringNotNullOrEmpty = new Predicate<String>(){

        public boolean apply(String item) {
            return !Strings.isNullOrEmpty((String)item);
        }
    };

    public static final <T extends TileEntity> T getTileEntityAt(IBlockAccess access, Class<T> entityType, BlockCoords coords) {
        return Utils.getTileEntityAt(access, entityType, coords.x, coords.y, coords.z);
    }

    public static final <T extends TileEntity> T getTileEntityAt(IBlockAccess access, Class<T> entityType, int ... coords) {
        TileEntity entity;
        if (access != null && entityType != null && coords != null && coords.length == 3 && (entity = access.func_147438_o(coords[0], coords[1], coords[2])) != null && entity.getClass() == entityType) {
            return (T)entity;
        }
        return null;
    }

    public static final <T extends Block> boolean isBlockType(IBlockAccess access, Class<T> type, BlockCoords coords) {
        return Utils.isBlockType(access, type, coords.x, coords.y, coords.z);
    }

    public static final <T extends Block> boolean isBlockType(IBlockAccess access, Class<T> type, int x, int y, int z) {
        Block blockToCheck = access.func_147439_a(x, y, z);
        return blockToCheck != null && type.isInstance(blockToCheck);
    }

    public static final boolean notNullorEmpty(Iterable<String> items) {
        return Iterables.all(items, stringNotNullOrEmpty);
    }

    public static final ArrayList<String> multiLineTranslateToLocal(String key, Object ... args) {
        ArrayList<String> lines = new ArrayList<String>();
        if (key != null) {
            int x = 0;
            String currentKey = key + x;
            while (StatCollector.func_94522_b((String)currentKey)) {
                lines.add(StatCollector.func_74837_a((String)currentKey, (Object[])args));
                currentKey = key + ++x;
            }
        }
        return lines;
    }

    public static final boolean isEmptyComplexContainer(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item.func_77973_b();
            FluidStack containerFluid = container.getFluid(item);
            return containerFluid == null || containerFluid.amount == 0;
        }
        return false;
    }

    public static final int getFluidContainerCapacity(FluidStack fluid, ItemStack container) {
        if (fluid == null || container == null) {
            return 0;
        }
        if (Config.overrideBottleVolume > 0 && (container.func_77969_a(FluidContainerRegistry.EMPTY_BOTTLE) || container.func_77969_a(FILLED_BOTTLE))) {
            return Config.overrideBottleVolume;
        }
        return FluidContainerRegistry.getContainerCapacity((FluidStack)fluid, (ItemStack)container);
    }

    public static ItemStack fillFluidContainer(FluidStack fluid, ItemStack container) {
        if (container == null || fluid == null) {
            return null;
        }
        if (Config.overrideBottleVolume > 0 && container.func_77969_a(FluidContainerRegistry.EMPTY_BOTTLE)) {
            if (cachedFluidContainerData == null) {
                cachedFluidContainerData = FluidContainerRegistry.getRegisteredFluidContainerData();
            }
            for (FluidContainerRegistry.FluidContainerData data : cachedFluidContainerData) {
                if (!container.func_77969_a(data.emptyContainer) || !fluid.isFluidEqual(data.fluid) || fluid.amount < Config.overrideBottleVolume) continue;
                return data.filledContainer.func_77946_l();
            }
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)container);
    }

    public static FluidStack getFluidForFilledItem(ItemStack filledContainer) {
        if (filledContainer == null) {
            return null;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
        if (fluid != null && Config.overrideBottleVolume > 0 && filledContainer.func_77969_a(FILLED_BOTTLE)) {
            fluid.amount = Config.overrideBottleVolume;
        }
        return fluid;
    }
}

