/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.configuration;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.RecipeComponent;
import net.zarathul.simplefluidtanks.configuration.RecipePattern;

public class Recipe {
    public final boolean isShapeless;
    public final int yield;
    public final RecipePattern pattern;
    public final RecipeComponent[] components;

    public Recipe(int yield, RecipeComponent[] components) {
        this(yield, null, components, true);
    }

    public Recipe(int yield, RecipePattern pattern, RecipeComponent[] components) {
        this(yield, pattern, components, pattern == null);
    }

    private Recipe(int yield, RecipePattern pattern, RecipeComponent[] components, boolean isShapeless) {
        this.yield = yield;
        this.pattern = isShapeless ? null : pattern;
        this.components = components;
        this.isShapeless = isShapeless;
    }

    public String[] getComponentList() {
        if (this.components == null || this.components.length == 0) {
            return null;
        }
        ArrayList<String> componentList = new ArrayList<String>(this.components.length * 3);
        for (RecipeComponent component : this.components) {
            componentList.add(component.identifier);
            componentList.add(component.modId);
            componentList.add(component.itemId);
        }
        return componentList.toArray(new String[componentList.size()]);
    }

    public Object[] getRegistrationArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        if (!this.isShapeless) {
            for (String patternRow : this.pattern.rows) {
                args.add(patternRow.length() > 3 ? patternRow.substring(0, 3) : patternRow);
            }
        }
        String componentArg = null;
        char id = '\u0000';
        for (RecipeComponent component : this.components) {
            String string = componentArg = !component.modId.equals("oreDict") ? GameRegistry.findItemStack((String)component.modId, (String)component.itemId, (int)1) : component.itemId;
            if (componentArg == null) {
                return null;
            }
            if (!this.isShapeless) {
                if (component.identifier == null || component.identifier.length() == 0) {
                    return null;
                }
                id = component.identifier.charAt(0);
                if (id == "-".charAt(0)) {
                    return null;
                }
                args.add(Character.valueOf(id));
            }
            args.add(componentArg);
        }
        return args.toArray();
    }

    public static RecipeComponent[] toComponents(String[] components) {
        if (components == null || components.length % 3 != 0 || !Utils.notNullorEmpty(Arrays.asList(components))) {
            return null;
        }
        int componentCount = components.length / 3;
        RecipeComponent[] componentList = new RecipeComponent[componentCount];
        for (int x = 0; x < componentCount; ++x) {
            componentList[x] = new RecipeComponent(components[x * 3], components[x * 3 + 1], components[x * 3 + 2]);
        }
        return componentList;
    }
}

