/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.registration;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.LogWrapper;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.FakeFluidBlock;
import net.zarathul.simplefluidtanks.blocks.TankBlock;
import net.zarathul.simplefluidtanks.blocks.ValveBlock;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.configuration.Recipe;
import net.zarathul.simplefluidtanks.items.TankItem;
import net.zarathul.simplefluidtanks.items.ValveItem;
import net.zarathul.simplefluidtanks.items.WrenchItem;
import net.zarathul.simplefluidtanks.rendering.TankBlockRenderer;
import net.zarathul.simplefluidtanks.rendering.ValveItemRenderer;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public final class Registry {
    public static final String TANKBLOCK_NAME = "tankBlock";
    public static final String TANKITEM_NAME = "tankItem";
    public static final String VALVEBLOCK_NAME = "valveBlock";
    public static final String VALVEITEM_NAME = "valveItem";
    public static final String WRENCH_ITEM_NAME = "wrench";
    private static final String TANKBLOCK_ENTITY_NAME = "tankBlockEntity";
    private static final String TANKBLOCK_ENTITY_KEY = "simplefluidtanks:tankBlockEntity";
    private static final String VALVEBLOCK_ENTITY_NAME = "valveBlockEntity";
    private static final String VALVEBLOCK_ENTITY_KEY = "simplefluidtanks:valveBlockEntity";

    public static void registerBlocks() {
        SimpleFluidTanks.tankBlock = new TankBlock();
        GameRegistry.registerBlock((Block)SimpleFluidTanks.tankBlock, TankItem.class, (String)TANKBLOCK_NAME);
        SimpleFluidTanks.fakeFluidBlock = new FakeFluidBlock();
        SimpleFluidTanks.valveBlock = new ValveBlock();
        GameRegistry.registerBlock((Block)SimpleFluidTanks.valveBlock, ValveItem.class, (String)VALVEBLOCK_NAME);
        GameRegistry.registerTileEntity(TankBlockEntity.class, (String)TANKBLOCK_ENTITY_KEY);
        GameRegistry.registerTileEntity(ValveBlockEntity.class, (String)VALVEBLOCK_ENTITY_KEY);
    }

    public static void registerItems() {
        SimpleFluidTanks.wrenchItem = new WrenchItem();
        GameRegistry.registerItem((Item)SimpleFluidTanks.wrenchItem, (String)WRENCH_ITEM_NAME, (String)"simplefluidtanks");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerCustomRenderers() {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new TankBlockRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)SimpleFluidTanks.valveBlock), (IItemRenderer)new ValveItemRenderer());
    }

    public static final void registerWithWaila() {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.zarathul.simplefluidtanks.waila.Registry.register");
    }

    public static final void registerRecipes() {
        ItemStack tankBlockRecipeResult = new ItemStack((Block)SimpleFluidTanks.tankBlock);
        ItemStack valveBlockRecipeResult = new ItemStack((Block)SimpleFluidTanks.valveBlock);
        Registry.registerRecipeWithAlternative(tankBlockRecipeResult, Config.tankBlockRecipe, Config.defaultTankBlockRecipe);
        Registry.registerRecipeWithAlternative(valveBlockRecipeResult, Config.valveBlockRecipe, Config.defaultValveBlockRecipe);
        if (Config.wrenchEnabled) {
            ItemStack wrenchRecipeResult = new ItemStack((Item)SimpleFluidTanks.wrenchItem);
            Registry.registerRecipeWithAlternative(wrenchRecipeResult, Config.wrenchRecipe, Config.defaultWrenchRecipe);
        }
    }

    private static final void registerRecipeWithAlternative(ItemStack result, Recipe recipe, Recipe defaultRecipe) {
        if (!Registry.registerRecipe(result, recipe)) {
            LogWrapper.severe((String)"[%s] Failed to register recipe for: %s. Check your config file.", (Object[])new Object[]{"simplefluidtanks", result.func_77977_a()});
            if (!Registry.registerRecipe(result, defaultRecipe)) {
                LogWrapper.severe((String)"[%s] Failed to register default recipe for: %s.", (Object[])new Object[]{"simplefluidtanks", result.func_77977_a()});
            }
        }
    }

    private static final boolean registerRecipe(ItemStack result, Recipe recipe) {
        try {
            Object[] registrationArgs = recipe.getRegistrationArgs();
            if (registrationArgs != null && recipe.yield > 0) {
                result.field_77994_a = recipe.yield;
                if (recipe.isShapeless) {
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(result, registrationArgs));
                } else {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{false, registrationArgs}));
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addCreativeTab() {
        SimpleFluidTanks.creativeTab = new CreativeTabs("Simple Fluid Tanks"){

            public String func_78024_c() {
                return this.func_78013_b();
            }

            public Item func_78016_d() {
                return Item.func_150898_a((Block)SimpleFluidTanks.tankBlock);
            }
        };
    }
}

