/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.rendering;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.zarathul.simplefluidtanks.rendering.TessellationManager;

@SideOnly(value=Side.CLIENT)
public abstract class BaseItemRenderer
implements IItemRenderer {
    protected final double[] defaultOrigin = new double[]{-0.5, -0.5, -0.5};
    protected final double[] equippedOrigin = new double[]{0.0, 0.0, 0.0};

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (type) {
            case ENTITY: {
                return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || helper == IItemRenderer.ItemRendererHelper.BLOCK_3D;
            }
            case EQUIPPED: {
                return helper == IItemRenderer.ItemRendererHelper.BLOCK_3D || helper == IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK;
            }
            case EQUIPPED_FIRST_PERSON: {
                return helper == IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK;
            }
            case INVENTORY: {
                return helper == IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        TessellationManager.setBaseCoords(type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON ? this.equippedOrigin : this.defaultOrigin);
    }
}

