/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.rendering;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankBlock;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.rendering.TessellationManager;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;

@SideOnly(value=Side.CLIENT)
public class TankBlockRenderer
implements ISimpleBlockRenderingHandler {
    public static final int id = RenderingRegistry.getNextAvailableRenderId();
    private static final double flickerOffset = 5.0E-4;
    private static final float yPosLightFactor = 1.0f;
    private static final float yNegLightFactor = 0.5f;
    private static final float zLightFactor = 0.8f;
    private static final float xLightFactor = 0.6f;

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TankBlockEntity tankEntity = Utils.getTileEntityAt(world, TankBlockEntity.class, x, y, z);
        if (tankEntity == null) {
            return false;
        }
        TankBlock tank = (TankBlock)block;
        IIcon[] frameIcons = tank.getIcons();
        TessellationManager.setBaseCoords(x, y, z);
        int colorMultiplier = SimpleFluidTanks.tankBlock.func_149720_d(world, x, y, z);
        float red = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorMultiplier & 0xFF) / 255.0f;
        if (tankEntity.isPartOfTank()) {
            int fillPercentage = tankEntity.getFillPercentage();
            boolean[] connections = tankEntity.getConnections();
            if (fillPercentage > 0) {
                IIcon fluidIcon;
                Fluid fluid = tankEntity.getFluid();
                IIcon iIcon = fluidIcon = fluid != null ? fluid.getStillIcon() : null;
                if (fluidIcon != null) {
                    this.renderFluid(renderer, connections, fluidIcon, fillPercentage, x, y, z, red, green, blue);
                }
            }
            this.renderFrame(tank, renderer, tankEntity, connections, frameIcons, red, green, blue);
        } else {
            this.renderUnlinkedTank(tank, renderer, tankEntity, frameIcons[0], red, green, blue);
        }
        return true;
    }

    public int getRenderId() {
        return id;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        TessellationManager.setBaseCoords(-0.5, -0.5, -0.5);
        TessellationManager.startDrawingQuads();
        TessellationManager.renderCube(0.0, 0.0, 0.0, 16.0, 16.0, 16.0, block.func_149691_a(0, 0));
        TessellationManager.draw();
        TessellationManager.resetBaseCoords();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    private void renderUnlinkedTank(TankBlock block, RenderBlocks renderer, TankBlockEntity entity, IIcon icon, float red, float green, float blue) {
        World world = entity.func_145831_w();
        TankBlockEntity BlockYNEG = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, entity.field_145851_c, entity.field_145848_d - 1, entity.field_145849_e);
        TankBlockEntity BlockYPOS = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, entity.field_145851_c, entity.field_145848_d + 1, entity.field_145849_e);
        TankBlockEntity BlockZNEG = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e - 1);
        TankBlockEntity BlockZPOS = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e + 1);
        TankBlockEntity BlockXNEG = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, entity.field_145851_c - 1, entity.field_145848_d, entity.field_145849_e);
        TankBlockEntity BlockXPOS = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, entity.field_145851_c + 1, entity.field_145848_d, entity.field_145849_e);
        if (BlockYNEG == null || BlockYNEG.isPartOfTank()) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.5f * red, 0.5f * green, 0.5f * blue);
            renderer.func_147768_a((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
            TessellationManager.setColorOpaque(1.0f * red, 1.0f * green, 1.0f * blue);
            renderer.func_147806_b((Block)block, (double)entity.field_145851_c, (double)(entity.field_145848_d - 1) + 5.0E-4, (double)entity.field_145849_e, icon);
        }
        if (BlockYPOS == null || BlockYPOS.isPartOfTank()) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(1.0f * red, 1.0f * green, 1.0f * blue);
            renderer.func_147806_b((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
            TessellationManager.setColorOpaque(0.5f * red, 0.5f * green, 0.5f * blue);
            renderer.func_147768_a((Block)block, (double)entity.field_145851_c, (double)(entity.field_145848_d + 1) - 5.0E-4, (double)entity.field_145849_e, icon);
        }
        if (BlockZNEG == null || BlockZNEG.isPartOfTank()) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.8f * red, 0.8f * green, 0.8f * blue);
            renderer.func_147761_c((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
            renderer.func_147734_d((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)(entity.field_145849_e - 1) + 5.0E-4, icon);
        }
        if (BlockZPOS == null || BlockZPOS.isPartOfTank()) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.8f * red, 0.8f * green, 0.8f * blue);
            renderer.func_147734_d((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
            renderer.func_147761_c((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)(entity.field_145849_e + 1) - 5.0E-4, icon);
        }
        if (BlockXNEG == null || BlockXNEG.isPartOfTank()) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.6f * red, 0.6f * green, 0.6f * blue);
            renderer.func_147798_e((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
            renderer.func_147764_f((Block)block, (double)(entity.field_145851_c - 1) + 5.0E-4, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
        }
        if (BlockXPOS == null || BlockXPOS.isPartOfTank()) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.6f * red, 0.6f * green, 0.6f * blue);
            renderer.func_147764_f((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
            renderer.func_147798_e((Block)block, (double)(entity.field_145851_c + 1) - 5.0E-4, (double)entity.field_145848_d, (double)entity.field_145849_e, icon);
        }
    }

    private void renderFrame(TankBlock block, RenderBlocks renderer, TankBlockEntity entity, boolean[] connections, IIcon[] icons, float red, float green, float blue) {
        World world = entity.func_145831_w();
        if (!connections[0]) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.5f * red, 0.5f * green, 0.5f * blue);
            renderer.field_147865_v = 3;
            renderer.func_147768_a((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(1)]);
            renderer.field_147865_v = 0;
            TessellationManager.setColorOpaque(1.0f * red, 1.0f * green, 1.0f * blue);
            renderer.field_147867_u = 3;
            renderer.func_147806_b((Block)block, (double)entity.field_145851_c, (double)(entity.field_145848_d - 1) + 5.0E-4, (double)entity.field_145849_e, icons[entity.getTextureIndex(1)]);
            renderer.field_147867_u = 0;
        }
        if (!connections[1]) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(1.0f * red, 1.0f * green, 1.0f * blue);
            renderer.field_147867_u = 3;
            renderer.func_147806_b((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(1)]);
            renderer.field_147867_u = 0;
            TessellationManager.setColorOpaque(0.5f * red, 0.5f * green, 0.5f * blue);
            renderer.field_147865_v = 3;
            renderer.func_147768_a((Block)block, (double)entity.field_145851_c, (double)(entity.field_145848_d + 1) - 5.0E-4, (double)entity.field_145849_e, icons[entity.getTextureIndex(1)]);
            renderer.field_147865_v = 0;
        }
        if (!connections[2]) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.8f * red, 0.8f * green, 0.8f * blue);
            renderer.func_147761_c((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(2)]);
            renderer.func_147734_d((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)(entity.field_145849_e - 1) + 5.0E-4, icons[entity.getTextureIndex(3)]);
        }
        if (!connections[3]) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.8f * red, 0.8f * green, 0.8f * blue);
            renderer.func_147734_d((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(3)]);
            renderer.func_147761_c((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)(entity.field_145849_e + 1) - 5.0E-4, icons[entity.getTextureIndex(2)]);
        }
        if (!connections[4]) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.6f * red, 0.6f * green, 0.6f * blue);
            renderer.func_147798_e((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(4)]);
            renderer.func_147764_f((Block)block, (double)(entity.field_145851_c - 1) + 5.0E-4, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(5)]);
        }
        if (!connections[5]) {
            TessellationManager.setBrightness(block.func_149677_c((IBlockAccess)world, entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
            TessellationManager.setColorOpaque(0.6f * red, 0.6f * green, 0.6f * blue);
            renderer.func_147764_f((Block)block, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(5)]);
            renderer.func_147798_e((Block)block, (double)(entity.field_145851_c + 1) - 5.0E-4, (double)entity.field_145848_d, (double)entity.field_145849_e, icons[entity.getTextureIndex(4)]);
        }
    }

    private void renderFluid(RenderBlocks renderer, boolean[] connections, IIcon fluidIcon, int fillPercentage, int x, int y, int z, float red, float green, float blue) {
        double[] renderBounds = new double[]{connections[4] ? 0.0 : 5.0E-4, connections[0] ? 0.0 : 5.0E-4, connections[2] ? 0.0 : 5.0E-4, connections[5] ? 1.0 : 0.9995, connections[1] || fillPercentage < 100 ? 1.0 : 0.9995, connections[3] ? 1.0 : 0.9995};
        renderer.func_147782_a(renderBounds[0], renderBounds[1], renderBounds[2], renderBounds[3], renderBounds[4] / 100.0 * (double)fillPercentage, renderBounds[5]);
        renderer.func_147757_a(fluidIcon);
        renderer.func_147736_d((Block)SimpleFluidTanks.fakeFluidBlock, x, y, z, red, green, blue);
        renderer.func_147771_a();
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

